
#ifndef ACTION_H_INCLUDED
#define ACTION_H_INCLUDED

typedef enum
{
  SWFACTION_END        = 0x00,

/* v3 actions */
  SWFACTION_NEXTFRAME     = 0x04,
  SWFACTION_PREVFRAME     = 0x05,
  SWFACTION_PLAY          = 0x06,
  SWFACTION_STOP          = 0x07,
  SWFACTION_TOGGLEQUALITY = 0x08,
  SWFACTION_STOPSOUNDS    = 0x09,
  SWFACTION_GOTOFRAME     = 0x81, /* >= 0x80 means record has args */
  SWFACTION_GETURL        = 0x83,
  SWFACTION_IFFRAMELOADED = 0x8A,
  SWFACTION_SETTARGET     = 0x8B,
  SWFACTION_GOTOLABEL     = 0x8C,

/* v4 actions */
  SWFACTION_ADD                     = 0x0A,
  SWFACTION_SUBTRACT                = 0x0B,
  SWFACTION_MULTIPLY                = 0x0C,
  SWFACTION_DIVIDE                  = 0x0D,
  SWFACTION_EQUALS                  = 0x0E,
  SWFACTION_LESSTHAN                = 0x0F,
  SWFACTION_LOGICALAND              = 0x10,
  SWFACTION_LOGICALOR               = 0x11,
  SWFACTION_LOGICALNOT              = 0x12,
  SWFACTION_STRINGEQ                = 0x13,
  SWFACTION_STRINGLENGTH            = 0x14,
  SWFACTION_SUBSTRING               = 0x15,
  SWFACTION_POP                     = 0x17,
  SWFACTION_INT                     = 0x18,
  SWFACTION_GETVARIABLE             = 0x1C,
  SWFACTION_SETVARIABLE             = 0x1D,
  SWFACTION_SETTARGETEXPRESSION     = 0x20,
  SWFACTION_STRINGCONCAT            = 0x21,
  SWFACTION_GETPROPERTY             = 0x22,
  SWFACTION_SETPROPERTY             = 0x23,
  SWFACTION_DUPLICATECLIP           = 0x24,
  SWFACTION_REMOVECLIP              = 0x25,
  SWFACTION_TRACE                   = 0x26,
  SWFACTION_STARTDRAGMOVIE          = 0x27,
  SWFACTION_STOPDRAGMOVIE           = 0x28,
  SWFACTION_STRINGLESSTHAN          = 0x29,
  SWFACTION_RANDOM                  = 0x30,
  SWFACTION_MBLENGTH                = 0x31,
  SWFACTION_ORD                     = 0x32,
  SWFACTION_CHR                     = 0x33,
  SWFACTION_GETTIMER                = 0x34,
  SWFACTION_MBSUBSTRING             = 0x35,
  SWFACTION_MBORD                   = 0x36,
  SWFACTION_MBCHR                   = 0x37,

  SWFACTION_IFFRAMELOADEDEXPRESSION = 0x8D,
  SWFACTION_PUSHDATA                = 0x96,
  SWFACTION_BRANCHALWAYS            = 0x99,
  SWFACTION_GETURL2                 = 0x9A,
  SWFACTION_BRANCHIFTRUE            = 0x9D,
  SWFACTION_CALLFRAME               = 0x9E,
  SWFACTION_GOTOEXPRESSION          = 0x9F,

/* v5 actions */
  SWFACTION_DELETE                  = 0x3A,
  SWFACTION_DELETE2                 = 0x3B,
  SWFACTION_VAREQUALS               = 0x3C,
  SWFACTION_CALLFUNCTION            = 0x3D,
  SWFACTION_RETURN                  = 0x3E,
  SWFACTION_MODULO                  = 0x3F,
  SWFACTION_NEW                     = 0x40,
  SWFACTION_VAR                     = 0x41,
  SWFACTION_INITARRAY               = 0x42,
  SWFACTION_INITOBJECT              = 0x43,
  SWFACTION_TYPEOF                  = 0x44,
  SWFACTION_TARGETPATH              = 0x45,
  SWFACTION_ENUMERATE               = 0x46,
  SWFACTION_NEWADD                  = 0x47,
  SWFACTION_NEWLESSTHAN             = 0x48,
  SWFACTION_NEWEQUALS               = 0x49,
  SWFACTION_TONUMBER                = 0x4A,
  SWFACTION_TOSTRING                = 0x4B,
  SWFACTION_DUP                     = 0x4C,
  SWFACTION_SWAP                    = 0x4D,
  SWFACTION_GETMEMBER               = 0x4E,
  SWFACTION_SETMEMBER               = 0x4F,
  SWFACTION_INCREMENT               = 0x50,
  SWFACTION_DECREMENT               = 0x51,
  SWFACTION_CALLMETHOD              = 0x52,
  SWFACTION_NEWMETHOD               = 0x53,
  SWFACTION_BITWISEAND              = 0x60,
  SWFACTION_BITWISEOR               = 0x61,
  SWFACTION_BITWISEXOR              = 0x62,
  SWFACTION_SHIFTLEFT               = 0x63,
  SWFACTION_SHIFTRIGHT              = 0x64,
  SWFACTION_SHIFTRIGHT2             = 0x65,
  SWFACTION_SETREGISTER             = 0x87,
  SWFACTION_CONSTANTPOOL            = 0x88,
  SWFACTION_WITH                    = 0x94,
  SWFACTION_DEFINEFUNCTION          = 0x9B,

/* v6 actions */
  SWFACTION_INSTANCEOF		    = 0x54,
  SWFACTION_ENUMERATEVALUE          = 0x55,
  SWFACTION_STRICTEQUALS            = 0x66,
  SWFACTION_GREATERTHAN             = 0x67,
  SWFACTION_STRINGGREATERTHAN       = 0x68,
  SWFACTION_STRICTMODE		    = 0x89
} Action;


/* These constants are still unused in flasm
typedef enum
{
  PROPERTY_X              = 0x00,
  PROPERTY_Y              = 0x01,
  PROPERTY_XSCALE         = 0x02,
  PROPERTY_YSCALE         = 0x03,
  PROPERTY_CURRENTFRAME   = 0x04,
  PROPERTY_TOTALFRAMES    = 0x05,
  PROPERTY_ALPHA          = 0x06,
  PROPERTY_VISIBLE        = 0x07,
  PROPERTY_WIDTH          = 0x08,
  PROPERTY_HEIGHT         = 0x09,
  PROPERTY_ROTATION       = 0x0a,
  PROPERTY_TARGET         = 0x0b,
  PROPERTY_FRAMESLOADED   = 0x0c,
  PROPERTY_NAME           = 0x0d,
  PROPERTY_DROPTARGET     = 0x0e,
  PROPERTY_URL            = 0x0f,
  PROPERTY_XMOUSE         = 0x10,
  PROPERTY_YMOUSE         = 0x11,
  PROPERTY_HIGHQUALITY    = 0x12,
  PROPERTY_FOCUSRECT      = 0x13,
  PROPERTY_SOUNDBUFTIME   = 0x14,
  PROPERTY_QUALITY        = 0x15,
  PROPERTY_WTHIT          = 0x16
} Property;
*/

typedef enum
{
  splaceMove          = 0x01, // this place moves an exisiting object
  splaceCharacter     = 0x02, // there is a character tag (if no tag, must be a move)
  splaceMatrix        = 0x04, // there is a matrix (matrix)
  splaceColorTransform= 0x08, // there is a color transform (cxform with alpha)
  splaceRatio         = 0x10, // there is a blend ratio (word)
  splaceName          = 0x20, // there is an object name (string)
  splaceDefineClip    = 0x40, // this shape should open or close a clipping bracket (character != 0 to open, character == 0 to close)
  splaceOnClipEvents  = 0x80  // there are onClipEvents
} placeflags;

typedef enum
{
  TAG_SHOWFRAME        = 1,  // frame is completely described now, please show
  TAG_DOACTION         = 12, // normal action block
  TAG_PROTECT          = 24, // the author doesn't want the file to be opened
  TAG_ENABLEDEBUGGER   = 58, // debugger enabled
  TAG_ENABLEDEBUGGER2  = 64, // debugger enabled
  TAG_PLACEOBJECT2     = 26, // possibly onClipEvents inside
  TAG_DEFINEBUTTON2    = 34, // possibly button events inside
  TAG_DEFINEMOVIECLIP  = 39, // movie clip timeline comes
  TAG_FRAMELABEL       = 43, // just a label
  TAG_INITMOVIECLIP    = 59, // flash 6 mc initialization actions (#initclip .. #endinitclip)
  TAG_END              = 0   // end tag for movie clip or swf
} tagheaderid;

typedef enum
{
  MODE_DECOMPRESS      = 0,
  MODE_COMPRESS        = 1,
  MODE_ASSEMBLE        = 2,
  MODE_DISASSEMBLE     = 3,
  MODE_UPDATE          = 4,
  MODE_OBFUSCATE       = 5,
  MODE_IDE             = 6,
/*MODE_PROFILE         = 6, */
  MODE_FLASH_HELP      = 8
} processingmode;

#define MAX_BUFFER	 32000
#define MAX_CONSTANTS	 10000
#define MAX_LABELS	 2048
#define MAX_INCLUDE_POOL 4000
#define DUPCLIP_NUMBER   0x4000

#endif /* ACTION_H_INCLUDED */
