
%{

#include <math.h>
#include <string.h>
#include <unistd.h>

#include "flasm.h"
#include "assembler.tab.h"

int yydebug;

char *lexBuffer	= NULL;
int lexBufferLen = 0;

#define	MAX_INCLUDE_DEPTH 10
#define	MAX_LINE_LENGTH	4096
extern char *inputName;
YY_BUFFER_STATE	include_stack[MAX_INCLUDE_DEPTH];
static int include_stack_ptr = 0;
static char *includenames[MAX_INCLUDE_DEPTH];
static int  sLineNumber[MAX_INCLUDE_DEPTH];
static int  column[MAX_INCLUDE_DEPTH];
static char szLine[MAX_LINE_LENGTH];

/* Function prototypes */
int  yywrap();
void count(int numActionsIncrement);
void comment(void);
void comment1(void);
void yyerror(char *msg);
void warning(char *msg);

char buf[4096];
char *s;

int numActions = 0;

%}

DIGIT	 [0-9]
LABELD	 [a-zA-Z_][a-zA-Z0-9_.]*:
ID	 [a-zA-Z_][a-zA-Z0-9_.]*
%x MOVIEDECL
%x STRINGSINGLEQ
%x STRINGDOUBLEQ
%x INCL

%%

0x[0-9a-fA-F]+		{ count(0);	yylval.str = strdup(yytext+2);
					return HEX;		}
-{DIGIT}+		{ count(0);	yylval.str = strdup(yytext);
					return INTEGER;		}
{DIGIT}+		{ count(0);	yylval.str = strdup(yytext);
					return INTEGER;		}

-?{DIGIT}+"."{DIGIT}*(e("+"|"-"){DIGIT}{1,3})?f	{ count(0);
						  yylval.str = strdup(yytext);
						  return FLOAT; }

-?{DIGIT}+"."{DIGIT}*(e("+"|"-"){DIGIT}{1,3})?	{ count(0);
						  yylval.str = strdup(yytext);
						  return DOUBLE; }

r\:{DIGIT}+		{ count(0);	yylval.str = strdup(yytext+2);
					return REGISTER;	}

compressed		{ count(0);	return COMPRESSED; }
protect			{ count(0);	return PROTECT; }
enableDebugger		{ count(0);	return ENABLEDEBUGGER; }
enableDebugger2		{ count(0);	return ENABLEDEBUGGER2; }
placemovieclip		{ count(0);	return PLACEMOVIECLIP; }
definemovieclip		{ count(0);	return DEFINEMOVIECLIP;	}
initmovieclip		{ count(-1);	return INITMOVIECLIP; }
definebutton		{ count(0);	return DEFINEBUTTON; }
frame			{ count(-1);	return FRAME; }
on			{ count(-1);	return ON; }
onclipevent		{ count(-1);	return ONCLIPEVENT; }
end			{ count(0);	return END; }

_nan			{ count(0);	return _NAN; }
positive_infinity	{ count(0);	return POSITIVE_INFINITY; }
negative_infinity	{ count(0);	return NEGATIVE_INFINITY; }
_nanf			{ count(0);	return _NANF; }
positive_infinityf	{ count(0);	return POSITIVE_INFINITYF; }
negative_infinityf	{ count(0);	return NEGATIVE_INFINITYF; }

x_property		{ count(0);	return X_PROPERTY; }
y_property		{ count(0);	return Y_PROPERTY; }
xscale_property		{ count(0);	return XSCALE_PROPERTY;	}
yscale_property		{ count(0);	return YSCALE_PROPERTY;	}
width_property		{ count(0);	return WIDTH_PROPERTY; }
height_property		{ count(0);	return HEIGHT_PROPERTY;	}
alpha_property		{ count(0);	return ALPHA_PROPERTY; }
visible_property	{ count(0);	return VISIBLE_PROPERTY; }
rotation_property	{ count(0);	return ROTATION_PROPERTY; }
highquality_property	{ count(0);	return HIGHQUALITY_PROPERTY; }
focusrect_property	{ count(0);	return FOCUSRECT_PROPERTY; }
soundbuftime_property	{ count(0);	return SOUNDBUFTIME_PROPERTY; }
currentframe_property	{ count(0);	return CURRENTFRAME_PROPERTY; }
totalframes_property	{ count(0);	return TOTALFRAMES_PROPERTY; }
target_property		{ count(0);	return TARGET_PROPERTY;	}
framesloaded_property	{ count(0);	return FRAMESLOADED_PROPERTY; }
name_property		{ count(0);	return NAME_PROPERTY; }
droptarget_property	{ count(0);	return DROPTARGET_PROPERTY; }
url_property		{ count(0);	return URL_PROPERTY; }
quality_property	{ count(0);	return QUALITY_PROPERTY; }
xmouse_property		{ count(0);	return XMOUSE_PROPERTY;	}
ymouse_property		{ count(0);	return YMOUSE_PROPERTY;	}

idletooverup		{ count(0);	return BIDLETOOVERUP; }
overuptoidle		{ count(0);	return BOVERUPTOIDLE; }
overuptooverdown	{ count(0);	return BOVERUPTOOVERDOWN; }
overdowntooverup	{ count(0);	return BOVERDOWNTOOVERUP; }
overdowntooutdown	{ count(0);	return BOVERDOWNTOOUTDOWN; }
outdowntooverdown	{ count(0);	return BOUTDOWNTOOVERDOWN; }
outdowntoidle		{ count(0);	return BOUTDOWNTOIDLE; }
idletooverdown		{ count(0);	return BIDLETOOVERDOWN;	}
overdowntoidle		{ count(0);	return BOVERDOWNTOIDLE;	}

keypress		{ count(0);	return KEYPRESS; }

_left			{ count(0);	return _LEFT; }
_right			{ count(0);	return _RIGHT; }
_home			{ count(0);	return _HOME; }
_end			{ count(0);	return _END; }
_ins			{ count(0);	return _INS; }
_del			{ count(0);	return _DEL; }
_backspace		{ count(0);	return _BACKSPACE; }
_enter			{ count(0);	return _ENTER; }
_up			{ count(0);	return _UP; }
_dn			{ count(0);	return _DN; }
_pgup			{ count(0);	return _PGUP; }
_pgdn			{ count(0);	return _PGDN; }
_tab			{ count(0);	return _TAB; }
_space			{ count(0);	return _SPACE; }

load			{ count(0);	return MCLOAD; }
enterframe		{ count(0);	return MCENTERFRAME; }
unload			{ count(0);	return MCUNLOAD; }
mousemove		{ count(0);	return MCMOUSEMOVE; }
mousedown		{ count(0);	return MCMOUSEDOWN; }
mouseup			{ count(0);	return MCMOUSEUP; }
keydown			{ count(0);	return MCKEYDOWN; }
keyup			{ count(0);	return MCKEYUP;	}
data			{ count(0);	return MCDATA; }
initialize		{ count(0);	return MCINITIALIZE; }
press			{ count(0);	return MCPRESS; }
release			{ count(0);	return MCRELEASE; }
releaseoutside		{ count(0);	return MCRELEASEOUTSIDE; }
rollover		{ count(0);	return MCROLLOVER; }
rollout			{ count(0);	return MCROLLOUT; }
dragover		{ count(0);	return MCDRAGOVER; }
dragout			{ count(0);	return MCDRAGOUT; }

true			{ count(0);	return TRUEVAL;	}
false			{ count(0);	return FALSEVAL; }
null			{ count(0);	return NULLVAL;	}
undef			{ count(0);	return UNDEFVAL; }

nextframe		{ count(1);	return NEXTFRAME; }
prevframe		{ count(1);	return PREVFRAME; }
gotoframe		{ count(1);	return GOTOFRAME; }
gotolabel		{ count(1);	return GOTOLABEL; }
geturl			{ count(1);	return GETURL; }
play			{ count(1);	return PLAY; }
stop			{ count(1);	return STOP; }
stopsounds		{ count(1);	return STOPSOUNDS; }
togglequality		{ count(1);	return TOGGLEQUALITY; }
function		{ count(1);	return FUNCTION; }
dup			{ count(1);	return DUP; }
swap			{ count(1);	return SWAP; }
pop			{ count(1);	return POP; }
with			{ count(1);	return WITH; }
push			{ count(1);	return PUSH; }
constants		{ count(1);	return CONSTANTS; }
setregister		{ count(1);	return SETREGISTER; }
callfunction		{ count(1);	return CALLFUNCTION; }
return			{ count(1);	return RETURN; }
newmethod		{ count(1);	return NEWMETHOD; }
callmethod		{ count(1);	return CALLMETHOD; }
bitwiseand		{ count(1);	return BITWISEAND; }
bitwiseor		{ count(1);	return BITWISEOR; }
bitwisexor		{ count(1);	return BITWISEXOR; }
modulo			{ count(1);	return MODULO; }
oldadd			{ count(1);	return OLDADD; }
add			{ count(1);	return NEWADD; }
newadd			{ count(1);	return NEWADD; }
oldlessthan		{ count(1);	return OLDLESSTHAN; }
lessthan		{ count(1);	return NEWLESSTHAN; }
newlessthan		{ count(1);	return NEWLESSTHAN; }
greaterthan		{ count(1);	return GREATERTHAN; }
oldequals		{ count(1);	return OLDEQUALS; }
equals			{ count(1);	return NEWEQUALS; }
newequals		{ count(1);	return NEWEQUALS; }
strictequals		{ count(1);	return STRICTEQUALS; }
tonumber		{ count(1);	return TONUMBER; }
tostring		{ count(1);	return TOSTRING; }
increment		{ count(1);	return INCREMENT; }
decrement		{ count(1);	return DECREMENT; }
typeof			{ count(1);	return TYPEOF; }
targetpath		{ count(1);	return TARGETPATH; }
enumerate		{ count(1);	return ENUMERATE; }
enumerateValue		{ count(1);	return ENUMERATEVALUE; }
instanceof		{ count(1);	return INSTANCEOF; }
delete			{ count(1);	return DELETE; }
delete2			{ count(1);	return DELETE2;	}
new			{ count(1);	return NEW; }
initobject		{ count(1);	return INITOBJECT; }
initarray		{ count(1);	return INITARRAY; }
getmember		{ count(1);	return GETMEMBER; }
setmember		{ count(1);	return SETMEMBER; }
shiftleft		{ count(1);	return SHIFTLEFT; }
shiftright		{ count(1);	return SHIFTRIGHT; }
shiftright2		{ count(1);	return SHIFTRIGHT2; }
var			{ count(1);	return VAR; }
varequals		{ count(1);	return VAREQUALS; }
subtract		{ count(1);	return SUBTRACT; }
multiply		{ count(1);	return MULTIPLY; }
divide			{ count(1);	return DIVIDE; }
and			{ count(1);	return LOGICALAND; }
or			{ count(1);	return LOGICALOR; }
not			{ count(1);	return LOGICALNOT; }
stringeq		{ count(1);	return STRINGEQ; }
stringlength		{ count(1);	return STRINGLENGTH; }
substring		{ count(1);	return SUBSTRING; }
int			{ count(1);	return INT; }
getvariable		{ count(1);	return GETVARIABLE; }
setvariable		{ count(1);	return SETVARIABLE; }
settarget		{ count(2);	return SETTARGET; }
settargetexpr		{ count(2);	return SETTARGETEXPR; }
concat			{ count(1);	return STRINGCONCAT; }
getproperty		{ count(1);	return GETPROPERTY; }
setproperty		{ count(1);	return SETPROPERTY; }
duplicateclip		{ count(1);	return DUPLICATECLIP; }
removeclip		{ count(1);	return REMOVECLIP; }
trace			{ count(1);	return TRACE; }
startdrag		{ count(1);	return STARTDRAGMOVIE; }
stopdrag		{ count(1);	return STOPDRAGMOVIE; }
stringlessthan		{ count(1);	return STRINGLESSTHAN; }
stringgreaterthan	{ count(1);	return STRINGGREATERTHAN; }
random			{ count(1);	return RANDOM; }
mblength		{ count(1);	return MBLENGTH; }
ord			{ count(1);	return ORD; }
chr			{ count(1);	return CHR; }
gettimer		{ count(1);	return GETTIMER; }
mbsubstring		{ count(1);	return MBSUBSTRING; }
mbord			{ count(1);	return MBORD; }
mbchr			{ count(1);	return MBCHR; }
branch			{ count(1);	return BRANCHALWAYS; }
branchalways		{ count(1);	return BRANCHALWAYS; }
branchiftrue		{ count(1);	return BRANCHIFTRUE; }
geturl2			{ count(1);	return GETURL2;	}
loadvariables		{ count(1);	return LOADVARIABLES; }
loadvariablesnum	{ count(1);	return LOADVARIABLESNUM; }
loadmovie		{ count(1);	return LOADMOVIE; }
loadmovienum		{ count(1);	return LOADMOVIENUM; }
callframe		{ count(1);	return CALLFRAME; }
gotoandplay		{ count(1);	return GOTOANDPLAY; }
gotoandstop		{ count(1);	return GOTOANDSTOP; }
skip			{ count(1);	return SKIP; }
ifframeloadedexpr	{ count(1);	return IFFRAMELOADEDEXPR; }
ifframeloaded		{ count(1);	return IFFRAMELOADED; }
strictmode		{ count(1);	return STRICTMODE; }
swfaction		{ count(1);	return SWFACTION; }

as			{ count(0);	return AS; }
post			{ count(0);	return POST; }
get			{ count(0);	return GET; }
hexdata			{ count(0);	return HEXDATA;	}
off			{ count(0);	return OFF; }

#INCLUDE[ \"\'\t]*	{ count(0);	BEGIN(INCL); }
<INCL>[^\"\'\t\r\n]+	{ /* got the include file name */
			  count(0);
			  if (include_stack_ptr	>= MAX_INCLUDE_DEPTH) 
			    yyerror("Includes nested too deeply");
			  if (access(yytext, R_OK)!=0)
			    yyerror("Cannot open include file!");
			  includenames[include_stack_ptr+1] = strdup(yytext); }
<INCL>[ \"\'\t\r]*\n	{ /* eat EOL and possible end quote */
			  count(0);
			  sLineNumber[include_stack_ptr]++;
			  include_stack[include_stack_ptr++] = YY_CURRENT_BUFFER;
			  sLineNumber[include_stack_ptr] = 0;
			  yyin = fopen(includenames[include_stack_ptr],	"r");	  
			  if (!yyin) {
			    include_stack_ptr--;
			    sLineNumber[include_stack_ptr]--;
			    yyerror("Problem opening include file!");
			  }
			  yy_switch_to_buffer(yy_create_buffer(yyin, YY_BUF_SIZE));
			  BEGIN	0; } 

{LABELD}		{ count(0);	yylval.str = strdup(yytext);
					yylval.str[yyleng-1]=0;
					return LABEL;		}

{ID}			{ count(0);	yylval.str = strdup(yytext);
					return STRING;		}

\'			{ count(0);	BEGIN STRINGSINGLEQ; s = buf; }
<STRINGSINGLEQ>\n	{ column[include_stack_ptr]--;
			  yyerror("Unterminated string!"); }
<STRINGSINGLEQ>\\b	{ count(0);	*s++ = '\b'; }
<STRINGSINGLEQ>\\t	{ count(0);	*s++ = '\t'; }
<STRINGSINGLEQ>\\n	{ count(0);	*s++ = '\n'; }
<STRINGSINGLEQ>\\f	{ count(0);	*s++ = '\f'; }
<STRINGSINGLEQ>\\r	{ count(0);	*s++ = '\r'; }
<STRINGSINGLEQ>\\\\	{ count(0);	*s++ = '\\'; }
<STRINGSINGLEQ>\\\'	{ count(0);	*s++ = '\''; }
<STRINGSINGLEQ>\'	{ count(0);
			  *s = 0;
			  yylval.str = strdup(buf);
			  BEGIN	0;
			  return STRING; }
<STRINGSINGLEQ>.	{ count(0);	*s++ = *yytext;	}

\"			{ count(0);	BEGIN STRINGDOUBLEQ; s = buf; }
<STRINGDOUBLEQ>\n	{ column[include_stack_ptr]--;
			  yyerror("Unterminated string!"); }
<STRINGDOUBLEQ>\\b	{ count(0);	*s++ = '\b'; }
<STRINGDOUBLEQ>\\t	{ count(0);	*s++ = '\t'; }
<STRINGDOUBLEQ>\\n	{ count(0);	*s++ = '\n'; }
<STRINGDOUBLEQ>\\f	{ count(0);	*s++ = '\f'; }
<STRINGDOUBLEQ>\\r	{ count(0);	*s++ = '\r'; }
<STRINGDOUBLEQ>\\\\	{ count(0);	*s++ = '\\'; }
<STRINGDOUBLEQ>\\\"	{ count(0);	*s++ = '\"'; }
<STRINGDOUBLEQ>\"	{ count(0); 
			  *s = 0;
			  yylval.str = strdup(buf);
			  BEGIN	0;
			  return STRING; }
<STRINGDOUBLEQ>.	{ count(0);	*s++ = *yytext;	}

"movie"[ \t\v\f]+[\'\"]	{ count(0);
			  BEGIN	MOVIEDECL;
			  s = buf;
			  return MOVIE;	}
<MOVIEDECL>\n		{ column[include_stack_ptr]--;
			  yyerror("Unterminated movie name!"); }
<MOVIEDECL>[\'\"]	{ count(0);
			  *s = 0;
			  yylval.str = strdup(buf);
			  BEGIN	0;
			  return MOVIENAME; }
<MOVIEDECL>.		{ count(0);	*s++ = *yytext;	}

"movie"[ \t\v\f]+[^\n\\'\\"] { count(0);	yyerror("Movie name must be included in	quotes"); }

"/*"			{ count(0);	comment();	}
"//"			{ count(0);	comment1();	}
[ \t\v\f]		{ count(0); }


":"			{ count(0); return ':'; }
"("			{ count(0); return '('; }
")"			{ count(0); return ')'; }
","			{ count(0); return ','; }
"."			{ count(0); return '.'; }

\r			
\n			{ count(0); }

.			{ yyerror("Unrecognized character"); }

<<EOF>>			{ if (--include_stack_ptr < 0)
			    yyterminate();
			  else {
			    yy_delete_buffer(YY_CURRENT_BUFFER);
			    yy_switch_to_buffer(include_stack[include_stack_ptr]);
			    column[include_stack_ptr] =	0;
			  }
			}
%%

int yywrap()
{
   return(1);
}

char *FileName(void)
{  
   if (include_stack_ptr==0)
     return inputName;
   else
     return includenames[include_stack_ptr];
}

int LineNumber(void)
{
   return sLineNumber[include_stack_ptr];
}

int ColumnNumber(void)
{
   return column[include_stack_ptr];
}

void comment(void)
{
   // Handle block comments

   char	c, c1;

loop:
   // We have the start	of a comment so	look skip everything up	to the
   // end of the comment character
   while ((c = input())	!= '*' && c != 0  && c != EOF)
   {
      column[include_stack_ptr]++;

      // keep the line number in synch
      if (c == '\n')
      {
	 column[include_stack_ptr] = 0;
	 sLineNumber[include_stack_ptr]++;
      }

      if (yydebug) putchar(c);
   }

   // is this the end of comment character
   if ((c1 = input()) != '/' &&	c != 0)
   {
      // false start as	this was no end	of comment
      unput(c1);
      goto loop;
   }

   // write out	the start of the end of	comment
   if (c != 0)
      if (yydebug) putchar(c);

   // write out	the end	of the end of comment
   if (c1 != 0)	
      if (yydebug) putchar(c1);
}

void comment1(void)
{
   // Handle comment of	type 1 (ie '//')

   char	c;

   // this is a	line comment
   while ((c = input())	!= '\n'	&& c !=	0 && c != EOF)
   {
      if (yydebug) putchar(c);
   };

   // keep the line number in synch
   if (c == '\n')
   {
      if (yydebug) putchar(c);
      column[include_stack_ptr]	= 0;
      sLineNumber[include_stack_ptr]++;
   }
}

void count(int numActionsIncrement)
{
   // Count the	characters to maintain the current column position
   if (yytext[0] == '\n')
   {
      column[include_stack_ptr]	= 0;
      sLineNumber[include_stack_ptr]++;

      if (yydebug) printf("\n");
   }
   else
   {
      if (yydebug) printf("%s",	yytext);
      column[include_stack_ptr]	+= yyleng;
   }

   if (numActionsIncrement != -1)
     numActions += numActionsIncrement;
   else
     numActions = 0;
}

void warning(char *msg)
{
   // print a warning message
   strcpy(szLine, yytext+yyleng-ColumnNumber());
   fprintf(stderr,"\n%s", szLine);
   if (yytext[0] != '\n') fprintf(stderr,"\n");
   fprintf(stderr,"%*s", ColumnNumber(), "^");
   fprintf(stderr,"\nLine %4.4d of %s:\nWarning: %s \n\n", LineNumber()+1, FileName(), msg);
}

void yyerror(char *msg)
{
   // report a error

   if (strlen(yytext))
   {
      strcpy(szLine, yytext+yyleng-ColumnNumber());
      sLineNumber[include_stack_ptr]++;
      fprintf(stderr,"\n%s", szLine);
      if (yytext[0] != '\n') fprintf(stderr,"\n");
      fprintf(stderr,"%*s", ColumnNumber(), "^");
      fprintf(stderr,"\nLine %4.4d of %s:\n%s \n", LineNumber(), FileName(), msg);
   }
   else
      fprintf(stderr, "Unexpected EOF found in %s while	looking	for input.\n",inputName);

   error("");
}
