%{

#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "flasm.h"

void yyerror(char *s);
void warning(char *msg);
int yylex();

extern char *yytext;

char *func_args[256];
unsigned long int curevent, allevents;

extern long int len;
extern int nConstants;
extern int mode;
extern char compressAfter;

extern int numActions;
int frameloadedstart = -1;
%}


%union
{
  unsigned long int len;
  char *str;
  char num;
}

%expect	1  /* double nots shift/reduce warning */

%token <str> MOVIENAME
%token <str> STRING
%token <str> INTEGER
%token <str> HEX
%token <str> FLOAT
%token <str> DOUBLE
%token <str> TRUEVAL
%token <str> FALSEVAL
%token <str> NULLVAL
%token <str> UNDEFVAL
%token <str> REGISTER
%token <str> LABEL

%token MOVIE
%token COMPRESSED
%token PROTECT
%token ENABLEDEBUGGER
%token ENABLEDEBUGGER2
%token FRAME
%token PLACEMOVIECLIP
%token DEFINEMOVIECLIP
%token INITMOVIECLIP
%token DEFINEBUTTON
%token ON
%token ONCLIPEVENT
%token AS

// special double values
%token _NAN
%token POSITIVE_INFINITY
%token NEGATIVE_INFINITY

// special float values - push type 1
%token _NANF
%token POSITIVE_INFINITYF
%token NEGATIVE_INFINITYF

// button events
%token BIDLETOOVERUP
%token BOVERUPTOIDLE
%token BOVERUPTOOVERDOWN
%token BOVERDOWNTOOVERUP
%token BOVERDOWNTOOUTDOWN
%token BOUTDOWNTOOVERDOWN
%token BOUTDOWNTOIDLE
%token BIDLETOOVERDOWN
%token BOVERDOWNTOIDLE

%token KEYPRESS

// keyPress pre-defined
%token _LEFT
%token _RIGHT
%token _HOME
%token _END
%token _INS
%token _DEL
%token _BACKSPACE
%token _ENTER
%token _UP
%token _DN
%token _PGUP
%token _PGDN
%token _TAB
%token _SPACE

// onClipEvents
%token MCLOAD
%token MCENTERFRAME
%token MCUNLOAD
%token MCMOUSEMOVE
%token MCMOUSEDOWN
%token MCMOUSEUP
%token MCKEYDOWN
%token MCKEYUP
%token MCINITIALIZE
%token MCDATA
%token MCPRESS
%token MCRELEASE
%token MCRELEASEOUTSIDE
%token MCROLLOVER
%token MCROLLOUT
%token MCDRAGOVER
%token MCDRAGOUT

// old-style properties
%token X_PROPERTY
%token Y_PROPERTY
%token XSCALE_PROPERTY
%token YSCALE_PROPERTY
%token WIDTH_PROPERTY
%token HEIGHT_PROPERTY
%token ALPHA_PROPERTY
%token VISIBLE_PROPERTY
%token ROTATION_PROPERTY
%token CURRENTFRAME_PROPERTY
%token TOTALFRAMES_PROPERTY
%token TARGET_PROPERTY
%token FRAMESLOADED_PROPERTY
%token NAME_PROPERTY
%token DROPTARGET_PROPERTY
%token URL_PROPERTY
%token QUALITY_PROPERTY
%token XMOUSE_PROPERTY
%token YMOUSE_PROPERTY
%token HIGHQUALITY_PROPERTY
%token FOCUSRECT_PROPERTY
%token SOUNDBUFTIME_PROPERTY

%token NEXTFRAME
%token PREVFRAME
%token GOTOFRAME
%token GOTOLABEL
%token PLAY
%token STOP
%token TOGGLEQUALITY
%token STOPSOUNDS
%token FUNCTION
%token CONSTANTS
%token END
%token DUP
%token SWAP
%token POP
%token WITH
%token PUSH
%token SETREGISTER
%token CALLFUNCTION
%token RETURN
%token NEWMETHOD
%token CALLMETHOD
%token BITWISEAND
%token BITWISEOR
%token BITWISEXOR
%token MODULO
%token NEWADD
%token NEWLESSTHAN
%token NEWEQUALS
%token TONUMBER
%token TOSTRING
%token INCREMENT
%token DECREMENT
%token TYPEOF
%token TARGETPATH
%token ENUMERATE
%token ENUMERATEVALUE
%token INSTANCEOF
%token DELETE
%token DELETE2
%token NEW
%token INITARRAY
%token INITOBJECT
%token GETMEMBER
%token SETMEMBER
%token SHIFTLEFT
%token SHIFTRIGHT
%token SHIFTRIGHT2
%token VAR
%token VAREQUALS
%token OLDADD
%token SUBTRACT
%token MULTIPLY
%token DIVIDE
%token OLDEQUALS
%token OLDLESSTHAN
%token STRICTEQUALS
%token GREATERTHAN
%token LOGICALAND
%token LOGICALOR
%token LOGICALNOT
%token STRINGEQ
%token STRINGLENGTH
%token SUBSTRING
%token INT
%token GETVARIABLE
%token SETVARIABLE
%token SETTARGET
%token SETTARGETEXPR
%token STRINGCONCAT
%token GETPROPERTY
%token SETPROPERTY
%token DUPLICATECLIP
%token REMOVECLIP
%token TRACE
%token STARTDRAGMOVIE
%token STOPDRAGMOVIE
%token STRINGLESSTHAN
%token STRINGGREATERTHAN
%token RANDOM
%token MBLENGTH
%token ORD
%token CHR
%token GETTIMER
%token MBSUBSTRING
%token MBORD
%token MBCHR
%token BRANCHALWAYS
%token GETURL
%token GETURL2
%token LOADMOVIE
%token LOADMOVIENUM
%token LOADVARIABLES
%token LOADVARIABLESNUM
%token POST
%token GET
%token BRANCHIFTRUE
%token CALLFRAME
%token GOTOANDPLAY
%token GOTOANDSTOP
%token SKIP
%token IFFRAMELOADEDEXPR
%token IFFRAMELOADED
%token ELSE
%token SKIP
%token STRICTMODE
%token OFF

/* unknown instruction handling	*/
%token SWFACTION
%token HEXDATA

%token '(', ')', ',', ':', '"',	'.'

%type <str> funcname_opt
%type <str> mcname_opt
%type <len> statements,	statement, statements_opt
%type <len> function, function_args
%type <len> push_list, push_item
%type <len> with
%type <len> settarget, settargetexpression, ifframeloaded, ifframeloadedexpression
%type <len> actionblocks, actionblock, actionblocks_opt
%type <len> buttoneventblocks, buttoneventblock, buttoneventblocks_opt
%type <len> mceventblocks, mceventblock, mceventblocks_opt
%type <len> mcblocks, mcblock, mcblocks_opt
%type <len> frame, definebutton, definemc, placemc, initmc
%type <len> buttonevent, buttonevents, mcevent, mcevents, key, property
%type <len> opcode,hex_list, hexdata_opt
%type <num> urlmethod

%%

/* rules */
program
	: MOVIE	MOVIENAME			{ startUpdate($2); }
	  actionblocks_opt END			{ finishUpdate();  }
	;

actionblocks_opt
	: /* empty */				{ $$ = 0;  }
	| actionblocks				{ $$ = $1; }
	;

actionblocks
	: actionblock				{ $$ = $1; }
	| actionblocks actionblock		{ $$ = $1;
						  $$ += $2; }
	;

actionblock
	: frame					{ $$ = $1; }
	| definebutton				{ $$ = $1; }
	| definemc				{ $$ = $1; }
	| placemc				{ $$ = $1; }
	| initmc				{ $$ = $1; }
	| COMPRESSED				{ compressAfter = 1; $$ = 0; }
	| PROTECT				{ writeProtect(""); $$ = 0; }
	| PROTECT STRING			{ writeProtect($2); $$ = 0; }
	| ENABLEDEBUGGER			{ writeEnableDebugger(""); $$ = 0; }
	| ENABLEDEBUGGER STRING			{ writeEnableDebugger($2); $$ = 0; }
	| ENABLEDEBUGGER2 STRING		{ writeEnableDebugger2($2); $$ = 0; }
	;

frame
	: FRAME	INTEGER			
	  statements_opt END			{ $$ = $3;
						  $$ +=	writeByte(0); /*action end*/
						  writeDoAction();
						  $$ = 0; }
	;

initmc
	: INITMOVIECLIP	INTEGER			
	  statements_opt END			{ $$ = $3;
						  $$ +=	writeByte(0); /*action end*/
						  writeInitMC(atoi($2));
						  $$ = 0; }
	;

definebutton
	: DEFINEBUTTON INTEGER			{ writeButtonStart(atoi($2)); }
	  buttoneventblocks_opt	END		{ $$ = $4;
						  writeButtonEnd(); }
	;

buttoneventblocks_opt
	: /* empty */				{ $$ = 0; }
	| buttoneventblocks			{ $$ = $1; }
	;

buttoneventblocks
	: buttoneventblock			{ $$ = $1; }
	| buttoneventblocks buttoneventblock	{ $$ = $1;
						  $$ +=	$2; }
	;

buttoneventblock
	: ON					{ curevent = 0;	}
	  buttonevents				
	  statements END			{ $$ = $4;
						  $$ +=	writeByte(0); /*event action end*/
						  writeButtonEvent((unsigned int)curevent); }
	;

buttonevents
	: buttonevent				{ $$ = $1;
						  curevent += $1; }
	| buttonevents ',' buttonevent		{ $$ +=	$3;
						  curevent += $3; }
	;

buttonevent
	: BIDLETOOVERUP				{ $$ = 0x01; }
	| BOVERUPTOIDLE				{ $$ = 0x02; }
	| BOVERUPTOOVERDOWN			{ $$ = 0x04; }
	| BOVERDOWNTOOVERUP			{ $$ = 0x08; }
	| BOVERDOWNTOOUTDOWN			{ $$ = 0x10; }
	| BOUTDOWNTOOVERDOWN			{ $$ = 0x20; }
	| BOUTDOWNTOIDLE			{ $$ = 0x40; }
	| BIDLETOOVERDOWN			{ $$ = 0x80; }
	| BOVERDOWNTOIDLE			{ $$ = 0x100; }
	| KEYPRESS key				{ $$ = $2<<9; }
	;

key
	: _LEFT					{ $$ = 1; }
	| _RIGHT				{ $$ = 2; }
	| _HOME					{ $$ = 3; }
	| _END					{ $$ = 4; }
	| _INS					{ $$ = 5; }
	| _DEL					{ $$ = 6; }
	| _BACKSPACE				{ $$ = 8; }
	| _ENTER				{ $$ = 13; }
	| _UP					{ $$ = 14; }
	| _DN					{ $$ = 15; }
	| _PGUP					{ $$ = 16; }
	| _PGDN					{ $$ = 17; }
	| _TAB					{ $$ = 18; }
	| _SPACE				{ $$ = 32; }
	| STRING				{ $$ = $1[0]; }
	;

definemc
	: DEFINEMOVIECLIP INTEGER		{ writeDefineMCStart(atoi($2));	}
	  mcblocks_opt END			{ $$ = $4;
						  writeDefineMCEnd(); }
	;

mcblocks_opt
	: /* empty */				{ $$ = 0; }
	| mcblocks				{ $$ = $1; }
	;

mcblocks
	: mcblock				{ $$ = $1; }
	| mcblocks mcblock			{ $$ = $1;
						  $$ +=	$2; }
	;

mcblock
	: frame					{ $$ = $1; }
	| placemc				{ $$ = $1; }
	| PROTECT				{ yyerror("Protect tag is not allowed within movie clip definition"); }
	;

placemc
	: PLACEMOVIECLIP INTEGER mcname_opt	{ allevents = 0;
						  writePlaceMCStart(atoi($2)); }
	  mceventblocks_opt END			{ $$ = $5;
						  writePlaceMCEnd(allevents); }
	;

mcname_opt
	: /* empty */				{ $$ = ""; }
	| AS STRING				{ $$ = $2; }
	;

mceventblocks_opt
	: /* empty */				{ $$ = 0;  }
	| mceventblocks				{ $$ = $1; }
	;

mceventblocks
	: mceventblock				{ $$ = $1; }
	| mceventblocks	mceventblock		{ $$ = $1;
						  $$ +=	$2;}
	;

mceventblock
	: ONCLIPEVENT mcevents			{ curevent = $2;
						  allevents |= curevent; }
	  statements_opt END			{ $$ = $4;
						  $$ +=	writeByte(0); /*event action end*/
						  writeOnClipEvent(curevent);
						  curevent = 0; }
	;

mcevents
	: mcevent				{ $$ = $1;
						  curevent += $1; }
	| mcevents ',' mcevent			{ $$ +=	$3;
						  curevent += $3; }
	;

mcevent
	: /* empty */			{ yyerror("Missing mc event condition")	}
	| MCLOAD			{ $$ = 0x01;   }
	| MCENTERFRAME			{ $$ = 0x02;   }
	| MCUNLOAD			{ $$ = 0x04;   }
	| MCMOUSEMOVE			{ $$ = 0x08;   }
	| MCMOUSEDOWN			{ $$ = 0x10;   }
	| MCMOUSEUP			{ $$ = 0x20;   }
	| MCKEYDOWN			{ $$ = 0x40;   }
	| MCKEYUP			{ $$ = 0x80;   }
	| MCDATA			{ $$ = 0x100;  }
	| MCINITIALIZE			{ $$ = 0x200;  }
	| MCPRESS			{ $$ = 0x400;  }
	| MCRELEASE			{ $$ = 0x800;  }
	| MCRELEASEOUTSIDE		{ $$ = 0x1000; }
	| MCROLLOVER			{ $$ = 0x2000; }
	| MCROLLOUT			{ $$ = 0x4000; }
	| MCDRAGOVER			{ $$ = 0x8000; }
	| MCDRAGOUT			{ $$ = 0x10000;}
	| KEYPRESS key			{ $$ = 0x20000;
					  writeByte($2); }
	;

statements
	: statement			{ $$ = $1; }
	| statements statement		{ $$ = $1;
					  $$ +=	$2; }
	;

statement
	: label				{ $$ = 0;  }
	| function			{ $$ = $1; }
	| with				{ $$ = $1; }
	| settarget			{ $$ = $1; }
	| settargetexpression		{ $$ = $1; }
	| ifframeloaded			{ $$ = $1; }
	| ifframeloadedexpression	{ $$ = $1; }
	| opcode			{ $$ = $1; }
	;


label
	: LABEL				{ addLabel($1);	}
	;

/* this	is weird/dumb- now we're returning the number of args instead
   of their length, and	the args are stored in a global	array func_args. */

function_args
	: /* empty */			{ $$ = 0; }
	| STRING			{ func_args[0] = strdup($1);
					  $$ = 1; }

	| function_args	',' STRING	{ func_args[$1]	= strdup($3);
					  $$ = $1 + 1; }
	;


statements_opt
	: /* empty */			{ $$ = 0; }
	| statements			{ $$ = $1; }
	;

funcname_opt
	: /* empty */			{ $$ = ""; }
	| STRING			{ $$ = $1; }
	;

function
	: FUNCTION funcname_opt		{ $$ = writeByte(SWFACTION_DEFINEFUNCTION);
					  $$ +=	writeShort(0); /* block	length */
					  $$ +=	writeString($2); }

	  '(' function_args ')'		{ int i, nargs = $5;

					  $$ = $<len>3 + writeShort(nargs);

					  for(i=0; i<nargs; ++i)
					    $$ += writeString(func_args[i]);

					  $$ +=	writeShort(0); /* function length */
					  patchLength($$-3);
					}

	  statements_opt END		{ $$ = $<len>7 + $8;
					  patchLength($8); }
	;


with
	: WITH
					{ $$ = writeByte(SWFACTION_WITH);
					  $$ +=	writeShort(2);	/* length of with action - 2 bytes */
					  $$ +=	writeShort(0);}	/* length of with block - will be patched */
	  statements_opt END		{ 
					  $$ = $<len>2 + $3;
					  patchLength($3);
					}

	;

settarget
	: SETTARGET STRING		{ $$ = writeByte(SWFACTION_SETTARGET);
					  $$ +=	writeShort(strlen($2)+1);
					  $$ +=	writeString($2); }
	  statements_opt END		{ $$ = $4 + writeByte(SWFACTION_SETTARGET);
					  $$ +=	$<len>3	+ writeShort(1);
					  $$ +=	writeByte(0); }
	;

settargetexpression
	: SETTARGETEXPR			{ $$ = writeByte(SWFACTION_SETTARGETEXPRESSION); }
	  statements_opt END		{ $$ = $3 + writeByte(SWFACTION_SETTARGET);
					  $$ +=	$<len>2	+ writeShort(1);
					  $$ +=	writeByte(0); }
	;

ifframeloadedexpression
	: IFFRAMELOADEDEXPR
					{ if (frameloadedstart>-1)
 					    yyerror("IfFrameLoaded actions can't be nested");
					  $$ = writeByte(SWFACTION_IFFRAMELOADEDEXPRESSION);
					  $$ +=	writeShort(1);
					  $$ +=	writeByte(0);
					  frameloadedstart = numActions; }
	  statements_opt END		{ 
					  $$ = $<len>2 + $3;
					  patchFrameLoaded($3, numActions-frameloadedstart);
					  frameloadedstart = -1;
					}
	;

ifframeloaded
	: IFFRAMELOADED INTEGER
					{ if (frameloadedstart>-1)
 					    yyerror("IfFrameLoaded actions can't be nested");
					  $$ = writeByte(SWFACTION_IFFRAMELOADED);
					  $$ +=	writeShort(3);
					  $$ +=	writeShort(atoi($2));
					  $$ +=	writeByte(0);
					  frameloadedstart = numActions; }
					 
	  statements_opt END		{ 
					  $$ = $<len>3 + $4;
					  patchFrameLoaded($4, numActions-frameloadedstart);
					  frameloadedstart = -1;
					}
	;

push_item
	: STRING			{ $$ = writePushString($1); }
	| property			{ writeByte(0x01);
					  $$ = writeFloat((float)$1)+1; }
	| FLOAT				{ float f;
					  int n;
					  writeByte(0x01);
				          n = sscanf($1, "%f", &f);
					  $$ = writeFloat(f)+1; }
	| _NANF				{ writeByte(0x01);
					  $$ = writeFloat(0.0f/0.0f)+1;	}
	| POSITIVE_INFINITYF		{ writeByte(0x01);
					  $$ = writeFloat(1.0/0.0f)+1;  }
	| NEGATIVE_INFINITYF		{ writeByte(0x01);
					  $$ = writeFloat(-1.0/0.0f)+1; }
	| HEX				{ writeByte(0x07);
					  $$ = writeInt(xtoi($1))+1; }
	| INTEGER			{ writeByte(0x07);
					  $$ = writeInt(atoi($1))+1; }
	| DOUBLE			{ writeByte(0x06);
					  $$ = writeDouble(atof($1))+1;	}
	| _NAN				{ writeByte(0x06);
					  $$ = writeDouble(0.0/0.0)+1;	}
	| POSITIVE_INFINITY		{ writeByte(0x06);
					  $$ = writeDouble(1.0/0.0)+1;	}
	| NEGATIVE_INFINITY		{ writeByte(0x06);
					  $$ = writeDouble(-1.0/0.0)+1;	}
	| TRUEVAL			{ writeByte(0x05);
					  $$ = writeByte(1)+1; }
	| FALSEVAL			{ writeByte(0x05);
					  $$ = writeByte(0)+1; }
	| NULLVAL			{ $$ = writeByte(2); }
	| UNDEFVAL			{ $$ = writeByte(3); }
	| REGISTER			{ if ((char)atoi($1)>3)
					    warning("flash 5/6 supports r:0, r:1, r:2 and r:3 registers only");
					  writeByte(0x04);
					  $$ = writeByte((char)atoi($1))+1; }
	;

property
	: X_PROPERTY			{ $$ = 0; }
	| Y_PROPERTY			{ $$ = 1; }
	| XSCALE_PROPERTY		{ $$ = 2; }
	| YSCALE_PROPERTY		{ $$ = 3; }
	| CURRENTFRAME_PROPERTY		{ $$ = 4; }
	| TOTALFRAMES_PROPERTY		{ $$ = 5; }
	| ALPHA_PROPERTY		{ $$ = 6; }
	| VISIBLE_PROPERTY		{ $$ = 7; }
	| WIDTH_PROPERTY		{ $$ = 8; }
	| HEIGHT_PROPERTY		{ $$ = 9; }
	| ROTATION_PROPERTY		{ $$ = 10; }
	| TARGET_PROPERTY		{ $$ = 11; }
	| FRAMESLOADED_PROPERTY		{ $$ = 12; }
	| NAME_PROPERTY			{ $$ = 13; }
	| DROPTARGET_PROPERTY		{ $$ = 14; }
	| URL_PROPERTY			{ $$ = 15; }
	| HIGHQUALITY_PROPERTY		{ $$ = 16; }
	| FOCUSRECT_PROPERTY		{ $$ = 17; }
	| SOUNDBUFTIME_PROPERTY		{ $$ = 18; }
	| QUALITY_PROPERTY		{ $$ = 19; }
	| XMOUSE_PROPERTY		{ $$ = 20; }
	| YMOUSE_PROPERTY		{ $$ = 21; }
	;

push_list
	: push_item			{ $$ = $1; }
	| push_list ','	push_item	{ $$ +=	$3; }
	;

constant_list
	: STRING			{ addConstant($1); }
	| constant_list	',' STRING	{ addConstant($3); }
	;

hex_list
	: HEX				{ if (xtoi($1)>0xff)
					    yyerror("Action data must be a byte	list!");
					  $$ = writeByte((char)xtoi($1)); }
	| hex_list ',' HEX		{ if (xtoi($3)>0xff)
					    yyerror("Action data must be a byte	list!");
					  $$ +=	writeByte((char)xtoi($3)); }
	;

hexdata_opt
	: /* empty */			{ $$ = 0; }
	| HEXDATA hex_list		{ $$ = $2; }
	;

urlmethod
	: /* empty */			{ $$ = 0; }
	| GET				{ $$ = 1; }
	| POST				{ $$ = 2; }
	;

opcode
	: CONSTANTS			{ nConstants = 0; }
	  constant_list			{ $$ = writeConstants(); }

	| PUSH				{ $$ = writeByte(SWFACTION_PUSHDATA);
					  $$ +=	writeShort(0); /* length */ }
	  push_list			{ $$ = $<len>2 + $3;
					  patchLength($3); }

	| SWFACTION HEX			{ if (xtoi($2)>0xff)
					    yyerror("Action code out of	range");
					  $$ = writeByte((char)xtoi($2));
					  if (xtoi($2)>=0x80)
					    $$ += writeShort(0); /* length */ }
	  hexdata_opt			{ if (($4>0) && (xtoi($2)>=0x80))
					    patchLength($4);
					  $$ = $<len>3 + $4; }

	| SETREGISTER REGISTER		{ if ((char)atoi($2)>3)
					    warning("flash 5/6 supports r:0, r:1, r:2 and r:3 registers only");
					  $$ = writeByte(SWFACTION_SETREGISTER);
					  $$ +=	writeShort(1);
					  $$ +=	writeByte((char)atoi($2)); }

	/* flash 6 actions */
	| STRICTEQUALS			{ $$ = writeByte(SWFACTION_STRICTEQUALS); }
	| GREATERTHAN			{ $$ = writeByte(SWFACTION_GREATERTHAN); }
	| ENUMERATEVALUE		{ $$ = writeByte(SWFACTION_ENUMERATEVALUE); }
	| INSTANCEOF			{ $$ = writeByte(SWFACTION_INSTANCEOF); }

	/* no args */
	| NEXTFRAME			{ $$ = writeByte(SWFACTION_NEXTFRAME); }
	| PREVFRAME			{ $$ = writeByte(SWFACTION_PREVFRAME); }
	| PLAY				{ $$ = writeByte(SWFACTION_PLAY); }
	| STOP				{ $$ = writeByte(SWFACTION_STOP); }
	| TOGGLEQUALITY			{ $$ = writeByte(SWFACTION_TOGGLEQUALITY); }
	| STOPSOUNDS			{ $$ = writeByte(SWFACTION_STOPSOUNDS);	}
	| CALLFUNCTION			{ $$ = writeByte(SWFACTION_CALLFUNCTION); }
	| RETURN			{ $$ = writeByte(SWFACTION_RETURN); }
	| NEWMETHOD			{ $$ = writeByte(SWFACTION_NEWMETHOD); }
	| CALLMETHOD			{ $$ = writeByte(SWFACTION_CALLMETHOD);	}
	| BITWISEAND			{ $$ = writeByte(SWFACTION_BITWISEAND);	}
	| BITWISEOR			{ $$ = writeByte(SWFACTION_BITWISEOR); }
	| BITWISEXOR			{ $$ = writeByte(SWFACTION_BITWISEXOR);	}
	| MODULO			{ $$ = writeByte(SWFACTION_MODULO); }
	| NEWADD			{ $$ = writeByte(SWFACTION_NEWADD); }
	| NEWLESSTHAN			{ $$ = writeByte(SWFACTION_NEWLESSTHAN); }
	| NEWEQUALS			{ $$ = writeByte(SWFACTION_NEWEQUALS); }
	| TONUMBER			{ $$ = writeByte(SWFACTION_TONUMBER); }
	| TOSTRING			{ $$ = writeByte(SWFACTION_TOSTRING); }
	| INCREMENT			{ $$ = writeByte(SWFACTION_INCREMENT); }
	| DECREMENT			{ $$ = writeByte(SWFACTION_DECREMENT); }
	| TYPEOF			{ $$ = writeByte(SWFACTION_TYPEOF); }
	| TARGETPATH			{ $$ = writeByte(SWFACTION_TARGETPATH);	}
	| ENUMERATE			{ $$ = writeByte(SWFACTION_ENUMERATE); }
	| DELETE			{ $$ = writeByte(SWFACTION_DELETE); }
	| DELETE2			{ $$ = writeByte(SWFACTION_DELETE2); }
	| NEW				{ $$ = writeByte(SWFACTION_NEW); }
	| INITARRAY			{ $$ = writeByte(SWFACTION_INITARRAY); }
	| INITOBJECT			{ $$ = writeByte(SWFACTION_INITOBJECT);	}
	| GETMEMBER			{ $$ = writeByte(SWFACTION_GETMEMBER); }
	| SETMEMBER			{ $$ = writeByte(SWFACTION_SETMEMBER); }
	| SHIFTLEFT			{ $$ = writeByte(SWFACTION_SHIFTLEFT); }
	| SHIFTRIGHT			{ $$ = writeByte(SWFACTION_SHIFTRIGHT);	}
	| SHIFTRIGHT2			{ $$ = writeByte(SWFACTION_SHIFTRIGHT2); }
	| VAR				{ $$ = writeByte(SWFACTION_VAR); }
	| VAREQUALS			{ $$ = writeByte(SWFACTION_VAREQUALS); }

	/* f4 ops */
	| OLDADD			{ $$ = writeByte(SWFACTION_ADD); }
	| SUBTRACT			{ $$ = writeByte(SWFACTION_SUBTRACT); }
	| MULTIPLY			{ $$ = writeByte(SWFACTION_MULTIPLY); }
	| DIVIDE			{ $$ = writeByte(SWFACTION_DIVIDE); }
	| OLDEQUALS			{ $$ = writeByte(SWFACTION_EQUALS); }
	| OLDLESSTHAN			{ $$ = writeByte(SWFACTION_LESSTHAN); }
	| LOGICALAND			{ $$ = writeByte(SWFACTION_LOGICALAND);	}
	| LOGICALOR			{ $$ = writeByte(SWFACTION_LOGICALOR); }
	| LOGICALNOT LOGICALNOT		{ if (mode>=MODE_UPDATE) {
					    /* strip double nots */
					    $$ = 0;
					    numActions = numActions-2;
					  }
					  else
					  {
					    $$ = writeByte(SWFACTION_LOGICALNOT);
					    $$ +=writeByte(SWFACTION_LOGICALNOT);
					  }
					}
	| LOGICALNOT			{ $$ = writeByte(SWFACTION_LOGICALNOT);	}
	| STRINGEQ			{ $$ = writeByte(SWFACTION_STRINGEQ); }
	| STRINGLENGTH			{ $$ = writeByte(SWFACTION_STRINGLENGTH); }
	| SUBSTRING			{ $$ = writeByte(SWFACTION_SUBSTRING); }
	| INT				{ $$ = writeByte(SWFACTION_INT); }
	| DUP				{ $$ = writeByte(SWFACTION_DUP); }
	| SWAP				{ $$ = writeByte(SWFACTION_SWAP); }
	| POP				{ $$ = writeByte(SWFACTION_POP); }
	| GETVARIABLE			{ $$ = writeByte(SWFACTION_GETVARIABLE); }
	| SETVARIABLE			{ $$ = writeByte(SWFACTION_SETVARIABLE); }
	| STRINGCONCAT			{ $$ = writeByte(SWFACTION_STRINGCONCAT); }
	| GETPROPERTY			{ $$ = writeByte(SWFACTION_GETPROPERTY); }
	| SETPROPERTY			{ $$ = writeByte(SWFACTION_SETPROPERTY); }
	| DUPLICATECLIP			{ $$ = writeByte(SWFACTION_DUPLICATECLIP); }
	| REMOVECLIP			{ $$ = writeByte(SWFACTION_REMOVECLIP);	}
	| TRACE				{ $$ = writeByte(SWFACTION_TRACE); }
	| STARTDRAGMOVIE		{ $$ = writeByte(SWFACTION_STARTDRAGMOVIE); }
	| STOPDRAGMOVIE			{ $$ = writeByte(SWFACTION_STOPDRAGMOVIE); }
	| STRINGLESSTHAN		{ $$ = writeByte(SWFACTION_STRINGLESSTHAN); }
	| STRINGGREATERTHAN		{ $$ = writeByte(SWFACTION_STRINGGREATERTHAN); }
	| RANDOM			{ $$ = writeByte(SWFACTION_RANDOM); }
	| MBLENGTH			{ $$ = writeByte(SWFACTION_MBLENGTH); }
	| ORD				{ $$ = writeByte(SWFACTION_ORD); }
	| CHR				{ $$ = writeByte(SWFACTION_CHR); }
	| GETTIMER			{ $$ = writeByte(SWFACTION_GETTIMER); }
	| MBSUBSTRING			{ $$ = writeByte(SWFACTION_MBSUBSTRING); }
	| MBORD				{ $$ = writeByte(SWFACTION_MBORD); }
	| MBCHR				{ $$ = writeByte(SWFACTION_MBCHR); }
	| CALLFRAME			{ $$ = writeByte(SWFACTION_CALLFRAME);
					  $$ +=	writeShort(0); }

	/* with	args */
	| GOTOANDSTOP			{ $$ = writeByte(SWFACTION_GOTOEXPRESSION);
					  $$ +=	writeShort(1);
					  $$ +=	writeByte(0); }

	| GOTOANDSTOP SKIP INTEGER	{ $$ = writeByte(SWFACTION_GOTOEXPRESSION);
					  $$ +=	writeShort(3);
					  $$ +=	writeByte(2);
					  $$ +=	writeShort(atoi($3)); }

	| GOTOANDPLAY			{ $$ = writeByte(SWFACTION_GOTOEXPRESSION);
					  $$ +=	writeShort(1);
					  $$ +=	writeByte(1); }

	| GOTOANDPLAY SKIP INTEGER	{ $$ = writeByte(SWFACTION_GOTOEXPRESSION);
					  $$ +=	writeShort(3);
					  $$ +=	writeByte(3);
					  $$ +=	writeShort(atoi($3)); }

	| GOTOLABEL STRING		{ $$ = writeByte(SWFACTION_GOTOLABEL);
					  $$ +=	writeShort(strlen($2)+1);
					  $$ +=	writeString($2); }

	| BRANCHALWAYS STRING		{ $$ = writeByte(SWFACTION_BRANCHALWAYS);
					  $$ +=	writeShort(2);
					  $$ +=	branchTarget($2); }

	| BRANCHALWAYS INTEGER		{ $$ = writeByte(SWFACTION_BRANCHALWAYS);
					  $$ +=	writeShort(2);
					  $$ +=	addNumLabel(atoi($2)); }

	| BRANCHIFTRUE STRING		{ $$ = writeByte(SWFACTION_BRANCHIFTRUE);
					  $$ +=	writeShort(2);
					  $$ +=	branchTarget($2); }

	| BRANCHIFTRUE INTEGER		{ $$ = writeByte(SWFACTION_BRANCHIFTRUE);
					  $$ +=	writeShort(2);
					  $$ +=	addNumLabel(atoi($2)); }

	| GOTOFRAME INTEGER		{ $$ = writeByte(SWFACTION_GOTOFRAME);
					  $$ +=	writeShort(2);
					  $$ +=	writeShort(atoi($2)) }

	| GETURL STRING	STRING		{ $$ = writeByte(SWFACTION_GETURL);
					  $$ +=	writeShort(strlen($2)+strlen($3)+2);
					  $$ +=	writeString($2); 
					  $$ +=	writeString($3); }

	| GETURL2 urlmethod		{ $$ = writeByte(SWFACTION_GETURL2);
					  $$ +=	writeShort(1);
					  $$ +=	writeByte($2); }

	| LOADVARIABLES	urlmethod	{ $$ = writeByte(SWFACTION_GETURL2);
					  $$ +=	writeShort(1);
					  $$ +=	writeByte(0xc0 + $2); }

	| LOADVARIABLESNUM urlmethod	{ $$ = writeByte(SWFACTION_GETURL2);
					  $$ +=	writeShort(1);
					  $$ +=	writeByte(0x80 + $2); }

	| LOADMOVIE urlmethod		{ $$ = writeByte(SWFACTION_GETURL2);
					  $$ +=	writeShort(1);
					  $$ +=	writeByte(0x40 + $2); }

	| LOADMOVIENUM urlmethod	{ $$ = writeByte(SWFACTION_GETURL2);
					  $$ +=	writeShort(1);
					  $$ +=	writeByte($2); }

	| STRICTMODE ON			{ $$ = writeByte(SWFACTION_STRICTMODE);
					  $$ +=	writeShort(1);
					  $$ +=	writeByte(1); }

	| STRICTMODE OFF		{ $$ = writeByte(SWFACTION_STRICTMODE);
					  $$ +=	writeShort(1);
					  $$ +=	writeByte(0); }

	| MOVIE	STRING			{ yyerror("Movie declaration inside of the action block"); }
	| PROTECT			{ yyerror("Protect tag is not allowed within action block"); }
	;
