<?php
include_once("test_common.php");

/// builds a big array
function makeHardTestData($n)
{
    $TotalArray = array();
    for( $i = 0; $i < $n; $i++ )
{
	$Col1 = "This is row ".$i;
	$Col2 = "10000000" . $i;
	$Col3 = "More text to add to this row." . $i;
	$ThisRow = array("col1"=>$Col1, "col2"=>$Col2, "col3"=>$Col3 );
	$TotalArray[] = $ThisRow;
    }

    return $TotalArray;
}

/// tests a big array using PHP encoding
function makeHardTestPHP($n)
{
    $data = makeHardTestData($n);
    
    $GLOBALS['amfphp']['encoding'] = "amf0";        
    $w = new AMFSerializer();
    $s = getmicrotime();
    $w->writeData($data);
    $e = getmicrotime()-$s;
    $amf3phplen = strlen($w->outBuffer);
    echo("PHP  $n,$e,$amf3phplen\n");
    
    $GLOBALS['amfphp']['encoding'] = "amf3";        
    $w = new AMFSerializer();
    $s = getmicrotime();
    $w->writeData($data);
    $e = getmicrotime()-$s;
    $amf3phplen = strlen($w->outBuffer);
    echo("3PHP $n,$e,$amf3phplen\n");
}

/// test native encoding with big data
function makeHardTest($n)
{
    $data = makeHardTestData($n);

    $s = getmicrotime();
    $ee = amf_encode($data,AMF_FLAG_BIG_ENDIAN);
    $e = getmicrotime()-$s;
    $amf3phplen = strlen($ee);
    echo("C    $n,$e,$amf3phplen\n");

    $s = getmicrotime();
    $ee = amf_encode($data,AMF_FLAG_BIG_ENDIAN|AMF_AMF3);
    $e = getmicrotime()-$s;
    $amf3phplen = strlen($ee);
    echo("3C   $n,$e,$amf3phplen\n");
}

$testspeed = 0;
$testdump = 0;
$q = 0;

if($q == 0)
{
    makeHardTest(100);
    makeHardTest(5000);
    makeHardTest(10000);
    makeHardTest(15000);
    makeHardTest(20000);
    makeHardTest(30000);
    makeHardTest(40000);
}
else if($q == 1)
{
    makeHardTestPHP(5000);
    makeHardTestPHP(10000);
    makeHardTestPHP(15000);
    makeHardTestPHP(20000);
    makeHardTestPHP(30000);
    makeHardTestPHP(40000);
    makeHardTestPHP(1);
}
else if($q == 2)
{
    test(makeHardTestData(1));
}

?>