<?php
include_once("test_common.php");

class RecordSetAdapter {
	var $rows = array();
	var $columns = array();

	/**
	 * The number of rows in this recordset
	 * 
	 * @access private 
	 * @var int 
	 */
	var $numRows = -1;

	/**
	 * Dummy constructor function.
	 * 
	 * @param resource $d The result resource
	 */

	function RecordSetAdapter ($d) {
		$this->_resultResource = $d;
		$this->_charsetHandler = new CharsetHandler('sqltophp');
		$this->_directCharsetHandler = new CharsetHandler('sqltoflash');
		$this->isBigEndian = AMFPHP_BIG_ENDIAN;
	} 

	/**
	 * getter for the number of rows
	 * 
	 * @return int The number of rows
	 */
	function getRowCount () {
		if($this->numRows == -1)
		{
			$this->numRows = count($this->rows);
		}
		return $this->numRows;
	} 
	
	function getID() {
		return md5(microtime());
	}
} 

class sqliteAdapter extends RecordSetAdapter
{

	/**
	 * Constructor method for the adapter.  This constructor implements the setting of the
	 * 3 required properties for the object.
	 * 
	 * @param resource $d The datasource resource
	 */
	 
	function sqliteAdapter($d)
	{
		parent::RecordSetAdapter($d);
		// grab all of the rows

		$fieldcount = $d->numFields();
	
		// loop over all of the fields
		for($i=0; $i<$fieldcount; $i++)  {
			// decode each field name ready for encoding when it goes through serialization
			// and save each field name into the array
			$this->columns[] = $d->fieldName($i);
		}
		
		if($d->numRows() > 0)
		{
			$this->rows = $d->fetchAll(SQLITE_NUM);
		}
	}
}

// default is use of typed object with original class
function amfphp_serialize_callback($value)
{
    if(is_resource($value))
        return "";
	$className = strtolower(get_class($value));
    if($className == 'sqliteresult')
    {
        $recordSet = new sqliteAdapter($value);
				$mode = 2;
                return array(
					array("__amf_recordset__" => $mode,
						 "rows" => $recordSet->rows,
						 "columns" => $recordSet->columns),
				5);
    
    }
	else
	{
        echo("unknonw class $className\n");
		//list($type, $subtype) = $this->sanitizeType($classname);
		//return array($value,3,$classname);		
	}
}

$db=new SQLiteDatabase("db.sqlite");
$db->query("BEGIN;
        CREATE TABLE users (id INTEGER(4) PRIMARY KEY,
name CHAR(255), email CHAR(255));
        INSERT INTO users (id,name,email) VALUES
(NULL,'User1','user1@domain.com');
        INSERT INTO users (id,name,email) VALUES
(NULL,'User2','user2@domain.com');
        INSERT INTO users (id,name,email) VALUES
(NULL,'User3','user3@domain.com');
        COMMIT;");
test($db->query("SELECT * FROM users"));


?>