<?php
/*
 * Common file for testing AMF native extension
 * by Emanuele Ruffaldi 2007
 * 
 * If the AMFPHP is present then it is used for comparison
 */
 
include_once(use_path(array("../amfext.php","../../amfext.php"))); // extension constants

define("AMFPHP_BASE", use_path(array("../../../../amfphp1.9/core/","../../../../amfphp1.9/core/","../../amfphp1.9/core/")));
define("AMFPHP_PHP5", PHP_VERSION >= 5 ? true : false);
define("AMFPHP_BIG_ENDIAN", pack("d", 1) == "\0\0\0\0\0\0\360\77");
define("AMFPHP_PRESENT", file_exists(AMFPHP_BASE."amf/io/AMFSerializer.php"));

// computed big endian flag for AMFPHP extension
define("AMF_FLAG_BIG_ENDIAN", pack("d", 1) == "\0\0\0\0\0\0\360\77" ? AMF_BIG_ENDIAN : 0);

extension_loaded("amf") or exit("AMF extension has not been loaded. Please copy php_amf.dll/php_amf.so in extension directory and enable it in php.ini");
    
global $amfphp;
if(AMFPHP_PRESENT)
{
    require_once(AMFPHP_BASE. "shared/util/Compat.php");
    require_once(AMFPHP_BASE. "shared/util/CharsetHandler.php");
    require_once(AMFPHP_BASE. "amf/io/AMFSerializer.php");
    require_once(AMFPHP_BASE."amf/io/AMFDeserializer.php");
    
    $amfphp = array();
    $amfphp['error_level'] = E_ALL ^ E_NOTICE;
    $amfphp['instanceName'] = NULL;
    $amfphp['native'] = false;
    $amfphp['classPath'] = 'services/';
    $amfphp['customMappingsPath'] = 'services/';
    $amfphp['adapterMappings'] = array();
    $amfphp['incomingClassMappings'] = array();
    $amfphp['outgoingClassMappings'] = array();
    $amfphp['webServiceMethod'] = 'php5';
    $amfphp['disableDescribeService'] = false;
    $amfphp['disableTrace'] = false;
    $amfphp['disableDebug'] = false;
    $amfphp['lastMethodCall'] = '/1';
    $amfphp['isFlashComm'] = false;
    $amfphp['classInstances'] = array();
}
else
    echo("AMFPHP is not present for testing. No PHP tests\n");

/**
 * Utility functions
 */

function use_path($x)
{
    foreach($x as $v)
        if(file_exists($v))
            return $v;
    return "./";
}

/// converts a string into hexadecimal
function strhex($string) {

   $hex = '';
   $len = strlen($string);
  
   for ($i = 0; $i < $len; $i++) {
      
       $hex .= str_pad(dechex(ord($string[$i])), 2, 0, STR_PAD_LEFT);
   }
      
   return $hex;
  
}

/// return precise timing
function getmicrotime(){
   list($usec, $sec) = explode(" ",microtime());
   return ((float)$usec + (float)$sec);
   }

/// version dependent XML loading into DOM
function loadXML($xmldoc)
{
    if(AMFPHP_PHP5 == 1)
    {
        $xml = new DOMDocument();
        $xml->LoadXML( $xmldoc );
        return $xml;
    }
    else if(extension_loaded("domxml"))
        return domxml_new_doc ($xmldoc);
    else if(extension_loaded("SimpleXML"))
        return simplexml_load_string($xmldoc);
    else
        return false;
}


/**
 * Global variables that control the testing 
 */
$testspeed = 0; // perform test speed
$testcount = 1000; // iterations
$testdump = 1; // dump result of tests in speed test
$cb = "amfphp_serialize_callback"; // default callback
$cbd = "amfphp_unserialize_callback";
$defaultFlags = AMF_ASSOCIATIVE_DECODE;
$test3 = 1;
$test0 = 1;

function test($x)
{
    global $testspeed,$testcount,$cb,$cbd,$testdump,$defaultFlags,$test3,$test0;
    if($testspeed == 1)
    {
        $tstart = getmicrotime();
        for($i = 0; $i < $testcount; $i++)
        {       
            $amf0 = amf_encode($x,AMF_FLAG_BIG_ENDIAN,$cb);
        }
        if($testdump)
            print("AMF0 C:".strhex($amf0)."\n\n");
        $tend = getmicrotime();
        $tamf0 = $tend-$tstart;
        $tstart = getmicrotime();
        for($i = 0; $i < $testcount; $i++)
        {       
            $amf3 = amf_encode($x,AMF_AMF3|AMF_FLAG_BIG_ENDIAN,$cb);
        }
        if($testdump)
        print("AMF3 C:".strhex($amf3)."\n\n");
        $tend = getmicrotime();
        $tamf3 = $tend-$tstart;
        $tstart = getmicrotime();
        for($i = 0; $i < $testcount; $i++)
        {       
            amf_decode($amf3,AMF_FLAG_BIG_ENDIAN,0,$cbd);
        }
        $tend = getmicrotime();
        $tdamf3 = $tend-$tstart;
        $tstart = getmicrotime();
        for($i = 0; $i < $testcount; $i++)
        {       
            amf_decode($amf0,AMF_FLAG_BIG_ENDIAN,0,$cbd);
        }
        $tend = getmicrotime();
        $tdamf0 = $tend-$tstart;
        
        echo "C  Tested $testcount times Encode (AMF0 $tamf0 AMF3 $tamf3) Decode:AMF0 $tdamf0 AMF3 $tdamf3\n";
    }
    else if($testspeed == 2)
    {
        if(AMFPHP_PRESENT)
        {
            var_dump($x);
            $tstart = getmicrotime();
            $GLOBALS['amfphp']['encoding'] = "amf0";
            for($i = 0; $i < $testcount; $i++)
            {       
                $w = new AMFSerializer();
                $w->writeData($x);
                $amf0 = $w->outBuffer;
            }
            if($testdump)
                print("AMF0 PHP:".strhex($amf0)."\n\n");
            $tend = getmicrotime();
            $tamf0 = $tend-$tstart;
            $tstart = getmicrotime();
            $GLOBALS['amfphp']['encoding'] = "amf3";
            for($i = 0; $i < $testcount; $i++)
            {       
                $w = new AMFSerializer();
                $w->writeData($x);
                $amf3 = $w->outBuffer;
            }
            if($testdump)
            print("AMF3 PHP:".strhex($amf3)."\n\n");
            $tend = getmicrotime();
            $tamf3 = $tend-$tstart;
            $tstart = getmicrotime();
            
            for($i = 0; $i < $testcount; $i++)
            {       
                $w = new AMFDeserializer($amf3);
                $w->readAny();
            }
            $tend = getmicrotime();
            $tdamf3 = $tend-$tstart;
            $tstart = getmicrotime();
            for($i = 0; $i < $testcount; $i++)
            {       
                $w = new AMFDeserializer($amf0);
                $w->readAny();
            }
            $tend = getmicrotime();
            $tdamf0 = $tend-$tstart;
            
            echo "PHP Tested $testcount times Encode (AMF0 $tamf0 AMF3 $tamf3) Decode:AMF0 $tdamf0 AMF3 $tdamf3\n";
            $testspeed = 1;
            test($x);
            $testspeed = 2;
        }
    }
    else
    {
        // every combination of C/PHP and AMF3 encoding and decoding
        echo(" SRC    :");var_dump($x);
        
        if($test0)
        {
            $amf0 = amf_encode($x,AMF_FLAG_BIG_ENDIAN,$cb);
            echo(" C      :".strhex($amf0)."\n");
            
            if(AMFPHP_PRESENT)
            {
                $GLOBALS['amfphp']['encoding'] = "amf0";        
                $GLOBALS['amfphp']['native'] = false;
                $w = new AMFSerializer();
                $w->writeData($x);
                $amf0php = $w->outBuffer;
                echo(" PHP    :".strhex($amf0php)."\n");
            }
            
            $r0 = amf_decode($amf0,AMF_FLAG_BIG_ENDIAN|$defaultFlags,0,$cbd);
            echo(" C>C    :");var_dump($r0);
            
            if(AMFPHP_PRESENT)
            {
                $w = new AMFDeserializer($amf0); 
                $r0php = $w->readAny();
                echo(" C>PHP  :");var_dump($r0php);
                $r0phpnative = amf_decode($amf0php,AMF_FLAG_BIG_ENDIAN|$defaultFlags,0,$cbd);
                echo(" PHP>C  :");var_dump($r0phpnative);  
                $w = new AMFDeserializer($amf0php); 
                $r0phpphp = $w->readAny();
                echo(" PHP>PHP:");var_dump($r0phpphp);
            }
        }

        if($test3)
        {
            $amf3 = amf_encode($x,AMF_FLAG_BIG_ENDIAN|AMF_AMF3,$cb);
            echo(" 3C      :".strhex($amf3)."\n");
            
            if(AMFPHP_PRESENT)
            {
                echo(" 3PHP    :");
                $GLOBALS['amfphp']['encoding'] = "amf3";        
                $GLOBALS['amfphp']['native'] = false;        
     	        $w = new AMFSerializer();
                $w->writeData($x);
                $amf3php = $w->outBuffer;
                echo(strhex($amf3php)."\n");
            }
                
            $r3 = amf_decode($amf3,AMF_FLAG_BIG_ENDIAN|$defaultFlags,0,$cbd);
            echo(" 3C>C    :"); var_dump($r3);
            
            if(AMFPHP_PRESENT)
            {
                $w = new AMFDeserializer($amf3); 
                $r3php = $w->readAny();
                echo(" 3C>PHP  :"); var_dump($r3php);            
                $r3phpnative = amf_decode($amf3php,AMF_FLAG_BIG_ENDIAN|$defaultFlags,0,$cbd);
                echo(" 3PHP>C  :");var_dump($r3phpnative);
                $w = new AMFDeserializer($amf3php); 
                $r3phpphp = $w->readAny();
                echo(" 3PHP>PHP:");var_dump($r3phpphp);
            }
        }           
        echo("\n");
    }
}


?>