/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.httpclient;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.owasp.webscarab.httpclient.ConversationHandler;
import org.owasp.webscarab.httpclient.HTTPClientFactory;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;

public class FetcherQueue {
    private ConversationHandler _handler;
    private Fetcher[] _fetchers;
    private int _requestDelay;
    private long _lastRequest = 0L;
    private List _requestQueue = new ArrayList();
    private boolean _running = true;
    private int _pending = 0;

    public FetcherQueue(String name, ConversationHandler handler, int threads, int requestDelay) {
        this._handler = handler;
        this._fetchers = new Fetcher[threads];
        this._requestDelay = requestDelay;
        for (int i = 0; i < threads; ++i) {
            this._fetchers[i] = new Fetcher(name + "-" + i);
        }
        this.start();
    }

    public void stop() {
        this._running = false;
    }

    public void start() {
        this._running = true;
        for (int i = 0; i < this._fetchers.length; ++i) {
            this._fetchers[i].start();
        }
    }

    public boolean isBusy() {
        return this._pending > 0 || this.getRequestsQueued() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(Request request) {
        List list = this._requestQueue;
        synchronized (list) {
            this._requestQueue.add(request);
            this._requestQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRequestsQueued() {
        List list = this._requestQueue;
        synchronized (list) {
            return this._requestQueue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRequestQueue() {
        List list = this._requestQueue;
        synchronized (list) {
            this._requestQueue.clear();
        }
    }

    private void responseReceived(Response response) {
        this._handler.responseReceived(response);
        --this._pending;
    }

    private void requestError(Request request, IOException ioe) {
        this._handler.requestError(request, ioe);
        --this._pending;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Request getNextRequest() {
        List list = this._requestQueue;
        synchronized (list) {
            while (this._requestQueue.size() == 0) {
                try {
                    this._requestQueue.wait();
                }
                catch (InterruptedException ie) {}
            }
            if (this._requestDelay > 0) {
                long currentTimeMillis = System.currentTimeMillis();
                while (currentTimeMillis < this._lastRequest + (long)this._requestDelay) {
                    try {
                        Thread.sleep(this._lastRequest + (long)this._requestDelay - currentTimeMillis);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    currentTimeMillis = System.currentTimeMillis();
                }
                this._lastRequest = currentTimeMillis;
            }
            ++this._pending;
            return (Request)this._requestQueue.remove(0);
        }
    }

    private class Fetcher
    extends Thread {
        public Fetcher(String name) {
            super(name);
            this.setDaemon(true);
            this.setPriority(1);
        }

        public void run() {
            while (FetcherQueue.this._running) {
                Request request = FetcherQueue.this.getNextRequest();
                try {
                    Response response = HTTPClientFactory.getInstance().fetchResponse(request);
                    response.flushContentStream();
                    FetcherQueue.this.responseReceived(response);
                }
                catch (IOException ioe) {
                    FetcherQueue.this.requestError(request, ioe);
                }
            }
        }
    }
}

