/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.model;

import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.UrlEvent;
import org.owasp.webscarab.model.UrlListener;
import org.owasp.webscarab.model.UrlModel;

public abstract class AbstractUrlModel
implements UrlModel {
    private EventListenerList _listenerList = new EventListenerList();
    private Logger _logger = Logger.getLogger(this.getClass().getName());

    public abstract int getChildCount(HttpUrl var1);

    public abstract int getIndexOf(HttpUrl var1);

    public abstract HttpUrl getChildAt(HttpUrl var1, int var2);

    public abstract Sync readLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUrlListener(UrlListener listener) {
        EventListenerList eventListenerList = this._listenerList;
        synchronized (eventListenerList) {
            this._listenerList.add(UrlListener.class, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUrlListener(UrlListener listener) {
        EventListenerList eventListenerList = this._listenerList;
        synchronized (eventListenerList) {
            this._listenerList.remove(UrlListener.class, listener);
        }
    }

    protected void fireUrlAdded(HttpUrl url, int position) {
        Object[] listeners = this._listenerList.getListenerList();
        UrlEvent evt = new UrlEvent(this, url, position);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$owasp$webscarab$model$UrlListener == null ? AbstractUrlModel.class$("org.owasp.webscarab.model.UrlListener") : class$org$owasp$webscarab$model$UrlListener)) continue;
            try {
                ((UrlListener)listeners[i + 1]).urlAdded(evt);
                continue;
            }
            catch (Exception e) {
                this._logger.severe("Unhandled exception: " + e);
                e.printStackTrace();
            }
        }
    }

    protected void fireUrlRemoved(HttpUrl url, int position) {
        Object[] listeners = this._listenerList.getListenerList();
        UrlEvent evt = new UrlEvent(this, url, position);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$owasp$webscarab$model$UrlListener == null ? AbstractUrlModel.class$("org.owasp.webscarab.model.UrlListener") : class$org$owasp$webscarab$model$UrlListener)) continue;
            try {
                ((UrlListener)listeners[i + 1]).urlRemoved(evt);
                continue;
            }
            catch (Exception e) {
                this._logger.severe("Unhandled exception: " + e);
            }
        }
    }

    protected void fireUrlChanged(HttpUrl url, int position) {
        Object[] listeners = this._listenerList.getListenerList();
        UrlEvent evt = new UrlEvent(this, url, position);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$owasp$webscarab$model$UrlListener == null ? AbstractUrlModel.class$("org.owasp.webscarab.model.UrlListener") : class$org$owasp$webscarab$model$UrlListener)) continue;
            try {
                ((UrlListener)listeners[i + 1]).urlChanged(evt);
                continue;
            }
            catch (Exception e) {
                this._logger.severe("Unhandled exception: " + e);
                e.printStackTrace();
            }
        }
    }

    protected void fireUrlsChanged() {
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$owasp$webscarab$model$UrlListener == null ? AbstractUrlModel.class$("org.owasp.webscarab.model.UrlListener") : class$org$owasp$webscarab$model$UrlListener)) continue;
            try {
                ((UrlListener)listeners[i + 1]).urlsChanged();
                continue;
            }
            catch (Exception e) {
                this._logger.severe("Unhandled exception: " + e);
                e.printStackTrace();
            }
        }
    }
}

