/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.model;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.Cookie;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;
import org.owasp.webscarab.model.SiteModelStore;
import org.owasp.webscarab.model.StoreException;
import org.owasp.webscarab.util.MRUCache;

public class FileSystemStore
implements SiteModelStore {
    private static final HttpUrl[] NO_CHILDREN = new HttpUrl[0];
    private File _dir;
    private File _conversationDir;
    private Logger _logger = Logger.getLogger(this.getClass().getName());
    private List _conversations = new ArrayList();
    private SortedMap _conversationProperties = new TreeMap(new NullComparator());
    private SortedMap _urlProperties = new TreeMap(new NullComparator());
    private SortedMap _urlConversations = new TreeMap(new NullComparator());
    private SortedMap _urls = new TreeMap(new NullComparator());
    private Map _requestCache = new MRUCache(16);
    private Map _responseCache = new MRUCache(16);
    private Map _urlCache = new MRUCache(32);
    private SortedMap _cookies = new TreeMap();

    public static boolean isExistingSession(File dir) {
        File f = new File(dir, "conversations");
        return f.exists() && f.isDirectory();
    }

    public FileSystemStore(File dir) throws StoreException {
        this._logger.setLevel(Level.FINE);
        if (dir == null) {
            throw new StoreException("Cannot create a new FileSystemStore with a null directory!");
        }
        this._dir = dir;
        this._conversationDir = new File(this._dir, "conversations");
        if (this._conversationDir.exists()) {
            this._logger.fine("Loading session from " + this._dir);
            this.load();
            this._logger.fine("Finished loading session from " + this._dir);
        } else {
            this.create();
        }
    }

    private void load() throws StoreException {
        this._logger.fine("Loading conversations");
        this.loadConversationProperties();
        this._logger.fine("Loading urls");
        this.loadUrlProperties();
        this._logger.fine("Loading cookies");
        this.loadCookies();
        this._logger.fine("Done!");
    }

    private void loadConversationProperties() throws StoreException {
        ConversationID.reset();
        try {
            String line;
            File f = new File(this._dir, "conversationlog");
            if (!f.exists()) {
                return;
            }
            BufferedReader br = new BufferedReader(new FileReader(f));
            int linecount = 0;
            HashMap map = null;
            ConversationID id = null;
            while ((line = br.readLine()) != null) {
                ++linecount;
                if (line.startsWith("### Conversation :")) {
                    String cid = line.substring(line.indexOf(":") + 2);
                    try {
                        id = new ConversationID(cid);
                        map = new HashMap();
                        this._conversations.add(id);
                        this._conversationProperties.put(id, map);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new StoreException("Malformed conversation ID (" + cid + ") parsing conversation log");
                    }
                }
                if (line.equals("")) {
                    try {
                        HttpUrl url = new HttpUrl((String)map.get("URL"));
                        this.addConversationForUrl(url, id);
                    }
                    catch (MalformedURLException mue) {
                        throw new StoreException("Malformed URL reading conversation " + id);
                    }
                    id = null;
                    map = null;
                    continue;
                }
                if (map == null) {
                    throw new StoreException("Malformed conversation log at line " + linecount);
                }
                String property = line.substring(0, line.indexOf(":"));
                String value = line.substring(line.indexOf(":") + 2);
                this.addProperty(map, property, value);
            }
        }
        catch (IOException ioe) {
            throw new StoreException("Exception loading conversationlog: " + ioe);
        }
    }

    private void loadUrlProperties() throws StoreException {
        try {
            String line;
            File f = new File(this._dir, "urlinfo");
            if (!f.exists()) {
                return;
            }
            BufferedReader br = new BufferedReader(new FileReader(f));
            int linecount = 0;
            Map map = null;
            HttpUrl url = null;
            while ((line = br.readLine()) != null) {
                ++linecount;
                if (line.startsWith("### URL :")) {
                    String urlstr = line.substring(line.indexOf(":") + 2);
                    try {
                        url = new HttpUrl(urlstr);
                        this.addUrl(url);
                        map = (Map)this._urlProperties.get(url);
                        continue;
                    }
                    catch (MalformedURLException mue) {
                        throw new StoreException("Malformed URL " + urlstr + " at line " + linecount + " in urlinfo");
                    }
                }
                if (line.equals("")) {
                    url = null;
                    map = null;
                    continue;
                }
                if (map == null) {
                    throw new StoreException("Malformed url info at line " + linecount);
                }
                String property = line.substring(0, line.indexOf(":"));
                String value = line.substring(line.indexOf(":") + 2);
                this.addProperty(map, property, value);
            }
        }
        catch (IOException ioe) {
            throw new StoreException("Exception loading url info : " + ioe);
        }
    }

    private void create() throws StoreException {
        if (!this._dir.exists() && !this._dir.mkdirs()) {
            throw new StoreException("Couldn't create directory " + this._dir);
        }
        if (!this._dir.isDirectory()) {
            throw new StoreException(this._dir + " exists, and is not a directory!");
        }
        this._conversationDir = new File(this._dir, "conversations");
        if (!this._conversationDir.exists() && !this._conversationDir.mkdirs()) {
            throw new StoreException("Couldn't create directory " + this._conversationDir);
        }
        if (!this._conversationDir.isDirectory()) {
            throw new StoreException(this._conversationDir + " exists, and is not a directory!");
        }
    }

    public int addConversation(ConversationID id, Date when, Request request, Response response) {
        this.setRequest(id, request);
        this.setResponse(id, response);
        HashMap map = new HashMap();
        this._conversationProperties.put(id, map);
        this.setConversationProperty(id, "METHOD", request.getMethod());
        this.setConversationProperty(id, "URL", request.getURL().toString());
        this.setConversationProperty(id, "STATUS", response.getStatusLine());
        this.setConversationProperty(id, "WHEN", Long.toString(when.getTime()));
        this.addConversationForUrl(request.getURL(), id);
        int index = Collections.binarySearch(this._conversations, id);
        if (index < 0) {
            index = -index - 1;
            this._conversations.add(index, id);
        }
        return index;
    }

    private void addConversationForUrl(HttpUrl url, ConversationID id) {
        int index;
        ArrayList<ConversationID> clist = (ArrayList<ConversationID>)this._urlConversations.get(url);
        if (clist == null) {
            clist = new ArrayList<ConversationID>();
            this._urlConversations.put(url, clist);
        }
        if ((index = Collections.binarySearch(clist, id)) < 0) {
            clist.add(-index - 1, id);
        }
    }

    public void setConversationProperty(ConversationID id, String property, String value) {
        Map map = (Map)this._conversationProperties.get(id);
        if (map == null) {
            throw new NullPointerException("No conversation Map for " + id);
        }
        map.put(property, value);
    }

    public boolean addConversationProperty(ConversationID id, String property, String value) {
        Map map = (Map)this._conversationProperties.get(id);
        if (map == null) {
            throw new NullPointerException("No conversation Map for " + id);
        }
        return this.addProperty(map, property, value);
    }

    private boolean addProperty(Map map, String property, String value) {
        Object previous = map.get(property);
        if (previous == null) {
            map.put(property, value);
            return true;
        }
        if (previous instanceof String) {
            if (previous.equals(value)) {
                return false;
            }
            String[] newval = new String[]{(String)previous, value};
            map.put(property, newval);
            return true;
        }
        String[] old = (String[])previous;
        for (int i = 0; i < old.length; ++i) {
            if (!old[i].equals(value)) continue;
            return false;
        }
        String[] newval = new String[old.length + 1];
        System.arraycopy(old, 0, newval, 0, old.length);
        newval[old.length] = value;
        map.put(property, newval);
        return true;
    }

    public String[] getConversationProperties(ConversationID id, String property) {
        Map map = (Map)this._conversationProperties.get(id);
        if (map == null) {
            throw new NullPointerException("No conversation Map for " + id);
        }
        return this.getProperties(map, property);
    }

    private String[] getProperties(Map map, String property) {
        Object value = map.get(property);
        if (value == null) {
            return new String[0];
        }
        if (value instanceof String[]) {
            String[] values = (String[])value;
            if (values.length == 0) {
                return values;
            }
            String[] copy = new String[values.length];
            System.arraycopy(values, 0, copy, 0, values.length);
            return copy;
        }
        String[] values = new String[]{(String)value};
        return values;
    }

    public void addUrl(HttpUrl url) {
        if (this._urlProperties.get(url) != null) {
            throw new IllegalStateException("Adding an URL that is already there " + url);
        }
        HashMap map = new HashMap();
        this._urlProperties.put(url, map);
        HttpUrl parent = url.getParentUrl();
        this._urlCache.remove(parent);
        TreeSet<HttpUrl> childSet = (TreeSet<HttpUrl>)this._urls.get(parent);
        if (childSet == null) {
            childSet = new TreeSet<HttpUrl>();
            this._urls.put(parent, childSet);
        }
        childSet.add(url);
    }

    public boolean isKnownUrl(HttpUrl url) {
        return this._urlProperties.containsKey(url);
    }

    public void setUrlProperty(HttpUrl url, String property, String value) {
        Map map = (Map)this._urlProperties.get(url);
        if (map == null) {
            throw new NullPointerException("No URL Map for " + url);
        }
        map.put(property, value);
    }

    public boolean addUrlProperty(HttpUrl url, String property, String value) {
        Map map = (Map)this._urlProperties.get(url);
        if (map == null) {
            throw new NullPointerException("No URL Map for " + url);
        }
        return this.addProperty(map, property, value);
    }

    public String[] getUrlProperties(HttpUrl url, String property) {
        Map map = (Map)this._urlProperties.get(url);
        if (map == null) {
            return new String[0];
        }
        return this.getProperties(map, property);
    }

    public int getChildCount(HttpUrl url) {
        SortedSet childSet = (SortedSet)this._urls.get(url);
        if (childSet == null) {
            return 0;
        }
        return childSet.size();
    }

    public HttpUrl getChildAt(HttpUrl url, int index) {
        HttpUrl[] children = (HttpUrl[])this._urlCache.get(url);
        if (children == null) {
            SortedSet childSet = (SortedSet)this._urls.get(url);
            if (childSet == null) {
                throw new IndexOutOfBoundsException(url + " has no children");
            }
            if (index >= childSet.size()) {
                throw new IndexOutOfBoundsException(url + " has only " + childSet.size() + " children, not " + index);
            }
            children = childSet.toArray(NO_CHILDREN);
            this._urlCache.put(url, children);
        }
        return children[index];
    }

    public int getIndexOf(HttpUrl url) {
        HttpUrl parent = url.getParentUrl();
        Object[] children = (HttpUrl[])this._urlCache.get(parent);
        if (children == null) {
            SortedSet childSet = (SortedSet)this._urls.get(parent);
            if (childSet == null) {
                throw new IndexOutOfBoundsException(url + " has no children");
            }
            children = childSet.toArray(NO_CHILDREN);
            this._urlCache.put(parent, children);
        }
        return Arrays.binarySearch(children, url);
    }

    public int getConversationCount(HttpUrl url) {
        if (url == null) {
            return this._conversationProperties.size();
        }
        List list = (List)this._urlConversations.get(url);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    public ConversationID getConversationAt(HttpUrl url, int index) {
        ArrayList list = url == null ? new ArrayList(this._conversationProperties.keySet()) : (ArrayList)this._urlConversations.get(url);
        if (list == null) {
            throw new NullPointerException(url + " does not have any conversations");
        }
        if (list.size() < index) {
            throw new ArrayIndexOutOfBoundsException(url + " does not have " + index + " conversations");
        }
        return (ConversationID)list.get(index);
    }

    public int getIndexOfConversation(HttpUrl url, ConversationID id) {
        List list = url == null ? this._conversations : (List)this._urlConversations.get(url);
        if (list == null) {
            throw new NullPointerException(url + " has no conversations");
        }
        int index = Collections.binarySearch(list, id);
        return index;
    }

    public void setRequest(ConversationID id, Request request) {
        if (request == null) {
            return;
        }
        this._requestCache.put(id, request);
        try {
            File f = new File(this._conversationDir, id + "-request");
            FileOutputStream fos = new FileOutputStream(f);
            request.write(fos);
            fos.close();
        }
        catch (IOException ioe) {
            this._logger.severe("IOException writing request(" + id + ") : " + ioe);
        }
    }

    public Request getRequest(ConversationID id) {
        Object o = this._requestCache.get(id);
        if (o != null) {
            return (Request)o;
        }
        File f = new File(this._conversationDir, id + "-request");
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
        }
        catch (FileNotFoundException fnfe) {
            return null;
        }
        Request r = new Request();
        try {
            r.read(fis);
            r.getContent();
            fis.close();
            return r;
        }
        catch (IOException ioe) {
            this._logger.severe("IOException reading request(" + id + ") : " + ioe);
            return null;
        }
    }

    public void setResponse(ConversationID id, Response response) {
        if (response == null) {
            return;
        }
        this._responseCache.put(id, response);
        try {
            File f = new File(this._conversationDir, id + "-response");
            FileOutputStream fos = new FileOutputStream(f);
            response.write(fos);
            fos.close();
        }
        catch (IOException ioe) {
            this._logger.severe("IOException writing response(" + id + ") : " + ioe);
        }
    }

    public Response getResponse(ConversationID id) {
        Object o = this._responseCache.get(id);
        if (o != null) {
            return (Response)o;
        }
        File f = new File(this._conversationDir, id + "-response");
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
        }
        catch (FileNotFoundException fnfe) {
            return null;
        }
        Response r = new Response();
        try {
            r.read(fis);
            r.getContent();
            fis.close();
            return r;
        }
        catch (IOException ioe) {
            this._logger.severe("IOException reading response(" + id + ") : " + ioe);
            return null;
        }
    }

    public void flush() throws StoreException {
        this.flushConversationProperties();
        this.flushUrlProperties();
        this.flushCookies();
    }

    private void flushConversationProperties() throws StoreException {
        try {
            File f = new File(this._dir, "conversationlog");
            BufferedWriter bw = new BufferedWriter(new FileWriter(f));
            Iterator it = this._conversationProperties.keySet().iterator();
            while (it.hasNext()) {
                ConversationID id = (ConversationID)it.next();
                Map map = (Map)this._conversationProperties.get(id);
                bw.write("### Conversation : " + id + "\n");
                Iterator props = map.keySet().iterator();
                while (props.hasNext()) {
                    String property = (String)props.next();
                    String[] values = this.getProperties(map, property);
                    if (values == null || values.length <= 0) continue;
                    for (int i = 0; i < values.length; ++i) {
                        bw.write(property + ": " + values[i] + "\n");
                    }
                }
                bw.write("\n");
            }
            bw.close();
        }
        catch (IOException ioe) {
            throw new StoreException("Error writing conversation properties: " + ioe);
        }
    }

    private void flushUrlProperties() throws StoreException {
        try {
            File f = new File(this._dir, "urlinfo");
            BufferedWriter bw = new BufferedWriter(new FileWriter(f));
            Iterator it = this._urlProperties.keySet().iterator();
            while (it.hasNext()) {
                HttpUrl url = (HttpUrl)it.next();
                Map map = (Map)this._urlProperties.get(url);
                bw.write("### URL : " + url + "\n");
                Iterator props = map.keySet().iterator();
                while (props.hasNext()) {
                    String property = (String)props.next();
                    String[] values = this.getProperties(map, property);
                    if (values == null || values.length <= 0) continue;
                    for (int i = 0; i < values.length; ++i) {
                        bw.write(property + ": " + values[i] + "\n");
                    }
                }
                bw.write("\n");
            }
            bw.close();
        }
        catch (IOException ioe) {
            throw new StoreException("Error writing url properties: " + ioe);
        }
    }

    public int getCookieCount() {
        return this._cookies.size();
    }

    public int getCookieCount(String key) {
        List list = (List)this._cookies.get(key);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    public String getCookieAt(int index) {
        return (String)new ArrayList(this._cookies.keySet()).get(index);
    }

    public Cookie getCookieAt(String key, int index) {
        List list = (List)this._cookies.get(key);
        if (list == null) {
            throw new NullPointerException("No such cookie! " + key);
        }
        return (Cookie)list.get(index);
    }

    public Cookie getCurrentCookie(String key) {
        List list = (List)this._cookies.get(key);
        if (list == null) {
            throw new NullPointerException("No such cookie! " + key);
        }
        return (Cookie)list.get(list.size() - 1);
    }

    public int getIndexOfCookie(Cookie cookie) {
        return new ArrayList(this._cookies.keySet()).indexOf(cookie.getKey());
    }

    public int getIndexOfCookie(String key, Cookie cookie) {
        List list = (List)this._cookies.get(key);
        if (list == null) {
            throw new NullPointerException("No such cookie! " + key);
        }
        return list.indexOf(cookie);
    }

    public boolean addCookie(Cookie cookie) {
        String key = cookie.getKey();
        ArrayList<Cookie> list = (ArrayList<Cookie>)this._cookies.get(key);
        if (list == null) {
            list = new ArrayList<Cookie>();
            this._cookies.put(key, list);
        }
        if (list.indexOf(cookie) > -1) {
            return false;
        }
        list.add(cookie);
        return true;
    }

    public boolean removeCookie(Cookie cookie) {
        String key = cookie.getKey();
        List list = (List)this._cookies.get(key);
        if (list == null) {
            return false;
        }
        boolean deleted = list.remove(cookie);
        if (list.size() == 0) {
            this._cookies.remove(key);
        }
        return deleted;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadCookies() throws StoreException {
        this._cookies.clear();
        try {
            String line;
            File f = new File(this._dir, "cookies");
            if (!f.exists()) {
                return;
            }
            BufferedReader br = new BufferedReader(new FileReader(f));
            int linecount = 0;
            ArrayList<Cookie> list = null;
            String name = null;
            Cookie cookie = null;
            while ((line = br.readLine()) != null) {
                ++linecount;
                if (line.startsWith("### Cookie :")) {
                    name = line.substring(line.indexOf(":") + 2);
                    list = new ArrayList<Cookie>();
                    this._cookies.put(name, list);
                    continue;
                }
                if (line.equals("")) {
                    name = null;
                    list = null;
                    continue;
                }
                if (list == null) {
                    throw new StoreException("Malformed cookie log at line " + linecount);
                }
                int pos = line.indexOf(" ");
                try {
                    long time = Long.parseLong(line.substring(0, pos));
                    cookie = new Cookie(new Date(time), line.substring(pos + 1));
                    list.add(cookie);
                }
                catch (Exception e) {
                    throw new StoreException("Malformed cookie log at line " + linecount + " : " + e);
                    return;
                }
            }
        }
        catch (IOException ioe) {
            throw new StoreException("Exception loading conversationlog: " + ioe);
        }
    }

    private void flushCookies() throws StoreException {
        try {
            File f = new File(this._dir, "cookies");
            BufferedWriter bw = new BufferedWriter(new FileWriter(f));
            Iterator it = this._cookies.keySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                List list = (List)this._cookies.get(name);
                bw.write("### Cookie : " + name + "\n");
                Iterator cookies = list.iterator();
                while (cookies.hasNext()) {
                    Cookie cookie = (Cookie)cookies.next();
                    bw.write(cookie.toString() + "\n");
                }
                bw.write("\n");
            }
            bw.close();
        }
        catch (IOException ioe) {
            throw new StoreException("Error writing cookies: " + ioe);
        }
    }

    private class NullComparator
    implements Comparator {
        private NullComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null && o2 != null) {
                return 1;
            }
            if (o1 != null && o2 == null) {
                return -1;
            }
            if (o1 instanceof Comparable) {
                return ((Comparable)o1).compareTo(o2);
            }
            throw new ClassCastException("Incomparable objects " + o1.getClass().getName() + " and " + o2.getClass().getName());
        }
    }
}

