/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.model;

import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import org.owasp.webscarab.model.AbstractUrlModel;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.UrlEvent;
import org.owasp.webscarab.model.UrlListener;
import org.owasp.webscarab.model.UrlModel;
import org.owasp.webscarab.util.MRUCache;

public abstract class FilteredUrlModel
extends AbstractUrlModel {
    protected UrlModel _urlModel;
    private Set _filteredUrls = null;
    private Set _implicitUrls = null;
    private MRUCache _cache = new MRUCache(16);
    protected EventListenerList _listenerList = new EventListenerList();
    protected Logger _logger = Logger.getLogger(this.getClass().getName());
    private boolean _updating = false;
    private int hit;
    private int miss = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilteredUrlModel(UrlModel urlModel) {
        this._logger.setLevel(Level.INFO);
        this._urlModel = urlModel;
        try {
            this._urlModel.readLock().acquire();
            this.updateFilteredUrls();
            this._urlModel.addUrlListener(new Listener());
        }
        catch (InterruptedException ie) {
            this._logger.warning("Interrupted waiting for the read lock! " + ie.getMessage());
        }
        finally {
            this._urlModel.readLock().release();
        }
    }

    public Sync readLock() {
        return this._urlModel.readLock();
    }

    protected void initFilters() {
        this._filteredUrls = new HashSet();
        this._implicitUrls = new HashSet();
    }

    protected abstract boolean shouldFilter(HttpUrl var1);

    protected boolean isFiltered(HttpUrl url) {
        return this._filteredUrls != null && this._filteredUrls.contains(url);
    }

    protected void setFiltered(HttpUrl url, boolean filtered) {
        if (filtered) {
            this._filteredUrls.add(url);
        } else {
            this._filteredUrls.remove(url);
        }
    }

    public boolean isImplicit(HttpUrl url) {
        return this._implicitUrls.contains(url);
    }

    protected void setImplicit(HttpUrl url, boolean filtered) {
        if (this._implicitUrls == null) {
            this._implicitUrls = new HashSet();
        }
        if (filtered) {
            this._implicitUrls.add(url);
        } else {
            this._implicitUrls.remove(url);
        }
    }

    private boolean isVisible(HttpUrl url) {
        return this.isImplicit(url) || !this.isFiltered(url);
    }

    public int getIndexOf(HttpUrl url) {
        int index = Collections.binarySearch(this.getFilteredChildren(url), url);
        return index < 0 ? -1 : index;
    }

    public HttpUrl getChildAt(HttpUrl url, int index) {
        return (HttpUrl)this.getFilteredChildren(url).get(index);
    }

    private void updateFilteredUrls() {
        this.initFilters();
        this.recurseTree(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList getFilteredChildren(HttpUrl parent) {
        ArrayList<HttpUrl> childList = (ArrayList<HttpUrl>)this._cache.get(parent);
        if (childList != null) {
            ++this.hit;
            return childList;
        }
        try {
            childList = new ArrayList<HttpUrl>();
            this._urlModel.readLock().acquire();
            int count = this._urlModel.getChildCount(parent);
            for (int i = 0; i < count; ++i) {
                HttpUrl child = this._urlModel.getChildAt(parent, i);
                if (!this.isVisible(child)) continue;
                childList.add(child);
            }
            if (count > 0) {
                ++this.miss;
                this._logger.fine("Hit=" + this.hit + ", miss=" + this.miss + " parent = " + parent + " count=" + count);
                this._cache.put(parent, childList);
            }
            ArrayList<HttpUrl> arrayList = childList;
            return arrayList;
        }
        catch (InterruptedException ie) {
            this._logger.warning("Interrupted waiting for the read lock! " + ie.getMessage());
        }
        finally {
            this._urlModel.readLock().release();
        }
        return null;
    }

    public int getChildCount(HttpUrl url) {
        return this.getFilteredChildren(url).size();
    }

    private void recurseTree(HttpUrl parent) {
        int count = this._urlModel.getChildCount(parent);
        for (int i = 0; i < count; ++i) {
            HttpUrl url = this._urlModel.getChildAt(parent, i);
            if (this.shouldFilter(url)) {
                this.setFiltered(url, true);
            } else {
                this.grow(url);
            }
            this.recurseTree(url);
        }
    }

    private void grow(HttpUrl url) {
        HttpUrl[] path = url.getUrlHierarchy();
        for (int i = 0; i < path.length - 1; ++i) {
            if (this.isVisible(path[i])) continue;
            this.setImplicit(path[i], true);
            if (i == 0) {
                this._cache.remove(null);
            } else {
                this._cache.remove(path[i - 1]);
            }
            if (this._updating) continue;
            this.fireUrlAdded(path[i], -1);
        }
        this._cache.remove(url.getParentUrl());
        if (!this._updating) {
            this.fireUrlAdded(url, 0);
        }
    }

    private void prune(HttpUrl url) {
        this._cache.remove(url.getParentUrl());
        if (!this._updating) {
            this.fireUrlRemoved(url, -1);
        }
        HttpUrl[] path = url.getUrlHierarchy();
        for (int i = path.length - 2; i >= 0; --i) {
            if (!this.isImplicit(path[i]) || this.getChildCount(path[i]) != 0) continue;
            this.setImplicit(path[i], false);
            if (i == 0) {
                this._cache.remove(null);
            } else {
                this._cache.remove(path[i - 1]);
            }
            if (this._updating) continue;
            this.fireUrlRemoved(path[i], -1);
        }
    }

    public void reset() {
        this._cache.clear();
        this._updating = true;
        this.updateFilteredUrls();
        this._updating = false;
        this.fireUrlsChanged();
    }

    private class Listener
    implements UrlListener {
        public void urlsChanged() {
            FilteredUrlModel.this.reset();
        }

        public void urlAdded(UrlEvent evt) {
            HttpUrl url = evt.getUrl();
            if (!FilteredUrlModel.this.shouldFilter(url)) {
                FilteredUrlModel.this.grow(url);
            } else {
                FilteredUrlModel.this.setFiltered(url, true);
            }
        }

        public void urlChanged(UrlEvent evt) {
            HttpUrl url = evt.getUrl();
            if (FilteredUrlModel.this.shouldFilter(url)) {
                if (FilteredUrlModel.this.isVisible(url)) {
                    if (FilteredUrlModel.this.getChildCount(url) > 0) {
                        FilteredUrlModel.this.setFiltered(url, true);
                        FilteredUrlModel.this.setImplicit(url, true);
                        if (!FilteredUrlModel.this._updating) {
                            FilteredUrlModel.this.fireUrlChanged(url, -1);
                        }
                    } else {
                        FilteredUrlModel.this.setFiltered(url, true);
                        FilteredUrlModel.this.prune(url);
                    }
                }
            } else if (!FilteredUrlModel.this.isVisible(url)) {
                FilteredUrlModel.this.setFiltered(url, false);
                FilteredUrlModel.this.grow(url);
            } else if (!FilteredUrlModel.this._updating) {
                FilteredUrlModel.this.fireUrlChanged(url, -1);
            }
        }

        public void urlRemoved(UrlEvent evt) {
            HttpUrl url = evt.getUrl();
            if (FilteredUrlModel.this.isVisible(url)) {
                FilteredUrlModel.this.prune(url);
            } else {
                FilteredUrlModel.this.setFiltered(url, false);
            }
        }
    }
}

