/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.compare;

import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.owasp.webscarab.model.AbstractConversationModel;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.ConversationModel;
import org.owasp.webscarab.model.FrameworkModel;
import org.owasp.webscarab.plugin.AbstractPluginModel;

public class CompareModel
extends AbstractPluginModel {
    private FrameworkModel _model = null;
    private Map _distances = new HashMap();
    private ArrayList _compared = new ArrayList();
    private DiffModel _diffModel;
    private Logger _logger = Logger.getLogger(this.getClass().getName());

    public CompareModel(FrameworkModel model) {
        this._model = model;
        this._diffModel = new DiffModel(model);
    }

    public ConversationModel getConversationModel() {
        return this._model.getConversationModel();
    }

    public ConversationModel getComparisonModel() {
        return this._diffModel;
    }

    public void clearConversations() {
        try {
            this._rwl.writeLock().acquire();
            this._distances.clear();
            this._compared.clear();
            this._rwl.readLock().acquire();
            this._rwl.writeLock().release();
            this._diffModel.fireConversationsChanged();
            this._rwl.readLock().release();
        }
        catch (InterruptedException ie) {
            this._logger.warning("Interrupted! " + ie);
        }
    }

    public void setDistance(ConversationID id, int distance) {
        try {
            this._rwl.writeLock().acquire();
            this._distances.put(id, new Integer(distance));
            int insert = Collections.binarySearch(this._compared, id);
            if (insert < 0) {
                this._compared.add(-insert - 1, id);
            }
            this._logger.info("Adding conversation " + id + " distance " + distance + " at " + insert);
            this._rwl.readLock().acquire();
            this._rwl.writeLock().release();
            if (insert < 0) {
                this._diffModel.fireConversationAdded(id, -insert - 1);
            }
            this._rwl.readLock().release();
        }
        catch (InterruptedException ie) {
            this._logger.warning("Interrupted! " + ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getDistance(ConversationID id) {
        try {
            this._rwl.readLock().acquire();
            Integer n = (Integer)this._distances.get(id);
            return n;
        }
        catch (InterruptedException ie) {
            this._logger.warning("Interrupted! " + ie);
            Integer n = null;
            return n;
        }
        finally {
            this._rwl.readLock().release();
        }
    }

    private class DiffModel
    extends AbstractConversationModel {
        public DiffModel(FrameworkModel model) {
            super(model);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ConversationID getConversationAt(int index) {
            try {
                CompareModel.this._rwl.readLock().acquire();
                ConversationID conversationID = (ConversationID)CompareModel.this._compared.get(index);
                return conversationID;
            }
            catch (InterruptedException ie) {
                CompareModel.this._logger.warning("Interrupted! " + ie);
                ConversationID conversationID = null;
                return conversationID;
            }
            finally {
                CompareModel.this._rwl.readLock().release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getConversationCount() {
            try {
                CompareModel.this._rwl.readLock().acquire();
                int n = CompareModel.this._compared.size();
                return n;
            }
            catch (InterruptedException ie) {
                CompareModel.this._logger.warning("Interrupted! " + ie);
                int n = -1;
                return n;
            }
            finally {
                CompareModel.this._rwl.readLock().release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getIndexOfConversation(ConversationID id) {
            try {
                CompareModel.this._rwl.readLock().acquire();
                int n = Collections.binarySearch(CompareModel.this._compared, id);
                return n;
            }
            catch (InterruptedException ie) {
                CompareModel.this._logger.warning("Interrupted! " + ie);
                int n = -1;
                return n;
            }
            finally {
                CompareModel.this._rwl.readLock().release();
            }
        }

        public Sync readLock() {
            return CompareModel.this._rwl.readLock();
        }

        public void fireConversationsChanged() {
            super.fireConversationsChanged();
        }

        public void fireConversationAdded(ConversationID id, int position) {
            super.fireConversationAdded(id, position);
        }
    }
}

