/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.proxy;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.logging.Logger;
import org.owasp.webscarab.plugin.proxy.ConnectionHandler;
import org.owasp.webscarab.plugin.proxy.ListenerSpec;
import org.owasp.webscarab.plugin.proxy.Proxy;
import org.owasp.webscarab.util.W32WinInet;

public class Listener
implements Runnable {
    private Proxy _proxy;
    private ListenerSpec _spec;
    private ServerSocket _serversocket = null;
    private boolean _stop = false;
    private boolean _stopped = true;
    private int _count = 1;
    private Logger _logger = Logger.getLogger(this.getClass().getName());

    public Listener(Proxy proxy, ListenerSpec spec) {
        this._proxy = proxy;
        this._spec = spec;
    }

    public void run() {
        this._stop = false;
        this._stopped = false;
        if (this._serversocket == null || this._serversocket.isClosed()) {
            try {
                this.listen();
            }
            catch (IOException ioe) {
                this._logger.severe("Can't listen at " + this._spec + ": " + ioe);
                this._stopped = true;
                return;
            }
        }
        if (W32WinInet.isAvailable() && this._spec.isPrimaryProxy()) {
            W32WinInet.interceptProxy("localhost", this._spec.getPort());
        }
        while (!this._stop) {
            try {
                Socket sock = this._serversocket.accept();
                ConnectionHandler ch = new ConnectionHandler(this._proxy, sock, this._spec.getBase());
                Thread thread = new Thread((Runnable)ch, Thread.currentThread().getName() + "-" + Integer.toString(this._count++));
                thread.setDaemon(true);
                thread.start();
            }
            catch (IOException e) {
                if (e.getMessage().equals("Accept timed out")) continue;
                System.err.println("I/O error while waiting for a connection : " + e.getMessage());
            }
        }
        this._stopped = true;
        try {
            this._serversocket.close();
        }
        catch (IOException ioe) {
            System.err.println("Error closing socket : " + ioe);
        }
        if (W32WinInet.isAvailable() && this._spec.isPrimaryProxy()) {
            W32WinInet.revertProxy();
        }
        this._logger.info("Not listening on " + this._spec);
    }

    private void listen() throws IOException {
        InetSocketAddress sa = this._spec.getInetSocketAddress();
        this._serversocket = new ServerSocket(sa.getPort(), 5, sa.getAddress());
        this._logger.info("Proxy listening on " + this._spec);
        try {
            this._serversocket.setSoTimeout(100);
        }
        catch (SocketException se) {
            this._logger.warning("Error setting sockettimeout " + se);
            this._logger.warning("It is likely that this listener will be unstoppable!");
        }
    }

    public boolean stop() {
        this._stop = true;
        if (!this._stopped) {
            for (int i = 0; i < 20; ++i) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this._stopped) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public ListenerSpec getListenerSpec() {
        return this._spec;
    }
}

