/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.proxy.swing;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import org.owasp.webscarab.plugin.proxy.ListenerSpec;
import org.owasp.webscarab.plugin.proxy.Proxy;

public class ListenerTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -8353819323669374935L;
    private ArrayList _listeners = new ArrayList();
    protected String[] columnNames = new String[]{"Address", "Port", "Base URL", "Primary"};
    protected Class[] columnClass = new Class[]{String.class, Integer.class, String.class, Boolean.class};

    public ListenerTableModel(Proxy proxy) {
    }

    public String getColumnName(int column) {
        if (column < this.columnNames.length) {
            return this.columnNames[column];
        }
        return "";
    }

    public Class getColumnClass(int column) {
        return this.columnClass[column];
    }

    public synchronized int getColumnCount() {
        return this.columnNames.length;
    }

    public synchronized int getRowCount() {
        return this._listeners.size();
    }

    public synchronized Object getValueAt(int row, int column) {
        if (row < 0 || row >= this._listeners.size()) {
            System.err.println("Attempt to get row " + row + ", column " + column + " : row does not exist!");
            return null;
        }
        ListenerSpec spec = this.getListener(row);
        if (column <= this.columnNames.length) {
            switch (column) {
                case 0: {
                    return spec.getAddress();
                }
                case 1: {
                    return new Integer(spec.getPort());
                }
                case 2: {
                    return spec.getBase();
                }
                case 3: {
                    return new Boolean(spec.isPrimaryProxy());
                }
            }
            return null;
        }
        System.err.println("Attempt to get row " + row + ", column " + column + " : column does not exist!");
        return null;
    }

    public ListenerSpec getListener(int index) {
        return (ListenerSpec)this._listeners.get(index);
    }

    public void proxyRemoved(ListenerSpec spec) {
        int index = this._listeners.indexOf(spec);
        if (index > -1) {
            this._listeners.remove(index);
            this.fireTableRowsDeleted(index, index);
        }
    }

    public void proxyAdded(ListenerSpec spec) {
        int index = this._listeners.indexOf(spec);
        if (index == -1) {
            this._listeners.add(spec);
            this.fireTableRowsInserted(this._listeners.size(), this._listeners.size());
        }
    }
}

