/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.proxy.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.owasp.webscarab.plugin.proxy.BrowserCache;
import org.owasp.webscarab.plugin.proxy.CookieTracker;
import org.owasp.webscarab.plugin.proxy.RevealHidden;
import org.owasp.webscarab.plugin.proxy.swing.ProxyPluginUI;

public class MiscPanel
extends JPanel
implements ProxyPluginUI {
    private static final long serialVersionUID = -6036027012899433768L;
    private RevealHidden _revealHidden;
    private BrowserCache _browsercache;
    private CookieTracker _cookieTracker;
    private JCheckBox browserCacheCheckBox;
    private JCheckBox injectRequestCookiesCheckBox;
    private JCheckBox interceptHiddenFieldCheckBox;
    private JCheckBox readResponseCookiesCheckBox;
    private JLabel spacerLabel;

    public MiscPanel(RevealHidden rh, BrowserCache bc, CookieTracker ct) {
        this._revealHidden = rh;
        this._browsercache = bc;
        this._cookieTracker = ct;
        this.initComponents();
        this.configure();
    }

    public JPanel getPanel() {
        return this;
    }

    public String getPluginName() {
        return new String("Miscellaneous");
    }

    private void configure() {
        this.interceptHiddenFieldCheckBox.setSelected(this._revealHidden.getEnabled());
        this.browserCacheCheckBox.setSelected(this._browsercache.getEnabled());
        this.injectRequestCookiesCheckBox.setSelected(this._cookieTracker.getInjectRequests());
        this.readResponseCookiesCheckBox.setSelected(this._cookieTracker.getReadResponses());
    }

    private void initComponents() {
        this.interceptHiddenFieldCheckBox = new JCheckBox();
        this.browserCacheCheckBox = new JCheckBox();
        this.spacerLabel = new JLabel();
        this.injectRequestCookiesCheckBox = new JCheckBox();
        this.readResponseCookiesCheckBox = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.interceptHiddenFieldCheckBox.setText("Reveal hidden fields in HTML pages : ");
        this.interceptHiddenFieldCheckBox.setToolTipText("Select this to change all hidden form fields to text fields. Looks at pages of type HTML and javascript.");
        this.interceptHiddenFieldCheckBox.setHorizontalTextPosition(10);
        this.interceptHiddenFieldCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MiscPanel.this.interceptHiddenFieldCheckBoxActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.add((Component)this.interceptHiddenFieldCheckBox, gridBagConstraints);
        this.browserCacheCheckBox.setText("Prevent browser from caching content : ");
        this.browserCacheCheckBox.setToolTipText("");
        this.browserCacheCheckBox.setHorizontalTextPosition(10);
        this.browserCacheCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MiscPanel.this.browserCacheCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.browserCacheCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.spacerLabel, gridBagConstraints);
        this.injectRequestCookiesCheckBox.setText("Inject known cookies into requests");
        this.injectRequestCookiesCheckBox.setToolTipText("");
        this.injectRequestCookiesCheckBox.setHorizontalTextPosition(10);
        this.injectRequestCookiesCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MiscPanel.this.injectRequestCookiesCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.injectRequestCookiesCheckBox, gridBagConstraints);
        this.readResponseCookiesCheckBox.setText("Get cookies from responses");
        this.readResponseCookiesCheckBox.setToolTipText("");
        this.readResponseCookiesCheckBox.setHorizontalTextPosition(10);
        this.readResponseCookiesCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MiscPanel.this.readResponseCookiesCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.readResponseCookiesCheckBox, gridBagConstraints);
    }

    private void readResponseCookiesCheckBoxActionPerformed(ActionEvent evt) {
        this._cookieTracker.setReadResponses(this.readResponseCookiesCheckBox.isSelected());
    }

    private void injectRequestCookiesCheckBoxActionPerformed(ActionEvent evt) {
        this._cookieTracker.setInjectRequests(this.injectRequestCookiesCheckBox.isSelected());
    }

    private void browserCacheCheckBoxActionPerformed(ActionEvent evt) {
        this._browsercache.setEnabled(this.browserCacheCheckBox.isSelected());
    }

    private void interceptHiddenFieldCheckBoxActionPerformed(ActionEvent evt) {
        this._revealHidden.setEnabled(this.interceptHiddenFieldCheckBox.isSelected());
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.browserCacheCheckBox.setEnabled(enabled);
        this.injectRequestCookiesCheckBox.setEnabled(enabled);
        this.interceptHiddenFieldCheckBox.setEnabled(enabled);
        this.readResponseCookiesCheckBox.setEnabled(enabled);
    }
}

