/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.sessionid.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.PatternSyntaxException;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.data.AbstractSeriesDataset;
import org.jfree.data.XYDataset;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.Preferences;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;
import org.owasp.webscarab.plugin.sessionid.SessionID;
import org.owasp.webscarab.plugin.sessionid.SessionIDAnalysis;
import org.owasp.webscarab.plugin.sessionid.SessionIDListener;
import org.owasp.webscarab.plugin.sessionid.SessionIDModel;
import org.owasp.webscarab.ui.swing.ConversationListModel;
import org.owasp.webscarab.ui.swing.ConversationRenderer;
import org.owasp.webscarab.ui.swing.DateRenderer;
import org.owasp.webscarab.ui.swing.RequestPanel;
import org.owasp.webscarab.ui.swing.ResponsePanel;
import org.owasp.webscarab.ui.swing.SwingPluginUI;
import org.owasp.webscarab.util.swing.ColumnDataModel;
import org.owasp.webscarab.util.swing.ListComboBoxModel;
import org.owasp.webscarab.util.swing.SwingWorker;
import org.owasp.webscarab.util.swing.TableSorter;

public class SessionIDPanel
extends JPanel
implements SwingPluginUI,
SessionIDListener {
    private static final long serialVersionUID = -6717611035456089823L;
    private static final ColumnDataModel[] CDM = new ColumnDataModel[0];
    private final RequestPanel _requestPanel;
    private final ResponsePanel _responsePanel;
    private JFreeChart _chart = null;
    private String _key = null;
    private SessionIDAnalysis _sa;
    private SessionIDDataset _sidd;
    private SessionIDTableModel _tableModel;
    private ConversationListModel _conversationList;
    private Map _conversationColumns = new HashMap();
    private Map _urlColumns = new HashMap();
    private DefaultListModel _sessionIDNames = new DefaultListModel();
    private SessionIDModel _model;
    private Logger _logger = Logger.getLogger(this.getClass().getName());
    private JPanel actionPanel;
    private JPanel analysisPanel;
    private JCheckBox bodyCheckBox;
    private JButton clearButton;
    private JPanel collectionPanel;
    private JPanel conversationPanel;
    private JSplitPane conversationSplitPane;
    private JButton exportButton;
    private JButton fetchButton;
    private JPanel historyPanel;
    private JTable idTable;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JTabbedPane mainTabbedPane;
    private JTextField maxTextField;
    private JTextField minTextField;
    private JComboBox nameComboBox;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JTextField rangeTextField;
    private JTextField regexTextField;
    private JComboBox requestComboBox;
    private JSpinner sampleSpinner;
    private JPanel specPanel;
    private JButton testButton;
    private JPanel visualisationPanel;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$math$BigInteger;

    public SessionIDPanel(SessionIDAnalysis sa) {
        this._sa = sa;
        this._model = this._sa.getModel();
        this.initComponents();
        this.mainTabbedPane.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SessionIDPanel.this.mainTabbedPaneStateChanged(e);
            }
        });
        this._requestPanel = new RequestPanel();
        this._requestPanel.setBorder(new TitledBorder("Request"));
        this._requestPanel.setEditable(true);
        this._requestPanel.setRequest(null);
        this._responsePanel = new ResponsePanel();
        this._responsePanel.setBorder(new TitledBorder("Response"));
        this.conversationSplitPane.setTopComponent(this._requestPanel);
        this.conversationSplitPane.setBottomComponent(this._responsePanel);
        this._sessionIDNames.clear();
        for (int i = 0; i < this._model.getSessionIDNameCount(); ++i) {
            this._sessionIDNames.addElement(this._model.getSessionIDName(i));
        }
        this.requestComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object o = SessionIDPanel.this.requestComboBox.getSelectedItem();
                if (o instanceof ConversationID) {
                    ConversationID id = (ConversationID)o;
                    Request r = SessionIDPanel.this._model.getRequest(id);
                    SessionIDPanel.this._requestPanel.setEditable(true);
                    SessionIDPanel.this._requestPanel.setRequest(r);
                    SessionIDPanel.this._responsePanel.setEditable(false);
                    SessionIDPanel.this._responsePanel.setResponse(null);
                }
            }
        });
        this._tableModel = new SessionIDTableModel();
        this._sidd = new SessionIDDataset();
        this._sidd.fireDatasetChanged();
        this._tableModel.fireTableDataChanged();
        this.nameComboBox.setModel(new ListComboBoxModel(this._sessionIDNames));
        this._model.addModelListener(this);
        this.idTable.setModel(new TableSorter(this._tableModel, this.idTable.getTableHeader()));
        this.idTable.setDefaultRenderer(Date.class, new DateRenderer());
        this._conversationList = new ConversationListModel(this._model.getConversationModel());
        this.requestComboBox.setModel(new ListComboBoxModel(this._conversationList));
        this.requestComboBox.setRenderer(new ConversationRenderer(this._model.getConversationModel()));
        this.createColumns();
    }

    private void createColumns() {
        ColumnDataModel cdm = new ColumnDataModel(){

            public Object getValue(Object key) {
                if (SessionIDPanel.this._model == null) {
                    return null;
                }
                return SessionIDPanel.this._model.getRequestCookies((ConversationID)key);
            }

            public String getColumnName() {
                return "Cookie";
            }

            public Class getColumnClass() {
                return class$java$lang$String == null ? (class$java$lang$String = SessionIDPanel.class$("java.lang.String")) : class$java$lang$String;
            }
        };
        this._conversationColumns.put("COOKIE", cdm);
        cdm = new ColumnDataModel(){

            public Object getValue(Object key) {
                if (SessionIDPanel.this._model == null) {
                    return null;
                }
                return SessionIDPanel.this._model.getResponseCookies((ConversationID)key);
            }

            public String getColumnName() {
                return "Set-Cookie";
            }

            public Class getColumnClass() {
                return class$java$lang$String == null ? (class$java$lang$String = SessionIDPanel.class$("java.lang.String")) : class$java$lang$String;
            }
        };
        this._conversationColumns.put("SET-COOKIE", cdm);
        cdm = new ColumnDataModel(){

            public Object getValue(Object key) {
                if (SessionIDPanel.this._model == null) {
                    return null;
                }
                String value = SessionIDPanel.this._model.getResponseCookies((HttpUrl)key);
                return value != null;
            }

            public String getColumnName() {
                return "Set-Cookie";
            }

            public Class getColumnClass() {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = SessionIDPanel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
        };
        this._urlColumns.put("SET-COOKIE", cdm);
    }

    private void initComponents() {
        this.mainTabbedPane = new JTabbedPane();
        this.collectionPanel = new JPanel();
        this.specPanel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.regexTextField = new JTextField();
        this.bodyCheckBox = new JCheckBox();
        this.conversationPanel = new JPanel();
        this.conversationSplitPane = new JSplitPane();
        this.actionPanel = new JPanel();
        this.testButton = new JButton();
        this.jLabel3 = new JLabel();
        this.sampleSpinner = new JSpinner();
        this.fetchButton = new JButton();
        this.historyPanel = new JPanel();
        this.requestComboBox = new JComboBox();
        this.jLabel9 = new JLabel();
        this.analysisPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel8 = new JLabel();
        this.nameComboBox = new JComboBox();
        this.jPanel2 = new JPanel();
        this.clearButton = new JButton();
        this.exportButton = new JButton();
        this.jPanel3 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.idTable = new JTable();
        this.jPanel4 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel4 = new JLabel();
        this.minTextField = new JTextField();
        this.maxTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.rangeTextField = new JTextField();
        this.visualisationPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.collectionPanel.setLayout(new GridBagLayout());
        this.specPanel.setLayout(new GridBagLayout());
        this.specPanel.setToolTipText("Provide a name and regex to match a sessionid in the Location or body");
        this.nameLabel.setText("Name");
        this.nameLabel.setEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.specPanel.add((Component)this.nameLabel, gridBagConstraints);
        this.nameTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.specPanel.add((Component)this.nameTextField, gridBagConstraints);
        this.jLabel2.setText("Regex");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.specPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.regexTextField.setToolTipText("The string enclosed in brackets is used as the session id");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.specPanel.add((Component)this.regexTextField, gridBagConstraints);
        this.bodyCheckBox.setText("From message body");
        this.bodyCheckBox.setHorizontalTextPosition(10);
        this.bodyCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SessionIDPanel.this.bodyCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        this.specPanel.add((Component)this.bodyCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.collectionPanel.add((Component)this.specPanel, gridBagConstraints);
        this.conversationPanel.setLayout(new BorderLayout());
        this.conversationSplitPane.setOrientation(0);
        this.conversationSplitPane.setResizeWeight(0.5);
        this.conversationPanel.add((Component)this.conversationSplitPane, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.collectionPanel.add((Component)this.conversationPanel, gridBagConstraints);
        this.testButton.setText("Test");
        this.testButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SessionIDPanel.this.testButtonActionPerformed(evt);
            }
        });
        this.actionPanel.add(this.testButton);
        this.jLabel3.setText("Samples");
        this.actionPanel.add(this.jLabel3);
        this.sampleSpinner.setMinimumSize(new Dimension(61, 24));
        this.sampleSpinner.setPreferredSize(new Dimension(61, 24));
        this.actionPanel.add(this.sampleSpinner);
        this.fetchButton.setText("Fetch");
        this.fetchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SessionIDPanel.this.fetchButtonActionPerformed(evt);
            }
        });
        this.actionPanel.add(this.fetchButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.5;
        this.collectionPanel.add((Component)this.actionPanel, gridBagConstraints);
        this.historyPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.historyPanel.add((Component)this.requestComboBox, gridBagConstraints);
        this.jLabel9.setText("Previous Requests :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.historyPanel.add((Component)this.jLabel9, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.collectionPanel.add((Component)this.historyPanel, gridBagConstraints);
        this.mainTabbedPane.addTab("Collection", this.collectionPanel);
        this.analysisPanel.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.jLabel8.setText("Session Identifier : ");
        this.jPanel1.add((Component)this.jLabel8, "West");
        this.nameComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SessionIDPanel.this.nameComboBoxActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.nameComboBox, "Center");
        this.analysisPanel.add((Component)this.jPanel1, "North");
        this.clearButton.setText("Clear");
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SessionIDPanel.this.clearButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.clearButton);
        this.exportButton.setText("Export");
        this.exportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SessionIDPanel.this.exportButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.exportButton);
        this.analysisPanel.add((Component)this.jPanel2, "South");
        this.jPanel3.setLayout(new BorderLayout());
        this.idTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane1.setViewportView(this.idTable);
        this.jPanel3.add((Component)this.jScrollPane1, "Center");
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabel1.setText("Minimum : ");
        this.jPanel4.add((Component)this.jLabel1, new GridBagConstraints());
        this.jLabel4.setText("Maximum : ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.jPanel4.add((Component)this.jLabel4, gridBagConstraints);
        this.minTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this.minTextField, gridBagConstraints);
        this.maxTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this.maxTextField, gridBagConstraints);
        this.jLabel5.setText("Range : ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.jPanel4.add((Component)this.jLabel5, gridBagConstraints);
        this.rangeTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this.rangeTextField, gridBagConstraints);
        this.jPanel3.add((Component)this.jPanel4, "South");
        this.analysisPanel.add((Component)this.jPanel3, "Center");
        this.mainTabbedPane.addTab("Analysis", this.analysisPanel);
        this.mainTabbedPane.addTab("Visualisation", this.visualisationPanel);
        this.add((Component)this.mainTabbedPane, "Center");
    }

    private void exportButtonActionPerformed(ActionEvent evt) {
        File dir;
        if (this._key == null) {
            JOptionPane.showMessageDialog(null, "Please select the Session ID to export, using the drop down list", "Error", 0);
            return;
        }
        JFileChooser jfc = new JFileChooser(Preferences.getPreference("WebScarab.DefaultDirectory"));
        jfc.setDialogTitle("Select a directory to write the sessionids into");
        int returnVal = jfc.showSaveDialog(this);
        if (returnVal == 0) {
            File file = jfc.getSelectedFile();
            try {
                this._sa.exportIDSToCSV(this._key, file);
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(null, new String[]{"Error exporting session identifiers", ioe.getMessage()}, "Error", 0);
            }
        }
        if ((dir = jfc.getCurrentDirectory()) != null) {
            Preferences.setPreference("WebScarab.DefaultDirectory", dir.getAbsolutePath());
        }
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        if (this._key == null) {
            JOptionPane.showMessageDialog(null, "Please select the Session ID to clear, using the drop down list", "Error", 0);
            return;
        }
        this._sa.clearSessionIDs(this._key);
    }

    private void bodyCheckBoxActionPerformed(ActionEvent evt) {
        this.nameLabel.setEnabled(this.bodyCheckBox.isSelected());
        this.nameTextField.setEnabled(this.bodyCheckBox.isSelected());
        if (!this.bodyCheckBox.isSelected()) {
            this.nameTextField.setText("");
        }
    }

    private void testButtonActionPerformed(ActionEvent evt) {
        try {
            final Request request = this._requestPanel.getRequest();
            if (request == null) {
                return;
            }
            this.testButton.setEnabled(false);
            final SessionIDPanel parent = this;
            new SwingWorker(){

                public Object construct() {
                    try {
                        SessionIDPanel.this._sa.setRequest(request);
                        SessionIDPanel.this._sa.fetchResponse();
                        return SessionIDPanel.this._sa.getResponse();
                    }
                    catch (IOException ioe) {
                        return ioe;
                    }
                }

                public void finished() {
                    Object obj = this.getValue();
                    if (obj instanceof Response) {
                        Response response = (Response)this.getValue();
                        if (response != null) {
                            SessionIDPanel.this._responsePanel.setResponse(response);
                            String name = SessionIDPanel.this.nameTextField.getText();
                            String regex = SessionIDPanel.this.regexTextField.getText();
                            try {
                                Map ids = SessionIDPanel.this._sa.getIDsFromResponse(response, name, regex);
                                String[] keys = ids.keySet().toArray(new String[0]);
                                for (int i = 0; i < keys.length; ++i) {
                                    SessionID id = (SessionID)ids.get(keys[i]);
                                    keys[i] = keys[i] + " = " + id.getValue();
                                }
                                if (keys.length == 0) {
                                    keys = new String[]{"No session identifiers found!"};
                                }
                                JOptionPane.showMessageDialog(parent, keys, "Extracted Sessionids", 1);
                            }
                            catch (PatternSyntaxException pse) {
                                JOptionPane.showMessageDialog(parent, pse.getMessage(), "Patter Syntax Exception", 2);
                            }
                        }
                    } else if (obj instanceof Exception) {
                        JOptionPane.showMessageDialog(null, new String[]{"Error fetching response: ", obj.toString()}, "Error", 0);
                        SessionIDPanel.this._logger.severe("Exception fetching response: " + obj);
                    }
                    SessionIDPanel.this.testButton.setEnabled(true);
                }
            }.start();
        }
        catch (MalformedURLException mue) {
            JOptionPane.showMessageDialog(this, new String[]{"The URL requested is malformed", mue.getMessage()}, "Malformed URL", 0);
        }
        catch (ParseException pe) {
            JOptionPane.showMessageDialog(this, new String[]{"The request is malformed", pe.getMessage()}, "Malformed Request", 0);
        }
    }

    private void mainTabbedPaneStateChanged(ChangeEvent evt) {
        int selected = this.mainTabbedPane.getSelectedIndex();
        if (this.mainTabbedPane.getTitleAt(selected).equals("Visualisation") && this._chart == null) {
            new SwingWorker(){

                public Object construct() {
                    return SessionIDPanel.this.createChart(SessionIDPanel.this._sidd);
                }

                public void finished() {
                    SessionIDPanel.this._chart = (JFreeChart)this.get();
                    SessionIDPanel.this.visualisationPanel.add((Component)new ChartPanel(SessionIDPanel.this._chart, 900, 500, 600, 400, 1280, 1024, true, true, true, false, true, true));
                    SessionIDPanel.this.visualisationPanel.doLayout();
                }
            }.start();
        }
    }

    private JFreeChart createChart(XYDataset data) {
        DateAxis timeAxis = new DateAxis("Date/Time");
        timeAxis.setLowerMargin(0.02);
        timeAxis.setUpperMargin(0.02);
        NumberAxis valueAxis = new NumberAxis("Value");
        valueAxis.setAutoRangeIncludesZero(false);
        XYPlot plot = new XYPlot(data, (ValueAxis)timeAxis, (ValueAxis)valueAxis, null);
        plot.setRenderer((XYItemRenderer)new StandardXYItemRenderer(1, null, null));
        JFreeChart chart = new JFreeChart("Cookie values over time", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, false);
        return chart;
    }

    private void nameComboBoxActionPerformed(ActionEvent evt) {
        this._key = (String)this.nameComboBox.getSelectedItem();
        this._tableModel.fireTableDataChanged();
        this._sidd.fireDatasetChanged();
        this.updateStats();
    }

    private void fetchButtonActionPerformed(ActionEvent evt) {
        try {
            Request request = this._requestPanel.getRequest();
            if (request == null) {
                this._logger.warning("Request was null in fetch request");
                return;
            }
            String name = this.nameTextField.getText();
            String regex = this.regexTextField.getText();
            int count = (Integer)this.sampleSpinner.getValue();
            try {
                this._sa.fetch(request, name, regex, count);
            }
            catch (PatternSyntaxException pse) {
                JOptionPane.showMessageDialog(this, pse.getMessage(), "Pattern Syntax Exception", 2);
            }
        }
        catch (MalformedURLException mue) {
            JOptionPane.showMessageDialog(this, new String[]{"The URL requested is malformed", mue.getMessage()}, "Malformed URL", 0);
        }
        catch (ParseException pe) {
            JOptionPane.showMessageDialog(this, new String[]{"The request is malformed", pe.getMessage()}, "Malformed Request", 0);
        }
    }

    public void sessionIDAdded(final String key, final int index) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (index == 0) {
                this._sessionIDNames.addElement(key);
            }
            if (key.equals(this._key)) {
                this._sidd.fireDatasetChanged();
                this._tableModel.fireTableRowsInserted(index, index);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SessionIDPanel.this.sessionIDAdded(key, index);
                }
            });
        }
    }

    public void sessionIDsChanged() {
        if (SwingUtilities.isEventDispatchThread()) {
            this._key = null;
            this._sessionIDNames.clear();
            int count = this._model.getSessionIDNameCount();
            for (int i = 0; i < count; ++i) {
                this._sessionIDNames.addElement(this._model.getSessionIDName(i));
            }
            this._sidd.fireDatasetChanged();
            this._tableModel.fireTableDataChanged();
            this.updateStats();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SessionIDPanel.this.sessionIDsChanged();
                }
            });
        }
    }

    private void updateStats() {
        if (this._key == null) {
            this.maxTextField.setText("");
            this.minTextField.setText("");
            this.rangeTextField.setText("");
            return;
        }
        BigInteger min = this._model.getMinimumValue(this._key);
        BigInteger max = this._model.getMaximumValue(this._key);
        if (min != null) {
            this.minTextField.setText(min.toString());
        } else {
            this.minTextField.setText("");
        }
        if (max != null) {
            this.maxTextField.setText(max.toString());
        } else {
            this.maxTextField.setText("");
        }
        if (min != null && max != null) {
            BigInteger range = max.subtract(min);
            this.rangeTextField.setText(Float.toString(range.floatValue()));
        } else {
            this.rangeTextField.setText("");
        }
    }

    public void calculatorChanged(final String key) {
        if (key.equals(this._key)) {
            if (SwingUtilities.isEventDispatchThread()) {
                this._sidd.fireDatasetChanged();
                this._tableModel.fireTableDataChanged();
                this.updateStats();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SessionIDPanel.this.calculatorChanged(key);
                    }
                });
            }
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getPluginName() {
        return "SessionID Analysis";
    }

    public Action[] getConversationActions() {
        return null;
    }

    public Action[] getUrlActions() {
        return null;
    }

    public void setEnabled(final boolean enabled) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.mainTabbedPane.setEnabled(enabled);
            this.testButton.setEnabled(enabled);
            this.fetchButton.setEnabled(enabled);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SessionIDPanel.this.setEnabled(enabled);
                }
            });
        }
    }

    public ColumnDataModel[] getConversationColumns() {
        return this._conversationColumns.values().toArray(CDM);
    }

    public ColumnDataModel[] getUrlColumns() {
        return this._urlColumns.values().toArray(CDM);
    }

    public class SessionIDTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1799339015349456174L;
        private String[] _columnNames = new String[]{"Date", "Value", "Numeric", "Difference"};
        private Class[] _columnClass = new Class[]{class$java$util$Date == null ? (class$java$util$Date = SessionIDPanel.class$("java.util.Date")) : class$java$util$Date, class$java$lang$String == null ? (class$java$lang$String = SessionIDPanel.class$("java.lang.String")) : class$java$lang$String, class$java$math$BigInteger == null ? (class$java$math$BigInteger = SessionIDPanel.class$("java.math.BigInteger")) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = SessionIDPanel.class$("java.math.BigInteger")) : class$java$math$BigInteger};

        public int getColumnCount() {
            return this._columnNames.length;
        }

        public int getRowCount() {
            if (SessionIDPanel.this._key == null) {
                return 0;
            }
            return SessionIDPanel.this._model.getSessionIDCount(SessionIDPanel.this._key);
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (SessionIDPanel.this._key == null) {
                return null;
            }
            SessionID id = SessionIDPanel.this._model.getSessionIDAt(SessionIDPanel.this._key, rowIndex);
            switch (columnIndex) {
                case 0: {
                    return id.getDate();
                }
                case 1: {
                    return id.getValue();
                }
                case 2: {
                    return SessionIDPanel.this._model.getSessionIDValue(SessionIDPanel.this._key, id);
                }
                case 3: {
                    if (rowIndex == 0) {
                        return null;
                    }
                    SessionID prev = SessionIDPanel.this._model.getSessionIDAt(SessionIDPanel.this._key, rowIndex - 1);
                    BigInteger prevValue = SessionIDPanel.this._model.getSessionIDValue(SessionIDPanel.this._key, prev);
                    BigInteger now = SessionIDPanel.this._model.getSessionIDValue(SessionIDPanel.this._key, id);
                    if (now != null && prevValue != null) {
                        return now.subtract(prevValue);
                    }
                    return null;
                }
            }
            return null;
        }

        public String getColumnName(int columnIndex) {
            return this._columnNames[columnIndex];
        }

        public Class getColumnClass(int columnIndex) {
            return this._columnClass[columnIndex];
        }
    }

    private class SessionIDDataset
    extends AbstractSeriesDataset
    implements XYDataset {
        private static final long serialVersionUID = -8276132180435935115L;

        private SessionIDDataset() {
        }

        public int getSeriesCount() {
            return 1;
        }

        public String getSeriesName(int param) {
            return "Cookie value";
        }

        public int getItemCount(int series) {
            if (SessionIDPanel.this._key == null) {
                return 0;
            }
            return SessionIDPanel.this._model.getSessionIDCount(SessionIDPanel.this._key);
        }

        public Number getXValue(int series, int item) {
            SessionID id = SessionIDPanel.this._model.getSessionIDAt(SessionIDPanel.this._key, item);
            return new Long(id.getDate().getTime());
        }

        public Number getYValue(int series, int item) {
            SessionID id = SessionIDPanel.this._model.getSessionIDAt(SessionIDPanel.this._key, item);
            BigInteger bi = SessionIDPanel.this._model.getSessionIDValue(SessionIDPanel.this._key, id);
            if (bi == null) {
                return new Double(0.0);
            }
            return new Double(bi.doubleValue());
        }

        public void calculatorChanged(String key) {
            if (key.equals(SessionIDPanel.this._key)) {
                this.fireDatasetChanged();
            }
        }

        public void sessionIDAdded(String key, int index) {
            if (key.equals(SessionIDPanel.this._key)) {
                this.fireDatasetChanged();
            }
        }

        public void fireDatasetChanged() {
            super.fireDatasetChanged();
        }
    }
}

