/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.spider.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.plugin.spider.Link;
import org.owasp.webscarab.plugin.spider.Spider;
import org.owasp.webscarab.plugin.spider.SpiderModel;
import org.owasp.webscarab.plugin.spider.SpiderUI;
import org.owasp.webscarab.ui.swing.HeaderPanel;
import org.owasp.webscarab.ui.swing.SwingPluginUI;
import org.owasp.webscarab.ui.swing.UrlTreeModelAdapter;
import org.owasp.webscarab.ui.swing.UrlTreeRenderer;
import org.owasp.webscarab.util.swing.ColumnDataModel;

public class SpiderPanel
extends JPanel
implements SwingPluginUI,
SpiderUI {
    private static final long serialVersionUID = 8563871484142539698L;
    private SpiderModel _model;
    private Spider _spider;
    private Logger _logger = Logger.getLogger(this.getClass().getName());
    private HeaderPanel _hp;
    private JCheckBox cookieSyncCheckBox;
    private JTextField domainRegexTextField;
    private JButton headerButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane2;
    private JButton linkTreeFetchSelectionButton;
    private JButton linkTreeFetchTreeButton;
    private JPanel linkTreePanel;
    private JTextField pathRegexTextField;
    private JCheckBox recursiveCheckBox;
    private JButton stopButton;
    private JTree unseenLinkTree;

    public SpiderPanel(Spider spider) {
        this.initComponents();
        this._hp = new HeaderPanel();
        this._hp.setEditable(true);
        this._spider = spider;
        this._model = this._spider.getModel();
        UrlTreeModelAdapter treeModel = new UrlTreeModelAdapter(this._model.getUrlModel());
        this.unseenLinkTree.setModel(treeModel);
        this.unseenLinkTree.setRootVisible(false);
        this.unseenLinkTree.setShowsRootHandles(true);
        this.unseenLinkTree.setCellRenderer(new UrlTreeRenderer());
        this.configure();
    }

    public JPanel getPanel() {
        return this;
    }

    public String getPluginName() {
        return new String("Spider");
    }

    private void configure() {
        this.recursiveCheckBox.setSelected(this._model.getRecursive());
        this.cookieSyncCheckBox.setSelected(this._model.getCookieSync());
        this.domainRegexTextField.setText(this._model.getAllowedDomains());
        this.pathRegexTextField.setText(this._model.getForbiddenPaths());
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.domainRegexTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.pathRegexTextField = new JTextField();
        this.recursiveCheckBox = new JCheckBox();
        this.stopButton = new JButton();
        this.cookieSyncCheckBox = new JCheckBox();
        this.linkTreePanel = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.unseenLinkTree = new JTree();
        this.linkTreeFetchSelectionButton = new JButton();
        this.linkTreeFetchTreeButton = new JButton();
        this.headerButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setText("Allowed Domains");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.domainRegexTextField.setToolTipText("A regular expression describing which domains to include");
        this.domainRegexTextField.setMinimumSize(new Dimension(60, 19));
        this.domainRegexTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiderPanel.this.domainRegexTextFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.domainRegexTextField, gridBagConstraints);
        this.jLabel2.setText("Forbidden Paths");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.pathRegexTextField.setToolTipText("A regular expression describing which paths to exclude");
        this.pathRegexTextField.setMinimumSize(new Dimension(60, 19));
        this.pathRegexTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiderPanel.this.pathRegexTextFieldActionPerformed(evt);
            }
        });
        this.pathRegexTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                SpiderPanel.this.pathRegexTextFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pathRegexTextField, gridBagConstraints);
        this.recursiveCheckBox.setText("Fetch Recursively");
        this.recursiveCheckBox.setToolTipText("Enables recursive fetching of Links");
        this.recursiveCheckBox.setHorizontalTextPosition(10);
        this.recursiveCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiderPanel.this.recursiveCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.recursiveCheckBox, gridBagConstraints);
        this.stopButton.setText("Stop");
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiderPanel.this.stopButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        this.add((Component)this.stopButton, gridBagConstraints);
        this.cookieSyncCheckBox.setText("Synchronise cookies");
        this.cookieSyncCheckBox.setHorizontalTextPosition(10);
        this.cookieSyncCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiderPanel.this.cookieSyncCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.cookieSyncCheckBox, gridBagConstraints);
        this.linkTreePanel.setLayout(new GridBagLayout());
        this.jScrollPane2.setViewportView(this.unseenLinkTree);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.linkTreePanel.add((Component)this.jScrollPane2, gridBagConstraints);
        this.linkTreeFetchSelectionButton.setText("Fetch Selection");
        this.linkTreeFetchSelectionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiderPanel.this.linkTreeFetchSelectionButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        this.linkTreePanel.add((Component)this.linkTreeFetchSelectionButton, gridBagConstraints);
        this.linkTreeFetchTreeButton.setText("Fetch Tree");
        this.linkTreeFetchTreeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiderPanel.this.linkTreeFetchTreeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        this.linkTreePanel.add((Component)this.linkTreeFetchTreeButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.linkTreePanel, gridBagConstraints);
        this.headerButton.setText("Headers");
        this.headerButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiderPanel.this.headerButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.add((Component)this.headerButton, gridBagConstraints);
    }

    private void headerButtonActionPerformed(ActionEvent evt) {
        this._hp.setHeaders(this._model.getExtraHeaders());
        JOptionPane.showMessageDialog(this, this._hp, "Spider Extra Headers", -1);
        this._model.setExtraHeaders(this._hp.getHeaders());
    }

    private void cookieSyncCheckBoxActionPerformed(ActionEvent evt) {
        this._model.setCookieSync(this.cookieSyncCheckBox.isSelected());
    }

    private void linkTreeFetchTreeButtonActionPerformed(ActionEvent evt) {
        TreePath[] selection = this.unseenLinkTree.getSelectionPaths();
        if (selection != null && selection.length == 1) {
            if (this._spider.isBusy()) {
                this._logger.warning("Spider is still busy, please wait");
                JOptionPane.showMessageDialog(this, "Spider is still busy, please wait");
                return;
            }
            HttpUrl url = (HttpUrl)selection[0].getLastPathComponent();
            this._spider.requestLinksUnder(url);
        } else {
            this._logger.info("Cannot fetch a tree if there are 0 or many paths selected!");
            JOptionPane.showMessageDialog(this, "Cannot fetch a tree if there are 0 or many paths selected!");
        }
    }

    private void linkTreeFetchSelectionButtonActionPerformed(ActionEvent evt) {
        TreePath[] selection = this.unseenLinkTree.getSelectionPaths();
        if (selection == null || selection.length == 0) {
            return;
        }
        if (this._spider.isBusy()) {
            this._logger.warning("Spider is still busy, please wait");
            return;
        }
        this.unseenLinkTree.clearSelection();
        HttpUrl[] urls = new HttpUrl[selection.length];
        for (int i = 0; i < selection.length; ++i) {
            urls[i] = (HttpUrl)selection[i].getLastPathComponent();
        }
        this._spider.requestLinks(urls);
    }

    private void pathRegexTextFieldFocusLost(FocusEvent evt) {
    }

    private void pathRegexTextFieldActionPerformed(ActionEvent evt) {
        this._model.setForbiddenPaths(this.pathRegexTextField.getText());
    }

    private void domainRegexTextFieldActionPerformed(ActionEvent evt) {
        this._model.setAllowedDomains(this.domainRegexTextField.getText());
    }

    private void stopButtonActionPerformed(ActionEvent evt) {
        this._spider.clearQueue();
    }

    private void recursiveCheckBoxActionPerformed(ActionEvent evt) {
        this._model.setRecursive(this.recursiveCheckBox.isSelected());
    }

    public Action[] getConversationActions() {
        return null;
    }

    public Action[] getUrlActions() {
        return new Action[]{new SpiderAction()};
    }

    public void linkDequeued(final Link link, final int queueSize) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (link != null) {
                // empty if block
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SpiderPanel.this.linkDequeued(link, queueSize);
                }
            });
        }
    }

    public void linkQueued(final Link link, final int queueSize) {
        if (SwingUtilities.isEventDispatchThread()) {
            this._logger.fine(queueSize + " in queue, adding: " + link.getURL());
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SpiderPanel.this.linkQueued(link, queueSize);
                }
            });
        }
    }

    public void setEnabled(final boolean enabled) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.cookieSyncCheckBox.setEnabled(enabled);
            this.domainRegexTextField.setEnabled(enabled);
            this.linkTreeFetchSelectionButton.setEnabled(enabled);
            this.linkTreeFetchTreeButton.setEnabled(enabled);
            this.pathRegexTextField.setEnabled(enabled);
            this.recursiveCheckBox.setEnabled(enabled);
            this.stopButton.setEnabled(enabled);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SpiderPanel.this.setEnabled(enabled);
                }
            });
        }
    }

    public ColumnDataModel[] getConversationColumns() {
        return null;
    }

    public ColumnDataModel[] getUrlColumns() {
        return null;
    }

    private class SpiderAction
    extends AbstractAction {
        private static final long serialVersionUID = -2207351321290083769L;

        public SpiderAction() {
            this.putValue("Name", "Spider tree");
            this.putValue("ShortDescription", "Fetches any unseen links below this point");
            this.putValue("URL", null);
        }

        public void actionPerformed(ActionEvent e) {
            Object o = this.getValue("URL");
            if (o == null || !(o instanceof HttpUrl)) {
                return;
            }
            HttpUrl url = (HttpUrl)o;
            if (!SpiderPanel.this._spider.isBusy()) {
                SpiderPanel.this._spider.requestLinksUnder(url);
            } else {
                SpiderPanel.this._logger.warning("Spider is still busy, please wait");
                JOptionPane.showMessageDialog(SpiderPanel.this, "Spider is still busy, please wait");
            }
        }

        public void putValue(String key, Object value) {
            super.putValue(key, value);
            if (key != null && key.equals("URL")) {
                if (value != null && value instanceof HttpUrl) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            }
        }
    }
}

