/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.xsscrlf.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.Preferences;
import org.owasp.webscarab.plugin.xsscrlf.XSSCRLF;
import org.owasp.webscarab.plugin.xsscrlf.XSSCRLFModel;
import org.owasp.webscarab.ui.swing.ColumnWidthTracker;
import org.owasp.webscarab.ui.swing.ConversationTableModel;
import org.owasp.webscarab.ui.swing.DateRenderer;
import org.owasp.webscarab.ui.swing.ShowConversationAction;
import org.owasp.webscarab.ui.swing.SwingPluginUI;
import org.owasp.webscarab.util.swing.ColumnDataModel;
import org.owasp.webscarab.util.swing.SwingWorker;
import org.owasp.webscarab.util.swing.TableSorter;

public class XSSCRLFPanel
extends JPanel
implements SwingPluginUI {
    private static final long serialVersionUID = -5862303750441463107L;
    private XSSCRLF _xsscrlf;
    private XSSCRLFModel _model;
    private Logger _logger = Logger.getLogger(this.getClass().getName());
    private ColumnDataModel[] _vulnerableConversationColumns;
    private ColumnDataModel[] _vulnerableUrlColumns;
    private ShowConversationAction _showAction;
    private JButton cancelButton;
    private JButton checkButton;
    private JPanel controlPanel;
    private JTable conversationTable;
    private JTextArea crlfTextArea;
    private JButton editButton;
    private JDialog editDialog;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JSplitPane jSplitPane1;
    private JButton loadButton;
    private JButton okButton;
    private JTable suspectedTable;
    private JTabbedPane tabbedPane;
    private JTextArea xssTextArea;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;

    public XSSCRLFPanel(XSSCRLF xsscrlf) {
        this._xsscrlf = xsscrlf;
        this._model = xsscrlf.getModel();
        this.initComponents();
        this._vulnerableConversationColumns = new ColumnDataModel[2];
        ConversationTableModel vtm = new ConversationTableModel(this._model.getVulnerableConversationModel());
        this._vulnerableConversationColumns = new ColumnDataModel[]{new ColumnDataModel(){

            public String getColumnName() {
                return "Possible Injection";
            }

            public Object getValue(Object key) {
                ConversationID id = (ConversationID)key;
                return XSSCRLFPanel.this._model.isXSSSuspected(id) || XSSCRLFPanel.this._model.isCRLFSuspected(id) ? Boolean.TRUE : Boolean.FALSE;
            }

            public Class getColumnClass() {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = XSSCRLFPanel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
        }, new ColumnDataModel(){

            public String getColumnName() {
                return "XSS";
            }

            public Object getValue(Object key) {
                return XSSCRLFPanel.this._model.isXSSVulnerable((ConversationID)key) ? Boolean.TRUE : Boolean.FALSE;
            }

            public Class getColumnClass() {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = XSSCRLFPanel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
        }, new ColumnDataModel(){

            public String getColumnName() {
                return "CRLF";
            }

            public Object getValue(Object key) {
                return XSSCRLFPanel.this._model.isCRLFVulnerable((ConversationID)key) ? Boolean.TRUE : Boolean.FALSE;
            }

            public Class getColumnClass() {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = XSSCRLFPanel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
        }};
        vtm.addColumn(this._vulnerableConversationColumns[0]);
        vtm.addColumn(this._vulnerableConversationColumns[1]);
        ConversationTableModel stm = new ConversationTableModel(this._model.getSuspectedConversationModel());
        stm.addColumn(new ColumnDataModel(){

            public String getColumnName() {
                return "XSS";
            }

            public Object getValue(Object key) {
                return XSSCRLFPanel.this._model.isXSSSuspected((ConversationID)key) ? Boolean.TRUE : Boolean.FALSE;
            }

            public Class getColumnClass() {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = XSSCRLFPanel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
        });
        stm.addColumn(new ColumnDataModel(){

            public String getColumnName() {
                return "XSS parameters";
            }

            public Object getValue(Object key) {
                return XSSCRLFPanel.this._model.getXSSSuspected((ConversationID)key);
            }

            public Class getColumnClass() {
                return class$java$lang$String == null ? (class$java$lang$String = XSSCRLFPanel.class$("java.lang.String")) : class$java$lang$String;
            }
        });
        stm.addColumn(new ColumnDataModel(){

            public String getColumnName() {
                return "CRLF";
            }

            public Object getValue(Object key) {
                return XSSCRLFPanel.this._model.isCRLFSuspected((ConversationID)key) ? Boolean.TRUE : Boolean.FALSE;
            }

            public Class getColumnClass() {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = XSSCRLFPanel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
        });
        stm.addColumn(new ColumnDataModel(){

            public String getColumnName() {
                return "CRLF parameters";
            }

            public Object getValue(Object key) {
                return XSSCRLFPanel.this._model.getCRLFSuspected((ConversationID)key);
            }

            public Class getColumnClass() {
                return class$java$lang$String == null ? (class$java$lang$String = XSSCRLFPanel.class$("java.lang.String")) : class$java$lang$String;
            }
        });
        TableSorter vts = new TableSorter(vtm, this.conversationTable.getTableHeader());
        TableSorter sts = new TableSorter(stm, this.suspectedTable.getTableHeader());
        this.conversationTable.setModel(vts);
        this.suspectedTable.setModel(sts);
        ColumnWidthTracker.getTracker("ConversationTable").addTable(this.conversationTable);
        ColumnWidthTracker.getTracker("ConversationTable").addTable(this.suspectedTable);
        this.conversationTable.setDefaultRenderer(Date.class, new DateRenderer());
        this.suspectedTable.setDefaultRenderer(Date.class, new DateRenderer());
        this._vulnerableUrlColumns = new ColumnDataModel[]{new ColumnDataModel(){

            public String getColumnName() {
                return "Possible Injection";
            }

            public Object getValue(Object key) {
                HttpUrl url = (HttpUrl)key;
                return XSSCRLFPanel.this._model.isSuspected(url) ? Boolean.TRUE : Boolean.FALSE;
            }

            public Class getColumnClass() {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = XSSCRLFPanel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
        }, new ColumnDataModel(){

            public String getColumnName() {
                return "Injection";
            }

            public Object getValue(Object key) {
                HttpUrl url = (HttpUrl)key;
                return XSSCRLFPanel.this._model.isXSSVulnerable(url) || XSSCRLFPanel.this._model.isCRLFVulnerable(url) ? Boolean.TRUE : Boolean.FALSE;
            }

            public Class getColumnClass() {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = XSSCRLFPanel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
        }};
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.editDialog.setBounds((screenSize.width - 300) / 2, (screenSize.height - 150) / 2, 300, 150);
        this.addTableListeners();
    }

    private void addTableListeners() {
        this._showAction = new ShowConversationAction(this._model.getVulnerableConversationModel());
        this.conversationTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int row = XSSCRLFPanel.this.conversationTable.getSelectedRow();
                TableModel tm = XSSCRLFPanel.this.conversationTable.getModel();
                if (row > -1) {
                    ConversationID id = (ConversationID)tm.getValueAt(row, 0);
                    XSSCRLFPanel.this._showAction.putValue("CONVERSATION", id);
                } else {
                    XSSCRLFPanel.this._showAction.putValue("CONVERSATION", null);
                }
            }
        });
        this.conversationTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int row = XSSCRLFPanel.this.conversationTable.rowAtPoint(e.getPoint());
                XSSCRLFPanel.this.conversationTable.getSelectionModel().setSelectionInterval(row, row);
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    ActionEvent evt = new ActionEvent(XSSCRLFPanel.this.conversationTable, 0, (String)XSSCRLFPanel.this._showAction.getValue("ActionCommandKey"));
                    if (XSSCRLFPanel.this._showAction.isEnabled()) {
                        XSSCRLFPanel.this._showAction.actionPerformed(evt);
                    }
                }
            }
        });
    }

    private void initComponents() {
        this.editDialog = new JDialog();
        this.tabbedPane = new JTabbedPane();
        this.jScrollPane4 = new JScrollPane();
        this.xssTextArea = new JTextArea();
        this.jScrollPane3 = new JScrollPane();
        this.crlfTextArea = new JTextArea();
        this.jPanel3 = new JPanel();
        this.loadButton = new JButton();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.suspectedTable = new JTable();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.conversationTable = new JTable();
        this.controlPanel = new JPanel();
        this.editButton = new JButton();
        this.checkButton = new JButton();
        this.editDialog.setTitle("Extensions");
        this.editDialog.setModal(true);
        this.tabbedPane.setMinimumSize(new Dimension(200, 200));
        this.tabbedPane.setPreferredSize(new Dimension(200, 200));
        this.jScrollPane4.setViewportView(this.xssTextArea);
        this.tabbedPane.addTab("XSS", this.jScrollPane4);
        this.jScrollPane3.setViewportView(this.crlfTextArea);
        this.tabbedPane.addTab("CRLF Injection", this.jScrollPane3);
        this.editDialog.getContentPane().add((Component)this.tabbedPane, "Center");
        this.loadButton.setText("Load");
        this.loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XSSCRLFPanel.this.loadButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.loadButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XSSCRLFPanel.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.cancelButton);
        this.okButton.setText("Ok");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XSSCRLFPanel.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.okButton);
        this.editDialog.getContentPane().add((Component)this.jPanel3, "South");
        this.setLayout(new BorderLayout());
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jPanel1.setLayout(new BorderLayout());
        this.jLabel1.setText("Suspected Vulnerabilities");
        this.jPanel1.add((Component)this.jLabel1, "North");
        this.suspectedTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.suspectedTable.setAutoResizeMode(0);
        this.jScrollPane1.setViewportView(this.suspectedTable);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        this.jPanel2.setLayout(new BorderLayout());
        this.jLabel2.setText("Confirmed Vulnerabilities");
        this.jPanel2.add((Component)this.jLabel2, "North");
        this.conversationTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.conversationTable.setAutoResizeMode(0);
        this.jScrollPane2.setViewportView(this.conversationTable);
        this.jPanel2.add((Component)this.jScrollPane2, "Center");
        this.jSplitPane1.setRightComponent(this.jPanel2);
        this.add((Component)this.jSplitPane1, "Center");
        this.controlPanel.setLayout(new GridBagLayout());
        this.editButton.setText("Edit Test Strings");
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XSSCRLFPanel.this.editButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        this.controlPanel.add((Component)this.editButton, gridBagConstraints);
        this.checkButton.setText("Check");
        this.checkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XSSCRLFPanel.this.checkButtonActionPerformed(evt);
            }
        });
        this.controlPanel.add((Component)this.checkButton, new GridBagConstraints());
        this.add((Component)this.controlPanel, "South");
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this._model.setCRLFTestString(this.crlfTextArea.getText());
        this._model.setXSSTestString(this.xssTextArea.getText());
        this.editDialog.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.editDialog.setVisible(false);
    }

    private void loadButtonActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser(Preferences.getPreference("XSSCRLF.DefaultDirectory"));
        jfc.setDialogTitle("Open test string file");
        int returnVal = jfc.showOpenDialog(this);
        if (returnVal == 0) {
            File extFile = jfc.getSelectedFile();
            try {
                String testString = this._xsscrlf.loadString(extFile);
                if (this.tabbedPane.getTitleAt(this.tabbedPane.getSelectedIndex()).equals("XSS")) {
                    this.xssTextArea.setText(testString);
                } else {
                    this.crlfTextArea.setText(testString);
                }
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(null, new String[]{"Error loading test string: ", ioe.getMessage()}, "Error", 0);
            }
        }
        Preferences.setPreference("XSSCRLF.DefaultDirectory", jfc.getCurrentDirectory().getAbsolutePath());
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        this.xssTextArea.setText(this._model.getXSSTestString());
        this.crlfTextArea.setText(this._model.getCRLFTestString());
        this.editDialog.setVisible(true);
    }

    private void checkButtonActionPerformed(ActionEvent evt) {
        String action = evt.getActionCommand();
        if (action.equals("Stop")) {
            this._xsscrlf.stopChecks();
            return;
        }
        int[] selection = this.suspectedTable.getSelectedRows();
        if (selection == null || selection.length == 0) {
            return;
        }
        if (this._xsscrlf.isBusy()) {
            this.showBusyMessage();
            return;
        }
        final ConversationID[] CIDs = new ConversationID[selection.length];
        TableModel tm = this.suspectedTable.getModel();
        for (int i = 0; i < selection.length; ++i) {
            CIDs[i] = (ConversationID)tm.getValueAt(i, 0);
        }
        this.checkButton.setText("Stop");
        new SwingWorker(){

            public Object construct() {
                XSSCRLFPanel.this._xsscrlf.checkSelected(CIDs);
                return null;
            }

            public void finished() {
                Object result = this.getValue();
                if (result != null && result instanceof Throwable) {
                    Throwable throwable = (Throwable)result;
                    XSSCRLFPanel.this._logger.warning("Caught a : " + throwable.toString());
                }
                XSSCRLFPanel.this.checkButton.setText("Check");
            }
        }.start();
    }

    private void showBusyMessage() {
        this._logger.warning("Plugin is still busy, please wait");
    }

    public Action[] getConversationActions() {
        return null;
    }

    public ColumnDataModel[] getConversationColumns() {
        return this._vulnerableConversationColumns;
    }

    public JPanel getPanel() {
        return this;
    }

    public String getPluginName() {
        return this._xsscrlf.getPluginName();
    }

    public Action[] getUrlActions() {
        return null;
    }

    public ColumnDataModel[] getUrlColumns() {
        return this._vulnerableUrlColumns;
    }
}

