/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import org.owasp.webscarab.httpclient.HTTPClientFactory;
import org.owasp.webscarab.httpclient.SSLContextManager;

public class CertificateManager
extends JFrame {
    private static final long serialVersionUID = 5690492352598432340L;
    private SSLContextManager _sslcm = HTTPClientFactory.getInstance().getSSLContextManager();
    private DefaultListModel _keystoreListModel;
    private AliasTableModel _aliasTableModel;
    private JButton addKeystoreButton;
    private JDialog addKeystoreDialog;
    private JTable aliasTable;
    private JPasswordField askPasswordField;
    private JPanel buttonPanel;
    private JTextArea certTextArea;
    private JButton closeButton;
    private JTextField currentCertTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JList keyStoreList;
    private JButton keystoreCancelButton;
    private JButton keystoreOkButton;
    private JTabbedPane keystoreTabbedPane;
    private JButton pkcs11BrowseButton;
    private JTextField pkcs11LibraryTextField;
    private JTextField pkcs11NameTextField;
    private JPanel pkcs11Panel;
    private JPasswordField pkcs11PasswordField;
    private JButton pkcs12BrowseButton;
    private JTextField pkcs12FileTextField;
    private JPanel pkcs12Panel;
    private JPasswordField pkcs12PasswordField;
    private JButton setButton;

    public CertificateManager() {
        this.initComponents();
        if (!this._sslcm.isProviderAvailable("PKCS11")) {
            this.keystoreTabbedPane.setEnabledAt(1, false);
        }
        this._keystoreListModel = new DefaultListModel();
        this.updateKeystoreList();
        this.keyStoreList.setModel(this._keystoreListModel);
        this.keyStoreList.setSelectionMode(0);
        this.keyStoreList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                int keystore = CertificateManager.this.keyStoreList.getSelectedIndex();
                try {
                    CertificateManager.this._aliasTableModel.setKeystore(keystore);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, new String[]{"Error accessing key store: ", e.toString()}, "Error", 0);
                    e.printStackTrace();
                }
            }
        });
        this._aliasTableModel = new AliasTableModel();
        this.aliasTable.setModel(this._aliasTableModel);
        this.aliasTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                CertificateManager.this._sslcm.setDefaultKey(null);
                int keystore = CertificateManager.this.keyStoreList.getSelectedIndex();
                int alias = CertificateManager.this.aliasTable.getSelectedRow();
                if (alias > -1) {
                    try {
                        Certificate cert = CertificateManager.this._sslcm.getCertificate(keystore, alias);
                        CertificateManager.this.certTextArea.setText(cert.toString());
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, new String[]{"Error accessing key store: ", e.toString()}, "Error", 0);
                        e.printStackTrace();
                    }
                } else {
                    CertificateManager.this.certTextArea.setText("");
                }
            }
        });
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.addKeystoreDialog.setBounds((screenSize.width - 450) / 2, (screenSize.height - 190) / 2, 450, 190);
        this.setBounds((screenSize.width - 600) / 2, (screenSize.height - 400) / 2, 600, 400);
        this.getRootPane().setDefaultButton(this.closeButton);
        this.addKeystoreDialog.getRootPane().setDefaultButton(this.keystoreOkButton);
    }

    public String getPassword() {
        int result = JOptionPane.showConfirmDialog(this, this.askPasswordField, "Enter password", 2);
        if (result == 0) {
            char[] password = this.askPasswordField.getPassword();
            if (password != null) {
                return new String(password);
            }
            return new String();
        }
        return null;
    }

    private void initComponents() {
        this.addKeystoreDialog = new JDialog(this);
        this.keystoreTabbedPane = new JTabbedPane();
        this.pkcs12Panel = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.pkcs12FileTextField = new JTextField();
        this.pkcs12BrowseButton = new JButton();
        this.pkcs12PasswordField = new JPasswordField();
        this.pkcs11Panel = new JPanel();
        this.jLabel5 = new JLabel();
        this.pkcs11NameTextField = new JTextField();
        this.jLabel6 = new JLabel();
        this.pkcs11LibraryTextField = new JTextField();
        this.pkcs11BrowseButton = new JButton();
        this.jLabel7 = new JLabel();
        this.pkcs11PasswordField = new JPasswordField();
        this.buttonPanel = new JPanel();
        this.keystoreCancelButton = new JButton();
        this.keystoreOkButton = new JButton();
        this.askPasswordField = new JPasswordField();
        this.jScrollPane1 = new JScrollPane();
        this.keyStoreList = new JList();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.aliasTable = new JTable();
        this.jPanel1 = new JPanel();
        this.addKeystoreButton = new JButton();
        this.setButton = new JButton();
        this.closeButton = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.certTextArea = new JTextArea();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.currentCertTextField = new JTextField();
        this.addKeystoreDialog.setTitle("Add Key Store");
        this.addKeystoreDialog.setModal(true);
        this.addKeystoreDialog.setResizable(false);
        this.pkcs12Panel.setLayout(new GridBagLayout());
        this.jLabel3.setText("File");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.pkcs12Panel.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText("Password");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.pkcs12Panel.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pkcs12Panel.add((Component)this.pkcs12FileTextField, gridBagConstraints);
        this.pkcs12BrowseButton.setText("Browse");
        this.pkcs12BrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CertificateManager.this.pkcs12BrowseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.pkcs12Panel.add((Component)this.pkcs12BrowseButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pkcs12Panel.add((Component)this.pkcs12PasswordField, gridBagConstraints);
        this.keystoreTabbedPane.addTab("PKCS#12", this.pkcs12Panel);
        this.pkcs11Panel.setLayout(new GridBagLayout());
        this.jLabel5.setText("Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.pkcs11Panel.add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pkcs11Panel.add((Component)this.pkcs11NameTextField, gridBagConstraints);
        this.jLabel6.setText("Library");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.pkcs11Panel.add((Component)this.jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pkcs11Panel.add((Component)this.pkcs11LibraryTextField, gridBagConstraints);
        this.pkcs11BrowseButton.setText("Browse");
        this.pkcs11BrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CertificateManager.this.pkcs11BrowseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.pkcs11Panel.add((Component)this.pkcs11BrowseButton, gridBagConstraints);
        this.jLabel7.setText("Password");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.pkcs11Panel.add((Component)this.jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pkcs11Panel.add((Component)this.pkcs11PasswordField, gridBagConstraints);
        this.keystoreTabbedPane.addTab("PKCS#11", this.pkcs11Panel);
        this.addKeystoreDialog.getContentPane().add((Component)this.keystoreTabbedPane, "Center");
        this.keystoreCancelButton.setText("Cancel");
        this.keystoreCancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CertificateManager.this.keystoreCancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.keystoreCancelButton);
        this.keystoreOkButton.setText("Ok");
        this.keystoreOkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CertificateManager.this.keystoreOkButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.keystoreOkButton);
        this.addKeystoreDialog.getContentPane().add((Component)this.buttonPanel, "South");
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Certificate Manager");
        this.jScrollPane1.setMinimumSize(new Dimension(250, 22));
        this.jScrollPane1.setPreferredSize(new Dimension(250, 176));
        this.jScrollPane1.setViewportView(this.keyStoreList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.5;
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabel1.setText("Key Store");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("Certificates");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.aliasTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane2.setViewportView(this.aliasTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        this.getContentPane().add((Component)this.jScrollPane2, gridBagConstraints);
        this.addKeystoreButton.setText("Add Key Store");
        this.addKeystoreButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CertificateManager.this.addKeystoreButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.addKeystoreButton);
        this.setButton.setText("Activate Selected Alias");
        this.setButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CertificateManager.this.setButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.setButton);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CertificateManager.this.closeButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.closeButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.certTextArea.setEditable(false);
        this.jScrollPane3.setViewportView(this.certTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jScrollPane3, gridBagConstraints);
        this.jLabel8.setText("Certificate Details");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jLabel8, gridBagConstraints);
        this.jLabel9.setText("Active key");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jLabel9, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.currentCertTextField, gridBagConstraints);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 600) / 2, (screenSize.height - 400) / 2, 600, 400);
    }

    private void setButtonActionPerformed(ActionEvent evt) {
        int ks = this.keyStoreList.getSelectedIndex();
        int alias = this.aliasTable.getSelectedRow();
        String fingerprint = "";
        if (ks > -1 && alias > -1) {
            if (!this._sslcm.isKeyUnlocked(ks, alias)) {
                String password = this.getPassword();
                try {
                    this._sslcm.unlockKey(ks, alias, password);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(null, new String[]{"Error accessing key store: ", e.toString()}, "Error", 0);
                }
            }
            Certificate cert = this._sslcm.getCertificate(ks, alias);
            try {
                fingerprint = this._sslcm.getFingerPrint(cert);
            }
            catch (KeyStoreException kse) {
                kse.printStackTrace();
                JOptionPane.showMessageDialog(null, new String[]{"Error calculating key fingerprint: ", kse.toString()}, "Error", 0);
                fingerprint = "";
            }
        }
        this.currentCertTextField.setText(fingerprint);
        this._sslcm.setDefaultKey(fingerprint);
    }

    private void pkcs11BrowseButtonActionPerformed(ActionEvent evt) {
        File library = this.chooseFile("Select the native PKCS#11 library", null);
        if (library != null) {
            this.pkcs11LibraryTextField.setText(library.getAbsolutePath());
        }
    }

    private void pkcs12BrowseButtonActionPerformed(ActionEvent evt) {
        FileFilter filter = new FileFilter(){

            public String getDescription() {
                return "*.p12, *.pfx";
            }

            public boolean accept(File file) {
                String name = file.getName();
                if (file.isDirectory()) {
                    return true;
                }
                return name.endsWith(".p12") || name.endsWith(".pfx");
            }
        };
        File file = this.chooseFile("Select a PKCS#12 certificate", filter);
        if (file != null) {
            this.pkcs12FileTextField.setText(file.getAbsolutePath());
        }
    }

    private File chooseFile(String message, FileFilter filter) {
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle(message);
        jfc.setFileFilter(filter);
        int result = jfc.showOpenDialog(this.addKeystoreDialog);
        if (result == 0) {
            return jfc.getSelectedFile();
        }
        return null;
    }

    private void keystoreOkButtonActionPerformed(ActionEvent evt) {
        try {
            int tab = this.keystoreTabbedPane.getSelectedIndex();
            if (tab == 0) {
                String file = this.pkcs12FileTextField.getText();
                if (file.equals("")) {
                    return;
                }
                String kspass = new String(this.pkcs12PasswordField.getPassword());
                if (kspass.equals("")) {
                    kspass = null;
                }
                int ksIndex = this._sslcm.loadPKCS12Certificate(file, kspass);
                this._keystoreListModel.insertElementAt(this._sslcm.getKeyStoreDescription(ksIndex), ksIndex);
            } else if (tab == 1) {
                String name = this.pkcs11NameTextField.getText();
                if (name.equals("")) {
                    return;
                }
                String library = this.pkcs11LibraryTextField.getText();
                if (library.equals("")) {
                    return;
                }
                String kspass = new String(this.pkcs11PasswordField.getPassword());
                if (kspass.equals("")) {
                    kspass = null;
                }
                int ksIndex = this._sslcm.initPKCS11(name, library, kspass);
                this._keystoreListModel.insertElementAt(this._sslcm.getKeyStoreDescription(ksIndex), ksIndex);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, new String[]{"Error loading Key Store: ", e.toString()}, "Error", 0);
            return;
        }
        this.addKeystoreDialog.setVisible(false);
    }

    private void updateKeystoreList() {
        this._keystoreListModel.removeAllElements();
        for (int i = 0; i < this._sslcm.getKeyStoreCount(); ++i) {
            this._keystoreListModel.addElement(this._sslcm.getKeyStoreDescription(i));
        }
    }

    private void keystoreCancelButtonActionPerformed(ActionEvent evt) {
        this.addKeystoreDialog.setVisible(false);
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void addKeystoreButtonActionPerformed(ActionEvent evt) {
        this.addKeystoreDialog.setVisible(true);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new CertificateManager().setVisible(true);
            }
        });
    }

    private class AliasTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 7086599198379703765L;
        private int _ks = -1;
        private List _aliases = new ArrayList();

        private AliasTableModel() {
        }

        public void setKeystore(int ks) {
            this._ks = ks;
            this._aliases.clear();
            if (this._ks > -1) {
                for (int i = 0; i < CertificateManager.this._sslcm.getAliasCount(ks); ++i) {
                    this._aliases.add(CertificateManager.this._sslcm.getAliasAt(ks, i));
                }
            }
            this.fireTableDataChanged();
        }

        public String getAlias(int row) {
            return (String)this._aliases.get(row);
        }

        public int getColumnCount() {
            return 1;
        }

        public int getRowCount() {
            return this._aliases.size();
        }

        public Object getValueAt(int row, int col) {
            return this._aliases.get(row);
        }
    }
}

