/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import org.owasp.webscarab.model.Cookie;
import org.owasp.webscarab.model.FrameworkEvent;
import org.owasp.webscarab.model.FrameworkListener;
import org.owasp.webscarab.model.FrameworkModel;
import org.owasp.webscarab.util.swing.TableSorter;

public class CookieJarViewer
extends JFrame {
    private static final long serialVersionUID = -1330444912535205210L;
    private FrameworkModel _model;
    private CookieTableModel _cookieTableModel;
    private HistoricalCookieTableModel _detailTableModel;
    private Logger _logger = Logger.getLogger(this.getClass().getName());
    private String _key = null;
    private JButton addButton;
    private JDialog addDialog;
    private JButton cancelButton;
    private JButton closeButton;
    private JTable cookieDetailTable;
    private JTable cookieTable;
    private JButton deleteButton;
    private JTextField domainTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextField nameTextField;
    private JButton okButton;
    private JTextField pathTextField;
    private JTextField valueTextField;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Boolean;

    public CookieJarViewer(FrameworkModel model) {
        this._model = model;
        this.initComponents();
        this._cookieTableModel = new CookieTableModel(this._model);
        this.cookieTable.setModel(new TableSorter(this._cookieTableModel, this.cookieTable.getTableHeader()));
        this._detailTableModel = new HistoricalCookieTableModel(this._model);
        this.cookieDetailTable.setModel(new TableSorter(this._detailTableModel, this.cookieDetailTable.getTableHeader()));
        this.cookieTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                if (evt.getValueIsAdjusting()) {
                    return;
                }
                int row = CookieJarViewer.this.cookieTable.getSelectedRow();
                if (row > -1) {
                    CookieJarViewer.this._key = CookieJarViewer.this._cookieTableModel.getKeyAt(row);
                } else {
                    CookieJarViewer.this._key = null;
                }
                CookieJarViewer.this._detailTableModel.setKey(CookieJarViewer.this._key);
            }
        });
        this.addDialog.pack();
    }

    private void initComponents() {
        this.addDialog = new JDialog();
        this.jLabel6 = new JLabel();
        this.domainTextField = new JTextField();
        this.jLabel4 = new JLabel();
        this.pathTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.nameTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.valueTextField = new JTextField();
        this.jPanel2 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.cookieTable = new JTable();
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.cookieDetailTable = new JTable();
        this.closeButton = new JButton();
        this.jPanel1 = new JPanel();
        this.addButton = new JButton();
        this.deleteButton = new JButton();
        this.addDialog.getContentPane().setLayout(new GridBagLayout());
        this.addDialog.setTitle("Add Cookie");
        this.addDialog.setLocationRelativeTo(null);
        this.addDialog.setModal(true);
        this.addDialog.setName("Add Cookie");
        this.addDialog.setResizable(false);
        this.jLabel6.setText("Domain : ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        this.addDialog.getContentPane().add((Component)this.jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.addDialog.getContentPane().add((Component)this.domainTextField, gridBagConstraints);
        this.jLabel4.setText("Path : ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.addDialog.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        this.pathTextField.setMinimumSize(new Dimension(200, 19));
        this.pathTextField.setPreferredSize(new Dimension(400, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.addDialog.getContentPane().add((Component)this.pathTextField, gridBagConstraints);
        this.jLabel5.setText("Name : ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.addDialog.getContentPane().add((Component)this.jLabel5, gridBagConstraints);
        this.nameTextField.setMinimumSize(new Dimension(200, 19));
        this.nameTextField.setPreferredSize(new Dimension(400, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.addDialog.getContentPane().add((Component)this.nameTextField, gridBagConstraints);
        this.jLabel3.setText("Value : ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        this.addDialog.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.valueTextField.setMinimumSize(new Dimension(200, 19));
        this.valueTextField.setPreferredSize(new Dimension(400, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.addDialog.getContentPane().add((Component)this.valueTextField, gridBagConstraints);
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CookieJarViewer.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.jPanel2.add(this.cancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        this.addDialog.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("WebScarab Cookies");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                CookieJarViewer.this.exitForm(evt);
            }
        });
        this.jLabel1.setText("Cookies");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jScrollPane1.setPreferredSize(new Dimension(600, 200));
        this.cookieTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane1.setViewportView(this.cookieTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabel2.setText("Previous values");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.jScrollPane2.setPreferredSize(new Dimension(300, 200));
        this.cookieDetailTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane2.setViewportView(this.cookieDetailTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jScrollPane2, gridBagConstraints);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CookieJarViewer.this.closeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.closeButton, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.addButton.setText("Add");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CookieJarViewer.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.addButton, gridBagConstraints);
        this.deleteButton.setText("Delete");
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CookieJarViewer.this.deleteButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.deleteButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 600) / 2, (screenSize.height - 400) / 2, 600, 400);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        String name;
        String domain = this.domainTextField.getText();
        this.domainTextField.setBackground("".equals(domain) ? Color.RED : Color.WHITE);
        String path = this.pathTextField.getText();
        if ("".equals(path)) {
            path = "/";
        }
        this.nameTextField.setBackground("".equals(name = this.nameTextField.getText()) ? Color.RED : Color.WHITE);
        String value = this.valueTextField.getText();
        if ("".equals(domain) || "".equals(name)) {
            return;
        }
        Cookie cookie = new Cookie(new Date(), name + "=" + value + "; domain=" + domain + "; path=" + path);
        this._logger.info("Cookie is " + cookie);
        this._model.addCookie(cookie);
        this.addDialog.setVisible(false);
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        int row = this.cookieDetailTable.getSelectedRow();
        if (row < this.cookieDetailTable.getRowCount() && row > -1) {
            Cookie cookie = this._model.getCookieAt(this._key, row);
            this._model.removeCookie(cookie);
        }
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.addDialog.setVisible(true);
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void exitForm(WindowEvent evt) {
        this.setVisible(false);
    }

    private class HistoricalCookieTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 5621223454741175006L;
        private FrameworkModel _model = null;
        private String _key = null;
        private FrameworkListener _listener = new FrameworkListener(){

            public void cookieAdded(FrameworkEvent evt) {
                Cookie cookie = evt.getCookie();
                if (HistoricalCookieTableModel.this._key == null || !HistoricalCookieTableModel.this._key.equals(cookie.getKey())) {
                    return;
                }
                int row = HistoricalCookieTableModel.this._model.getIndexOfCookie(HistoricalCookieTableModel.this._key, cookie);
                HistoricalCookieTableModel.this.fireTableRowsInserted(row, row);
            }

            public void cookieRemoved(FrameworkEvent evt) {
                Cookie cookie = evt.getCookie();
                if (HistoricalCookieTableModel.this._key == null || !HistoricalCookieTableModel.this._key.equals(cookie.getKey())) {
                    return;
                }
                HistoricalCookieTableModel.this.fireTableDataChanged();
            }

            public void cookiesChanged() {
                HistoricalCookieTableModel.this.fireTableDataChanged();
            }

            public void conversationPropertyChanged(FrameworkEvent evt) {
            }

            public void urlPropertyChanged(FrameworkEvent evt) {
            }
        };
        private String[] _columnNames = new String[]{"Date", "Value", "Secure", "Max age", "Comment"};
        private Class[] _columnClass = new Class[]{class$java$util$Date == null ? (class$java$util$Date = CookieJarViewer.class$("java.util.Date")) : class$java$util$Date, class$java$lang$String == null ? (class$java$lang$String = CookieJarViewer.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Boolean == null ? (class$java$lang$Boolean = CookieJarViewer.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$String == null ? (class$java$lang$String = CookieJarViewer.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = CookieJarViewer.class$("java.lang.String")) : class$java$lang$String};

        public HistoricalCookieTableModel(FrameworkModel model) {
            this._model = model;
            this._model.addModelListener(this._listener);
        }

        public void setKey(String key) {
            this._key = key;
            this.fireTableDataChanged();
        }

        public int getRowCount() {
            if (this._model == null) {
                return 0;
            }
            if (this._key == null) {
                return 0;
            }
            return this._model.getCookieCount(this._key);
        }

        public Object getValueAt(int row, int column) {
            Cookie cookie = this._model.getCookieAt(this._key, row);
            switch (column) {
                case 0: {
                    return cookie.getDate();
                }
                case 1: {
                    return cookie.getValue();
                }
                case 2: {
                    return cookie.getSecure();
                }
                case 3: {
                    return cookie.getMaxAge();
                }
                case 4: {
                    return cookie.getComment();
                }
            }
            return null;
        }

        public int getColumnCount() {
            return this._columnNames.length;
        }

        public String getColumnName(int columnIndex) {
            return this._columnNames[columnIndex];
        }

        public Class getColumnClass(int columnIndex) {
            return this._columnClass[columnIndex];
        }
    }

    private class CookieTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 5256611073293100905L;
        private FrameworkModel _model;
        private FrameworkListener _listener = new FrameworkListener(){

            public void cookieAdded(FrameworkEvent evt) {
                Cookie cookie = evt.getCookie();
                int row = CookieTableModel.this._model.getIndexOfCookie(cookie);
                int count = CookieTableModel.this._model.getCookieCount(cookie.getKey());
                if (count == 1) {
                    CookieTableModel.this.fireTableRowsInserted(row, row);
                } else {
                    CookieTableModel.this.fireTableRowsUpdated(row, row);
                }
            }

            public void cookieRemoved(FrameworkEvent evt) {
                Cookie cookie = evt.getCookie();
                int count = CookieTableModel.this._model.getCookieCount(cookie.getKey());
                if (count == 0) {
                    CookieTableModel.this.fireTableDataChanged();
                } else {
                    int row = CookieTableModel.this._model.getIndexOfCookie(cookie);
                    CookieTableModel.this.fireTableRowsUpdated(row, row);
                }
            }

            public void cookiesChanged() {
                CookieTableModel.this.fireTableDataChanged();
            }

            public void conversationPropertyChanged(FrameworkEvent evt) {
            }

            public void urlPropertyChanged(FrameworkEvent evt) {
            }
        };
        private String[] _columnNames = new String[]{"Domain", "Path", "Name", "Date", "Value", "Secure", "Max age", "Comment"};
        private Class[] _columnClass = new Class[]{class$java$lang$String == null ? (class$java$lang$String = CookieJarViewer.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = CookieJarViewer.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = CookieJarViewer.class$("java.lang.String")) : class$java$lang$String, class$java$util$Date == null ? (class$java$util$Date = CookieJarViewer.class$("java.util.Date")) : class$java$util$Date, class$java$lang$String == null ? (class$java$lang$String = CookieJarViewer.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Boolean == null ? (class$java$lang$Boolean = CookieJarViewer.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$String == null ? (class$java$lang$String = CookieJarViewer.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = CookieJarViewer.class$("java.lang.String")) : class$java$lang$String};

        public CookieTableModel(FrameworkModel model) {
            this._model = model;
            this._model.addModelListener(this._listener);
        }

        public int getColumnCount() {
            return this._columnNames.length;
        }

        public int getRowCount() {
            if (this._model == null) {
                return 0;
            }
            return this._model.getCookieCount();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            String key = this._model.getCookieAt(rowIndex);
            Cookie cookie = this._model.getCurrentCookie(key);
            switch (columnIndex) {
                case 0: {
                    return cookie.getDomain();
                }
                case 1: {
                    return cookie.getPath();
                }
                case 2: {
                    return cookie.getName();
                }
                case 3: {
                    return cookie.getDate();
                }
                case 4: {
                    return cookie.getValue();
                }
                case 5: {
                    return cookie.getSecure();
                }
                case 6: {
                    return cookie.getMaxAge();
                }
                case 7: {
                    return cookie.getComment();
                }
            }
            return null;
        }

        public String getColumnName(int columnIndex) {
            return this._columnNames[columnIndex];
        }

        public Class getColumnClass(int columnIndex) {
            return this._columnClass[columnIndex];
        }

        public String getKeyAt(int row) {
            return this._model.getCookieAt(row);
        }
    }
}

