/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import org.owasp.webscarab.model.Preferences;
import org.owasp.webscarab.plugin.BasicCredential;
import org.owasp.webscarab.plugin.CredentialManager;
import org.owasp.webscarab.plugin.DomainCredential;
import org.owasp.webscarab.ui.swing.CredentialRequestDialog;

public class CredentialManagerFrame
extends JFrame {
    private static final long serialVersionUID = 1688116674185863060L;
    private CredentialManager _manager;
    private BasicTableModel _btm;
    private DomainTableModel _dtm;
    private JButton addButton;
    private JTable basicTable;
    private JButton clearButton;
    private JButton closeButton;
    private JButton deleteButton;
    private JTable domainTable;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JCheckBox promptCheckBox;

    public CredentialManagerFrame(CredentialManager manager) {
        this.initComponents();
        boolean prompt = Boolean.valueOf(Preferences.getPreference("WebScarab.promptForCredentials", "false"));
        this.promptCheckBox.setSelected(prompt);
        this.addComponentListener(new Updater());
        this._manager = manager;
        this._btm = new BasicTableModel();
        this._dtm = new DomainTableModel();
        this.basicTable.setModel(this._btm);
        this.domainTable.setModel(this._dtm);
    }

    private void updateCredentials() {
        this._btm.fireTableDataChanged();
        this._dtm.fireTableDataChanged();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.basicTable = new JTable();
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.domainTable = new JTable();
        this.jPanel1 = new JPanel();
        this.addButton = new JButton();
        this.deleteButton = new JButton();
        this.clearButton = new JButton();
        this.closeButton = new JButton();
        this.promptCheckBox = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("WebScarab Credentials");
        this.jLabel1.setText("Basic Credentials");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.basicTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.basicTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabel2.setText("Domain Credentials");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.domainTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane2.setViewportView(this.domainTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jScrollPane2, gridBagConstraints);
        this.addButton.setText("Add");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CredentialManagerFrame.this.addButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.addButton);
        this.deleteButton.setText("Delete");
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CredentialManagerFrame.this.deleteButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.deleteButton);
        this.clearButton.setText("Clear all");
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CredentialManagerFrame.this.clearButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.clearButton);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CredentialManagerFrame.this.closeButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.closeButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.promptCheckBox.setText("Ask when required");
        this.promptCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.promptCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.promptCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CredentialManagerFrame.this.promptCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.promptCheckBox, gridBagConstraints);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 400) / 2, (screenSize.height - 300) / 2, 400, 300);
    }

    private void promptCheckBoxActionPerformed(ActionEvent evt) {
        Preferences.setPreference("WebScarab.promptForCredentials", Boolean.toString(this.promptCheckBox.isSelected()));
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        int i;
        for (i = this._manager.getBasicCredentialCount() - 1; i >= 0; --i) {
            this._manager.deleteBasicCredentialAt(i);
        }
        for (i = this._manager.getDomainCredentialCount() - 1; i >= 0; --i) {
            this._manager.deleteDomainCredentialAt(i);
        }
        this.updateCredentials();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        int basicSelection = this.basicTable.getSelectedRow();
        int domainSelection = this.domainTable.getSelectedRow();
        if (basicSelection > -1 && domainSelection > -1) {
            return;
        }
        if (basicSelection > -1) {
            this._manager.deleteBasicCredentialAt(basicSelection);
        }
        if (domainSelection > -1) {
            this._manager.deleteDomainCredentialAt(domainSelection);
        }
        this.updateCredentials();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        new CredentialRequestDialog((Frame)this, true, this._manager).requestCredentials(null, null);
        this.updateCredentials();
    }

    private class Updater
    extends ComponentAdapter {
        private Updater() {
        }

        public void componentShown(ComponentEvent e) {
            CredentialManagerFrame.this.updateCredentials();
        }
    }

    private class DomainTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -4483058953578321230L;
        private String[] _columnNames = new String[]{"Host", "Domain", "Username"};

        private DomainTableModel() {
        }

        public String getColumnName(int column) {
            return this._columnNames[column];
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return CredentialManagerFrame.this._manager.getDomainCredentialCount();
        }

        public Object getValueAt(int row, int column) {
            DomainCredential dc = CredentialManagerFrame.this._manager.getDomainCredentialAt(row);
            switch (column) {
                case 0: {
                    return dc.getHost();
                }
                case 1: {
                    return dc.getDomain();
                }
                case 2: {
                    return dc.getUsername();
                }
            }
            return null;
        }
    }

    private class BasicTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 4101228666708000944L;
        private String[] _columnNames = new String[]{"Host", "Realm", "Username"};

        private BasicTableModel() {
        }

        public String getColumnName(int column) {
            return this._columnNames[column];
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return CredentialManagerFrame.this._manager.getBasicCredentialCount();
        }

        public Object getValueAt(int row, int column) {
            BasicCredential bc = CredentialManagerFrame.this._manager.getBasicCredentialAt(row);
            switch (column) {
                case 0: {
                    return bc.getHost();
                }
                case 1: {
                    return bc.getRealm();
                }
                case 2: {
                    return bc.getUsername();
                }
            }
            return null;
        }
    }
}

