/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.owasp.webscarab.plugin.BasicCredential;
import org.owasp.webscarab.plugin.CredentialManager;
import org.owasp.webscarab.plugin.CredentialManagerUI;
import org.owasp.webscarab.plugin.DomainCredential;

public class CredentialRequestDialog
extends JDialog
implements CredentialManagerUI {
    private static final long serialVersionUID = 2733259794943234695L;
    private CredentialManager _manager;
    private JRadioButton basicRadioButton;
    private JButton cancelButton;
    private JLabel domainLabel;
    private JRadioButton domainRadioButton;
    private JTextField domainTextField;
    private JLabel hostLabel;
    private JTextField hostTextField;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private ButtonGroup methodButtonGroup;
    private JButton okButton;
    private JLabel passwordLabel;
    private JPasswordField passwordTextField;
    private JLabel realmLabel;
    private JTextArea realmTextArea;
    private JLabel usernameLabel;
    private JTextField usernameTextField;

    public CredentialRequestDialog(Frame parent, boolean modal, CredentialManager manager) {
        super(parent, modal);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        this._manager = manager;
    }

    public void requestCredentials(String host, String[] challenges) {
        this.setup(host, challenges);
        this.getOwner().setVisible(true);
        this.setVisible(true);
        this.toFront();
    }

    private void setup(String host, String[] challenges) {
        this.basicRadioButton.setEnabled(false);
        this.domainRadioButton.setEnabled(false);
        this.hostTextField.setText("");
        this.domainTextField.setText("");
        this.realmTextArea.setText("");
        this.usernameTextField.setText("");
        this.passwordTextField.setText("");
        if (host != null) {
            this.hostTextField.setText(host);
        }
        if (challenges == null) {
            this.basicRadioButton.setEnabled(true);
            this.realmTextArea.setEditable(true);
            this.domainRadioButton.setEnabled(true);
        } else {
            for (int i = 0; i < challenges.length; ++i) {
                if (challenges[i].startsWith("Basic ")) {
                    this.basicRadioButton.setEnabled(true);
                    String realm = challenges[i].substring("Basic realm=\"".length(), challenges[i].length() - 1);
                    this.realmTextArea.setText(realm);
                    this.realmTextArea.setEditable(false);
                    continue;
                }
                if (!challenges[i].startsWith("NTLM") && !challenges[i].startsWith("Negotiate")) continue;
                this.domainRadioButton.setEnabled(true);
            }
        }
        if (this.basicRadioButton.isEnabled()) {
            this.basicRadioButton.doClick();
        } else if (this.domainRadioButton.isEnabled()) {
            this.domainRadioButton.doClick();
        }
    }

    private void initComponents() {
        this.methodButtonGroup = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.basicRadioButton = new JRadioButton();
        this.domainRadioButton = new JRadioButton();
        this.hostLabel = new JLabel();
        this.hostTextField = new JTextField();
        this.domainLabel = new JLabel();
        this.domainTextField = new JTextField();
        this.realmLabel = new JLabel();
        this.realmTextArea = new JTextArea();
        this.usernameLabel = new JLabel();
        this.usernameTextField = new JTextField();
        this.passwordLabel = new JLabel();
        this.passwordTextField = new JPasswordField();
        this.jPanel2 = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(0);
        this.setTitle("Enter your credentials to access this web site");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                CredentialRequestDialog.this.formWindowClosed(evt);
            }
        });
        this.methodButtonGroup.add(this.basicRadioButton);
        this.basicRadioButton.setSelected(true);
        this.basicRadioButton.setText("Basic");
        this.basicRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CredentialRequestDialog.this.basicRadioButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.basicRadioButton);
        this.methodButtonGroup.add(this.domainRadioButton);
        this.domainRadioButton.setText("Domain");
        this.domainRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CredentialRequestDialog.this.domainRadioButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.domainRadioButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.hostLabel.setText("Host");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.hostLabel, gridBagConstraints);
        this.hostTextField.setMinimumSize(new Dimension(200, 22));
        this.hostTextField.setPreferredSize(new Dimension(200, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.hostTextField, gridBagConstraints);
        this.domainLabel.setText("Domain");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.domainLabel, gridBagConstraints);
        this.domainTextField.setMinimumSize(new Dimension(200, 22));
        this.domainTextField.setPreferredSize(new Dimension(200, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.domainTextField, gridBagConstraints);
        this.realmLabel.setText("Realm");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.realmLabel, gridBagConstraints);
        this.realmTextArea.setEditable(false);
        this.realmTextArea.setMinimumSize(new Dimension(200, 22));
        this.realmTextArea.setPreferredSize(new Dimension(200, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.realmTextArea, gridBagConstraints);
        this.usernameLabel.setText("Username");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.usernameLabel, gridBagConstraints);
        this.usernameTextField.setMinimumSize(new Dimension(200, 22));
        this.usernameTextField.setPreferredSize(new Dimension(200, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.usernameTextField, gridBagConstraints);
        this.passwordLabel.setText("Password");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.passwordLabel, gridBagConstraints);
        this.passwordTextField.setMinimumSize(new Dimension(200, 22));
        this.passwordTextField.setPreferredSize(new Dimension(200, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.passwordTextField, gridBagConstraints);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CredentialRequestDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.cancelButton);
        this.okButton.setText("Ok");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CredentialRequestDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.okButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 419) / 2, (screenSize.height - 206) / 2, 419, 206);
    }

    private void domainRadioButtonActionPerformed(ActionEvent evt) {
        this.domainLabel.setVisible(true);
        this.domainTextField.setVisible(true);
        this.realmLabel.setVisible(false);
        this.realmTextArea.setVisible(false);
    }

    private void basicRadioButtonActionPerformed(ActionEvent evt) {
        this.domainLabel.setVisible(false);
        this.domainTextField.setVisible(false);
        this.realmLabel.setVisible(true);
        this.realmTextArea.setVisible(true);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.ok();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void formWindowClosed(WindowEvent evt) {
        this.cancel();
    }

    private void ok() {
        String host = this.hostTextField.getText();
        String domain = this.domainTextField.getText();
        String realm = this.realmTextArea.getText();
        String username = this.usernameTextField.getText();
        String password = new String(this.passwordTextField.getPassword());
        if (!username.equals("") && !password.equals("")) {
            if (this.basicRadioButton.isSelected()) {
                BasicCredential bc = new BasicCredential(host, realm, username, password);
                this._manager.addBasicCredentials(bc);
            } else if (this.domainRadioButton.isSelected()) {
                DomainCredential dc = new DomainCredential(host, domain, username, password);
                this._manager.addDomainCredentials(dc);
            }
        }
        this.setVisible(false);
    }

    private void cancel() {
        this.setVisible(false);
    }
}

