/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.FilteredUrlModel;
import org.owasp.webscarab.model.FrameworkModel;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.ui.swing.ColumnWidthTracker;
import org.owasp.webscarab.ui.swing.ConversationTableModel;
import org.owasp.webscarab.ui.swing.DateRenderer;
import org.owasp.webscarab.ui.swing.ShowConversationAction;
import org.owasp.webscarab.ui.swing.UrlFilteredConversationModel;
import org.owasp.webscarab.ui.swing.UrlTreeRenderer;
import org.owasp.webscarab.ui.swing.UrlTreeTableModelAdapter;
import org.owasp.webscarab.util.swing.ColumnDataModel;
import org.owasp.webscarab.util.swing.JTreeTable;
import org.owasp.webscarab.util.swing.TableSorter;

public class SummaryPanel
extends JPanel {
    private static final long serialVersionUID = -653352257745170107L;
    private FrameworkModel _model;
    private UrlFilteredConversationModel _conversationModel;
    private FilteredUrlModel _urlModel;
    private JTreeTable _urlTreeTable;
    private ArrayList _urlActions = new ArrayList();
    private HttpUrl _treeURL = null;
    private TableSorter _conversationTableSorter;
    private ConversationTableModel _conversationTableModel;
    private UrlTreeTableModelAdapter _urlTreeTableModel;
    private ArrayList _conversationActions = new ArrayList();
    private Map _urlColumns = new HashMap();
    private JPopupMenu conversationPopupMenu;
    private JScrollPane conversationScrollPane;
    private JTable conversationTable;
    private JSplitPane summarySplitPane;
    private JCheckBox treeCheckBox;
    private JScrollPane treeScrollPane;
    private JPanel urlPanel;
    private JPopupMenu urlPopupMenu;
    static /* synthetic */ Class class$java$lang$String;

    public SummaryPanel(FrameworkModel model) {
        this._model = model;
        this._conversationModel = new UrlFilteredConversationModel(this._model, this._model.getConversationModel());
        this._urlModel = new FilteredUrlModel(model.getUrlModel()){

            protected boolean shouldFilter(HttpUrl url) {
                return SummaryPanel.this._model.getUrlProperty(url, "METHODS") == null;
            }
        };
        this.initComponents();
        this.initTree();
        this.addTreeListeners();
        this.initTable();
        this.addTableListeners();
        this.addConversationActions(new Action[]{new ShowConversationAction(this._conversationModel)});
    }

    private void initTree() {
        this._urlTreeTableModel = new UrlTreeTableModelAdapter(this._urlModel);
        this._urlTreeTable = new JTreeTable(this._urlTreeTableModel);
        this._urlTreeTable.setAutoResizeMode(0);
        ColumnWidthTracker.getTracker("UrlTree").addTable(this._urlTreeTable);
        ColumnDataModel cdm = new ColumnDataModel(){

            public Object getValue(Object key) {
                if (SummaryPanel.this._model == null) {
                    return null;
                }
                return SummaryPanel.this._model.getUrlProperty((HttpUrl)key, "METHODS");
            }

            public String getColumnName() {
                return "Methods";
            }

            public Class getColumnClass() {
                return class$java$lang$String == null ? (class$java$lang$String = SummaryPanel.class$("java.lang.String")) : class$java$lang$String;
            }
        };
        this._urlColumns.put("METHODS", cdm);
        this._urlTreeTableModel.addColumn(cdm);
        cdm = new ColumnDataModel(){

            public Object getValue(Object key) {
                if (SummaryPanel.this._model == null) {
                    return null;
                }
                return SummaryPanel.this._model.getUrlProperty((HttpUrl)key, "STATUS");
            }

            public String getColumnName() {
                return "Status";
            }

            public Class getColumnClass() {
                return class$java$lang$String == null ? (class$java$lang$String = SummaryPanel.class$("java.lang.String")) : class$java$lang$String;
            }
        };
        this._urlColumns.put("STATUS", cdm);
        this._urlTreeTableModel.addColumn(cdm);
        JTree urlTree = this._urlTreeTable.getTree();
        urlTree.getSelectionModel().setSelectionMode(1);
        urlTree.setRootVisible(false);
        urlTree.setShowsRootHandles(true);
        urlTree.setCellRenderer(new UrlTreeRenderer());
        this.treeScrollPane.setViewportView(this._urlTreeTable);
    }

    private void addTreeListeners() {
        final JTree urlTree = this._urlTreeTable.getTree();
        urlTree.addTreeSelectionListener(new TreeSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void valueChanged(TreeSelectionEvent e) {
                Object o;
                TreePath selection = urlTree.getSelectionPath();
                SummaryPanel.this._treeURL = null;
                if (selection != null && (o = selection.getLastPathComponent()) instanceof HttpUrl) {
                    SummaryPanel.this._treeURL = (HttpUrl)o;
                }
                if (SummaryPanel.this.treeCheckBox.isSelected()) {
                    SummaryPanel.this._conversationModel.setUrl(SummaryPanel.this._treeURL);
                }
                ArrayList arrayList = SummaryPanel.this._urlActions;
                synchronized (arrayList) {
                    for (int i = 0; i < SummaryPanel.this._urlActions.size(); ++i) {
                        AbstractAction action = (AbstractAction)SummaryPanel.this._urlActions.get(i);
                        action.putValue("URL", SummaryPanel.this._treeURL);
                    }
                }
            }
        });
        this._urlTreeTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger() && SummaryPanel.this._urlActions.size() > 0) {
                    int row = SummaryPanel.this._urlTreeTable.rowAtPoint(e.getPoint());
                    SummaryPanel.this._urlTreeTable.getSelectionModel().setSelectionInterval(row, row);
                    SummaryPanel.this.urlPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    public void addUrlActions(Action[] actions) {
        int i;
        if (actions == null) {
            return;
        }
        for (i = 0; i < actions.length; ++i) {
            this._urlActions.add(actions[i]);
        }
        for (i = 0; i < actions.length; ++i) {
            this.urlPopupMenu.add(new JMenuItem(actions[i]));
        }
    }

    public void addUrlColumns(ColumnDataModel[] columns) {
        if (columns == null) {
            return;
        }
        for (int i = 0; i < columns.length; ++i) {
            this._urlTreeTableModel.addColumn(columns[i]);
        }
    }

    private void initTable() {
        this._conversationTableModel = new ConversationTableModel(this._conversationModel);
        ColumnWidthTracker.getTracker("ConversationTable").addTable(this.conversationTable);
        this._conversationTableSorter = new TableSorter(this._conversationTableModel, this.conversationTable.getTableHeader());
        this.conversationTable.setModel(this._conversationTableSorter);
        this.conversationTable.setDefaultRenderer(Date.class, new DateRenderer());
    }

    private void addTableListeners() {
        this.conversationTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int row = SummaryPanel.this.conversationTable.getSelectedRow();
                TableModel tm = SummaryPanel.this.conversationTable.getModel();
                ConversationID id = null;
                if (row > -1) {
                    id = (ConversationID)tm.getValueAt(row, 0);
                }
                ArrayList arrayList = SummaryPanel.this._conversationActions;
                synchronized (arrayList) {
                    for (int i = 0; i < SummaryPanel.this._conversationActions.size(); ++i) {
                        Action action = (Action)SummaryPanel.this._conversationActions.get(i);
                        action.putValue("CONVERSATION", id);
                    }
                }
            }
        });
        this.conversationTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                int row = SummaryPanel.this.conversationTable.rowAtPoint(e.getPoint());
                SummaryPanel.this.conversationTable.getSelectionModel().setSelectionInterval(row, row);
                if (e.isPopupTrigger() && SummaryPanel.this._conversationActions.size() > 0) {
                    SummaryPanel.this.conversationPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1 && SummaryPanel.this._conversationActions.size() > 0) {
                    Action action = (Action)SummaryPanel.this._conversationActions.get(0);
                    ActionEvent evt = new ActionEvent(SummaryPanel.this.conversationTable, 0, (String)action.getValue("ActionCommandKey"));
                    if (action.isEnabled()) {
                        action.actionPerformed(evt);
                    }
                }
            }
        });
    }

    public void addConversationActions(Action[] actions) {
        int i;
        if (actions == null) {
            return;
        }
        for (i = 0; i < actions.length; ++i) {
            this._conversationActions.add(actions[i]);
        }
        for (i = 0; i < actions.length; ++i) {
            this.conversationPopupMenu.add(new JMenuItem(actions[i]));
        }
    }

    public void addConversationColumns(ColumnDataModel[] columns) {
        if (columns == null) {
            return;
        }
        for (int i = 0; i < columns.length; ++i) {
            this._conversationTableModel.addColumn(columns[i]);
        }
        this._conversationTableSorter.setSortingStatus(0, -1);
    }

    private void initComponents() {
        this.urlPopupMenu = new JPopupMenu();
        this.conversationPopupMenu = new JPopupMenu();
        this.summarySplitPane = new JSplitPane();
        this.urlPanel = new JPanel();
        this.treeCheckBox = new JCheckBox();
        this.treeScrollPane = new JScrollPane();
        this.conversationScrollPane = new JScrollPane();
        this.conversationTable = new JTable();
        this.urlPopupMenu.setLabel("URL Actions");
        this.conversationPopupMenu.setLabel("Conversation Actions");
        this.setLayout(new BorderLayout());
        this.summarySplitPane.setOrientation(0);
        this.summarySplitPane.setResizeWeight(0.5);
        this.summarySplitPane.setOneTouchExpandable(true);
        this.urlPanel.setLayout(new GridBagLayout());
        this.urlPanel.setMinimumSize(new Dimension(283, 100));
        this.urlPanel.setPreferredSize(new Dimension(264, 100));
        this.treeCheckBox.setText("Tree Selection filters conversation list");
        this.treeCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SummaryPanel.this.treeCheckBoxActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.urlPanel.add((Component)this.treeCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.urlPanel.add((Component)this.treeScrollPane, gridBagConstraints);
        this.summarySplitPane.setLeftComponent(this.urlPanel);
        this.conversationTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.conversationTable.setAutoResizeMode(0);
        this.conversationTable.setCellSelectionEnabled(true);
        this.conversationScrollPane.setViewportView(this.conversationTable);
        this.summarySplitPane.setRightComponent(this.conversationScrollPane);
        this.add((Component)this.summarySplitPane, "Center");
    }

    private void treeCheckBoxActionPerformed(ActionEvent evt) {
        if (this.treeCheckBox.isSelected() && this._treeURL != null) {
            this._conversationModel.setUrl(this._treeURL);
        } else {
            this._conversationModel.setUrl(null);
        }
    }
}

