/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.FrameworkModel;

public class TagConversationAction
extends AbstractAction {
    private static final long serialVersionUID = -55516030560746658L;
    private Component parent;
    private FrameworkModel _model;

    public TagConversationAction(Component parent, FrameworkModel model) {
        this._model = model;
        this.putValue("Name", "Tag conversation");
        this.putValue("ShortDescription", "Assign a user-defined tag to this conversation");
        this.putValue("CONVERSATION", null);
    }

    public void actionPerformed(ActionEvent e) {
        Object o = this.getValue("CONVERSATION");
        if (o == null || !(o instanceof ConversationID)) {
            return;
        }
        ConversationID id = (ConversationID)o;
        String tag = this._model.getConversationProperty(id, "TAG");
        tag = JOptionPane.showInputDialog(this.parent, "Tag the conversation", tag == null ? "" : tag);
        this._model.setConversationProperty(id, "TAG", tag);
    }

    public void putValue(String key, Object value) {
        super.putValue(key, value);
        if (key != null && key.equals("CONVERSATION")) {
            if (value != null && value instanceof ConversationID) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }
}

