/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.owasp.webscarab.util.Encoding;

public class TranscoderFrame
extends JFrame
implements ClipboardOwner {
    private static final long serialVersionUID = 5712516501903313109L;
    protected UndoManager undo = new UndoManager();
    protected UndoAction undoAction;
    protected RedoAction redoAction;
    private Hashtable actions;
    private JButton base64DecodeButton;
    private JButton base64EncodeButton;
    private JLabel countLabel;
    private JMenu editMenu;
    private JMenuBar jMenuBar1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JButton md5hashButton;
    private JButton sha1hashButton;
    private JTextPane textPane;
    private JButton urlDecodeButton;
    private JButton urlEncodeButton;

    public TranscoderFrame() {
        this.initComponents();
        this.createActionTable(this.textPane);
        this.undo.setLimit(10);
        this.undoAction = new UndoAction();
        this.editMenu.add(this.undoAction);
        this.redoAction = new RedoAction();
        this.editMenu.add(this.redoAction);
        this.editMenu.addSeparator();
        this.editMenu.add(this.getActionByName("cut-to-clipboard"));
        this.editMenu.add(this.getActionByName("copy-to-clipboard"));
        this.editMenu.add(this.getActionByName("paste-from-clipboard"));
        this.editMenu.addSeparator();
        this.editMenu.add(this.getActionByName("select-all"));
        final Document d = this.textPane.getDocument();
        d.addUndoableEditListener(new MyUndoableEditListener());
        d.addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                this.update();
            }

            public void insertUpdate(DocumentEvent evt) {
                this.update();
            }

            public void removeUpdate(DocumentEvent evt) {
                this.update();
            }

            private void update() {
                TranscoderFrame.this.countLabel.setText("Characters: " + d.getLength());
            }
        });
    }

    private void createActionTable(JTextComponent textComponent) {
        this.actions = new Hashtable();
        Action[] actionsArray = textComponent.getActions();
        for (int i = 0; i < actionsArray.length; ++i) {
            Action a = actionsArray[i];
            this.actions.put(a.getValue("Name"), a);
        }
    }

    private Action getActionByName(String name) {
        return (Action)this.actions.get(name);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.textPane = new JTextPane();
        this.jPanel1 = new JPanel();
        this.urlEncodeButton = new JButton();
        this.urlDecodeButton = new JButton();
        this.base64EncodeButton = new JButton();
        this.base64DecodeButton = new JButton();
        this.md5hashButton = new JButton();
        this.sha1hashButton = new JButton();
        this.countLabel = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.editMenu = new JMenu();
        this.setTitle("Transcoder");
        this.textPane.setFont(new Font("Monospaced", 0, 12));
        this.jScrollPane1.setViewportView(this.textPane);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.jPanel1.setLayout(new GridBagLayout());
        this.urlEncodeButton.setText("URL encode");
        this.urlEncodeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TranscoderFrame.this.urlEncodeButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.urlEncodeButton, gridBagConstraints);
        this.urlDecodeButton.setText("URL decode");
        this.urlDecodeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TranscoderFrame.this.urlDecodeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.urlDecodeButton, gridBagConstraints);
        this.base64EncodeButton.setText("Base64 encode");
        this.base64EncodeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TranscoderFrame.this.base64EncodeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.base64EncodeButton, gridBagConstraints);
        this.base64DecodeButton.setText("Base64 decode");
        this.base64DecodeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TranscoderFrame.this.base64DecodeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.base64DecodeButton, gridBagConstraints);
        this.md5hashButton.setText("MD5 hash");
        this.md5hashButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TranscoderFrame.this.md5hashButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.md5hashButton, gridBagConstraints);
        this.sha1hashButton.setText("SHA-1 hash");
        this.sha1hashButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TranscoderFrame.this.sha1hashButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.sha1hashButton, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.countLabel.setText("Characters: 0");
        this.getContentPane().add((Component)this.countLabel, "North");
        this.editMenu.setText("Edit");
        this.jMenuBar1.add(this.editMenu);
        this.setJMenuBar(this.jMenuBar1);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 600) / 2, (screenSize.height - 400) / 2, 600, 400);
    }

    private void sha1hashButtonActionPerformed(ActionEvent evt) {
        if (this.textPane.getSelectionEnd() == this.textPane.getSelectionStart()) {
            this.textPane.select(0, this.textPane.getText().length());
        }
        this.textPane.replaceSelection(Encoding.hashSHA(this.textPane.getSelectedText()));
    }

    private void md5hashButtonActionPerformed(ActionEvent evt) {
        if (this.textPane.getSelectionEnd() == this.textPane.getSelectionStart()) {
            this.textPane.select(0, this.textPane.getText().length());
        }
        this.textPane.replaceSelection(Encoding.hashMD5(this.textPane.getSelectedText()));
    }

    private void base64DecodeButtonActionPerformed(ActionEvent evt) {
        try {
            if (this.textPane.getSelectionEnd() == this.textPane.getSelectionStart()) {
                this.textPane.select(0, this.textPane.getText().length());
            }
            this.textPane.replaceSelection(new String(Encoding.base64decode(this.textPane.getSelectedText(), false)));
        }
        catch (Throwable t) {
            Runtime.getRuntime().gc();
            t.printStackTrace();
            this.textPane.setText("Exception! " + t.toString());
        }
    }

    private void urlDecodeButtonActionPerformed(ActionEvent evt) {
        if (this.textPane.getSelectionEnd() == this.textPane.getSelectionStart()) {
            this.textPane.select(0, this.textPane.getText().length());
        }
        this.textPane.replaceSelection(TranscoderFrame.urlDecode(this.textPane.getSelectedText()));
    }

    private void urlEncodeButtonActionPerformed(ActionEvent evt) {
        if (this.textPane.getSelectionEnd() == this.textPane.getSelectionStart()) {
            this.textPane.select(0, this.textPane.getText().length());
        }
        this.textPane.replaceSelection(TranscoderFrame.urlEncode(this.textPane.getSelectedText()));
    }

    private void base64EncodeButtonActionPerformed(ActionEvent evt) {
        try {
            if (this.textPane.getSelectionEnd() == this.textPane.getSelectionStart()) {
                this.textPane.select(0, this.textPane.getText().length());
            }
            this.textPane.replaceSelection(Encoding.base64encode(this.textPane.getSelectedText().getBytes(), false));
        }
        catch (Throwable t) {
            Runtime.getRuntime().gc();
            t.printStackTrace();
            this.textPane.setText("Exception! " + t.toString());
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public static String urlDecode(String str) {
        try {
            return URLDecoder.decode(str, "utf-8");
        }
        catch (Exception e) {
            return "Decoding error";
        }
    }

    public static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, "utf-8");
        }
        catch (Exception e) {
            return "Encoding error";
        }
    }

    public static void main(String[] args) {
        TranscoderFrame tf = new TranscoderFrame();
        tf.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        tf.setVisible(true);
    }

    protected class MyUndoableEditListener
    implements UndoableEditListener {
        protected MyUndoableEditListener() {
        }

        public void undoableEditHappened(UndoableEditEvent e) {
            TranscoderFrame.this.undo.addEdit(e.getEdit());
            TranscoderFrame.this.undoAction.updateUndoState();
            TranscoderFrame.this.redoAction.updateRedoState();
        }
    }

    class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = -2044519935735823050L;

        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                TranscoderFrame.this.undo.redo();
            }
            catch (CannotRedoException ex) {
                System.out.println("Unable to redo: " + ex);
                ex.printStackTrace();
            }
            this.updateRedoState();
            TranscoderFrame.this.undoAction.updateUndoState();
        }

        protected void updateRedoState() {
            if (TranscoderFrame.this.undo.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", TranscoderFrame.this.undo.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = -137321944593284589L;

        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                TranscoderFrame.this.undo.undo();
            }
            catch (CannotUndoException ex) {
                System.out.println("Unable to undo: " + ex);
                ex.printStackTrace();
            }
            this.updateUndoState();
            TranscoderFrame.this.redoAction.updateRedoState();
        }

        protected void updateUndoState() {
            if (TranscoderFrame.this.undo.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", TranscoderFrame.this.undo.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }
    }
}

