/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.PatternSyntaxException;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.owasp.webscarab.model.FileSystemStore;
import org.owasp.webscarab.model.FrameworkModel;
import org.owasp.webscarab.model.Preferences;
import org.owasp.webscarab.model.StoreException;
import org.owasp.webscarab.plugin.CredentialManager;
import org.owasp.webscarab.plugin.Framework;
import org.owasp.webscarab.ui.swing.CertificateManager;
import org.owasp.webscarab.ui.swing.CookieJarViewer;
import org.owasp.webscarab.ui.swing.CredentialManagerFrame;
import org.owasp.webscarab.ui.swing.CredentialRequestDialog;
import org.owasp.webscarab.ui.swing.ProxyConfig;
import org.owasp.webscarab.ui.swing.ScriptManagerFrame;
import org.owasp.webscarab.ui.swing.SummaryPanel;
import org.owasp.webscarab.ui.swing.SwingPluginUI;
import org.owasp.webscarab.ui.swing.TagConversationAction;
import org.owasp.webscarab.ui.swing.TranscoderFrame;
import org.owasp.webscarab.util.TempDir;
import org.owasp.webscarab.util.TextFormatter;
import org.owasp.webscarab.util.swing.DocumentHandler;
import org.owasp.webscarab.util.swing.HeapMonitor;
import org.owasp.webscarab.util.swing.SwingWorker;

public class UIFramework
extends JFrame {
    private static final long serialVersionUID = 1703415432525545808L;
    private Framework _framework;
    private FrameworkModel _model;
    private CookieJarViewer _cookieJarViewer;
    private CertificateManager _certificateManager;
    private SummaryPanel _summaryPanel;
    private TranscoderFrame _transcoder = null;
    private ScriptManagerFrame _scriptManagerFrame = null;
    private CredentialManagerFrame _credentialManagerFrame = null;
    private CredentialRequestDialog _credentialRequestDialog = null;
    private Logger _logger = Logger.getLogger("org.owasp.webscarab");
    private DocumentHandler _dh;
    private Object _exit = new Object();
    private File _tempDir = null;
    private JMenuItem aboutMenuItem;
    private JButton cancelButton;
    private JMenuItem certsMenuItem;
    private JMenuItem contentsMenuItem;
    private JMenuItem cookieJarMenuItem;
    private JMenuItem credentialsMenuItem;
    private JDialog dropPatternDialog;
    private JTextField dropPatternTextField;
    private JMenu editorMenu;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JRadioButtonMenuItem fineLogRadioButtonMenuItem;
    private JRadioButtonMenuItem finerLogRadioButtonMenuItem;
    private JRadioButtonMenuItem finestLogRadioButtonMenuItem;
    private JMenu helpMenu;
    private JRadioButtonMenuItem infoLogRadioButtonMenuItem;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JCheckBoxMenuItem liteMenuItem;
    private ButtonGroup logLevelButtonGroup;
    private JMenu logMenu;
    private JTextArea logTextArea;
    private JMenuBar mainMenuBar;
    private JMenuItem newMenuItem;
    private JButton okButton;
    private JMenuItem openMenuItem;
    private JMenuItem proxyMenuItem;
    private JMenuItem restartMenuItem;
    private JMenuItem saveMenuItem;
    private JMenuItem scriptMenuItem;
    private JRadioButtonMenuItem severeLogRadioButtonMenuItem;
    private JMenuItem showDropPatternDialogMenuItem;
    private JTabbedPane tabbedPane;
    private JMenu toolsMenu;
    private JMenuItem transcoderMenuItem;
    private JMenu viewMenu;
    private JCheckBoxMenuItem wrapTextCheckBoxMenuItem;

    public UIFramework(Framework framework) {
        this._framework = framework;
        this._model = framework.getModel();
        this.initComponents();
        this.getContentPane().add((Component)new HeapMonitor(), "South");
        this.setPreferredSize();
        this._summaryPanel = new SummaryPanel(this._model);
        this._summaryPanel.addConversationActions(new Action[]{new TagConversationAction(this, this._model)});
        this.tabbedPane.addTab("Summary", this._summaryPanel);
        this.tabbedPane.addTab("Messages", new JScrollPane(this.logTextArea));
        this._cookieJarViewer = new CookieJarViewer(this._model);
        this._certificateManager = new CertificateManager();
        CredentialManager cm = this._framework.getCredentialManager();
        this._credentialManagerFrame = new CredentialManagerFrame(cm);
        this._credentialRequestDialog = new CredentialRequestDialog((Frame)this, true, cm);
        cm.setUI(this._credentialRequestDialog);
        this.initLogging();
        this.initEditorViews();
        this.initHelp();
    }

    private void initHelp() {
        try {
            URL url = this.getClass().getResource("/help/jhelpset.hs");
            if (url == null) {
                throw new NullPointerException("The help set could not be found");
            }
            HelpSet helpSet = new HelpSet(null, url);
            HelpBroker helpBroker = helpSet.createHelpBroker();
            this.contentsMenuItem.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(helpBroker));
            helpBroker.enableHelpKey((Component)this.getRootPane(), "about", helpSet);
        }
        catch (Throwable e) {
            final String[] message = e instanceof NullPointerException ? new String[]{"Help set not found"} : (e instanceof NoClassDefFoundError ? new String[]{"The JavaHelp libraries could not be found", "Please add jhall.jar to the extension directory of your Java Runtime environment"} : new String[]{"Unknown error: ", e.getClass().getName(), e.getMessage()});
            for (int i = 0; i < message.length; ++i) {
                System.err.println(message[i]);
            }
            this.contentsMenuItem.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = -7470145620330176298L;

                public void actionPerformed(ActionEvent evt) {
                    JOptionPane.showMessageDialog(UIFramework.this, message, "Help is not available", 0);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.createTemporarySession();
        Object object = this._exit;
        synchronized (object) {
            try {
                this._exit.wait();
            }
            catch (InterruptedException ie) {
                this._logger.info("Interrupted waiting for exit: " + ie);
            }
        }
    }

    public void initEditorViews() {
        String wrap = Preferences.getPreference("TextPanel.wrap", "false");
        if (wrap != null && wrap.equals("true")) {
            this.wrapTextCheckBoxMenuItem.setSelected(true);
        }
    }

    private void initLogging() {
        this._dh = new DocumentHandler(20480);
        this._dh.setFormatter(new TextFormatter());
        this._logger.addHandler(this._dh);
        Document doc = this._dh.getDocument();
        this.logTextArea.setDocument(doc);
        doc.addDocumentListener(new TextScroller(this.logTextArea));
        String level = Preferences.getPreference("UI.logLevel", "INFO");
        if (level.equals("SEVERE")) {
            this.severeLogRadioButtonMenuItem.setSelected(true);
        } else if (level.equals("INFO")) {
            this.infoLogRadioButtonMenuItem.setSelected(true);
        } else if (level.equals("FINE")) {
            this.fineLogRadioButtonMenuItem.setSelected(true);
        } else if (level.equals("FINER")) {
            this.finerLogRadioButtonMenuItem.setSelected(true);
        } else if (level.equals("FINEST")) {
            this.finestLogRadioButtonMenuItem.setSelected(true);
        }
    }

    private void setPreferredSize() {
        try {
            int xpos = Integer.parseInt(Preferences.getPreference("WebScarab.position.x").trim());
            int ypos = Integer.parseInt(Preferences.getPreference("WebScarab.position.y").trim());
            int width = Integer.parseInt(Preferences.getPreference("WebScarab.size.x").trim());
            int height = Integer.parseInt(Preferences.getPreference("WebScarab.size.y").trim());
            this.setBounds(xpos, ypos, width, height);
        }
        catch (NumberFormatException nfe) {
            this.setSize(800, 600);
            this.setExtendedState(6);
        }
        catch (NullPointerException npe) {
            this.setSize(800, 600);
            this.setExtendedState(6);
        }
    }

    public void addPlugin(final SwingPluginUI plugin) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JPanel panel = plugin.getPanel();
                if (panel != null) {
                    UIFramework.this.tabbedPane.addTab(plugin.getPluginName(), panel);
                }
                UIFramework.this._summaryPanel.addUrlActions(plugin.getUrlActions());
                UIFramework.this._summaryPanel.addUrlColumns(plugin.getUrlColumns());
                UIFramework.this._summaryPanel.addConversationActions(plugin.getConversationActions());
                UIFramework.this._summaryPanel.addConversationColumns(plugin.getConversationColumns());
            }
        });
    }

    private void initComponents() {
        this.logLevelButtonGroup = new ButtonGroup();
        this.logTextArea = new JTextArea();
        this.dropPatternDialog = new JDialog();
        this.jLabel1 = new JLabel();
        this.dropPatternTextField = new JTextField();
        this.jPanel1 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.tabbedPane = new JTabbedPane();
        this.mainMenuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.newMenuItem = new JMenuItem();
        this.openMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.viewMenu = new JMenu();
        this.editorMenu = new JMenu();
        this.wrapTextCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.toolsMenu = new JMenu();
        this.proxyMenuItem = new JMenuItem();
        this.credentialsMenuItem = new JMenuItem();
        this.certsMenuItem = new JMenuItem();
        this.cookieJarMenuItem = new JMenuItem();
        this.transcoderMenuItem = new JMenuItem();
        this.scriptMenuItem = new JMenuItem();
        this.restartMenuItem = new JMenuItem();
        this.showDropPatternDialogMenuItem = new JMenuItem();
        this.liteMenuItem = new JCheckBoxMenuItem();
        this.helpMenu = new JMenu();
        this.contentsMenuItem = new JMenuItem();
        this.logMenu = new JMenu();
        this.severeLogRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.infoLogRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.fineLogRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.finerLogRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.finestLogRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.aboutMenuItem = new JMenuItem();
        this.logTextArea.setBackground(new Color(204, 204, 204));
        this.logTextArea.setEditable(false);
        this.logTextArea.setToolTipText("");
        this.dropPatternDialog.setTitle("Discard conversations");
        this.dropPatternDialog.setModal(true);
        this.dropPatternDialog.setResizable(false);
        this.jLabel1.setFont(new Font("Tahoma", 1, 13));
        this.jLabel1.setText("Discard conversations matching (URL):");
        this.dropPatternDialog.getContentPane().add((Component)this.jLabel1, "North");
        this.dropPatternTextField.setPreferredSize(new Dimension(200, 22));
        this.dropPatternDialog.getContentPane().add((Component)this.dropPatternTextField, "Center");
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UIFramework.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UIFramework.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelButton);
        this.dropPatternDialog.getContentPane().add((Component)this.jPanel1, "South");
        this.setDefaultCloseOperation(0);
        this.setTitle("WebScarab");
        this.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent evt) {
                UIFramework.this.formComponentMoved(evt);
            }

            public void componentResized(ComponentEvent evt) {
                UIFramework.this.formComponentResized(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                UIFramework.this.windowClosing(evt);
            }
        });
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.fileMenu.setMnemonic('F');
        this.fileMenu.setText("File");
        this.newMenuItem.setMnemonic('N');
        this.newMenuItem.setText("New");
        this.newMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UIFramework.this.newMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.newMenuItem);
        this.openMenuItem.setMnemonic('O');
        this.openMenuItem.setText("Open");
        this.openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UIFramework.this.openMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.saveMenuItem.setMnemonic('S');
        this.saveMenuItem.setText("Save");
        this.saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UIFramework.this.saveMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveMenuItem);
        this.exitMenuItem.setMnemonic('X');
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UIFramework.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.mainMenuBar.add(this.fileMenu);
        this.viewMenu.setMnemonic('V');
        this.viewMenu.setText("View");
        this.editorMenu.setMnemonic('E');
        this.editorMenu.setText("Content Editors");
        this.wrapTextCheckBoxMenuItem.setMnemonic('W');
        this.wrapTextCheckBoxMenuItem.setText("Wrap Text");
        this.wrapTextCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UIFramework.this.wrapTextCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.editorMenu.add(this.wrapTextCheckBoxMenuItem);
        this.viewMenu.add(this.editorMenu);
        this.mainMenuBar.add(this.viewMenu);
        this.toolsMenu.setMnemonic('T');
        this.toolsMenu.setText("Tools");
        this.proxyMenuItem.setMnemonic('P');
        this.proxyMenuItem.setText("Proxies");
        this.proxyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UIFramework.this.proxyMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.proxyMenuItem);
        this.credentialsMenuItem.setText("Credentials");
        this.credentialsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UIFramework.this.credentialsMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.credentialsMenuItem);
        this.certsMenuItem.setMnemonic('C');
        this.certsMenuItem.setText("Certificates");
        this.certsMenuItem.setToolTipText("Allows configuration of client certificates");
        this.certsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UIFramework.this.certsMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.certsMenuItem);
        this.cookieJarMenuItem.setMnemonic('S');
        this.cookieJarMenuItem.setText("Shared Cookies");
        this.cookieJarMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UIFramework.this.cookieJarMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.cookieJarMenuItem);
        this.transcoderMenuItem.setMnemonic('T');
        this.transcoderMenuItem.setText("Transcoder");
        this.transcoderMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UIFramework.this.transcoderMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.transcoderMenuItem);
        this.scriptMenuItem.setText("Script Manager");
        this.scriptMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UIFramework.this.scriptMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.scriptMenuItem);
        this.restartMenuItem.setText("Restart Plugins");
        this.restartMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UIFramework.this.restartMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.restartMenuItem);
        this.showDropPatternDialogMenuItem.setText("Discard conversations");
        this.showDropPatternDialogMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UIFramework.this.showDropPatternDialogMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.showDropPatternDialogMenuItem);
        this.liteMenuItem.setText("Use Lite interface");
        this.liteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UIFramework.this.liteMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.liteMenuItem);
        this.mainMenuBar.add(this.toolsMenu);
        this.helpMenu.setMnemonic('H');
        this.helpMenu.setText("Help");
        this.contentsMenuItem.setText("Contents");
        this.helpMenu.add(this.contentsMenuItem);
        this.logMenu.setMnemonic('L');
        this.logMenu.setText("Log level");
        this.logMenu.setToolTipText("Configures the level of logging output displayed");
        this.logLevelButtonGroup.add(this.severeLogRadioButtonMenuItem);
        this.severeLogRadioButtonMenuItem.setText("SEVERE");
        this.severeLogRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UIFramework.this.logLevelActionPerformed(evt);
            }
        });
        this.logMenu.add(this.severeLogRadioButtonMenuItem);
        this.logLevelButtonGroup.add(this.infoLogRadioButtonMenuItem);
        this.infoLogRadioButtonMenuItem.setText("INFO");
        this.infoLogRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UIFramework.this.logLevelActionPerformed(evt);
            }
        });
        this.logMenu.add(this.infoLogRadioButtonMenuItem);
        this.logLevelButtonGroup.add(this.fineLogRadioButtonMenuItem);
        this.fineLogRadioButtonMenuItem.setText("FINE");
        this.fineLogRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UIFramework.this.logLevelActionPerformed(evt);
            }
        });
        this.logMenu.add(this.fineLogRadioButtonMenuItem);
        this.logLevelButtonGroup.add(this.finerLogRadioButtonMenuItem);
        this.finerLogRadioButtonMenuItem.setText("FINER");
        this.finerLogRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UIFramework.this.logLevelActionPerformed(evt);
            }
        });
        this.logMenu.add(this.finerLogRadioButtonMenuItem);
        this.logLevelButtonGroup.add(this.finestLogRadioButtonMenuItem);
        this.finestLogRadioButtonMenuItem.setText("FINEST");
        this.finestLogRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UIFramework.this.logLevelActionPerformed(evt);
            }
        });
        this.logMenu.add(this.finestLogRadioButtonMenuItem);
        this.helpMenu.add(this.logMenu);
        this.aboutMenuItem.setMnemonic('A');
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UIFramework.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.mainMenuBar.add(this.helpMenu);
        this.setJMenuBar(this.mainMenuBar);
    }

    private void showDropPatternDialogMenuItemActionPerformed(ActionEvent evt) {
        String pattern = this._framework.getDropPattern();
        this.dropPatternTextField.setText(pattern);
        this.dropPatternDialog.pack();
        this.dropPatternDialog.setLocationRelativeTo(this);
        this.dropPatternDialog.setVisible(true);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        try {
            this._framework.setDropPattern(this.dropPatternTextField.getText());
            this.dropPatternDialog.setVisible(false);
        }
        catch (PatternSyntaxException pse) {
            JOptionPane.showMessageDialog(this.dropPatternDialog, new String[]{"Invalid pattern", pse.getMessage()}, "Error", 0);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dropPatternDialog.setVisible(false);
    }

    private void liteMenuItemActionPerformed(ActionEvent evt) {
        Preferences.setPreference("WebScarab.lite", Boolean.toString(this.liteMenuItem.isSelected()));
        if (this.liteMenuItem.isSelected()) {
            JOptionPane.showMessageDialog(this, "Restart WebScarab in order to switch interfaces", "Restart required", 1);
        }
    }

    private void credentialsMenuItemActionPerformed(ActionEvent evt) {
        this._credentialManagerFrame.setVisible(true);
    }

    private void restartMenuItemActionPerformed(ActionEvent evt) {
        if (!this._framework.isRunning()) {
            return;
        }
        if (!this._framework.stopPlugins()) {
            String[] status = this._framework.getStatus();
            JOptionPane.showMessageDialog(this, status, "Error - Plugins are busy", 0);
        }
        this._framework.startPlugins();
    }

    private void saveMenuItemActionPerformed(ActionEvent evt) {
        if (this._tempDir != null) {
            JFileChooser jfc = new JFileChooser(Preferences.getPreference("WebScarab.DefaultDirectory"));
            jfc.setFileSelectionMode(1);
            jfc.setDialogTitle("Select a directory to write the session into");
            int returnVal = jfc.showSaveDialog(this);
            if (returnVal == 0) {
                final File dir = jfc.getSelectedFile();
                if (FileSystemStore.isExistingSession(dir)) {
                    JOptionPane.showMessageDialog(null, new String[]{dir + " already contains a session "}, "Error", 0);
                    return;
                }
                new SwingWorker(){

                    public Object construct() {
                        try {
                            UIFramework.this.closeSession();
                            TempDir.recursiveCopy(UIFramework.this._tempDir, dir);
                            TempDir.recursiveDelete(UIFramework.this._tempDir);
                            UIFramework.this._tempDir = null;
                            UIFramework.this._framework.setSession("FileSystem", dir, "");
                            UIFramework.this._framework.startPlugins();
                            return null;
                        }
                        catch (StoreException se) {
                            return se;
                        }
                        catch (IOException ioe) {
                            return ioe;
                        }
                    }

                    public void finished() {
                        Object result = this.getValue();
                        if (result == null) {
                            return;
                        }
                        if (result instanceof Exception) {
                            Exception e = (Exception)result;
                            JOptionPane.showMessageDialog(null, new String[]{"Error saving Session : ", e.toString()}, "Error", 0);
                        }
                    }
                }.start();
                Preferences.setPreference("WebScarab.DefaultDirectory", jfc.getCurrentDirectory().getAbsolutePath());
            }
        } else {
            try {
                if (this._framework.isModified()) {
                    boolean running = this._framework.isRunning();
                    if (running) {
                        this._framework.stopPlugins();
                    }
                    this._framework.saveSessionData();
                    if (running) {
                        this._framework.startPlugins();
                    }
                }
            }
            catch (StoreException se) {
                JOptionPane.showMessageDialog(null, new String[]{"Error saving Session : ", se.toString()}, "Error", 0);
            }
        }
    }

    private void scriptMenuItemActionPerformed(ActionEvent evt) {
        if (this._scriptManagerFrame == null) {
            this._scriptManagerFrame = new ScriptManagerFrame(this._framework.getScriptManager());
        }
        this._scriptManagerFrame.setVisible(true);
    }

    private void wrapTextCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        Preferences.setPreference("TextPanel.wrap", Boolean.toString(this.wrapTextCheckBoxMenuItem.isSelected()));
    }

    private void loadSession(final File sessionDir) {
        new SwingWorker(){

            public Object construct() {
                try {
                    UIFramework.this.closeSession();
                    UIFramework.this._framework.setSession("FileSystem", sessionDir, "");
                    UIFramework.this._framework.startPlugins();
                    return null;
                }
                catch (StoreException se) {
                    return se;
                }
            }

            public void finished() {
                Object result = this.getValue();
                if (result == null) {
                    return;
                }
                if (result instanceof StoreException) {
                    StoreException se = (StoreException)result;
                    JOptionPane.showMessageDialog(null, new String[]{"Error loading Session : ", se.toString()}, "Error", 0);
                }
            }
        }.start();
    }

    private void createTemporarySession() {
        this._tempDir = TempDir.createTempDir("webscarab", ".tmp", null);
        if (this._tempDir != null) {
            this.loadSession(this._tempDir);
        }
    }

    private void openExistingSession() {
        JFileChooser jfc = new JFileChooser(Preferences.getPreference("WebScarab.DefaultDirectory"));
        jfc.setFileSelectionMode(1);
        jfc.setDialogTitle("Choose a directory that contains a previous session");
        int returnVal = jfc.showOpenDialog(this);
        if (returnVal == 0) {
            File dir = jfc.getSelectedFile();
            if (!FileSystemStore.isExistingSession(dir)) {
                JOptionPane.showMessageDialog(null, new String[]{dir + " does not contain a session "}, "Error", 0);
            } else {
                this.loadSession(dir);
            }
            Preferences.setPreference("WebScarab.DefaultDirectory", jfc.getCurrentDirectory().getAbsolutePath());
        }
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        this.openExistingSession();
    }

    private void closeSession() throws StoreException {
        if (this._framework.isRunning()) {
            this._framework.stopPlugins();
        }
        if (this._framework.isModified()) {
            this._framework.saveSessionData();
        }
    }

    private void createNewSession() {
        JFileChooser jfc = new JFileChooser(Preferences.getPreference("WebScarab.DefaultDirectory"));
        jfc.setFileSelectionMode(1);
        jfc.setDialogTitle("Select a directory to write the session into");
        int returnVal = jfc.showOpenDialog(this);
        if (returnVal == 0) {
            File dir = jfc.getSelectedFile();
            if (FileSystemStore.isExistingSession(dir)) {
                JOptionPane.showMessageDialog(null, new String[]{dir + " already contains a session "}, "Error", 0);
            } else {
                this.loadSession(dir);
            }
            Preferences.setPreference("WebScarab.DefaultDirectory", jfc.getCurrentDirectory().getAbsolutePath());
        }
    }

    private void newMenuItemActionPerformed(ActionEvent evt) {
        this.createNewSession();
    }

    private void formComponentResized(ComponentEvent evt) {
        if (!this.isShowing()) {
            return;
        }
        Preferences.getPreferences().setProperty("WebScarab.size.x", Integer.toString(this.getWidth()));
        Preferences.getPreferences().setProperty("WebScarab.size.y", Integer.toString(this.getHeight()));
    }

    private void formComponentMoved(ComponentEvent evt) {
        if (!this.isShowing()) {
            return;
        }
        Preferences.getPreferences().setProperty("WebScarab.position.x", Integer.toString(this.getX()));
        Preferences.getPreferences().setProperty("WebScarab.position.y", Integer.toString(this.getY()));
    }

    private void logLevelActionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand().toUpperCase();
        if (cmd.equals("SEVERE")) {
            this._dh.setLevel(Level.SEVERE);
        } else if (cmd.equals("INFO")) {
            this._dh.setLevel(Level.INFO);
        } else if (cmd.equals("FINE")) {
            this._dh.setLevel(Level.FINE);
        } else if (cmd.equals("FINER")) {
            this._dh.setLevel(Level.FINER);
        } else if (cmd.equals("FINEST")) {
            this._dh.setLevel(Level.FINEST);
        } else {
            System.err.println("Unknown log level: '" + cmd + "'");
            return;
        }
        Preferences.setPreference("UI.logLevel", cmd);
    }

    private void certsMenuItemActionPerformed(ActionEvent evt) {
        this._certificateManager.setVisible(true);
    }

    private void transcoderMenuItemActionPerformed(ActionEvent evt) {
        if (this._transcoder == null) {
            this._transcoder = new TranscoderFrame();
        }
        this._transcoder.setVisible(true);
    }

    private void cookieJarMenuItemActionPerformed(ActionEvent evt) {
        this._cookieJarViewer.setVisible(true);
        this._cookieJarViewer.toFront();
        this._cookieJarViewer.requestFocus();
    }

    private void proxyMenuItemActionPerformed(ActionEvent evt) {
        new ProxyConfig((Frame)this, this._framework).setVisible(true);
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        this.exit();
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        String[] message = new String[]{"OWASP WebScarab - version " + this._framework.getVersion(), " - part of the Open Web Application Security Project", "See http://www.owasp.org/software/webscarab.html", "", "Primary Developer : ", "         Rogan Dawes (rogan at dawes.za.net)"};
        JOptionPane.showMessageDialog(this, message, "About WebScarab", 1);
    }

    private void windowClosing(WindowEvent evt) {
        this.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exit() {
        block8: {
            if (this._framework.isRunning() && !this._framework.stopPlugins() && this._framework.isModified()) {
                String[] status = this._framework.getStatus();
                int count = status.length;
                String[] message = new String[count + 2];
                System.arraycopy(status, 0, message, 0, count);
                message[count] = "";
                message[count + 1] = "Force data save anyway?";
                int choice = JOptionPane.showOptionDialog(this, message, "Error - Plugins are busy", 0, 0, null, null, null);
                if (choice != 0) {
                    return;
                }
            }
            if (this._framework.isModified()) {
                try {
                    this._framework.saveSessionData();
                }
                catch (Exception e) {
                    int choice = JOptionPane.showOptionDialog(this, new String[]{"Error saving session!", e.toString(), "Quit anyway?"}, "Error!", 0, 0, null, null, null);
                    if (choice == 0) break block8;
                    return;
                }
            }
        }
        Object object = this._exit;
        synchronized (object) {
            this._exit.notify();
        }
    }

    private class TextScroller
    implements DocumentListener {
        private JTextComponent _component;
        private TextUI _mapper;

        public TextScroller(JTextComponent component) {
            this._component = component;
            this._mapper = this._component.getUI();
        }

        public void removeUpdate(DocumentEvent e) {
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void insertUpdate(DocumentEvent e) {
            if (this._mapper != null) {
                try {
                    Rectangle newLoc = this._mapper.modelToView(this._component, e.getOffset(), Position.Bias.Forward);
                    this.adjustVisibility(newLoc);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        private void adjustVisibility(final Rectangle location) {
            if (location != null) {
                if (SwingUtilities.isEventDispatchThread()) {
                    this._component.scrollRectToVisible(location);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            TextScroller.this._component.scrollRectToVisible(location);
                        }
                    });
                }
            }
        }
    }
}

