/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing;

import java.util.ArrayList;
import java.util.List;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.UrlModel;
import org.owasp.webscarab.ui.swing.UrlTreeModelAdapter;
import org.owasp.webscarab.util.swing.ColumnDataEvent;
import org.owasp.webscarab.util.swing.ColumnDataListener;
import org.owasp.webscarab.util.swing.ColumnDataModel;
import org.owasp.webscarab.util.swing.treetable.TreeTableModel;

public class UrlTreeTableModelAdapter
extends UrlTreeModelAdapter
implements TreeTableModel {
    private List _columns = new ArrayList();
    private ColumnDataListener _columnListener;

    public UrlTreeTableModelAdapter(UrlModel model) {
        super(model);
        this.createListener();
    }

    private void createListener() {
        this._columnListener = new ColumnDataListener(){

            public void dataChanged(ColumnDataEvent cde) {
                Object column = cde.getSource();
                int col = UrlTreeTableModelAdapter.this._columns.indexOf(column);
                if (col < 0) {
                    return;
                }
                Object key = cde.getKey();
                if (key == null) {
                    UrlTreeTableModelAdapter.this.fireStructureChanged();
                } else {
                    HttpUrl url = (HttpUrl)key;
                    UrlTreeTableModelAdapter.this.firePathChanged(UrlTreeTableModelAdapter.this.urlTreePath(url));
                }
            }
        };
    }

    public void addColumn(ColumnDataModel column) {
        this._columns.add(column);
        column.addColumnDataListener(this._columnListener);
        this.fireStructureChanged();
    }

    public void removeColumn(ColumnDataModel column) {
        int index = this._columns.indexOf(column);
        if (index < 0) {
            return;
        }
        column.removeColumnDataListener(this._columnListener);
        this._columns.remove(index);
        this.fireStructureChanged();
    }

    public int getColumnCount() {
        return this._columns.size() + 1;
    }

    public String getColumnName(int column) {
        if (column == 0) {
            return "Url";
        }
        return ((ColumnDataModel)this._columns.get(column - 1)).getColumnName();
    }

    public Class getColumnClass(int column) {
        if (column == 0) {
            return TreeTableModel.class;
        }
        return ((ColumnDataModel)this._columns.get(column - 1)).getColumnClass();
    }

    public Object getValueAt(Object node, int column) {
        if (!(node instanceof HttpUrl)) {
            return null;
        }
        HttpUrl url = (HttpUrl)node;
        if (column == 0) {
            return url;
        }
        return ((ColumnDataModel)this._columns.get(column - 1)).getValue(url);
    }

    public boolean isCellEditable(Object node, int column) {
        return this.getColumnClass(column) == TreeTableModel.class;
    }

    public void setValueAt(Object aValue, Object node, int column) {
    }
}

