/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.Random;
import sun.security.action.GetPropertyAction;

public class TempDir {
    private static final Object tmpFileLock = new Object();
    private static int counter = -1;
    private static String tmpdir;

    private TempDir() {
    }

    private static File generateFile(String prefix, String suffix, File dir) {
        if (counter == -1) {
            counter = new Random().nextInt() & 0xFFFF;
        }
        return new File(dir, prefix + Integer.toString(++counter) + suffix);
    }

    private static String getTempDir() {
        if (tmpdir == null) {
            GetPropertyAction a = new GetPropertyAction("java.io.tmpdir");
            tmpdir = AccessController.doPrivileged(a);
        }
        return tmpdir;
    }

    private static boolean checkAndCreate(File file, SecurityManager sm) {
        if (sm != null) {
            try {
                sm.checkWrite(file.getPath());
            }
            catch (AccessControlException x) {
                throw new SecurityException("Unable to create temporary file");
            }
        }
        if (file.exists()) {
            return false;
        }
        return file.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createTempDir(String prefix, String suffix, File directory) {
        if (prefix == null) {
            throw new NullPointerException();
        }
        if (prefix.length() < 3) {
            throw new IllegalArgumentException("Prefix string too short");
        }
        String s = suffix == null ? ".tmp" : suffix;
        Object object = tmpFileLock;
        synchronized (object) {
            File f;
            if (directory == null) {
                directory = new File(TempDir.getTempDir());
            }
            SecurityManager sm = System.getSecurityManager();
            while (!TempDir.checkAndCreate(f = TempDir.generateFile(prefix, s, directory), sm)) {
            }
            return f;
        }
    }

    public static boolean recursiveDelete(File dir) {
        String[] ls = dir.list();
        for (int i = 0; i < ls.length; ++i) {
            File file = new File(dir, ls[i]);
            if (!(file.isDirectory() ? !TempDir.recursiveDelete(file) : !file.delete())) continue;
            return false;
        }
        return dir.delete();
    }

    public static void recursiveCopy(File source, File dest) throws IOException {
        if (dest.exists()) {
            throw new IOException("Copy to existing directory " + dest);
        }
        if (!source.isDirectory()) {
            throw new IOException("Source is not a directory " + source);
        }
        if (!dest.mkdirs()) {
            throw new IOException("Could not create destination directory " + dest);
        }
        File[] ls = source.listFiles();
        for (int i = 0; i < ls.length; ++i) {
            int got;
            if (ls[i].isDirectory()) {
                TempDir.recursiveCopy(ls[i], new File(dest, ls[i].getName()));
                continue;
            }
            File newDest = new File(dest, ls[i].getName());
            FileInputStream fis = new FileInputStream(ls[i]);
            FileOutputStream fos = new FileOutputStream(newDest);
            byte[] buff = new byte[1024];
            while ((got = fis.read(buff)) > 0) {
                fos.write(buff, 0, got);
            }
            fis.close();
            fos.close();
        }
    }
}

