/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.util.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.tree.TreeCellRenderer;

public class MultiLineTreeCellRenderer
extends JPanel
implements TreeCellRenderer {
    private static final long serialVersionUID = -6667215953379805686L;
    protected JLabel _icon;
    protected TreeTextArea _text;

    public MultiLineTreeCellRenderer() {
        this.setLayout(new BoxLayout(this, 0));
        this._icon = new JLabel(){
            private static final long serialVersionUID = 1750349321755256468L;

            public void setBackground(Color color) {
                if (color instanceof ColorUIResource) {
                    color = null;
                }
                super.setBackground(color);
            }
        };
        this.add(this._icon);
        this.add(Box.createHorizontalStrut(4));
        this._text = new TreeTextArea();
        this.add(this._text);
        this._text.setFont(new Font("Monospaced", 0, 12));
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String stringValue = tree.convertValueToText(value, isSelected, expanded, leaf, row, hasFocus);
        this.setEnabled(tree.isEnabled());
        this._text.setText(stringValue);
        this._text.setSelect(isSelected);
        this._text.setFocus(hasFocus);
        if (leaf) {
            this._icon.setIcon(UIManager.getIcon("Tree.leafIcon"));
        } else if (expanded) {
            this._icon.setIcon(UIManager.getIcon("Tree.openIcon"));
        } else {
            this._icon.setIcon(UIManager.getIcon("Tree.closedIcon"));
        }
        return this;
    }

    public Dimension getPreferredSize() {
        Dimension iconD = this._icon.getPreferredSize();
        Dimension textD = this._text.getPreferredSize();
        int height = iconD.height < textD.height ? textD.height : iconD.height;
        return new Dimension(iconD.width + textD.width, height);
    }

    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    class TreeTextArea
    extends JTextArea {
        private static final long serialVersionUID = 46035115936579701L;
        Dimension preferredSize;

        TreeTextArea() {
            this.setLineWrap(false);
            this.setWrapStyleWord(false);
            this.setOpaque(true);
        }

        public void setBackground(Color color) {
            if (color instanceof ColorUIResource) {
                color = null;
            }
            super.setBackground(color);
        }

        public void setText(String str) {
            BufferedImage bufferedImage = new BufferedImage(2, 2, 7);
            Graphics2D g2d = bufferedImage.createGraphics();
            FontRenderContext frc = g2d.getFontRenderContext();
            Font font = this.getFont();
            BufferedReader br = new BufferedReader(new StringReader(str));
            double maxWidth = 0.0;
            double maxHeight = 0.0;
            int lines = 0;
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    if (!line.equals("")) {
                        TextLayout tl = new TextLayout(line, font, frc);
                        maxWidth = Math.max(maxWidth, tl.getBounds().getWidth());
                        maxHeight = Math.max(maxHeight, tl.getBounds().getHeight());
                    }
                    ++lines;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            lines = lines < 1 ? 1 : lines;
            int height = (int)(maxHeight * (double)lines * 1.35);
            int width = (int)(maxWidth + 200.0);
            this.setPreferredSize(new Dimension(width, height));
            super.setText(str);
        }

        void setSelect(boolean isSelected) {
            Color bColor = isSelected ? UIManager.getColor("Tree.selectionBackground") : UIManager.getColor("Tree.textBackground");
            super.setBackground(bColor);
        }

        void setFocus(boolean hasFocus) {
            if (hasFocus) {
                Color lineColor = UIManager.getColor("Tree.selectionBorderColor");
                this.setBorder(BorderFactory.createLineBorder(lineColor));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            }
        }
    }
}

