/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.CrosshairInfo;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.Marker;
import org.jfree.chart.Spacer;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.Tick;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotNotCompatibleException;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.chart.renderer.RangeType;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.data.DatasetChangeEvent;
import org.jfree.data.DatasetUtilities;
import org.jfree.data.Range;
import org.jfree.data.TableXYDataset;
import org.jfree.data.XYDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.ObjectList;
import org.jfree.util.ObjectUtils;

public class XYPlot
extends Plot
implements ValueAxisPlot,
PropertyChangeListener,
Cloneable,
Serializable {
    public static final Stroke DEFAULT_GRIDLINE_STROKE = new BasicStroke(0.5f, 0, 2, 0.0f, new float[]{2.0f, 2.0f}, 0.0f);
    public static final Paint DEFAULT_GRIDLINE_PAINT = Color.lightGray;
    public static final boolean DEFAULT_CROSSHAIR_VISIBLE = false;
    public static final Stroke DEFAULT_CROSSHAIR_STROKE = DEFAULT_GRIDLINE_STROKE;
    public static final Paint DEFAULT_CROSSHAIR_PAINT = Color.blue;
    private PlotOrientation orientation = PlotOrientation.VERTICAL;
    private Spacer axisOffset = new Spacer(1, 0.0, 0.0, 0.0, 0.0);
    private ValueAxis domainAxis;
    private AxisLocation domainAxisLocation;
    private ObjectList secondaryDomainAxes = new ObjectList();
    private ObjectList secondaryDomainAxisLocations = new ObjectList();
    private ValueAxis rangeAxis;
    private AxisLocation rangeAxisLocation;
    private ObjectList secondaryRangeAxes = new ObjectList();
    private ObjectList secondaryRangeAxisLocations = new ObjectList();
    private XYDataset dataset;
    private ObjectList secondaryDatasets = new ObjectList();
    private ObjectList secondaryDatasetDomainAxisMap = new ObjectList();
    private ObjectList secondaryDatasetRangeAxisMap = new ObjectList();
    private XYItemRenderer renderer;
    private ObjectList secondaryRenderers = new ObjectList();
    private boolean domainGridlinesVisible;
    private transient Stroke domainGridlineStroke;
    private transient Paint domainGridlinePaint;
    private boolean rangeGridlinesVisible;
    private transient Stroke rangeGridlineStroke;
    private transient Paint rangeGridlinePaint;
    private boolean domainCrosshairVisible;
    private double domainCrosshairValue;
    private transient Stroke domainCrosshairStroke;
    private transient Paint domainCrosshairPaint;
    private boolean domainCrosshairLockedOnData = true;
    private boolean rangeCrosshairVisible;
    private double rangeCrosshairValue;
    private transient Stroke rangeCrosshairStroke;
    private transient Paint rangeCrosshairPaint;
    private boolean rangeCrosshairLockedOnData = true;
    private List domainMarkers;
    private List secondaryDomainMarkers;
    private List rangeMarkers;
    private List secondaryRangeMarkers;
    private List annotations;
    private transient Paint domainTickBandPaint;
    private transient Paint rangeTickBandPaint;
    private AxisSpace fixedDomainAxisSpace;
    private AxisSpace fixedRangeAxisSpace;
    private int weight = 1;
    private double anchorX;
    private double anchorY;
    private transient List axesAtTop;
    private transient List axesAtBottom;
    private transient List axesAtLeft;
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.plot.LocalizationBundle");
    private transient List axesAtRight;

    public XYPlot() {
        this(null, null, null, null);
    }

    public XYPlot(XYDataset xYDataset, ValueAxis valueAxis, ValueAxis valueAxis2, XYItemRenderer xYItemRenderer) {
        this.dataset = xYDataset;
        if (xYDataset != null) {
            xYDataset.addChangeListener(this);
        }
        this.anchorX = 0.0;
        this.anchorY = 0.0;
        this.domainAxis = valueAxis;
        if (valueAxis != null) {
            valueAxis.setPlot(this);
            valueAxis.addChangeListener(this);
            this.anchorX = valueAxis.getRange().getCentralValue();
        }
        this.domainAxisLocation = AxisLocation.BOTTOM_OR_LEFT;
        this.rangeAxis = valueAxis2;
        if (valueAxis2 != null) {
            valueAxis2.setPlot(this);
            valueAxis2.addChangeListener(this);
        }
        this.rangeAxisLocation = AxisLocation.TOP_OR_LEFT;
        this.renderer = xYItemRenderer;
        if (xYItemRenderer != null) {
            xYItemRenderer.setPlot(this);
            xYItemRenderer.addPropertyChangeListener(this);
        }
        this.domainGridlinesVisible = true;
        this.domainGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.domainGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.rangeGridlinesVisible = true;
        this.rangeGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.rangeGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.domainCrosshairVisible = false;
        this.domainCrosshairValue = 0.0;
        this.domainCrosshairStroke = DEFAULT_CROSSHAIR_STROKE;
        this.domainCrosshairPaint = DEFAULT_CROSSHAIR_PAINT;
        this.rangeCrosshairVisible = false;
        this.rangeCrosshairValue = 0.0;
        this.rangeCrosshairStroke = DEFAULT_CROSSHAIR_STROKE;
        this.rangeCrosshairPaint = DEFAULT_CROSSHAIR_PAINT;
        this.axesAtTop = new ArrayList();
        this.axesAtBottom = new ArrayList();
        this.axesAtLeft = new ArrayList();
        this.axesAtRight = new ArrayList();
    }

    public String getPlotType() {
        return localizationResources.getString("XY_Plot");
    }

    public PlotOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(PlotOrientation plotOrientation) {
        if (plotOrientation == null) {
            throw new IllegalArgumentException("XYPlot.setOrientation(...): null not allowed.");
        }
        if (plotOrientation != this.orientation) {
            this.orientation = plotOrientation;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Spacer getAxisOffset() {
        return this.axisOffset;
    }

    public void setAxisOffset(Spacer spacer) {
        this.axisOffset = spacer;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public ValueAxis getDomainAxis() {
        Plot plot;
        ValueAxis valueAxis = this.domainAxis;
        if (valueAxis == null && (plot = this.getParent()) instanceof XYPlot) {
            XYPlot xYPlot = (XYPlot)plot;
            valueAxis = xYPlot.getDomainAxis();
        }
        return valueAxis;
    }

    public void setDomainAxis(ValueAxis valueAxis) {
        if (valueAxis != null) {
            try {
                valueAxis.setPlot(this);
            }
            catch (PlotNotCompatibleException plotNotCompatibleException) {
                // empty catch block
            }
            valueAxis.addChangeListener(this);
        }
        if (this.domainAxis != null) {
            this.domainAxis.removeChangeListener(this);
        }
        this.domainAxis = valueAxis;
        if (valueAxis != null) {
            valueAxis.configure();
            valueAxis.addChangeListener(this);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public AxisLocation getDomainAxisLocation() {
        return this.domainAxisLocation;
    }

    public void setDomainAxisLocation(AxisLocation axisLocation) {
        this.setDomainAxisLocation(axisLocation, true);
    }

    public void setDomainAxisLocation(AxisLocation axisLocation, boolean bl) {
        if (axisLocation != this.domainAxisLocation) {
            this.domainAxisLocation = axisLocation;
            if (bl) {
                this.notifyListeners(new PlotChangeEvent(this));
            }
        }
    }

    public RectangleEdge getDomainAxisEdge() {
        return Plot.resolveDomainAxisLocation(this.domainAxisLocation, this.orientation);
    }

    public ValueAxis getSecondaryDomainAxis(int n) {
        Plot plot;
        ValueAxis valueAxis = null;
        if (n < this.secondaryDomainAxes.size()) {
            valueAxis = (ValueAxis)this.secondaryDomainAxes.get(n);
        }
        if (valueAxis == null && (plot = this.getParent()) instanceof XYPlot) {
            XYPlot xYPlot = (XYPlot)plot;
            valueAxis = xYPlot.getSecondaryDomainAxis(n);
        }
        return valueAxis;
    }

    public void setSecondaryDomainAxis(int n, ValueAxis valueAxis) {
        ValueAxis valueAxis2 = this.getSecondaryDomainAxis(n);
        if (valueAxis2 != null) {
            valueAxis2.removeChangeListener(this);
        }
        if (valueAxis != null) {
            try {
                valueAxis.setPlot(this);
            }
            catch (PlotNotCompatibleException plotNotCompatibleException) {
                // empty catch block
            }
        }
        this.secondaryDomainAxes.set(n, (Object)valueAxis);
        if (valueAxis != null) {
            valueAxis.configure();
            valueAxis.addChangeListener(this);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearSecondaryDomainAxes() {
        int n = 0;
        while (n < this.secondaryDomainAxes.size()) {
            ValueAxis valueAxis = (ValueAxis)this.secondaryDomainAxes.get(n);
            if (valueAxis != null) {
                valueAxis.removeChangeListener(this);
            }
            ++n;
        }
        this.secondaryDomainAxes.clear();
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void configureSecondaryDomainAxes() {
        int n = 0;
        while (n < this.secondaryDomainAxes.size()) {
            ValueAxis valueAxis = (ValueAxis)this.secondaryDomainAxes.get(n);
            if (valueAxis != null) {
                valueAxis.configure();
            }
            ++n;
        }
    }

    public AxisLocation getSecondaryDomainAxisLocation(int n) {
        Plot plot;
        AxisLocation axisLocation = null;
        if (n < this.secondaryDomainAxisLocations.size()) {
            axisLocation = (AxisLocation)this.secondaryDomainAxisLocations.get(n);
        }
        if (axisLocation == null && (plot = this.getParent()) instanceof XYPlot) {
            XYPlot xYPlot = (XYPlot)plot;
            axisLocation = xYPlot.getSecondaryDomainAxisLocation(n);
        }
        return axisLocation;
    }

    public void setSecondaryDomainAxisLocation(int n, AxisLocation axisLocation) {
        this.secondaryDomainAxisLocations.set(n, (Object)axisLocation);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public RectangleEdge getSecondaryDomainAxisEdge(int n) {
        AxisLocation axisLocation = this.getSecondaryDomainAxisLocation(n);
        RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(axisLocation, this.orientation);
        if (rectangleEdge == null) {
            rectangleEdge = RectangleEdge.opposite((RectangleEdge)this.getDomainAxisEdge());
        }
        return rectangleEdge;
    }

    public ValueAxis getRangeAxis() {
        Plot plot;
        ValueAxis valueAxis = this.rangeAxis;
        if (valueAxis == null && (plot = this.getParent()) instanceof XYPlot) {
            XYPlot xYPlot = (XYPlot)plot;
            valueAxis = xYPlot.getRangeAxis();
        }
        return valueAxis;
    }

    public void setRangeAxis(ValueAxis valueAxis) {
        if (valueAxis != null) {
            try {
                valueAxis.setPlot(this);
            }
            catch (PlotNotCompatibleException plotNotCompatibleException) {
                // empty catch block
            }
        }
        if (this.rangeAxis != null) {
            this.rangeAxis.removeChangeListener(this);
        }
        this.rangeAxis = valueAxis;
        if (valueAxis != null) {
            valueAxis.configure();
            valueAxis.addChangeListener(this);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public AxisLocation getRangeAxisLocation() {
        return this.rangeAxisLocation;
    }

    public void setRangeAxisLocation(AxisLocation axisLocation) {
        this.setRangeAxisLocation(axisLocation, true);
    }

    public void setRangeAxisLocation(AxisLocation axisLocation, boolean bl) {
        if (axisLocation != this.rangeAxisLocation) {
            this.rangeAxisLocation = axisLocation;
            if (bl) {
                this.notifyListeners(new PlotChangeEvent(this));
            }
        }
    }

    public RectangleEdge getRangeAxisEdge() {
        return Plot.resolveRangeAxisLocation(this.rangeAxisLocation, this.orientation);
    }

    public ValueAxis getSecondaryRangeAxis(int n) {
        Plot plot;
        ValueAxis valueAxis = null;
        if (n < this.secondaryRangeAxes.size()) {
            valueAxis = (ValueAxis)this.secondaryRangeAxes.get(n);
        }
        if (valueAxis == null && (plot = this.getParent()) instanceof XYPlot) {
            XYPlot xYPlot = (XYPlot)plot;
            valueAxis = xYPlot.getSecondaryRangeAxis(n);
        }
        return valueAxis;
    }

    public void setSecondaryRangeAxis(int n, ValueAxis valueAxis) {
        ValueAxis valueAxis2 = this.getSecondaryRangeAxis(n);
        if (valueAxis2 != null) {
            valueAxis2.removeChangeListener(this);
        }
        if (valueAxis != null) {
            try {
                valueAxis.setPlot(this);
            }
            catch (PlotNotCompatibleException plotNotCompatibleException) {
                // empty catch block
            }
        }
        this.secondaryRangeAxes.set(n, (Object)valueAxis);
        if (valueAxis != null) {
            valueAxis.configure();
            valueAxis.addChangeListener(this);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearSecondaryRangeAxes() {
        int n = 0;
        while (n < this.secondaryRangeAxes.size()) {
            ValueAxis valueAxis = (ValueAxis)this.secondaryRangeAxes.get(n);
            if (valueAxis != null) {
                valueAxis.removeChangeListener(this);
            }
            ++n;
        }
        this.secondaryRangeAxes.clear();
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void configureSecondaryRangeAxes() {
        int n = 0;
        while (n < this.secondaryRangeAxes.size()) {
            ValueAxis valueAxis = (ValueAxis)this.secondaryRangeAxes.get(n);
            if (valueAxis != null) {
                valueAxis.configure();
            }
            ++n;
        }
    }

    public AxisLocation getSecondaryRangeAxisLocation(int n) {
        Plot plot;
        AxisLocation axisLocation = null;
        if (n < this.secondaryRangeAxisLocations.size()) {
            axisLocation = (AxisLocation)this.secondaryRangeAxisLocations.get(n);
        }
        if (axisLocation == null && (plot = this.getParent()) instanceof XYPlot) {
            XYPlot xYPlot = (XYPlot)plot;
            axisLocation = xYPlot.getSecondaryRangeAxisLocation(n);
        }
        return axisLocation;
    }

    public void setSecondaryRangeAxisLocation(int n, AxisLocation axisLocation) {
        this.secondaryRangeAxisLocations.set(n, (Object)axisLocation);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public RectangleEdge getSecondaryRangeAxisEdge(int n) {
        AxisLocation axisLocation = this.getSecondaryRangeAxisLocation(n);
        RectangleEdge rectangleEdge = Plot.resolveRangeAxisLocation(axisLocation, this.orientation);
        if (rectangleEdge == null) {
            rectangleEdge = RectangleEdge.opposite((RectangleEdge)this.getRangeAxisEdge());
        }
        return rectangleEdge;
    }

    public XYDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(XYDataset xYDataset) {
        XYDataset xYDataset2 = this.dataset;
        if (xYDataset2 != null) {
            xYDataset2.removeChangeListener(this);
        }
        this.dataset = xYDataset;
        if (xYDataset != null) {
            this.setDatasetGroup(xYDataset.getGroup());
            xYDataset.addChangeListener(this);
        }
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent(this, xYDataset);
        this.datasetChanged(datasetChangeEvent);
    }

    public XYDataset getSecondaryDataset(int n) {
        XYDataset xYDataset = null;
        if (this.secondaryDatasets.size() > n) {
            xYDataset = (XYDataset)this.secondaryDatasets.get(n);
        }
        return xYDataset;
    }

    public int getSecondaryDatasetCount() {
        return this.secondaryDatasets.size();
    }

    public void setSecondaryDataset(int n, XYDataset xYDataset) {
        XYDataset xYDataset2 = (XYDataset)this.secondaryDatasets.get(n);
        if (xYDataset2 != null) {
            xYDataset2.removeChangeListener(this);
        }
        this.secondaryDatasets.set(n, (Object)xYDataset);
        xYDataset.addChangeListener(this);
        if (n >= this.secondaryDatasetRangeAxisMap.size()) {
            this.secondaryDatasetRangeAxisMap.set(n, null);
        }
        if (n >= this.secondaryDatasetDomainAxisMap.size()) {
            this.secondaryDatasetDomainAxisMap.set(n, null);
        }
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent(this, xYDataset);
        this.datasetChanged(datasetChangeEvent);
    }

    public void mapSecondaryDatasetToDomainAxis(int n, Integer n2) {
        this.secondaryDatasetDomainAxisMap.set(n, (Object)n2);
        this.datasetChanged(new DatasetChangeEvent(this, this.dataset));
    }

    public void mapSecondaryDatasetToRangeAxis(int n, Integer n2) {
        this.secondaryDatasetRangeAxisMap.set(n, (Object)n2);
        this.datasetChanged(new DatasetChangeEvent(this, this.dataset));
    }

    public XYItemRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(XYItemRenderer xYItemRenderer) {
        if (this.renderer != null) {
            this.renderer.removePropertyChangeListener(this);
        }
        this.renderer = xYItemRenderer;
        if (xYItemRenderer != null) {
            xYItemRenderer.setPlot(this);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public XYItemRenderer getSecondaryRenderer(int n) {
        XYItemRenderer xYItemRenderer = null;
        if (this.secondaryRenderers.size() > n) {
            xYItemRenderer = (XYItemRenderer)this.secondaryRenderers.get(n);
        }
        return xYItemRenderer;
    }

    public void setSecondaryRenderer(int n, XYItemRenderer xYItemRenderer) {
        XYItemRenderer xYItemRenderer2 = this.getSecondaryRenderer(n);
        if (xYItemRenderer2 != null) {
            xYItemRenderer2.removePropertyChangeListener(this);
        }
        this.secondaryRenderers.set(n, (Object)xYItemRenderer);
        if (xYItemRenderer != null) {
            xYItemRenderer.setPlot(this);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int n) {
        this.weight = n;
    }

    public boolean isDomainGridlinesVisible() {
        return this.domainGridlinesVisible;
    }

    public void setDomainGridlinesVisible(boolean bl) {
        if (this.domainGridlinesVisible != bl) {
            this.domainGridlinesVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getDomainGridlineStroke() {
        return this.domainGridlineStroke;
    }

    public void setDomainGridlineStroke(Stroke stroke) {
        this.domainGridlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getDomainGridlinePaint() {
        return this.domainGridlinePaint;
    }

    public void setDomainGridlinePaint(Paint paint) {
        this.domainGridlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isRangeGridlinesVisible() {
        return this.rangeGridlinesVisible;
    }

    public void setRangeGridlinesVisible(boolean bl) {
        if (this.rangeGridlinesVisible != bl) {
            this.rangeGridlinesVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getRangeGridlineStroke() {
        return this.rangeGridlineStroke;
    }

    public void setRangeGridlineStroke(Stroke stroke) {
        this.rangeGridlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getRangeGridlinePaint() {
        return this.rangeGridlinePaint;
    }

    public void setRangeGridlinePaint(Paint paint) {
        this.rangeGridlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getDomainTickBandPaint() {
        return this.domainTickBandPaint;
    }

    public void setDomainTickBandPaint(Paint paint) {
        this.domainTickBandPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getRangeTickBandPaint() {
        return this.rangeTickBandPaint;
    }

    public void setRangeTickBandPaint(Paint paint) {
        this.rangeTickBandPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void addDomainMarker(Marker marker) {
        if (this.domainMarkers == null) {
            this.domainMarkers = new ArrayList();
        }
        this.domainMarkers.add(marker);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearDomainMarkers() {
        if (this.domainMarkers != null) {
            this.domainMarkers.clear();
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public void addRangeMarker(Marker marker) {
        if (this.rangeMarkers == null) {
            this.rangeMarkers = new ArrayList();
        }
        this.rangeMarkers.add(marker);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearRangeMarkers() {
        if (this.rangeMarkers != null) {
            this.rangeMarkers.clear();
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public void addSecondaryRangeMarker(Marker marker) {
        if (this.secondaryRangeMarkers == null) {
            this.secondaryRangeMarkers = new ArrayList();
        }
        this.secondaryRangeMarkers.add(marker);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearSecondaryRangeMarkers() {
        if (this.secondaryRangeMarkers != null) {
            this.secondaryRangeMarkers.clear();
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public void addAnnotation(XYAnnotation xYAnnotation) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        this.annotations.add(xYAnnotation);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearAnnotations() {
        if (this.annotations != null) {
            this.annotations.clear();
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    protected AxisSpace calculateDomainAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D, AxisSpace axisSpace) {
        block6: {
            block4: {
                block5: {
                    if (axisSpace == null) {
                        axisSpace = new AxisSpace();
                    }
                    if (this.fixedDomainAxisSpace == null) break block4;
                    if (this.orientation != PlotOrientation.HORIZONTAL) break block5;
                    axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getLeft(), RectangleEdge.LEFT);
                    axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getRight(), RectangleEdge.RIGHT);
                    break block6;
                }
                if (this.orientation != PlotOrientation.VERTICAL) break block6;
                axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getTop(), RectangleEdge.TOP);
                axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getBottom(), RectangleEdge.BOTTOM);
                break block6;
            }
            if (this.domainAxis != null) {
                axisSpace = this.domainAxis.reserveSpace(graphics2D, this, rectangle2D, this.getDomainAxisEdge(), axisSpace);
            }
            int n = 0;
            while (n < this.secondaryDomainAxes.size()) {
                ValueAxis valueAxis = this.getSecondaryDomainAxis(n);
                if (valueAxis != null) {
                    RectangleEdge rectangleEdge = this.getSecondaryDomainAxisEdge(n);
                    axisSpace = valueAxis.reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
                }
                ++n;
            }
        }
        return axisSpace;
    }

    protected AxisSpace calculateRangeAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D, AxisSpace axisSpace) {
        block6: {
            block4: {
                block5: {
                    if (axisSpace == null) {
                        axisSpace = new AxisSpace();
                    }
                    if (this.fixedRangeAxisSpace == null) break block4;
                    if (this.orientation != PlotOrientation.HORIZONTAL) break block5;
                    axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getTop(), RectangleEdge.TOP);
                    axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getBottom(), RectangleEdge.BOTTOM);
                    break block6;
                }
                if (this.orientation != PlotOrientation.VERTICAL) break block6;
                axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getLeft(), RectangleEdge.LEFT);
                axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getRight(), RectangleEdge.RIGHT);
                break block6;
            }
            ValueAxis valueAxis = this.rangeAxis;
            if (valueAxis != null) {
                axisSpace = valueAxis.reserveSpace(graphics2D, this, rectangle2D, this.getRangeAxisEdge(), axisSpace);
            }
            int n = 0;
            while (n < this.secondaryRangeAxes.size()) {
                ValueAxis valueAxis2 = this.getSecondaryRangeAxis(n);
                if (valueAxis2 != null) {
                    RectangleEdge rectangleEdge = this.getSecondaryRangeAxisEdge(n);
                    axisSpace = valueAxis2.reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
                }
                ++n;
            }
        }
        return axisSpace;
    }

    protected AxisSpace calculateAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        AxisSpace axisSpace = new AxisSpace();
        axisSpace = this.calculateDomainAxisSpace(graphics2D, rectangle2D, axisSpace);
        axisSpace = this.calculateRangeAxisSpace(graphics2D, rectangle2D, axisSpace);
        return axisSpace;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo) {
        Insets insets;
        boolean bl;
        boolean bl2 = rectangle2D.getWidth() <= 10.0;
        boolean bl3 = bl = rectangle2D.getHeight() <= 10.0;
        if (bl2 || bl) {
            return;
        }
        if (chartRenderingInfo != null) {
            chartRenderingInfo.setPlotArea(rectangle2D);
        }
        if ((insets = this.getInsets()) != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)insets.left, rectangle2D.getY() + (double)insets.top, rectangle2D.getWidth() - (double)insets.left - (double)insets.right, rectangle2D.getHeight() - (double)insets.top - (double)insets.bottom);
        }
        AxisSpace axisSpace = this.calculateAxisSpace(graphics2D, rectangle2D);
        Rectangle2D rectangle2D2 = axisSpace.shrink(rectangle2D, null);
        this.axisOffset.trim(rectangle2D2);
        if (chartRenderingInfo != null) {
            chartRenderingInfo.setDataArea(rectangle2D2);
        }
        CrosshairInfo crosshairInfo = new CrosshairInfo();
        crosshairInfo.setCrosshairDistance(Double.POSITIVE_INFINITY);
        crosshairInfo.setAnchorX(this.getAnchorX());
        crosshairInfo.setAnchorY(this.getAnchorY());
        this.drawBackground(graphics2D, rectangle2D2);
        this.drawAxes(graphics2D, rectangle2D, rectangle2D2);
        if (this.renderer != null) {
            Marker marker;
            Iterator iterator;
            Shape shape = graphics2D.getClip();
            Composite composite = graphics2D.getComposite();
            graphics2D.clip(rectangle2D2);
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
            this.drawDomainTickBands(graphics2D, rectangle2D2);
            this.drawRangeTickBands(graphics2D, rectangle2D2);
            this.drawGridlines(graphics2D, rectangle2D2);
            if (this.domainMarkers != null) {
                iterator = this.domainMarkers.iterator();
                while (iterator.hasNext()) {
                    marker = (Marker)iterator.next();
                    this.renderer.drawDomainMarker(graphics2D, this, this.getDomainAxis(), marker, rectangle2D2);
                }
            }
            if (this.rangeMarkers != null) {
                iterator = this.rangeMarkers.iterator();
                while (iterator.hasNext()) {
                    marker = (Marker)iterator.next();
                    this.renderer.drawRangeMarker(graphics2D, this, this.getRangeAxis(), marker, rectangle2D2);
                }
            }
            if (this.secondaryRangeMarkers != null) {
                iterator = this.secondaryRangeMarkers.iterator();
                while (iterator.hasNext()) {
                    marker = (Marker)iterator.next();
                    this.renderer.drawRangeMarker(graphics2D, this, this.getSecondaryRangeAxis(0), marker, rectangle2D2);
                }
            }
            this.render(graphics2D, rectangle2D2, chartRenderingInfo, crosshairInfo);
            this.render2(graphics2D, rectangle2D2, chartRenderingInfo, crosshairInfo);
            this.drawAnnotations(graphics2D, rectangle2D2, chartRenderingInfo);
            graphics2D.setClip(shape);
            graphics2D.setComposite(composite);
        }
        this.drawOutline(graphics2D, rectangle2D2);
    }

    public void drawDomainTickBands(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Paint paint = this.getDomainTickBandPaint();
        if (paint != null) {
            boolean bl = false;
            ValueAxis valueAxis = this.getDomainAxis();
            double d = valueAxis.getLowerBound();
            Iterator iterator = valueAxis.getTicks().iterator();
            while (iterator.hasNext()) {
                Tick tick = (Tick)iterator.next();
                double d2 = tick.getNumericalValue();
                if (bl) {
                    this.renderer.fillDomainGridBand(graphics2D, this, valueAxis, rectangle2D, d, d2);
                }
                d = d2;
                boolean bl2 = bl = !bl;
            }
            double d3 = valueAxis.getUpperBound();
            if (bl) {
                this.renderer.fillDomainGridBand(graphics2D, this, valueAxis, rectangle2D, d, d3);
            }
        }
    }

    public void drawRangeTickBands(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Paint paint = this.getRangeTickBandPaint();
        if (paint != null) {
            boolean bl = false;
            ValueAxis valueAxis = this.getRangeAxis();
            double d = valueAxis.getLowerBound();
            Iterator iterator = valueAxis.getTicks().iterator();
            while (iterator.hasNext()) {
                Tick tick = (Tick)iterator.next();
                double d2 = tick.getNumericalValue();
                if (bl) {
                    this.renderer.fillRangeGridBand(graphics2D, this, valueAxis, rectangle2D, d, d2);
                }
                d = d2;
                boolean bl2 = bl = !bl;
            }
            double d3 = valueAxis.getUpperBound();
            if (bl) {
                this.renderer.fillRangeGridBand(graphics2D, this, valueAxis, rectangle2D, d, d3);
            }
        }
    }

    protected void drawAxes(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        double d;
        ValueAxis valueAxis;
        this.axesAtTop.clear();
        this.axesAtBottom.clear();
        this.axesAtLeft.clear();
        this.axesAtRight.clear();
        if (this.domainAxis != null) {
            this.addAxisToList(this.domainAxis, this.getDomainAxisEdge());
        }
        if (this.rangeAxis != null) {
            this.addAxisToList(this.rangeAxis, this.getRangeAxisEdge());
        }
        int n = 0;
        while (n < this.secondaryDomainAxes.size()) {
            ValueAxis valueAxis2 = (ValueAxis)this.secondaryDomainAxes.get(n);
            if (valueAxis2 != null) {
                this.addAxisToList(valueAxis2, this.getSecondaryDomainAxisEdge(n));
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.secondaryRangeAxes.size()) {
            ValueAxis valueAxis3 = (ValueAxis)this.secondaryRangeAxes.get(n2);
            if (valueAxis3 != null) {
                this.addAxisToList(valueAxis3, this.getSecondaryRangeAxisEdge(n2));
            }
            ++n2;
        }
        double d2 = rectangle2D2.getMinY() - this.axisOffset.getTopSpace(rectangle2D2.getHeight());
        Iterator iterator = this.axesAtTop.iterator();
        while (iterator.hasNext()) {
            valueAxis = (ValueAxis)iterator.next();
            d = valueAxis.draw(graphics2D, d2, rectangle2D, rectangle2D2, RectangleEdge.TOP);
            d2 -= d;
        }
        d2 = rectangle2D2.getMaxY() + this.axisOffset.getBottomSpace(rectangle2D2.getHeight());
        iterator = this.axesAtBottom.iterator();
        while (iterator.hasNext()) {
            valueAxis = (ValueAxis)iterator.next();
            d = valueAxis.draw(graphics2D, d2, rectangle2D, rectangle2D2, RectangleEdge.BOTTOM);
            d2 += d;
        }
        d2 = rectangle2D2.getMinX() - this.axisOffset.getLeftSpace(rectangle2D2.getWidth());
        iterator = this.axesAtLeft.iterator();
        while (iterator.hasNext()) {
            valueAxis = (ValueAxis)iterator.next();
            d = valueAxis.draw(graphics2D, d2, rectangle2D, rectangle2D2, RectangleEdge.LEFT);
            d2 -= d;
        }
        d2 = rectangle2D2.getMaxX() + this.axisOffset.getRightSpace(rectangle2D2.getWidth());
        iterator = this.axesAtRight.iterator();
        while (iterator.hasNext()) {
            valueAxis = (ValueAxis)iterator.next();
            d = valueAxis.draw(graphics2D, d2, rectangle2D, rectangle2D2, RectangleEdge.RIGHT);
            d2 += d;
        }
    }

    public void render(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, CrosshairInfo crosshairInfo) {
        XYDataset xYDataset = this.getDataset();
        if (!DatasetUtilities.isEmptyOrNull(xYDataset)) {
            int n = this.renderer.initialise(graphics2D, rectangle2D, this, xYDataset, chartRenderingInfo);
            ValueAxis valueAxis = this.getDomainAxis();
            ValueAxis valueAxis2 = this.getRangeAxis();
            int n2 = 0;
            while (n2 < n) {
                int n3 = xYDataset.getSeriesCount();
                int n4 = 0;
                while (n4 < n3) {
                    int n5 = xYDataset.getItemCount(n4);
                    int n6 = 0;
                    while (n6 < n5) {
                        this.renderer.drawItem(graphics2D, rectangle2D, chartRenderingInfo, this, valueAxis, valueAxis2, xYDataset, n4, n6, crosshairInfo, n2);
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
            this.setDomainCrosshairValue(crosshairInfo.getCrosshairX(), false);
            if (this.isDomainCrosshairVisible()) {
                this.drawVerticalLine(graphics2D, rectangle2D, this.getDomainCrosshairValue(), this.getDomainCrosshairStroke(), this.getDomainCrosshairPaint());
            }
            this.setRangeCrosshairValue(crosshairInfo.getCrosshairY(), false);
            if (this.isRangeCrosshairVisible()) {
                this.drawHorizontalLine(graphics2D, rectangle2D, this.getRangeCrosshairValue(), this.getRangeCrosshairStroke(), this.getRangeCrosshairPaint());
            }
        } else {
            this.drawNoDataMessage(graphics2D, rectangle2D);
        }
    }

    public void render2(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, CrosshairInfo crosshairInfo) {
        int n = 0;
        while (n < this.getSecondaryDatasetCount()) {
            XYDataset xYDataset = this.getSecondaryDataset(n);
            if (!DatasetUtilities.isEmptyOrNull(xYDataset)) {
                Object object;
                Object object2;
                ValueAxis valueAxis = this.getDomainAxis();
                Integer n2 = (Integer)this.secondaryDatasetDomainAxisMap.get(n);
                if (n2 != null && (object2 = this.getSecondaryDomainAxis(n2)) != null) {
                    valueAxis = object2;
                }
                object2 = this.getRangeAxis();
                Integer n3 = (Integer)this.secondaryDatasetRangeAxisMap.get(n);
                if (n3 != null && (object = this.getSecondaryRangeAxis(n3)) != null) {
                    object2 = object;
                }
                if ((object = this.getSecondaryRenderer(n)) == null) {
                    object = this.getRenderer();
                }
                int n4 = object.initialise(graphics2D, rectangle2D, this, xYDataset, chartRenderingInfo);
                int n5 = 0;
                while (n5 < n4) {
                    int n6 = xYDataset.getSeriesCount();
                    int n7 = 0;
                    while (n7 < n6) {
                        int n8 = xYDataset.getItemCount(n7);
                        int n9 = 0;
                        while (n9 < n8) {
                            object.drawItem(graphics2D, rectangle2D, chartRenderingInfo, this, valueAxis, (ValueAxis)object2, xYDataset, n7, n9, crosshairInfo, n5);
                            ++n9;
                        }
                        ++n7;
                    }
                    ++n5;
                }
            }
            ++n;
        }
    }

    protected void drawGridlines(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Object object;
        Object object2;
        Paint paint;
        Stroke stroke;
        if (this.renderer == null) {
            return;
        }
        if (this.isDomainGridlinesVisible()) {
            stroke = this.getDomainGridlineStroke();
            paint = this.getDomainGridlinePaint();
            if (stroke != null && paint != null) {
                object2 = this.getDomainAxis().getTicks().iterator();
                while (object2.hasNext()) {
                    object = (Tick)object2.next();
                    this.renderer.drawDomainGridLine(graphics2D, this, this.getDomainAxis(), rectangle2D, ((Tick)object).getNumericalValue());
                }
            }
        }
        if (this.isRangeGridlinesVisible()) {
            stroke = this.getRangeGridlineStroke();
            paint = this.getRangeGridlinePaint();
            if (stroke != null && paint != null && (object2 = this.getRangeAxis()) != null) {
                object = this.getRangeAxis().getTicks().iterator();
                while (object.hasNext()) {
                    Tick tick = (Tick)object.next();
                    this.renderer.drawRangeGridLine(graphics2D, this, this.getRangeAxis(), rectangle2D, tick.getNumericalValue());
                }
            }
        }
    }

    public void drawAnnotations(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo) {
        if (this.annotations != null) {
            Iterator iterator = this.annotations.iterator();
            while (iterator.hasNext()) {
                XYAnnotation xYAnnotation = (XYAnnotation)iterator.next();
                xYAnnotation.draw(graphics2D, this, rectangle2D, this.getDomainAxis(), this.getRangeAxis());
            }
        }
    }

    protected void drawVerticalLine(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, Stroke stroke, Paint paint) {
        if (this.getDomainAxis().getRange().contains(d)) {
            double d2 = this.getDomainAxis().translateValueToJava2D(d, rectangle2D, this.getDomainAxisEdge());
            Line2D.Double double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint);
            graphics2D.draw(double_);
        }
    }

    protected void drawHorizontalLine(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, Stroke stroke, Paint paint) {
        double d2 = this.getRangeAxis().translateValueToJava2D(d, rectangle2D, this.getRangeAxisEdge());
        Line2D.Double double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.draw(double_);
    }

    public void handleClick(int n, int n2, ChartRenderingInfo chartRenderingInfo) {
        ValueAxis valueAxis;
        ValueAxis valueAxis2 = this.getDomainAxis();
        if (valueAxis2 != null) {
            double d = valueAxis2.translateJava2DtoValue(n, chartRenderingInfo.getDataArea(), this.getDomainAxisEdge());
            this.setAnchorX(d);
            this.setDomainCrosshairValue(d);
        }
        if ((valueAxis = this.getRangeAxis()) != null) {
            double d = valueAxis.translateJava2DtoValue(n2, chartRenderingInfo.getDataArea(), this.getRangeAxisEdge());
            this.setAnchorY(d);
            this.setRangeCrosshairValue(d);
        }
    }

    public void zoom(double d) {
        if (d > 0.0) {
            ValueAxis valueAxis = this.getDomainAxis();
            double d2 = valueAxis.getRange().getLength();
            double d3 = d2 * d;
            valueAxis.setRange(this.anchorX - d3 / 2.0, this.anchorX + d3 / 2.0);
            ValueAxis valueAxis2 = this.getRangeAxis();
            d2 = valueAxis2.getRange().getLength();
            d3 = d2 * d;
            valueAxis2.setRange(this.anchorY - d3 / 2.0, this.anchorY + d3 / 2.0);
        } else {
            this.getRangeAxis().setAutoRange(true);
            this.getDomainAxis().setAutoRange(true);
        }
    }

    private List getSecondaryDatasetsMappedToDomainAxis(Integer n) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n2 = 0;
        while (n2 < this.secondaryDatasetDomainAxisMap.size()) {
            Integer n3 = (Integer)this.secondaryDatasetDomainAxisMap.get(n2);
            if (n3 == null) {
                if (n == null) {
                    arrayList.add(this.secondaryDatasets.get(n2));
                }
            } else if (n3.equals(n)) {
                arrayList.add(this.secondaryDatasets.get(n2));
            }
            ++n2;
        }
        return arrayList;
    }

    private List getSecondaryDatasetsMappedToRangeAxis(Integer n) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n2 = 0;
        while (n2 < this.secondaryDatasetRangeAxisMap.size()) {
            Integer n3 = (Integer)this.secondaryDatasetRangeAxisMap.get(n2);
            if (n3 == null) {
                if (n == null) {
                    arrayList.add(this.secondaryDatasets.get(n2));
                }
            } else if (n3.equals(n)) {
                arrayList.add(this.secondaryDatasets.get(n2));
            }
            ++n2;
        }
        return arrayList;
    }

    public Range getDataRange(ValueAxis valueAxis) {
        Range range = null;
        ArrayList<XYDataset> arrayList = new ArrayList<XYDataset>();
        boolean bl = true;
        if (valueAxis == this.getDomainAxis()) {
            bl = true;
            arrayList.add(this.dataset);
            arrayList.addAll(this.getSecondaryDatasetsMappedToDomainAxis(null));
        } else if (valueAxis == this.getRangeAxis()) {
            bl = false;
            arrayList.add(this.dataset);
            arrayList.addAll(this.getSecondaryDatasetsMappedToRangeAxis(null));
        } else {
            int n;
            int n2 = this.secondaryDomainAxes.indexOf((Object)valueAxis);
            if (n2 >= 0) {
                bl = true;
                arrayList.addAll(this.getSecondaryDatasetsMappedToDomainAxis(new Integer(n2)));
            }
            if ((n = this.secondaryRangeAxes.indexOf((Object)valueAxis)) >= 0) {
                bl = false;
                arrayList.addAll(this.getSecondaryDatasetsMappedToRangeAxis(new Integer(n)));
            }
        }
        XYItemRenderer xYItemRenderer = this.getRenderer();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            XYDataset xYDataset = (XYDataset)iterator.next();
            range = bl ? Range.combine(range, DatasetUtilities.getDomainExtent(xYDataset)) : (xYItemRenderer != null && xYItemRenderer.getRangeType() == RangeType.STACKED ? Range.combine(range, DatasetUtilities.getStackedRangeExtent((TableXYDataset)xYDataset)) : Range.combine(range, DatasetUtilities.getRangeExtent(xYDataset)));
        }
        return range;
    }

    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        Serializable serializable;
        if (this.domainAxis != null) {
            this.domainAxis.configure();
        }
        if (this.rangeAxis != null) {
            this.rangeAxis.configure();
        }
        int n = 0;
        while (n < this.secondaryDomainAxes.size()) {
            ValueAxis valueAxis = this.getSecondaryDomainAxis(n);
            if (valueAxis != null) {
                valueAxis.configure();
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.secondaryRangeAxes.size()) {
            serializable = this.getSecondaryRangeAxis(n2);
            if (serializable != null) {
                serializable.configure();
            }
            ++n2;
        }
        if (this.getParent() != null) {
            this.getParent().datasetChanged(datasetChangeEvent);
        } else {
            serializable = new PlotChangeEvent(this);
            this.notifyListeners((PlotChangeEvent)serializable);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isDomainCrosshairVisible() {
        return this.domainCrosshairVisible;
    }

    public void setDomainCrosshairVisible(boolean bl) {
        if (this.domainCrosshairVisible != bl) {
            this.domainCrosshairVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean isDomainCrosshairLockedOnData() {
        return this.domainCrosshairLockedOnData;
    }

    public void setDomainCrosshairLockedOnData(boolean bl) {
        if (this.domainCrosshairLockedOnData != bl) {
            this.domainCrosshairLockedOnData = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public double getDomainCrosshairValue() {
        return this.domainCrosshairValue;
    }

    public void setDomainCrosshairValue(double d) {
        this.setDomainCrosshairValue(d, true);
    }

    public void setDomainCrosshairValue(double d, boolean bl) {
        this.domainCrosshairValue = d;
        if (this.isDomainCrosshairVisible() && bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getDomainCrosshairStroke() {
        return this.domainCrosshairStroke;
    }

    public void setDomainCrosshairStroke(Stroke stroke) {
        this.domainCrosshairStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getDomainCrosshairPaint() {
        return this.domainCrosshairPaint;
    }

    public void setDomainCrosshairPaint(Paint paint) {
        this.domainCrosshairPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isRangeCrosshairVisible() {
        return this.rangeCrosshairVisible;
    }

    public void setRangeCrosshairVisible(boolean bl) {
        if (this.rangeCrosshairVisible != bl) {
            this.rangeCrosshairVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean isRangeCrosshairLockedOnData() {
        return this.rangeCrosshairLockedOnData;
    }

    public void setRangeCrosshairLockedOnData(boolean bl) {
        if (this.rangeCrosshairLockedOnData != bl) {
            this.rangeCrosshairLockedOnData = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public double getRangeCrosshairValue() {
        return this.rangeCrosshairValue;
    }

    public void setRangeCrosshairValue(double d) {
        this.setRangeCrosshairValue(d, true);
    }

    public void setRangeCrosshairValue(double d, boolean bl) {
        this.rangeCrosshairValue = d;
        if (this.isRangeCrosshairVisible() && bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getRangeCrosshairStroke() {
        return this.rangeCrosshairStroke;
    }

    public void setRangeCrosshairStroke(Stroke stroke) {
        this.rangeCrosshairStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getRangeCrosshairPaint() {
        return this.rangeCrosshairPaint;
    }

    public void setRangeCrosshairPaint(Paint paint) {
        this.rangeCrosshairPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public AxisSpace getFixedDomainAxisSpace() {
        return this.fixedDomainAxisSpace;
    }

    public void setFixedDomainAxisSpace(AxisSpace axisSpace) {
        this.fixedDomainAxisSpace = axisSpace;
    }

    public AxisSpace getFixedRangeAxisSpace() {
        return this.fixedRangeAxisSpace;
    }

    public void setFixedRangeAxisSpace(AxisSpace axisSpace) {
        this.fixedRangeAxisSpace = axisSpace;
    }

    public void zoomHorizontalAxes(double d) {
        ValueAxis valueAxis;
        PlotOrientation plotOrientation = this.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            ValueAxis valueAxis2 = this.getRangeAxis();
            if (valueAxis2 != null) {
                valueAxis2.resizeRange(d);
            }
            int n = 0;
            while (n < this.secondaryRangeAxes.size()) {
                ValueAxis valueAxis3 = (ValueAxis)this.secondaryRangeAxes.get(n);
                if (valueAxis3 != null) {
                    valueAxis3.resizeRange(d);
                }
                ++n;
            }
        } else if (plotOrientation == PlotOrientation.VERTICAL && (valueAxis = this.getDomainAxis()) != null) {
            valueAxis.resizeRange(d);
        }
    }

    public void zoomHorizontalAxes(double d, double d2) {
        ValueAxis valueAxis;
        PlotOrientation plotOrientation = this.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            ValueAxis valueAxis2 = this.getRangeAxis();
            if (valueAxis2 != null) {
                valueAxis2.zoomRange(d, d2);
            }
            int n = 0;
            while (n < this.secondaryRangeAxes.size()) {
                ValueAxis valueAxis3 = (ValueAxis)this.secondaryRangeAxes.get(n);
                if (valueAxis3 != null) {
                    valueAxis3.zoomRange(d, d2);
                }
                ++n;
            }
        } else if (plotOrientation == PlotOrientation.VERTICAL && (valueAxis = this.getDomainAxis()) != null) {
            valueAxis.zoomRange(d, d2);
        }
    }

    public void zoomVerticalAxes(double d) {
        PlotOrientation plotOrientation = this.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            ValueAxis valueAxis = this.getDomainAxis();
            if (valueAxis != null) {
                valueAxis.resizeRange(d);
            }
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            ValueAxis valueAxis = this.getRangeAxis();
            if (valueAxis != null) {
                valueAxis.resizeRange(d);
            }
            int n = 0;
            while (n < this.secondaryRangeAxes.size()) {
                ValueAxis valueAxis2 = (ValueAxis)this.secondaryRangeAxes.get(n);
                if (valueAxis2 != null) {
                    valueAxis2.resizeRange(d);
                }
                ++n;
            }
        }
    }

    public void zoomVerticalAxes(double d, double d2) {
        ValueAxis valueAxis;
        PlotOrientation plotOrientation = this.getOrientation();
        if (plotOrientation == PlotOrientation.VERTICAL) {
            ValueAxis valueAxis2 = this.getRangeAxis();
            if (valueAxis2 != null) {
                valueAxis2.zoomRange(d, d2);
            }
            int n = 0;
            while (n < this.secondaryRangeAxes.size()) {
                ValueAxis valueAxis3 = (ValueAxis)this.secondaryRangeAxes.get(n);
                if (valueAxis3 != null) {
                    valueAxis3.zoomRange(d, d2);
                }
                ++n;
            }
        } else if (plotOrientation == PlotOrientation.HORIZONTAL && (valueAxis = this.getDomainAxis()) != null) {
            valueAxis.zoomRange(d, d2);
        }
    }

    public double getAnchorX() {
        return this.anchorX;
    }

    public void setAnchorX(double d, boolean bl) {
        this.anchorX = d;
        if (bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    protected void setAnchorX(double d) {
        this.setAnchorX(d, true);
    }

    public double getAnchorY() {
        return this.anchorY;
    }

    public void setAnchorY(double d, boolean bl) {
        this.anchorY = d;
        if (bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    protected void setAnchorY(double d) {
        this.setAnchorY(d, true);
    }

    public int getSeriesCount() {
        int n = 0;
        if (this.dataset != null) {
            n = this.dataset.getSeriesCount();
        }
        return n;
    }

    public LegendItemCollection getLegendItems() {
        Object object;
        int n;
        XYItemRenderer xYItemRenderer;
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        XYDataset xYDataset = this.getDataset();
        if (xYDataset != null && (xYItemRenderer = this.getRenderer()) != null) {
            n = xYDataset.getSeriesCount();
            int n2 = 0;
            while (n2 < n) {
                object = xYItemRenderer.getLegendItem(0, n2);
                legendItemCollection.add((LegendItem)object);
                ++n2;
            }
        }
        int n3 = this.secondaryDatasets.size();
        n = 0;
        while (n < n3) {
            XYDataset xYDataset2 = this.getSecondaryDataset(n);
            if (xYDataset2 != null && (object = this.getSecondaryRenderer(n)) != null) {
                int n4 = xYDataset2.getSeriesCount();
                int n5 = 0;
                while (n5 < n4) {
                    LegendItem legendItem = object.getLegendItem(n + 1, n5);
                    legendItemCollection.add(legendItem);
                    ++n5;
                }
            }
            ++n;
        }
        return legendItemCollection;
    }

    private void addAxisToList(ValueAxis valueAxis, RectangleEdge rectangleEdge) {
        if (rectangleEdge == RectangleEdge.TOP) {
            this.axesAtTop.add(valueAxis);
        } else if (rectangleEdge == RectangleEdge.BOTTOM) {
            this.axesAtBottom.add(valueAxis);
        } else if (rectangleEdge == RectangleEdge.LEFT) {
            this.axesAtLeft.add(valueAxis);
        } else if (rectangleEdge == RectangleEdge.RIGHT) {
            this.axesAtRight.add(valueAxis);
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (super.equals(object) && object instanceof XYPlot) {
            XYPlot xYPlot = (XYPlot)object;
            boolean bl = this.orientation == xYPlot.orientation;
            boolean bl2 = ObjectUtils.equal((Object)this.axisOffset, (Object)xYPlot.axisOffset);
            boolean bl3 = ObjectUtils.equal((Object)this.domainAxis, (Object)xYPlot.domainAxis);
            boolean bl4 = this.domainAxisLocation == xYPlot.domainAxisLocation;
            boolean bl5 = this.secondaryDomainAxes.equals((Object)xYPlot.secondaryDomainAxes);
            boolean bl6 = this.secondaryDomainAxisLocations.equals((Object)xYPlot.secondaryDomainAxisLocations);
            boolean bl7 = ObjectUtils.equal((Object)this.rangeAxis, (Object)xYPlot.rangeAxis);
            boolean bl8 = this.rangeAxisLocation == xYPlot.rangeAxisLocation;
            boolean bl9 = ObjectUtils.equal((Object)this.renderer, (Object)xYPlot.renderer);
            boolean bl10 = ObjectUtils.equal((Object)this.secondaryRangeAxes, (Object)xYPlot.secondaryRangeAxes);
            boolean bl11 = this.secondaryRangeAxisLocations.equals((Object)xYPlot.secondaryRangeAxisLocations);
            boolean bl12 = ObjectUtils.equal((Object)this.secondaryDatasetDomainAxisMap, (Object)xYPlot.secondaryDatasetDomainAxisMap);
            boolean bl13 = ObjectUtils.equal((Object)this.secondaryDatasetRangeAxisMap, (Object)xYPlot.secondaryDatasetRangeAxisMap);
            boolean bl14 = ObjectUtils.equal((Object)this.secondaryRenderers, (Object)xYPlot.secondaryRenderers);
            boolean bl15 = this.domainGridlinesVisible == xYPlot.domainGridlinesVisible;
            boolean bl16 = ObjectUtils.equal((Object)this.domainGridlineStroke, (Object)xYPlot.domainGridlineStroke);
            boolean bl17 = ObjectUtils.equal((Object)this.domainGridlinePaint, (Object)xYPlot.domainGridlinePaint);
            boolean bl18 = this.rangeGridlinesVisible == xYPlot.rangeGridlinesVisible;
            boolean bl19 = ObjectUtils.equal((Object)this.rangeGridlineStroke, (Object)xYPlot.rangeGridlineStroke);
            boolean bl20 = ObjectUtils.equal((Object)this.rangeGridlinePaint, (Object)xYPlot.rangeGridlinePaint);
            boolean bl21 = this.domainCrosshairVisible == xYPlot.domainCrosshairVisible;
            boolean bl22 = this.domainCrosshairValue == xYPlot.domainCrosshairValue;
            boolean bl23 = ObjectUtils.equal((Object)this.domainCrosshairStroke, (Object)xYPlot.domainCrosshairStroke);
            boolean bl24 = ObjectUtils.equal((Object)this.domainCrosshairPaint, (Object)xYPlot.domainCrosshairPaint);
            boolean bl25 = this.domainCrosshairLockedOnData == xYPlot.domainCrosshairLockedOnData;
            boolean bl26 = this.rangeCrosshairVisible == xYPlot.rangeCrosshairVisible;
            boolean bl27 = this.rangeCrosshairValue == xYPlot.rangeCrosshairValue;
            boolean bl28 = ObjectUtils.equal((Object)this.rangeCrosshairStroke, (Object)xYPlot.rangeCrosshairStroke);
            boolean bl29 = ObjectUtils.equal((Object)this.rangeCrosshairPaint, (Object)xYPlot.rangeCrosshairPaint);
            boolean bl30 = this.rangeCrosshairLockedOnData == xYPlot.rangeCrosshairLockedOnData;
            boolean bl31 = ObjectUtils.equal((Object)this.domainMarkers, (Object)xYPlot.domainMarkers);
            boolean bl32 = ObjectUtils.equal((Object)this.rangeMarkers, (Object)xYPlot.rangeMarkers);
            boolean bl33 = ObjectUtils.equal((Object)this.secondaryRangeMarkers, (Object)xYPlot.secondaryRangeMarkers);
            boolean bl34 = ObjectUtils.equal((Object)this.annotations, (Object)xYPlot.annotations);
            boolean bl35 = this.weight == xYPlot.weight;
            return bl && bl2 && bl3 && bl4 && bl5 && bl6 && bl7 && bl8 && bl9 && bl10 && bl11 && bl12 && bl13 && bl14 && bl15 && bl16 && bl17 && bl18 && bl19 && bl20 && bl21 && bl22 && bl23 && bl24 && bl25 && bl26 && bl27 && bl28 && bl29 && bl30 && bl31 && bl32 && bl33 && bl34 && bl35;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        XYPlot xYPlot = (XYPlot)super.clone();
        xYPlot.domainAxis = (ValueAxis)ObjectUtils.clone((Object)this.domainAxis);
        xYPlot.secondaryDomainAxes = (ObjectList)ObjectUtils.clone((Object)this.secondaryDomainAxes);
        xYPlot.secondaryDomainAxisLocations = (ObjectList)this.secondaryDomainAxisLocations.clone();
        xYPlot.rangeAxis = (ValueAxis)ObjectUtils.clone((Object)this.rangeAxis);
        xYPlot.secondaryRangeAxes = (ObjectList)ObjectUtils.clone((Object)this.secondaryRangeAxes);
        xYPlot.secondaryRangeAxisLocations = (ObjectList)ObjectUtils.clone((Object)this.secondaryRangeAxisLocations);
        xYPlot.secondaryDatasets = (ObjectList)ObjectUtils.clone((Object)this.secondaryDatasets);
        xYPlot.secondaryDatasetDomainAxisMap = (ObjectList)ObjectUtils.clone((Object)this.secondaryDatasetDomainAxisMap);
        xYPlot.secondaryDatasetRangeAxisMap = (ObjectList)ObjectUtils.clone((Object)this.secondaryDatasetRangeAxisMap);
        xYPlot.renderer = (XYItemRenderer)ObjectUtils.clone((Object)this.renderer);
        xYPlot.secondaryRenderers = (ObjectList)ObjectUtils.clone((Object)this.secondaryRenderers);
        xYPlot.domainMarkers = ObjectUtils.clone((List)this.domainMarkers);
        xYPlot.secondaryDomainMarkers = ObjectUtils.clone((List)this.secondaryDomainMarkers);
        xYPlot.rangeMarkers = ObjectUtils.clone((List)this.rangeMarkers);
        xYPlot.secondaryRangeMarkers = ObjectUtils.clone((List)this.secondaryRangeMarkers);
        xYPlot.annotations = ObjectUtils.clone((List)this.annotations);
        xYPlot.fixedDomainAxisSpace = (AxisSpace)ObjectUtils.clone((Object)this.fixedDomainAxisSpace);
        xYPlot.fixedRangeAxisSpace = (AxisSpace)ObjectUtils.clone((Object)this.fixedRangeAxisSpace);
        xYPlot.axesAtTop = new ArrayList();
        xYPlot.axesAtBottom = new ArrayList();
        xYPlot.axesAtLeft = new ArrayList();
        xYPlot.axesAtRight = new ArrayList();
        return xYPlot;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeStroke((Stroke)this.domainGridlineStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.domainGridlinePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.rangeGridlineStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.rangeGridlinePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.domainCrosshairStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.domainCrosshairPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.rangeCrosshairStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.rangeCrosshairPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.domainTickBandPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.rangeTickBandPaint, (ObjectOutputStream)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.domainGridlineStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.domainGridlinePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.rangeGridlineStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.rangeGridlinePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.domainCrosshairStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.domainCrosshairPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.rangeCrosshairStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.rangeCrosshairPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.domainTickBandPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.rangeTickBandPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        if (this.domainAxis != null) {
            this.domainAxis.setPlot(this);
            this.domainAxis.addChangeListener(this);
        }
        if (this.rangeAxis != null) {
            this.rangeAxis.setPlot(this);
            this.rangeAxis.addChangeListener(this);
        }
        if (this.dataset != null) {
            this.dataset.addChangeListener(this);
        }
    }
}

