/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.AbstractCategoryItemRenderer;
import org.jfree.chart.renderer.Outlier;
import org.jfree.chart.renderer.OutlierList;
import org.jfree.chart.renderer.OutlierListCollection;
import org.jfree.data.CategoryDataset;
import org.jfree.data.statistics.BoxAndWhiskerCategoryDataset;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;
import org.jfree.ui.RectangleEdge;

public class BoxAndWhiskerRenderer
extends AbstractCategoryItemRenderer {
    private Paint artifactPaint = Color.black;
    private double boxWidth = 0.0;
    private double itemMargin = 0.2;

    public Paint getArtifactPaint() {
        return this.artifactPaint;
    }

    public void setArtifactPaint(Paint paint) {
        this.artifactPaint = paint;
    }

    public double getBoxWidth() {
        return this.boxWidth;
    }

    public void setBoxWidth(double d) {
        this.boxWidth = d;
    }

    public double getItemMargin() {
        return this.itemMargin;
    }

    public void setItemMargin(double d) {
        this.itemMargin = d;
    }

    public void initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, Integer n, ChartRenderingInfo chartRenderingInfo) {
        super.initialise(graphics2D, rectangle2D, categoryPlot, n, chartRenderingInfo);
        ValueAxis valueAxis = this.getRangeAxis(categoryPlot, n);
        CategoryAxis categoryAxis = this.getDomainAxis(categoryPlot, n);
        CategoryDataset categoryDataset = this.getDataset(categoryPlot, n);
        if (categoryDataset != null) {
            int n2 = categoryDataset.getColumnCount();
            int n3 = categoryDataset.getRowCount();
            double d = 0.0;
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                d = rectangle2D.getHeight();
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                d = rectangle2D.getWidth();
            }
            double d2 = 0.0;
            double d3 = 0.0;
            if (n2 > 1) {
                d2 = categoryAxis.getCategoryMargin();
            }
            if (n3 > 1) {
                d3 = this.getItemMargin();
            }
            double d4 = d * (1.0 - categoryAxis.getLowerMargin() - categoryAxis.getUpperMargin() - d2 - d3);
            if (n3 * n2 > 0) {
                this.setBoxWidth(d4 / (double)(categoryDataset.getColumnCount() * categoryDataset.getRowCount()));
            } else {
                this.setBoxWidth(d4);
            }
        }
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        if (!(categoryDataset instanceof BoxAndWhiskerCategoryDataset)) {
            throw new IllegalArgumentException("BoxAndWhiskerRenderer.drawItem() : the data should be of type BoxAndWhiskerCategoryDataset only.");
        }
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        if (plotOrientation != PlotOrientation.HORIZONTAL && plotOrientation == PlotOrientation.VERTICAL) {
            this.drawVerticalItem(graphics2D, rectangle2D, categoryPlot, categoryAxis, valueAxis, categoryDataset, n, n2);
        }
    }

    public void drawVerticalItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        Object object;
        DefaultBoxAndWhiskerCategoryDataset defaultBoxAndWhiskerCategoryDataset = (DefaultBoxAndWhiskerCategoryDataset)categoryDataset;
        Number number = defaultBoxAndWhiskerCategoryDataset.getMeanValue(n, n2);
        Number number2 = defaultBoxAndWhiskerCategoryDataset.getMedianValue(n, n2);
        Number number3 = defaultBoxAndWhiskerCategoryDataset.getQ1Value(n, n2);
        Number number4 = defaultBoxAndWhiskerCategoryDataset.getQ3Value(n, n2);
        Number number5 = defaultBoxAndWhiskerCategoryDataset.getMaxRegularValue(n, n2);
        Number number6 = defaultBoxAndWhiskerCategoryDataset.getMinRegularValue(n, n2);
        List list = defaultBoxAndWhiskerCategoryDataset.getOutliers(n, n2);
        double d = categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        int n3 = this.getRowCount();
        int n4 = this.getColumnCount();
        if (n3 > 1) {
            double d2 = rectangle2D.getWidth() * this.getItemMargin() / (double)(n4 * (n3 - 1));
            d += (double)n * (this.getBoxWidth() + d2);
        } else {
            d += (double)n * this.getBoxWidth();
        }
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        double d3 = valueAxis.translateValueToJava2D(number5.doubleValue(), rectangle2D, rectangleEdge);
        double d4 = valueAxis.translateValueToJava2D(number6.doubleValue(), rectangle2D, rectangleEdge);
        double d5 = valueAxis.translateValueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge);
        double d6 = 0.0;
        if (number != null) {
            d6 = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D, rectangleEdge);
        }
        double d7 = valueAxis.translateValueToJava2D(number3.doubleValue(), rectangle2D, rectangleEdge);
        double d8 = valueAxis.translateValueToJava2D(number4.doubleValue(), rectangle2D, rectangleEdge);
        Paint paint = this.getItemPaint(n, n2);
        if (paint != null) {
            graphics2D.setPaint(paint);
        }
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setStroke(stroke);
        double d9 = 0.0;
        if (d3 < d7 && d3 < d8) {
            graphics2D.draw(new Line2D.Double(d + this.boxWidth / 2.0, d3, d + this.boxWidth / 2.0, Math.max(d7, d8)));
            graphics2D.draw(new Line2D.Double(d, d3, d + this.boxWidth, d3));
        }
        if (d4 > d7 && d4 > d8) {
            graphics2D.draw(new Line2D.Double(d + this.boxWidth / 2.0, d4, d + this.boxWidth / 2.0, Math.min(d7, d8)));
            graphics2D.draw(new Line2D.Double(d, d4, d + this.boxWidth, d4));
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, Math.min(d7, d8), this.boxWidth, Math.abs(d7 - d8));
        graphics2D.fill(double_);
        graphics2D.draw(double_);
        graphics2D.setPaint(this.artifactPaint);
        if (number != null) {
            d9 = this.boxWidth / 4.0;
            Ellipse2D.Double double_2 = new Ellipse2D.Double(d + d9, d6 - d9, d9 * 2.0, d9 * 2.0);
            graphics2D.fill(double_2);
            graphics2D.draw(double_2);
        }
        graphics2D.draw(new Line2D.Double(d, d5, d + this.boxWidth, d5));
        double d10 = valueAxis.translateValueToJava2D(valueAxis.getUpperBound(), rectangle2D, rectangleEdge) + d9;
        double d11 = valueAxis.translateValueToJava2D(valueAxis.getLowerBound(), rectangle2D, rectangleEdge) - d9;
        graphics2D.setPaint(paint);
        double d12 = this.boxWidth / 3.0;
        ArrayList<Outlier> arrayList = new ArrayList<Outlier>();
        OutlierListCollection outlierListCollection = new OutlierListCollection();
        int n5 = 0;
        while (n5 < list.size()) {
            double d13;
            double d14 = ((Number)list.get(n5)).doubleValue();
            if (d14 > defaultBoxAndWhiskerCategoryDataset.getMaxOutlier(n, n2).doubleValue()) {
                outlierListCollection.setHighFarOut(true);
            } else if (d14 < defaultBoxAndWhiskerCategoryDataset.getMinOutlier(n, n2).doubleValue()) {
                outlierListCollection.setLowFarOut(true);
            } else if (d14 > defaultBoxAndWhiskerCategoryDataset.getMaxRegularValue(n, n2).doubleValue()) {
                d13 = valueAxis.translateValueToJava2D(d14, rectangle2D, rectangleEdge);
                arrayList.add(new Outlier(d + this.boxWidth / 2.0, d13, d12));
            } else if (d14 < defaultBoxAndWhiskerCategoryDataset.getMinRegularValue(n, n2).doubleValue()) {
                d13 = valueAxis.translateValueToJava2D(d14, rectangle2D, rectangleEdge);
                arrayList.add(new Outlier(d + this.boxWidth / 2.0, d13, d12));
            }
            Collections.sort(arrayList);
            ++n5;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (Outlier)iterator.next();
            outlierListCollection.add((Outlier)object);
        }
        object = outlierListCollection.iterator();
        while (object.hasNext()) {
            OutlierList outlierList = (OutlierList)object.next();
            Outlier outlier = outlierList.getAveragedOutlier();
            Point2D point2D = outlier.getPoint();
            if (outlierList.isMultiple()) {
                this.drawMultipleEllipse(point2D, this.boxWidth, d12, graphics2D);
                continue;
            }
            this.drawEllipse(point2D, d12, graphics2D);
        }
        if (outlierListCollection.isHighFarOut()) {
            this.drawHighFarOut(d9 / 2.0, graphics2D, d + this.boxWidth / 2.0, d10);
        }
        if (outlierListCollection.isLowFarOut()) {
            this.drawLowFarOut(d9 / 2.0, graphics2D, d + this.boxWidth / 2.0, d11);
        }
    }

    private void drawEllipse(Point2D point2D, double d, Graphics2D graphics2D) {
        Ellipse2D.Double double_ = new Ellipse2D.Double(point2D.getX() + d / 2.0, point2D.getY(), d, d);
        graphics2D.draw(double_);
    }

    private void drawMultipleEllipse(Point2D point2D, double d, double d2, Graphics2D graphics2D) {
        Ellipse2D.Double double_ = new Ellipse2D.Double(point2D.getX() - d / 2.0 + d2, point2D.getY(), d2, d2);
        Ellipse2D.Double double_2 = new Ellipse2D.Double(point2D.getX() + d / 2.0, point2D.getY(), d2, d2);
        graphics2D.draw(double_);
        graphics2D.draw(double_2);
    }

    private void drawHighFarOut(double d, Graphics2D graphics2D, double d2, double d3) {
        double d4 = d * 2.0;
        graphics2D.draw(new Line2D.Double(d2 - d4, d3 + d4, d2 + d4, d3 + d4));
        graphics2D.draw(new Line2D.Double(d2 - d4, d3 + d4, d2, d3));
        graphics2D.draw(new Line2D.Double(d2 + d4, d3 + d4, d2, d3));
    }

    private void drawLowFarOut(double d, Graphics2D graphics2D, double d2, double d3) {
        double d4 = d * 2.0;
        graphics2D.draw(new Line2D.Double(d2 - d4, d3 - d4, d2 + d4, d3 - d4));
        graphics2D.draw(new Line2D.Double(d2 - d4, d3 - d4, d2, d3));
        graphics2D.draw(new Line2D.Double(d2 + d4, d3 - d4, d2, d3));
    }
}

