/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.CrosshairInfo;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.HighLowToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.data.HighLowDataset;
import org.jfree.data.XYDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class CandlestickRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private double candleWidth;
    private double maxCandleWidthInMilliseconds = 7.2E7;
    private double maxCandleWidth;
    private transient Paint upPaint;
    private transient Paint downPaint;
    private boolean drawVolume;
    private double maxVolume;

    public CandlestickRenderer() {
        this(-1.0);
    }

    public CandlestickRenderer(double d) {
        this(d, true, new HighLowToolTipGenerator());
    }

    public CandlestickRenderer(double d, boolean bl, XYToolTipGenerator xYToolTipGenerator) {
        this.setToolTipGenerator(xYToolTipGenerator);
        this.candleWidth = d;
        this.drawVolume = bl;
        this.upPaint = Color.green;
        this.downPaint = Color.red;
    }

    public double getCandleWidth() {
        return this.candleWidth;
    }

    public void setCandleWidth(double d) {
        if (d != this.candleWidth) {
            Double d2 = new Double(this.candleWidth);
            this.candleWidth = d;
            this.firePropertyChanged("CandleStickRenderer.candleWidth", d2, new Double(d));
        }
    }

    public double getMaxCandleWidthInMilliseconds() {
        return this.maxCandleWidthInMilliseconds;
    }

    public void setMaxCandleWidthInMilliseconds(double d) {
        this.maxCandleWidthInMilliseconds = d;
        this.firePropertyChanged("CandlestickRenderer.maxCandleWidthInMilliseconds", null, new Double(d));
    }

    public Paint getUpPaint() {
        return this.upPaint;
    }

    public void setUpPaint(Paint paint) {
        Paint paint2 = this.upPaint;
        this.upPaint = paint;
        this.firePropertyChanged("CandleStickRenderer.upPaint", paint2, paint);
    }

    public Paint getDownPaint() {
        return this.downPaint;
    }

    public void setDownPaint(Paint paint) {
        Paint paint2 = this.downPaint;
        this.downPaint = paint;
        this.firePropertyChanged("CandleStickRenderer.downPaint", paint2, paint);
    }

    public boolean drawVolume() {
        return this.drawVolume;
    }

    public void setDrawVolume(boolean bl) {
        if (this.drawVolume != bl) {
            this.drawVolume = bl;
            this.firePropertyChanged("CandlestickRenderer.drawVolume", null, new Boolean(bl));
        }
    }

    public int initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, ChartRenderingInfo chartRenderingInfo) {
        ValueAxis valueAxis = xYPlot.getDomainAxis();
        double d = valueAxis.getLowerBound();
        double d2 = d + this.maxCandleWidthInMilliseconds;
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        double d3 = valueAxis.translateValueToJava2D(d, rectangle2D, rectangleEdge);
        double d4 = valueAxis.translateValueToJava2D(d2, rectangle2D, rectangleEdge);
        this.maxCandleWidth = d4 - d3;
        if (this.drawVolume) {
            HighLowDataset highLowDataset = (HighLowDataset)xYDataset;
            this.maxVolume = 0.0;
            int n = 0;
            while (n < highLowDataset.getSeriesCount()) {
                int n2 = 0;
                while (n2 < highLowDataset.getItemCount(n)) {
                    double d5 = highLowDataset.getVolumeValue(n, n2).doubleValue();
                    if (d5 > this.maxVolume) {
                        this.maxVolume = d5;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return 1;
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairInfo crosshairInfo, int n3) {
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            this.drawHorizontalItem(graphics2D, rectangle2D, chartRenderingInfo, xYPlot, valueAxis, valueAxis2, xYDataset, n, n2, crosshairInfo, n3);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            this.drawVerticalItem(graphics2D, rectangle2D, chartRenderingInfo, xYPlot, valueAxis, valueAxis2, xYDataset, n, n2, crosshairInfo, n3);
        }
    }

    public void drawHorizontalItem(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairInfo crosshairInfo, int n3) {
        EntityCollection entityCollection = null;
        if (chartRenderingInfo != null) {
            entityCollection = chartRenderingInfo.getEntityCollection();
        }
        HighLowDataset highLowDataset = (HighLowDataset)xYDataset;
        Number number = highLowDataset.getXValue(n, n2);
        Number number2 = highLowDataset.getHighValue(n, n2);
        Number number3 = highLowDataset.getLowValue(n, n2);
        Number number4 = highLowDataset.getOpenValue(n, n2);
        Number number5 = highLowDataset.getCloseValue(n, n2);
        double d = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D, xYPlot.getDomainAxisEdge());
        RectangleEdge rectangleEdge = xYPlot.getRangeAxisEdge();
        double d2 = valueAxis2.translateValueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge);
        double d3 = valueAxis2.translateValueToJava2D(number3.doubleValue(), rectangle2D, rectangleEdge);
        double d4 = valueAxis2.translateValueToJava2D(number4.doubleValue(), rectangle2D, rectangleEdge);
        double d5 = valueAxis2.translateValueToJava2D(number5.doubleValue(), rectangle2D, rectangleEdge);
        double d6 = this.candleWidth;
        double d7 = this.candleWidth;
        if (this.candleWidth <= 0.0) {
            int n4 = highLowDataset.getItemCount(n);
            d6 = rectangle2D.getHeight() / (double)n4 * 4.5 / 7.0;
            if (d6 < 1.0) {
                d6 = 1.0;
            }
            if (d6 > this.maxCandleWidth) {
                d6 = this.maxCandleWidth;
            }
            if ((d7 = d6) < 3.0) {
                d7 = 3.0;
            }
            if (d7 > this.maxCandleWidth) {
                d7 = this.maxCandleWidth;
            }
        }
        Paint paint = this.getItemPaint(n, n2);
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setStroke(stroke);
        if (this.drawVolume) {
            int n5 = highLowDataset.getVolumeValue(n, n2).intValue();
            double d8 = (double)n5 / this.maxVolume;
            double d9 = rectangle2D.getMinX();
            double d10 = rectangle2D.getMaxX();
            double d11 = d8 * (d10 - d9);
            graphics2D.setPaint(Color.gray);
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.3f));
            graphics2D.fill(new Rectangle2D.Double(d9, d - d6 / 2.0, d11, d6));
            graphics2D.setComposite(composite);
        }
        graphics2D.setPaint(paint);
        if (d2 > d4 && d2 > d5) {
            graphics2D.draw(new Line2D.Double(d2, d, Math.max(d4, d5), d));
        }
        if (d3 < d4 && d3 < d5) {
            graphics2D.draw(new Line2D.Double(d3, d, Math.min(d4, d5), d));
        }
        Rectangle2D.Double double_ = null;
        if (d4 < d5) {
            double_ = new Rectangle2D.Double(d4, d - d7 / 2.0, d5 - d4, d7);
            if (this.upPaint != null) {
                graphics2D.setPaint(this.upPaint);
                graphics2D.fill(double_);
            }
            graphics2D.setPaint(paint);
            graphics2D.draw(double_);
        } else {
            double_ = new Rectangle2D.Double(d5, d - d7 / 2.0, d4 - d5, d7);
            if (this.downPaint != null) {
                graphics2D.setPaint(this.downPaint);
            }
            graphics2D.fill(double_);
            graphics2D.setPaint(paint);
            graphics2D.draw(double_);
        }
        if (entityCollection != null) {
            String string = null;
            if (this.getToolTipGenerator() != null) {
                string = this.getToolTipGenerator().generateToolTip(xYDataset, n, n2);
            }
            String string2 = null;
            if (this.getURLGenerator() != null) {
                string2 = this.getURLGenerator().generateURL(xYDataset, n, n2);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(double_, xYDataset, n, n2, string, string2);
            entityCollection.addEntity(xYItemEntity);
        }
    }

    public void drawVerticalItem(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairInfo crosshairInfo, int n3) {
        EntityCollection entityCollection = null;
        if (chartRenderingInfo != null) {
            entityCollection = chartRenderingInfo.getEntityCollection();
        }
        HighLowDataset highLowDataset = (HighLowDataset)xYDataset;
        Number number = highLowDataset.getXValue(n, n2);
        Number number2 = highLowDataset.getHighValue(n, n2);
        Number number3 = highLowDataset.getLowValue(n, n2);
        Number number4 = highLowDataset.getOpenValue(n, n2);
        Number number5 = highLowDataset.getCloseValue(n, n2);
        double d = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D, xYPlot.getDomainAxisEdge());
        RectangleEdge rectangleEdge = xYPlot.getRangeAxisEdge();
        double d2 = valueAxis2.translateValueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge);
        double d3 = valueAxis2.translateValueToJava2D(number3.doubleValue(), rectangle2D, rectangleEdge);
        double d4 = valueAxis2.translateValueToJava2D(number4.doubleValue(), rectangle2D, rectangleEdge);
        double d5 = valueAxis2.translateValueToJava2D(number5.doubleValue(), rectangle2D, rectangleEdge);
        double d6 = this.candleWidth;
        double d7 = this.candleWidth;
        if (this.candleWidth <= 0.0) {
            int n4 = highLowDataset.getItemCount(n);
            d6 = (rectangle2D.getMaxX() - rectangle2D.getMinX()) / (double)n4 * 4.5 / 7.0;
            if (d6 < 1.0) {
                d6 = 1.0;
            }
            if (d6 > this.maxCandleWidth) {
                d6 = this.maxCandleWidth;
            }
            if ((d7 = d6) < 3.0) {
                d7 = 3.0;
            }
            if (d7 > this.maxCandleWidth) {
                d7 = this.maxCandleWidth;
            }
        }
        Paint paint = this.getItemPaint(n, n2);
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setStroke(stroke);
        if (this.drawVolume) {
            int n5 = highLowDataset.getVolumeValue(n, n2).intValue();
            double d8 = (double)n5 / this.maxVolume;
            double d9 = rectangle2D.getMinY();
            double d10 = rectangle2D.getMaxY();
            double d11 = d8 * (d10 - d9);
            graphics2D.setPaint(Color.gray);
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.3f));
            graphics2D.fill(new Rectangle2D.Double(d - d6 / 2.0, d10 - d11, d6, d11));
            graphics2D.setComposite(composite);
        }
        graphics2D.setPaint(paint);
        if (d2 < d4 && d2 < d5) {
            graphics2D.draw(new Line2D.Double(d, d2, d, Math.min(d4, d5)));
        }
        if (d3 > d4 && d3 > d5) {
            graphics2D.draw(new Line2D.Double(d, d3, d, Math.max(d4, d5)));
        }
        Rectangle2D.Double double_ = null;
        if (d4 > d5) {
            double_ = new Rectangle2D.Double(d - d7 / 2.0, d5, d7, d4 - d5);
            if (this.upPaint != null) {
                graphics2D.setPaint(this.upPaint);
                graphics2D.fill(double_);
            }
            graphics2D.setPaint(paint);
            graphics2D.draw(double_);
        } else {
            double_ = new Rectangle2D.Double(d - d7 / 2.0, d4, d7, d5 - d4);
            if (this.downPaint != null) {
                graphics2D.setPaint(this.downPaint);
            }
            graphics2D.fill(double_);
            graphics2D.setPaint(paint);
            graphics2D.draw(double_);
        }
        if (entityCollection != null) {
            String string = null;
            if (this.getToolTipGenerator() != null) {
                string = this.getToolTipGenerator().generateToolTip(xYDataset, n, n2);
            }
            String string2 = null;
            if (this.getURLGenerator() != null) {
                string2 = this.getURLGenerator().generateURL(xYDataset, n, n2);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(double_, xYDataset, n, n2, string, string2);
            entityCollection.addEntity(xYItemEntity);
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof CandlestickRenderer) {
            CandlestickRenderer candlestickRenderer = (CandlestickRenderer)object;
            boolean bl = super.equals(object);
            bl = bl && this.candleWidth == candlestickRenderer.getCandleWidth();
            bl = bl && this.upPaint.equals(candlestickRenderer.getUpPaint());
            bl = bl && this.downPaint.equals(candlestickRenderer.getDownPaint());
            bl = bl && this.drawVolume == candlestickRenderer.drawVolume;
            return bl;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint((Paint)this.upPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.downPaint, (ObjectOutputStream)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.upPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.downPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
    }
}

