/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.AbstractCategoryItemRenderer;
import org.jfree.data.CategoryDataset;
import org.jfree.util.BooleanList;
import org.jfree.util.PublicCloneable;

public class LineAndShapeRenderer
extends AbstractCategoryItemRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    public static final int SHAPES = 1;
    public static final int LINES = 2;
    public static final int SHAPES_AND_LINES = 3;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    private boolean drawShapes;
    private boolean drawLines;
    private Boolean shapesFilled;
    private BooleanList seriesShapesFilled;
    private Boolean defaultShapesFilled;

    public LineAndShapeRenderer() {
        this(3);
    }

    public LineAndShapeRenderer(int n) {
        if (n == 1) {
            this.drawShapes = true;
        }
        if (n == 2) {
            this.drawLines = true;
        }
        if (n == 3) {
            this.drawShapes = true;
            this.drawLines = true;
        }
        this.shapesFilled = null;
        this.seriesShapesFilled = new BooleanList();
        this.defaultShapesFilled = Boolean.TRUE;
    }

    public boolean isDrawShapes() {
        return this.drawShapes;
    }

    public void setDrawShapes(boolean bl) {
        if (bl != this.drawShapes) {
            this.drawShapes = bl;
            this.firePropertyChanged("Shapes", new Boolean(!bl), new Boolean(bl));
        }
    }

    public boolean isDrawLines() {
        return this.drawLines;
    }

    public void setDrawLines(boolean bl) {
        if (bl != this.drawLines) {
            this.drawLines = bl;
            this.firePropertyChanged("Lines", new Boolean(!bl), new Boolean(bl));
        }
    }

    public boolean getItemShapeFilled(int n, int n2) {
        return this.getSeriesShapesFilled(n);
    }

    public boolean getSeriesShapesFilled(int n) {
        if (this.shapesFilled != null) {
            return this.shapesFilled;
        }
        Boolean bl = this.seriesShapesFilled.getBoolean(n);
        if (bl != null) {
            return bl;
        }
        return this.defaultShapesFilled;
    }

    public void setShapesFilled(boolean bl) {
        if (bl) {
            this.setShapesFilled(Boolean.TRUE);
        } else {
            this.setShapesFilled(Boolean.FALSE);
        }
    }

    public void setShapesFilled(Boolean bl) {
        this.shapesFilled = bl;
    }

    public void setSeriesShapesFilled(int n, Boolean bl) {
        this.seriesShapesFilled.setBoolean(n, bl);
    }

    public Boolean getDefaultShapesFilled() {
        return this.defaultShapesFilled;
    }

    public void setDefaultShapesFilled(Boolean bl) {
        this.defaultShapesFilled = bl;
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        Object object;
        Number number = categoryDataset.getValue(n, n2);
        if (number == null) {
            return;
        }
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d = categoryAxis.getCategoryMiddle(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        double d2 = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D, categoryPlot.getRangeAxisEdge());
        graphics2D.setPaint(this.getItemPaint(n, n2));
        graphics2D.setStroke(this.getItemStroke(n, n2));
        Shape shape = this.getItemShape(n, n2);
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            shape = this.createTransformedShape(shape, d2, d);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            shape = this.createTransformedShape(shape, d, d2);
        }
        if (this.drawShapes) {
            if (this.getItemShapeFilled(n, n2)) {
                graphics2D.fill(shape);
            } else {
                graphics2D.draw(shape);
            }
        }
        if (this.drawLines && n2 != 0 && (object = categoryDataset.getValue(n, n2 - 1)) != null) {
            double d3 = ((Number)object).doubleValue();
            double d4 = categoryAxis.getCategoryMiddle(n2 - 1, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
            double d5 = valueAxis.translateValueToJava2D(d3, rectangle2D, categoryPlot.getRangeAxisEdge());
            graphics2D.setPaint(this.getItemPaint(n, n2));
            graphics2D.setStroke(this.getItemStroke(n, n2));
            Line2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double_ = new Line2D.Double(d5, d4, d2, d);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                double_ = new Line2D.Double(d4, d5, d, d2);
            }
            graphics2D.draw(double_);
        }
        if (this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, plotOrientation, categoryDataset, n, n2, d, d2, number.doubleValue() < 0.0);
        }
        if (this.getInfo() != null && (object = this.getInfo().getEntityCollection()) != null && shape != null) {
            String string = null;
            CategoryItemLabelGenerator categoryItemLabelGenerator = this.getItemLabelGenerator(n, n2);
            if (categoryItemLabelGenerator != null) {
                string = categoryItemLabelGenerator.generateToolTip(categoryDataset, n, n2);
            }
            String string2 = null;
            if (this.getItemURLGenerator(n, n2) != null) {
                string2 = this.getItemURLGenerator(n, n2).generateURL(categoryDataset, n, n2);
            }
            CategoryItemEntity categoryItemEntity = new CategoryItemEntity(shape, string, string2, categoryDataset, n, categoryDataset.getColumnKey(n2), n2);
            object.addEntity(categoryItemEntity);
        }
    }
}

