/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.CrosshairInfo;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.IntervalXYDataset;
import org.jfree.data.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class XYBarRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private double margin;
    private double translatedRangeZero;

    public XYBarRenderer() {
        this.margin = 0.0;
    }

    public XYBarRenderer(double d) {
        this.margin = d;
    }

    public XYBarRenderer(double d, XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        super(xYToolTipGenerator, xYURLGenerator);
        this.margin = d;
    }

    public void setMargin(double d) {
        Double d2 = new Double(this.margin);
        this.margin = d;
        this.firePropertyChanged("XYBarRenderer.margin", d2, new Double(d));
    }

    public int initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, ChartRenderingInfo chartRenderingInfo) {
        super.initialise(graphics2D, rectangle2D, xYPlot, xYDataset, chartRenderingInfo);
        ValueAxis valueAxis = xYPlot.getRangeAxis();
        this.translatedRangeZero = valueAxis.translateValueToJava2D(0.0, rectangle2D, xYPlot.getRangeAxisEdge());
        return 1;
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairInfo crosshairInfo, int n3) {
        EntityCollection entityCollection;
        IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
        Paint paint = this.getItemPaint(n, n2);
        Paint paint2 = this.getSeriesOutlinePaint(n);
        Number number = intervalXYDataset.getYValue(n, n2);
        if (number == null) {
            return;
        }
        double d = valueAxis2.translateValueToJava2D(number.doubleValue(), rectangle2D, xYPlot.getRangeAxisEdge());
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        Number number2 = intervalXYDataset.getStartXValue(n, n2);
        if (number2 == null) {
            return;
        }
        double d2 = valueAxis.translateValueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge);
        Number number3 = intervalXYDataset.getEndXValue(n, n2);
        if (number3 == null) {
            return;
        }
        double d3 = valueAxis.translateValueToJava2D(number3.doubleValue(), rectangle2D, rectangleEdge);
        double d4 = Math.max(1.0, Math.abs(d3 - d2));
        double d5 = Math.abs(d - this.translatedRangeZero);
        if (this.margin > 0.0) {
            double d6 = d4 * this.margin;
            d4 -= d6;
            d2 += d6 / 2.0;
        }
        Rectangle2D.Double double_ = null;
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Rectangle2D.Double(Math.min(this.translatedRangeZero, d), d3, d5, d4);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Rectangle2D.Double(d2, Math.min(this.translatedRangeZero, d), d4, d5);
        }
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (Math.abs(d3 - d2) > 3.0) {
            graphics2D.setStroke(this.getItemStroke(n, n2));
            graphics2D.setPaint(paint2);
            graphics2D.draw(double_);
        }
        if (chartRenderingInfo != null && (entityCollection = chartRenderingInfo.getEntityCollection()) != null) {
            String string = null;
            if (this.getToolTipGenerator() != null) {
                string = this.getToolTipGenerator().generateToolTip(xYDataset, n, n2);
            }
            String string2 = null;
            if (this.getURLGenerator() != null) {
                string2 = this.getURLGenerator().generateURL(xYDataset, n, n2);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(double_, xYDataset, n, n2, string, string2);
            entityCollection.addEntity(xYItemEntity);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

