/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.util.ArrayList;
import java.util.List;
import org.jfree.data.AbstractSeriesDataset;
import org.jfree.data.SeriesChangeEvent;
import org.jfree.data.XYDataItem;
import org.jfree.data.XYDataset;
import org.jfree.data.XYSeries;
import org.jfree.util.ObjectUtils;

public class TableXYDataset
extends AbstractSeriesDataset
implements XYDataset {
    private List data = new ArrayList();
    private List xPoints = new ArrayList();
    private boolean propagateEvents = true;

    public TableXYDataset() {
    }

    public TableXYDataset(XYSeries xYSeries) {
        if (xYSeries != null) {
            this.updateXPoints(xYSeries);
            this.data.add(xYSeries);
            xYSeries.addChangeListener(this);
        }
    }

    public void addSeries(XYSeries xYSeries) {
        if (xYSeries == null) {
            throw new IllegalArgumentException("XYSeriesCollection.addSeries(...): cannot add null series.");
        }
        this.updateXPoints(xYSeries);
        this.data.add(xYSeries);
        xYSeries.addChangeListener(this);
        this.fireDatasetChanged();
    }

    private void updateXPoints(XYSeries xYSeries) {
        ArrayList<Number> arrayList = new ArrayList<Number>();
        boolean bl = this.propagateEvents;
        this.propagateEvents = false;
        int n = 0;
        while (n < xYSeries.getItemCount()) {
            Number number = xYSeries.getXValue(n);
            arrayList.add(number);
            if (!this.xPoints.contains(number)) {
                this.xPoints.add(number);
                int n2 = 0;
                while (n2 < this.data.size()) {
                    XYSeries xYSeries2 = (XYSeries)this.data.get(n2);
                    if (!xYSeries2.equals(xYSeries)) {
                        xYSeries2.add(number, (Number)new Integer(0));
                    }
                    ++n2;
                }
            }
            ++n;
        }
        int n3 = 0;
        while (n3 < this.xPoints.size()) {
            Number number = (Number)this.xPoints.get(n3);
            if (!arrayList.contains(number)) {
                xYSeries.add(number, (Number)new Integer(0));
            }
            ++n3;
        }
        this.propagateEvents = bl;
    }

    public void updateXPoints() {
        this.propagateEvents = false;
        int n = 0;
        while (n < this.data.size()) {
            this.updateXPoints((XYSeries)this.data.get(n));
            ++n;
        }
        this.propagateEvents = true;
    }

    public int getSeriesCount() {
        return this.data.size();
    }

    public int getItemCount() {
        if (this.xPoints == null) {
            return 0;
        }
        return this.xPoints.size();
    }

    public XYSeries getSeries(int n) {
        if (n < 0 || n > this.getSeriesCount()) {
            throw new IllegalArgumentException("XYSeriesCollection.getSeries(...): index outside valid range.");
        }
        XYSeries xYSeries = (XYSeries)this.data.get(n);
        return xYSeries;
    }

    public String getSeriesName(int n) {
        return this.getSeries(n).getName();
    }

    public int getItemCount(int n) {
        return this.getSeries(n).getItemCount();
    }

    public Number getXValue(int n, int n2) {
        XYSeries xYSeries = (XYSeries)this.data.get(n);
        XYDataItem xYDataItem = xYSeries.getDataItem(n2);
        return xYDataItem.getX();
    }

    public Number getYValue(int n, int n2) {
        XYSeries xYSeries = (XYSeries)this.data.get(n);
        XYDataItem xYDataItem = xYSeries.getDataItem(n2);
        return xYDataItem.getY();
    }

    public void removeAllSeries() {
        int n = 0;
        while (n < this.data.size()) {
            XYSeries xYSeries = (XYSeries)this.data.get(n);
            xYSeries.removeChangeListener(this);
            ++n;
        }
        this.data.clear();
        this.xPoints.clear();
        this.fireDatasetChanged();
    }

    public void removeSeries(XYSeries xYSeries) {
        if (xYSeries == null) {
            throw new IllegalArgumentException("XYSeriesCollection.removeSeries(...): cannot remove null series.");
        }
        if (this.data.contains(xYSeries)) {
            xYSeries.removeChangeListener(this);
            this.data.remove(xYSeries);
            if (this.data.size() == 0) {
                this.xPoints.clear();
            }
            this.fireDatasetChanged();
        }
    }

    public void removeSeries(int n) {
        if (n < 0 || n > this.getSeriesCount()) {
            throw new IllegalArgumentException("XYSeriesCollection.removeSeries(...): index outside valid range.");
        }
        XYSeries xYSeries = (XYSeries)this.data.get(n);
        xYSeries.removeChangeListener(this);
        this.data.remove(n);
        if (this.data.size() == 0) {
            this.xPoints.clear();
        }
        this.fireDatasetChanged();
    }

    public void seriesChanged(SeriesChangeEvent seriesChangeEvent) {
        if (this.propagateEvents) {
            this.updateXPoints();
            this.fireDatasetChanged();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof TableXYDataset) {
            TableXYDataset tableXYDataset = (TableXYDataset)object;
            return ObjectUtils.equal((Object)this.data, (Object)tableXYDataset.data);
        }
        return false;
    }
}

