/*
 * Decompiled with CFR 0.152.
 */
package clover.cenqua_com_licensing.atlassian.time.tz;

import clover.cenqua_com_licensing.atlassian.time.Chronology;
import clover.cenqua_com_licensing.atlassian.time.DateTime;
import clover.cenqua_com_licensing.atlassian.time.DateTimeField;
import clover.cenqua_com_licensing.atlassian.time.DateTimeZone;
import clover.cenqua_com_licensing.atlassian.time.MutableDateTime;
import clover.cenqua_com_licensing.atlassian.time.chrono.ISOChronology;
import clover.cenqua_com_licensing.atlassian.time.chrono.LenientChronology;
import clover.cenqua_com_licensing.atlassian.time.format.DateTimeFormatter;
import clover.cenqua_com_licensing.atlassian.time.format.ISODateTimeFormat;
import clover.cenqua_com_licensing.atlassian.time.tz.DateTimeZoneBuilder;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class ZoneInfoCompiler {
    static DateTimeOfYear cStartOfYear;
    static Chronology cLenientISO;
    private Map iRuleSets = new HashMap();
    private List iZones = new ArrayList();
    private List iLinks = new ArrayList();

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            ZoneInfoCompiler.printUsage();
            return;
        }
        File file = null;
        File file2 = null;
        int n = 0;
        while (n < stringArray.length) {
            block8: {
                try {
                    if ("-src".equals(stringArray[n])) {
                        file = new File(stringArray[++n]);
                        break block8;
                    }
                    if ("-dst".equals(stringArray[n])) {
                        file2 = new File(stringArray[++n]);
                        break block8;
                    }
                    if (!"-?".equals(stringArray[n])) break;
                    ZoneInfoCompiler.printUsage();
                    return;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    ZoneInfoCompiler.printUsage();
                    return;
                }
            }
            ++n;
        }
        if (n >= stringArray.length) {
            ZoneInfoCompiler.printUsage();
            return;
        }
        File[] fileArray = new File[stringArray.length - n];
        int n2 = 0;
        while (n < stringArray.length) {
            fileArray[n2] = file == null ? new File(stringArray[n]) : new File(file, stringArray[n]);
            ++n;
            ++n2;
        }
        ZoneInfoCompiler zoneInfoCompiler = new ZoneInfoCompiler();
        zoneInfoCompiler.compile(file2, fileArray);
    }

    private static void printUsage() {
        System.out.println("Usage: java org.joda.time.tz.ZoneInfoCompiler <options> <source files>");
        System.out.println("where possible options include:");
        System.out.println("  -src <directory>    Specify where to read source files");
        System.out.println("  -dst <directory>    Specify where to write generated files");
    }

    static DateTimeOfYear getStartOfYear() {
        if (cStartOfYear == null) {
            cStartOfYear = new DateTimeOfYear();
        }
        return cStartOfYear;
    }

    static Chronology getLenientISOChronology() {
        if (cLenientISO == null) {
            cLenientISO = LenientChronology.getInstance(ISOChronology.getInstanceUTC());
        }
        return cLenientISO;
    }

    static void writeZoneInfoMap(DataOutputStream dataOutputStream, Map map) throws IOException {
        String string;
        Map.Entry entry;
        HashMap<String, Short> hashMap = new HashMap<String, Short>(map.size());
        TreeMap<Short, String> treeMap = new TreeMap<Short, String>();
        Iterator iterator = map.entrySet().iterator();
        short s = 0;
        while (iterator.hasNext()) {
            Short s2;
            entry = iterator.next();
            string = (String)entry.getKey();
            if (!hashMap.containsKey(string)) {
                s2 = new Short(s);
                hashMap.put(string, s2);
                treeMap.put(s2, string);
                s = (short)(s + 1);
                if (s == 0) {
                    throw new InternalError("Too many time zone ids");
                }
            }
            if (hashMap.containsKey(string = ((DateTimeZone)entry.getValue()).getID())) continue;
            s2 = new Short(s);
            hashMap.put(string, s2);
            treeMap.put(s2, string);
            s = (short)(s + 1);
            if (s != 0) continue;
            throw new InternalError("Too many time zone ids");
        }
        dataOutputStream.writeShort(treeMap.size());
        iterator = treeMap.values().iterator();
        while (iterator.hasNext()) {
            dataOutputStream.writeUTF((String)((Object)iterator.next()));
        }
        dataOutputStream.writeShort(map.size());
        iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            string = (String)entry.getKey();
            dataOutputStream.writeShort(((Short)hashMap.get(string)).shortValue());
            string = ((DateTimeZone)entry.getValue()).getID();
            dataOutputStream.writeShort(((Short)hashMap.get(string)).shortValue());
        }
    }

    static int parseYear(String string, int n) {
        if ((string = string.toLowerCase()).equals("minimum") || string.equals("min")) {
            return Integer.MIN_VALUE;
        }
        if (string.equals("maximum") || string.equals("max")) {
            return Integer.MAX_VALUE;
        }
        if (string.equals("only")) {
            return n;
        }
        return Integer.parseInt(string);
    }

    static int parseMonth(String string) {
        DateTimeField dateTimeField = ISOChronology.getInstanceUTC().monthOfYear();
        return dateTimeField.get(dateTimeField.set(0L, string, Locale.ENGLISH));
    }

    static int parseDayOfWeek(String string) {
        DateTimeField dateTimeField = ISOChronology.getInstanceUTC().dayOfWeek();
        return dateTimeField.get(dateTimeField.set(0L, string, Locale.ENGLISH));
    }

    static String parseOptional(String string) {
        return string.equals("-") ? null : string;
    }

    static int parseTime(String string) {
        int n;
        DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.hourMinuteSecondFraction();
        MutableDateTime mutableDateTime = new MutableDateTime(0L, ZoneInfoCompiler.getLenientISOChronology());
        int n2 = 0;
        if (string.startsWith("-")) {
            n2 = 1;
        }
        if ((n = dateTimeFormatter.parseInto(mutableDateTime, string, n2)) == ~n2) {
            throw new IllegalArgumentException(string);
        }
        int n3 = (int)mutableDateTime.getMillis();
        if (n2 == 1) {
            n3 = -n3;
        }
        return n3;
    }

    static char parseZoneChar(char c) {
        switch (c) {
            case 'S': 
            case 's': {
                return 's';
            }
            case 'G': 
            case 'U': 
            case 'Z': 
            case 'g': 
            case 'u': 
            case 'z': {
                return 'u';
            }
        }
        return 'w';
    }

    static boolean test(String string, DateTimeZone dateTimeZone) {
        long l;
        if (!string.equals(dateTimeZone.getID())) {
            return true;
        }
        long l2 = ISOChronology.getInstanceUTC().year().set(0L, 1850);
        long l3 = ISOChronology.getInstanceUTC().year().set(0L, 2050);
        int n = dateTimeZone.getOffset(l2);
        String string2 = dateTimeZone.getNameKey(l2);
        ArrayList<Long> arrayList = new ArrayList<Long>();
        while ((l = dateTimeZone.nextTransition(l2)) != l2 && l <= l3) {
            l2 = l;
            int n2 = dateTimeZone.getOffset(l2);
            String string3 = dateTimeZone.getNameKey(l2);
            if (n == n2 && string2.equals(string3)) {
                System.out.println("*d* Error in " + dateTimeZone.getID() + " " + new DateTime(l2, (Chronology)ISOChronology.getInstanceUTC()));
                return false;
            }
            if (string3 == null || string3.length() < 3 && !"??".equals(string3)) {
                System.out.println("*s* Error in " + dateTimeZone.getID() + " " + new DateTime(l2, (Chronology)ISOChronology.getInstanceUTC()) + ", nameKey=" + string3);
                return false;
            }
            arrayList.add(new Long(l2));
            n = n2;
            string2 = string3;
        }
        l2 = ISOChronology.getInstanceUTC().year().set(0L, 2050);
        l3 = ISOChronology.getInstanceUTC().year().set(0L, 1850);
        int n3 = arrayList.size();
        while (--n3 >= 0) {
            long l4 = dateTimeZone.previousTransition(l2);
            if (l4 == l2 || l4 < l3) break;
            l2 = l4;
            long l5 = (Long)arrayList.get(n3);
            if (l5 - 1L == l2) continue;
            System.out.println("*r* Error in " + dateTimeZone.getID() + " " + new DateTime(l2, (Chronology)ISOChronology.getInstanceUTC()) + " != " + new DateTime(l5 - 1L, (Chronology)ISOChronology.getInstanceUTC()));
            return false;
        }
        return true;
    }

    public Map compile(File file, File[] fileArray) throws IOException {
        Serializable serializable;
        Object object;
        Object object2;
        Object object3;
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(fileArray[n]));
                this.parseDataFile(bufferedReader);
                bufferedReader.close();
                ++n;
            }
        }
        if (file != null) {
            if (!file.exists()) {
                throw new IOException("Destination directory doesn't exist: " + file);
            }
            if (!file.isDirectory()) {
                throw new IOException("Destination is not a directory: " + file);
            }
        }
        TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>();
        int n = 0;
        while (n < this.iZones.size()) {
            Zone zone = (Zone)this.iZones.get(n);
            object3 = new DateTimeZoneBuilder();
            zone.addToBuilder((DateTimeZoneBuilder)object3, this.iRuleSets);
            object = object2 = ((DateTimeZoneBuilder)object3).toDateTimeZone(zone.iName);
            if (ZoneInfoCompiler.test(((DateTimeZone)object).getID(), (DateTimeZone)object)) {
                treeMap.put(((DateTimeZone)object).getID(), object);
                if (file != null) {
                    System.out.println("Writing " + ((DateTimeZone)object).getID());
                    serializable = new File(file, ((DateTimeZone)object).getID());
                    if (!((File)serializable).getParentFile().exists()) {
                        ((File)serializable).getParentFile().mkdirs();
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream((File)serializable);
                    ((DateTimeZoneBuilder)object3).writeTo(fileOutputStream);
                    ((OutputStream)fileOutputStream).close();
                    FileInputStream fileInputStream = new FileInputStream((File)serializable);
                    DateTimeZone dateTimeZone = DateTimeZoneBuilder.readFrom(fileInputStream, ((DateTimeZone)object).getID());
                    ((InputStream)fileInputStream).close();
                    if (!((DateTimeZone)object2).equals(dateTimeZone)) {
                        System.out.println("*e* Error in " + ((DateTimeZone)object).getID() + ": Didn't read properly from file");
                    }
                }
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < 2) {
            int n3 = 0;
            while (n3 < this.iLinks.size()) {
                object2 = (String)this.iLinks.get(n3);
                object = (String)this.iLinks.get(n3 + 1);
                serializable = (DateTimeZone)treeMap.get(object2);
                if (serializable == null) {
                    if (n2 > 0) {
                        System.out.println("Cannot find time zone '" + (String)object2 + "' to link alias '" + (String)object + "' to");
                    }
                } else {
                    treeMap.put(object, serializable);
                }
                n3 += 2;
            }
            ++n2;
        }
        if (file != null) {
            System.out.println("Writing ZoneInfoMap");
            object3 = new File(file, "ZoneInfoMap");
            if (!((File)object3).getParentFile().exists()) {
                ((File)object3).getParentFile().mkdirs();
            }
            object2 = new FileOutputStream((File)object3);
            object = new DataOutputStream((OutputStream)object2);
            serializable = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            serializable.putAll(treeMap);
            ZoneInfoCompiler.writeZoneInfoMap((DataOutputStream)object, (Map)((Object)serializable));
            ((FilterOutputStream)object).close();
        }
        return treeMap;
    }

    public void parseDataFile(BufferedReader bufferedReader) throws IOException {
        String string;
        Zone zone = null;
        while ((string = bufferedReader.readLine()) != null) {
            String string2 = string.trim();
            if (string2.length() == 0 || string2.charAt(0) == '#') continue;
            int n = string.indexOf(35);
            if (n >= 0) {
                string = string.substring(0, n);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
            if (Character.isWhitespace(string.charAt(0)) && stringTokenizer.hasMoreTokens()) {
                if (zone == null) continue;
                zone.chain(stringTokenizer);
                continue;
            }
            if (zone != null) {
                this.iZones.add(zone);
            }
            zone = null;
            if (!stringTokenizer.hasMoreTokens()) continue;
            String string3 = stringTokenizer.nextToken();
            if (string3.equalsIgnoreCase("Rule")) {
                Rule rule = new Rule(stringTokenizer);
                RuleSet ruleSet = (RuleSet)this.iRuleSets.get(rule.iName);
                if (ruleSet == null) {
                    ruleSet = new RuleSet(rule);
                    this.iRuleSets.put(rule.iName, ruleSet);
                    continue;
                }
                ruleSet.addRule(rule);
                continue;
            }
            if (string3.equalsIgnoreCase("Zone")) {
                zone = new Zone(stringTokenizer);
                continue;
            }
            if (string3.equalsIgnoreCase("Link")) {
                this.iLinks.add(stringTokenizer.nextToken());
                this.iLinks.add(stringTokenizer.nextToken());
                continue;
            }
            System.out.println("Unknown line: " + string);
        }
        if (zone != null) {
            this.iZones.add(zone);
        }
    }

    private static class Zone {
        public final String iName;
        public final int iOffsetMillis;
        public final String iRules;
        public final String iFormat;
        public final int iUntilYear;
        public final DateTimeOfYear iUntilDateTimeOfYear;
        private Zone iNext;

        Zone(StringTokenizer stringTokenizer) {
            this(stringTokenizer.nextToken(), stringTokenizer);
        }

        private Zone(String string, StringTokenizer stringTokenizer) {
            this.iName = string.intern();
            this.iOffsetMillis = ZoneInfoCompiler.parseTime(stringTokenizer.nextToken());
            this.iRules = ZoneInfoCompiler.parseOptional(stringTokenizer.nextToken());
            this.iFormat = stringTokenizer.nextToken().intern();
            int n = Integer.MAX_VALUE;
            DateTimeOfYear dateTimeOfYear = ZoneInfoCompiler.getStartOfYear();
            if (stringTokenizer.hasMoreTokens()) {
                n = Integer.parseInt(stringTokenizer.nextToken());
                if (stringTokenizer.hasMoreTokens()) {
                    dateTimeOfYear = new DateTimeOfYear(stringTokenizer);
                }
            }
            this.iUntilYear = n;
            this.iUntilDateTimeOfYear = dateTimeOfYear;
        }

        void chain(StringTokenizer stringTokenizer) {
            if (this.iNext != null) {
                this.iNext.chain(stringTokenizer);
            } else {
                this.iNext = new Zone(this.iName, stringTokenizer);
            }
        }

        public void addToBuilder(DateTimeZoneBuilder dateTimeZoneBuilder, Map map) {
            Zone.addToBuilder(this, dateTimeZoneBuilder, map);
        }

        private static void addToBuilder(Zone zone, DateTimeZoneBuilder dateTimeZoneBuilder, Map map) {
            while (zone != null) {
                dateTimeZoneBuilder.setStandardOffset(zone.iOffsetMillis);
                if (zone.iRules == null) {
                    dateTimeZoneBuilder.setFixedSavings(zone.iFormat, 0);
                } else {
                    try {
                        int n = ZoneInfoCompiler.parseTime(zone.iRules);
                        dateTimeZoneBuilder.setFixedSavings(zone.iFormat, n);
                    }
                    catch (Exception exception) {
                        RuleSet ruleSet = (RuleSet)map.get(zone.iRules);
                        if (ruleSet == null) {
                            throw new IllegalArgumentException("Rules not found: " + zone.iRules);
                        }
                        ruleSet.addRecurring(dateTimeZoneBuilder, zone.iFormat);
                    }
                }
                if (zone.iUntilYear == Integer.MAX_VALUE) break;
                zone.iUntilDateTimeOfYear.addCutover(dateTimeZoneBuilder, zone.iUntilYear);
                zone = zone.iNext;
            }
        }

        public String toString() {
            String string = "[Zone]\nName: " + this.iName + "\n" + "OffsetMillis: " + this.iOffsetMillis + "\n" + "Rules: " + this.iRules + "\n" + "Format: " + this.iFormat + "\n" + "UntilYear: " + this.iUntilYear + "\n" + this.iUntilDateTimeOfYear;
            if (this.iNext == null) {
                return string;
            }
            return string + "...\n" + this.iNext.toString();
        }
    }

    private static class RuleSet {
        private List iRules = new ArrayList();

        RuleSet(Rule rule) {
            this.iRules.add(rule);
        }

        void addRule(Rule rule) {
            if (!rule.iName.equals(((Rule)this.iRules.get((int)0)).iName)) {
                throw new IllegalArgumentException("Rule name mismatch");
            }
            this.iRules.add(rule);
        }

        public void addRecurring(DateTimeZoneBuilder dateTimeZoneBuilder, String string) {
            int n = 0;
            while (n < this.iRules.size()) {
                Rule rule = (Rule)this.iRules.get(n);
                rule.addRecurring(dateTimeZoneBuilder, string);
                ++n;
            }
        }
    }

    private static class Rule {
        public final String iName;
        public final int iFromYear;
        public final int iToYear;
        public final String iType;
        public final DateTimeOfYear iDateTimeOfYear;
        public final int iSaveMillis;
        public final String iLetterS;

        Rule(StringTokenizer stringTokenizer) {
            this.iName = stringTokenizer.nextToken().intern();
            this.iFromYear = ZoneInfoCompiler.parseYear(stringTokenizer.nextToken(), 0);
            this.iToYear = ZoneInfoCompiler.parseYear(stringTokenizer.nextToken(), this.iFromYear);
            if (this.iToYear < this.iFromYear) {
                throw new IllegalArgumentException();
            }
            this.iType = ZoneInfoCompiler.parseOptional(stringTokenizer.nextToken());
            this.iDateTimeOfYear = new DateTimeOfYear(stringTokenizer);
            this.iSaveMillis = ZoneInfoCompiler.parseTime(stringTokenizer.nextToken());
            this.iLetterS = ZoneInfoCompiler.parseOptional(stringTokenizer.nextToken());
        }

        public void addRecurring(DateTimeZoneBuilder dateTimeZoneBuilder, String string) {
            String string2 = this.formatName(string);
            this.iDateTimeOfYear.addRecurring(dateTimeZoneBuilder, string2, this.iSaveMillis, this.iFromYear, this.iToYear);
        }

        private String formatName(String string) {
            int n = string.indexOf(47);
            if (n > 0) {
                if (this.iSaveMillis == 0) {
                    return string.substring(0, n).intern();
                }
                return string.substring(n + 1).intern();
            }
            n = string.indexOf("%s");
            if (n < 0) {
                return string;
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 2);
            String string4 = this.iLetterS == null ? string2.concat(string3) : string2 + this.iLetterS + string3;
            return string4.intern();
        }

        public String toString() {
            return "[Rule]\nName: " + this.iName + "\n" + "FromYear: " + this.iFromYear + "\n" + "ToYear: " + this.iToYear + "\n" + "Type: " + this.iType + "\n" + this.iDateTimeOfYear + "SaveMillis: " + this.iSaveMillis + "\n" + "LetterS: " + this.iLetterS + "\n";
        }
    }

    private static class DateTimeOfYear {
        public final int iMonthOfYear;
        public final int iDayOfMonth;
        public final int iDayOfWeek;
        public final boolean iAdvanceDayOfWeek;
        public final int iMillisOfDay;
        public final char iZoneChar;

        DateTimeOfYear() {
            this.iMonthOfYear = 1;
            this.iDayOfMonth = 1;
            this.iDayOfWeek = 0;
            this.iAdvanceDayOfWeek = false;
            this.iMillisOfDay = 0;
            this.iZoneChar = (char)119;
        }

        DateTimeOfYear(StringTokenizer stringTokenizer) {
            int n = 1;
            int n2 = 1;
            int n3 = 0;
            int n4 = 0;
            boolean bl = false;
            int n5 = 119;
            if (stringTokenizer.hasMoreTokens()) {
                n = ZoneInfoCompiler.parseMonth(stringTokenizer.nextToken());
                if (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken();
                    if (string.startsWith("last")) {
                        n2 = -1;
                        n3 = ZoneInfoCompiler.parseDayOfWeek(string.substring(4));
                        bl = false;
                    } else {
                        try {
                            n2 = Integer.parseInt(string);
                            n3 = 0;
                            bl = false;
                        }
                        catch (NumberFormatException numberFormatException) {
                            int n6 = string.indexOf(">=");
                            if (n6 > 0) {
                                n2 = Integer.parseInt(string.substring(n6 + 2));
                                n3 = ZoneInfoCompiler.parseDayOfWeek(string.substring(0, n6));
                                bl = true;
                            }
                            n6 = string.indexOf("<=");
                            if (n6 > 0) {
                                n2 = Integer.parseInt(string.substring(n6 + 2));
                                n3 = ZoneInfoCompiler.parseDayOfWeek(string.substring(0, n6));
                                bl = false;
                            }
                            throw new IllegalArgumentException(string);
                        }
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        string = stringTokenizer.nextToken();
                        n5 = ZoneInfoCompiler.parseZoneChar(string.charAt(string.length() - 1));
                        n4 = ZoneInfoCompiler.parseTime(string);
                    }
                }
            }
            this.iMonthOfYear = n;
            this.iDayOfMonth = n2;
            this.iDayOfWeek = n3;
            this.iAdvanceDayOfWeek = bl;
            this.iMillisOfDay = n4;
            this.iZoneChar = (char)n5;
        }

        public void addRecurring(DateTimeZoneBuilder dateTimeZoneBuilder, String string, int n, int n2, int n3) {
            dateTimeZoneBuilder.addRecurringSavings(string, n, n2, n3, this.iZoneChar, this.iMonthOfYear, this.iDayOfMonth, this.iDayOfWeek, this.iAdvanceDayOfWeek, this.iMillisOfDay);
        }

        public void addCutover(DateTimeZoneBuilder dateTimeZoneBuilder, int n) {
            dateTimeZoneBuilder.addCutover(n, this.iZoneChar, this.iMonthOfYear, this.iDayOfMonth, this.iDayOfWeek, this.iAdvanceDayOfWeek, this.iMillisOfDay);
        }

        public String toString() {
            return "MonthOfYear: " + this.iMonthOfYear + "\n" + "DayOfMonth: " + this.iDayOfMonth + "\n" + "DayOfWeek: " + this.iDayOfWeek + "\n" + "AdvanceDayOfWeek: " + this.iAdvanceDayOfWeek + "\n" + "MillisOfDay: " + this.iMillisOfDay + "\n" + "ZoneChar: " + this.iZoneChar + "\n";
        }
    }
}

