/*
 * Decompiled with CFR 0.152.
 */
package clover.com.lowagie.text.pdf;

import clover.com.lowagie.text.DocWriter;
import clover.com.lowagie.text.Document;
import clover.com.lowagie.text.ExceptionConverter;
import clover.com.lowagie.text.pdf.PdfArray;
import clover.com.lowagie.text.pdf.PdfDictionary;
import clover.com.lowagie.text.pdf.PdfEncryption;
import clover.com.lowagie.text.pdf.PdfException;
import clover.com.lowagie.text.pdf.PdfName;
import clover.com.lowagie.text.pdf.PdfNumber;
import clover.com.lowagie.text.pdf.PdfObject;
import clover.com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;

public class PdfStream
extends PdfDictionary {
    protected boolean compressed = false;
    protected ByteArrayOutputStream streamBytes = null;
    protected byte[] dicBytes = null;
    static final byte[] STARTSTREAM = DocWriter.getISOBytes("\nstream\n");
    static final byte[] ENDSTREAM = DocWriter.getISOBytes("\nendstream");
    static final int SIZESTREAM = STARTSTREAM.length + ENDSTREAM.length;

    public PdfStream(byte[] byArray) {
        this.type = 7;
        this.bytes = byArray;
        this.put(PdfName.LENGTH, new PdfNumber(byArray.length));
    }

    protected PdfStream() {
        this.type = 7;
    }

    public byte[] toPdf(PdfWriter pdfWriter) {
        this.dicBytes = super.toPdf(pdfWriter);
        return null;
    }

    public void flateCompress() throws PdfException {
        if (!Document.compress) {
            return;
        }
        if (this.compressed) {
            return;
        }
        PdfObject pdfObject = this.get(PdfName.FILTER);
        if (pdfObject != null) {
            if (pdfObject.isName() && ((PdfName)pdfObject).compareTo(PdfName.FLATEDECODE) == 0) {
                return;
            }
            if (pdfObject.isArray() && ((PdfArray)pdfObject).contains(PdfName.FLATEDECODE)) {
                return;
            }
            throw new PdfException("Stream could not be compressed: filter is not a name or array.");
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
            if (this.streamBytes != null) {
                this.streamBytes.writeTo(deflaterOutputStream);
            } else {
                deflaterOutputStream.write(this.bytes);
            }
            deflaterOutputStream.close();
            this.streamBytes = byteArrayOutputStream;
            this.bytes = null;
            this.put(PdfName.LENGTH, new PdfNumber(this.streamBytes.size()));
            if (pdfObject == null) {
                this.put(PdfName.FILTER, PdfName.FLATEDECODE);
            } else {
                PdfArray pdfArray = new PdfArray(pdfObject);
                pdfArray.add(PdfName.FLATEDECODE);
                this.put(PdfName.FILTER, pdfArray);
            }
            this.compressed = true;
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    public int getStreamLength(PdfWriter pdfWriter) {
        if (this.dicBytes == null) {
            this.toPdf(pdfWriter);
        }
        if (this.streamBytes != null) {
            return this.streamBytes.size() + this.dicBytes.length + SIZESTREAM;
        }
        return this.bytes.length + this.dicBytes.length + SIZESTREAM;
    }

    void writeTo(OutputStream outputStream, PdfWriter pdfWriter) throws IOException {
        if (this.dicBytes == null) {
            this.toPdf(pdfWriter);
        }
        outputStream.write(this.dicBytes);
        outputStream.write(STARTSTREAM);
        PdfEncryption pdfEncryption = pdfWriter.getEncryption();
        if (pdfEncryption == null) {
            if (this.streamBytes != null) {
                this.streamBytes.writeTo(outputStream);
            } else {
                outputStream.write(this.bytes);
            }
        } else {
            byte[] byArray;
            pdfEncryption.prepareKey();
            if (this.streamBytes != null) {
                byArray = this.streamBytes.toByteArray();
                pdfEncryption.encryptRC4(byArray);
            } else {
                byArray = new byte[this.bytes.length];
                pdfEncryption.encryptRC4(this.bytes, byArray);
            }
            outputStream.write(byArray);
        }
        outputStream.write(ENDSTREAM);
    }
}

