/*
 * Decompiled with CFR 0.152.
 */
package clover.retrotranslator.net.sf.retrotranslator.runtime.format;

import clover.retrotranslator.net.sf.retrotranslator.runtime.format.FormatContext;
import clover.retrotranslator.net.sf.retrotranslator.runtime.format.NumericConversion;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.math._BigDecimal;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormatSymbols;

abstract class FloatingPointConversion
extends NumericConversion {
    FloatingPointConversion() {
    }

    protected abstract void printf(FormatContext var1, boolean var2, BigDecimal var3);

    protected void printf(FormatContext context) {
        Object argument = context.getArgument();
        if (argument instanceof Double) {
            this.printf(context, (Double)argument);
        } else if (argument instanceof Float) {
            this.printf(context, ((Float)argument).floatValue());
        } else if (argument == null) {
            context.writeRestricted(String.valueOf(argument));
        } else if (argument instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)argument;
            this.printf(context, bigDecimal.signum() < 0, bigDecimal.abs());
        } else {
            throw context.getConversionException();
        }
    }

    private void printf(FormatContext context, double argument) {
        if (!FloatingPointConversion.printSpecialNumber(context, argument)) {
            this.printf(context, Double.doubleToLongBits(argument) < 0L, _BigDecimal.valueOf(Math.abs(argument)));
        }
    }

    protected static void printComputerizedScientificNumber(FormatContext context, boolean negative, BigDecimal argument, int precision) {
        String unscaled = argument.unscaledValue().toString();
        StringBuffer builder = new StringBuffer();
        builder.append(unscaled.charAt(0));
        if (precision > 0 || context.isFlag('#')) {
            builder.append('.');
        }
        if (precision < unscaled.length()) {
            builder.append(unscaled.substring(1, precision + 1));
        } else {
            builder.append(unscaled.substring(1));
            FloatingPointConversion.appendZeros(builder, precision + 1 - unscaled.length());
        }
        int exponent = unscaled.equals("0") ? 0 : unscaled.length() - argument.scale() - 1;
        builder.append('e').append(exponent < 0 ? (char)'-' : '+');
        int absoluteExponent = Math.abs(exponent);
        if (absoluteExponent < 10) {
            builder.append('0');
        }
        builder.append(absoluteExponent);
        FloatingPointConversion.printNumber(context, negative, null, builder, context.getSymbols(false));
    }

    protected static void printDecimalNumber(FormatContext context, boolean negative, BigDecimal argument, boolean localized) {
        String unscaled = argument.unscaledValue().toString();
        String integerPart = "0";
        String fractionPart = "";
        int separatorIndex = unscaled.length() - argument.scale();
        if (separatorIndex < 0) {
            fractionPart = FloatingPointConversion.appendZeros(new StringBuffer(), -separatorIndex).append(unscaled).toString();
        } else if (separatorIndex == 0) {
            fractionPart = unscaled;
        } else if (separatorIndex < unscaled.length()) {
            integerPart = unscaled.substring(0, separatorIndex);
            fractionPart = unscaled.substring(separatorIndex);
        } else {
            integerPart = separatorIndex == unscaled.length() ? unscaled : FloatingPointConversion.appendZeros(new StringBuffer(unscaled), separatorIndex - unscaled.length()).toString();
        }
        StringBuffer builder = new StringBuffer();
        DecimalFormatSymbols symbols = context.getSymbols(localized);
        FloatingPointConversion.appendNumber(builder, integerPart, context.isFlag(','), symbols);
        if (fractionPart.length() > 0 || context.isFlag('#')) {
            builder.append(symbols.getDecimalSeparator());
        }
        FloatingPointConversion.appendNumber(builder, fractionPart, false, symbols);
        FloatingPointConversion.printNumber(context, negative, null, builder, symbols);
    }

    protected static StringBuffer appendZeros(StringBuffer builder, int count) {
        for (int i = 0; i < count; ++i) {
            builder.append('0');
        }
        return builder;
    }

    protected static BigDecimal round(BigDecimal decimal, int shift) {
        int scale = decimal.scale() - shift;
        return scale >= 0 ? decimal.setScale(scale, 4) : decimal.movePointRight(scale).setScale(0, 4).movePointLeft(scale);
    }

    public static class GeneralScientificConversion
    extends FloatingPointConversion {
        public void format(FormatContext context) {
            context.checkFlags();
            context.assertNoFlag('#');
            this.printf(context);
        }

        protected void printf(FormatContext context, boolean negative, BigDecimal argument) {
            int precision = Math.max(context.getNumberPrecision(), 1);
            BigDecimal roundedArgument = GeneralScientificConversion.round(argument, argument.unscaledValue().toString().length() - precision);
            if (roundedArgument.compareTo(new BigDecimal(BigInteger.ONE, 4)) >= 0 && roundedArgument.compareTo(_BigDecimal.ONE.movePointRight(precision)) < 0) {
                GeneralScientificConversion.printDecimalNumber(context, negative, roundedArgument, context.getArgument() instanceof BigDecimal);
            } else {
                GeneralScientificConversion.printComputerizedScientificNumber(context, negative, roundedArgument, precision - 1);
            }
        }
    }

    public static class DecimalConversion
    extends FloatingPointConversion {
        public void format(FormatContext context) {
            context.checkWidth();
            context.checkFlags();
            this.printf(context);
        }

        protected void printf(FormatContext context, boolean negative, BigDecimal argument) {
            BigDecimal roundedArgument = argument.setScale(context.getNumberPrecision(), 4);
            DecimalConversion.printDecimalNumber(context, negative, roundedArgument, true);
        }
    }

    public static class ComputerizedScientificConversion
    extends FloatingPointConversion {
        public void format(FormatContext context) {
            context.checkFlags();
            context.assertNoFlag(',');
            this.printf(context);
        }

        protected void printf(FormatContext context, boolean negative, BigDecimal argument) {
            int shift = argument.unscaledValue().toString().length() - context.getNumberPrecision() - 1;
            ComputerizedScientificConversion.printComputerizedScientificNumber(context, negative, ComputerizedScientificConversion.round(argument, shift), context.getNumberPrecision());
        }
    }
}

