/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover;

import com.cenqua.clover.ApplicationCoverage;
import com.cenqua.clover.CoverageDataSpec;
import com.cenqua.clover.CoverageRecordingTranscript;
import com.cenqua.clover.Logger;
import com.cenqua.clover.PerTestCoverage;
import com.cenqua.clover.PerTestRecordingTranscript;
import com.cenqua.clover.RecordingTranscripts;
import com.cenqua.clover.registry.Clover2Registry;
import com.cenqua.clover.registry.CoverageDataRange;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.TestCaseInfo;
import com.cenqua.clover.util.BitSetUtils;
import java.io.Serializable;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageData
implements ApplicationCoverage,
PerTestCoverage,
Serializable {
    private static final long serialVersionUID = -7764604340239734212L;
    private long timestamp;
    private final int[] hitCounts;
    private final PerTestCoverage perTestCoverage;
    private boolean empty;
    private transient RecordingTranscripts.Filter source;

    public CoverageData(Clover2Registry registry) {
        this(registry, new CoverageDataSpec());
    }

    public CoverageData(Clover2Registry registry, CoverageDataSpec spec) {
        this.hitCounts = new int[registry.getDataLength()];
        this.perTestCoverage = spec.getPerTestStrategy().build(registry, spec);
        this.empty = true;
    }

    public CoverageData(long timestamp, int[] hitCounts, PerTestCoverage perTestCoverage) {
        this.timestamp = timestamp;
        this.hitCounts = hitCounts;
        this.perTestCoverage = perTestCoverage;
        this.empty = false;
    }

    private CoverageData(Clover2Registry registry, CoverageData other) {
        this.timestamp = other.timestamp;
        this.hitCounts = new int[registry.getDataLength()];
        System.arraycopy(other.hitCounts, 0, this.hitCounts, 0, Math.min(other.hitCounts.length, this.hitCounts.length));
        this.perTestCoverage = other.perTestCoverage;
        this.empty = other.empty;
        this.source = other.source;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void resolve(Clover2Registry registry) {
        for (TestCaseInfo info : this.perTestCoverage.getTests()) {
            info.resolve(registry.getModel());
        }
    }

    int[] getHitCounts() {
        return this.hitCounts;
    }

    @Override
    public int getHitCount(int index) {
        return this.hitCounts[index];
    }

    @Override
    public int getCoverageSize() {
        return this.hitCounts.length;
    }

    public BitSet getPassOnlyAndIncidentalHits() {
        BitSet passOnlyTestHits = this.perTestCoverage.getPassOnlyHits();
        BitSet allTestHits = this.perTestCoverage.getAllHits();
        BitSet allHits = BitSetUtils.fromIntArray(this.hitCounts);
        allHits.andNot(allTestHits);
        passOnlyTestHits.or(allHits);
        return passOnlyTestHits;
    }

    @Override
    public TestCaseInfo getTestById(int testId) {
        return this.perTestCoverage.getTestById(testId);
    }

    @Override
    public BitSet getPassOnlyHits() {
        return this.perTestCoverage.getPassOnlyHits();
    }

    @Override
    public BitSet getHitsFor(TestCaseInfo tci) {
        return this.perTestCoverage.getHitsFor(tci);
    }

    @Override
    public BitSet getHitsFor(Set<TestCaseInfo> tcis) {
        return this.perTestCoverage.getHitsFor(tcis);
    }

    @Override
    public BitSet getHitsFor(Set<TestCaseInfo> tcis, CoverageDataRange range) {
        return this.perTestCoverage.getHitsFor(tcis, range);
    }

    @Override
    public BitSet getUniqueHitsFor(TestCaseInfo tci) {
        return this.perTestCoverage.getUniqueHitsFor(tci);
    }

    @Override
    public BitSet getUniqueHitsFor(Set<TestCaseInfo> tcis) {
        return this.perTestCoverage.getUniqueHitsFor(tcis);
    }

    @Override
    public boolean hasPerTestData() {
        return this.perTestCoverage.hasPerTestData();
    }

    @Override
    public Set<TestCaseInfo> getTests() {
        return this.perTestCoverage.getTests();
    }

    @Override
    public Set<TestCaseInfo> getTestsCovering(CoverageDataRange range) {
        return this.perTestCoverage.getTestsCovering(range);
    }

    @Override
    public Map<TestCaseInfo, BitSet> mapTestsAndCoverageForFile(FileInfo fileInfo) {
        return this.perTestCoverage.mapTestsAndCoverageForFile(fileInfo);
    }

    @Override
    public BitSet getAllHits() {
        return this.perTestCoverage.getAllHits();
    }

    @Override
    public void addCoverage(TestCaseInfo tci, PerTestRecordingTranscript recording) {
        this.perTestCoverage.addCoverage(tci, recording);
    }

    @Override
    public void addCoverage(CoverageRecordingTranscript recording) {
        int added = recording.addTo(this.hitCounts);
        if (added != recording.getCount()) {
            Logger.getInstance().verbose(new StringBuffer().append("Truncated recording file before adding to global coverage: ").append(recording).toString());
        }
        this.empty = false;
    }

    public static Set<TestCaseInfo> tcisInHitRange(Map<TestCaseInfo, BitSet> tcisAndHits, CoverageDataRange range) {
        HashSet<TestCaseInfo> hits = new HashSet<TestCaseInfo>();
        for (Map.Entry<TestCaseInfo, BitSet> tciAndHits : tcisAndHits.entrySet()) {
            int startIdx = range.getDataIndex();
            int endIdx = range.getDataIndex() + range.getDataLength();
            int hitIdx = tciAndHits.getValue().nextSetBit(startIdx);
            if (hitIdx == -1 || hitIdx >= endIdx) continue;
            hits.add(tciAndHits.getKey());
        }
        return hits;
    }

    public void avoidObviousOverflow() {
        int max = Integer.MAX_VALUE;
        for (int i = 0; i < this.hitCounts.length; ++i) {
            if (this.hitCounts[i] >= 0) continue;
            this.hitCounts[i] = Integer.MAX_VALUE;
        }
    }

    public CoverageData copy(Clover2Registry owner) {
        return new CoverageData(owner, this);
    }

    public void setSource(RecordingTranscripts.Filter source) {
        this.source = source.copy();
    }

    public boolean isOutOfDate() {
        if (this.source == null) {
            return false;
        }
        RecordingTranscripts.Filter latestFilter = new RecordingTranscripts.Filter(this.source.getDir(), this.source.getBasename(), this.source.getFrom(), this.source.getTo(), false);
        latestFilter.processDir();
        return !((Object)this.source.getCoverageRecordingFiles()).equals(latestFilter.getCoverageRecordingFiles());
    }
}

