/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.html;

import clover.org.apache.velocity.VelocityContext;
import clover.retrotranslator.edu.emory.mathcs.backport.java.util.concurrent.Callable;
import com.cenqua.clover.reporters.html.AbstractClassInfoClosure;
import com.cenqua.clover.reporters.html.ClassInfoClosure;
import com.cenqua.clover.reporters.html.FullHtmlReporter;
import com.cenqua.clover.reporters.html.HtmlReportUtil;
import com.cenqua.clover.reporters.html.StatisticsClassInfoVisitor;
import com.cenqua.clover.reporters.html.TabInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class RenderCoverageCloudAction
implements Callable {
    protected List classes;
    protected File basePath;
    protected VelocityContext context;
    protected FullHtmlReporter.TreeInfo tree;

    public RenderCoverageCloudAction(VelocityContext context, FullHtmlReporter.TreeInfo tree, List classes, File basePath) {
        this.context = context;
        this.tree = tree;
        this.classes = classes;
        this.basePath = basePath;
    }

    public Object call() throws Exception {
        ArrayList<TabInfo> allTabs = new ArrayList<TabInfo>();
        TabInfo risksInfo = this.createRisksTab();
        TabInfo quickWinsInfo = this.createQuickWinsTab();
        allTabs.add(risksInfo);
        allTabs.add(quickWinsInfo);
        this.renderQuickWins(this.createOutputDir(), allTabs, quickWinsInfo, this.tree);
        this.renderProjectRisks(this.createOutputDir(), allTabs, risksInfo, this.tree);
        return null;
    }

    protected abstract File createOutputDir() throws IOException;

    protected abstract TabInfo createRisksTab();

    protected TabInfo createQuickWinsTab() {
        return new TabInfo("Quick Wins", "quick-wins.html", "help_pkg_quick_wins");
    }

    protected void renderProjectRisks(File outDir, List allTabs, TabInfo currentTab, FullHtmlReporter.TreeInfo tree) throws Exception {
        this.renderCloudPage(outDir, allTabs, new AbstractClassInfoClosure.AvgMethodComplexityClosure(), new AbstractClassInfoClosure.PcCoveredElementsClosure(), currentTab, tree);
    }

    protected void renderQuickWins(File outDir, List allTabs, TabInfo currentTab, FullHtmlReporter.TreeInfo tree) throws Exception {
        this.renderCloudPage(outDir, allTabs, new AbstractClassInfoClosure.ElementCountClosure(), new AbstractClassInfoClosure.UncoveredElementsClosure(), currentTab, tree);
    }

    protected void renderCloudPage(File outDir, List allTabs, ClassInfoClosure axis1, ClassInfoClosure axis2, TabInfo currentTab, FullHtmlReporter.TreeInfo tree) throws Exception {
        this.context.put("currentPageURL", currentTab.getFilename());
        this.context.put("tabs", allTabs);
        this.context.put("tree", tree);
        this.context.put("showCloudOwner", Boolean.TRUE);
        this.applySpecificProperties();
        this.applyAxies(axis1, axis2);
        this.context.put("title", currentTab.getTitle());
        HtmlReportUtil.mergeTemplateToFile(new File(outDir, currentTab.getFilename()), this.context, "html_res/cloud-page.vm");
    }

    protected void applyAxis(String prefix, ClassInfoClosure axis1, ClassInfoClosure axis2, List classes) {
        StatisticsClassInfoVisitor v2 = StatisticsClassInfoVisitor.visit(classes, axis2);
        StatisticsClassInfoVisitor v1 = StatisticsClassInfoVisitor.visit(v2.getClasses(), axis1);
        this.context.put(prefix + "axis", Boolean.TRUE);
        this.context.put(prefix + "axis1", v1);
        this.context.put(prefix + "axis2", v2);
    }

    protected abstract void applyAxies(ClassInfoClosure var1, ClassInfoClosure var2);

    protected abstract void applySpecificProperties();
}

