/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.html;

import com.cenqua.clover.registry.BaseClassInfo;
import com.cenqua.clover.reporters.html.ClassInfoClosure;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class StatisticsClassInfoVisitor {
    private long min = Long.MAX_VALUE;
    private long max = Long.MIN_VALUE;
    private final Map classes = new LinkedHashMap();
    private final ClassInfoClosure closure;

    public StatisticsClassInfoVisitor(ClassInfoClosure closure) {
        this.closure = closure;
    }

    public void visitClassInfo(BaseClassInfo classInfo) {
        if (this.closure.ignore(classInfo)) {
            return;
        }
        int count = this.closure.getScaledValue(classInfo);
        this.classes.put(classInfo, this.closure.getFormattedValue(classInfo));
        if ((long)count <= this.min) {
            this.min = count;
        }
        if ((long)count >= this.max) {
            this.max = count;
        }
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public long getRange() {
        return this.max - this.min;
    }

    public List getClasses() {
        return new ArrayList(this.classes.keySet());
    }

    public boolean hasClassInfo(BaseClassInfo info) {
        return this.classes.containsKey(info);
    }

    public ClassInfoClosure getClosure() {
        return this.closure;
    }

    public static StatisticsClassInfoVisitor visit(List classes, ClassInfoClosure classInfoClosure) {
        StatisticsClassInfoVisitor visitor = new StatisticsClassInfoVisitor(classInfoClosure);
        for (int i = 0; i < classes.size(); ++i) {
            BaseClassInfo classInfo = (BaseClassInfo)classes.get(i);
            visitor.visitClassInfo(classInfo);
        }
        return visitor;
    }
}

