#ifndef SMS_ENVIRONMENT_H
#define SMS_ENVIRONMENT_H

#include <iostream>
#include "./cpu/z80.h"
#include "MemoryMapper.h"
#include "IOMapper.h"
#include "VDP.h"

using namespace std;

class SmsEnvironment : public Z80Environment
{
protected:
    MemoryMapper *mmapper;
    IOMapper *iomapper;
    VDP *v;
    Z80 *cpu;
    
public:
    /** Constructor. */
    SmsEnvironment(); 

    /** Destructor. */
    virtual ~SmsEnvironment();

    virtual unsigned char readByte( unsigned addr ); 
    virtual void writeByte( unsigned addr, unsigned char value );
    virtual unsigned char readPort( unsigned port );
    virtual void writePort( unsigned port, unsigned char value );
    virtual void onReturnFromInterrupt();
    virtual void onInterruptsEnabled();
    virtual void setMemoryMapper(MemoryMapper *m);
    virtual void setIOMapper(IOMapper *m);
    virtual void setVDP(VDP *v);
    virtual void setCPU(Z80 *c);
};

#endif
