//
// implements the following classes:
//
// AutoDialog
// wxNumericValidator -
//
// Copyright (c) 2001 Virtual Terrain Project
// Free for all uses, see license.txt for details.
//

#include "wx/wxprec.h"
#include "AutoDialog.h"
#include "wx/stattext.h"
#include "wx/textctrl.h"

/////////////////////////////////////////////////
// wxNumericValidator

wxNumericValidator::wxNumericValidator(int *val) : wxValidator()
{
    Initialize();
    m_pValInt = val;
}

wxNumericValidator::wxNumericValidator(float *val, int digits) : wxValidator()
{
    Initialize();
    m_pValFloat = val;
	m_iFloatDigits = digits;
}

wxNumericValidator::wxNumericValidator(const wxNumericValidator& val)
{
    Copy(val);
}

bool wxNumericValidator::Copy(const wxNumericValidator& val)
{
    wxValidator::Copy(val);

    m_pValInt = val.m_pValInt;
    m_pValFloat = val.m_pValFloat;
    m_iFloatDigits = val.m_iFloatDigits;

    return TRUE;
}

// Called to transfer data to the window
bool wxNumericValidator::TransferToWindow(void)
{
    if ( !m_validatorWindow )
        return FALSE;

	wxString str;
	if (m_pValInt)
		str.Printf("%d", *m_pValInt);
	if (m_pValFloat)
	{
//		wxString formatstring;
//		formatstring.Printf("%s%df", "%.", m_iFloatDigits);
//		str = wxString::Format(formatstring, *m_pValFloat);
		str.Printf("%g", *m_pValFloat);
	}

    if (m_validatorWindow->IsKindOf(CLASSINFO(wxStaticText)) )
    {
        wxStaticText* pControl = (wxStaticText*) m_validatorWindow;
		if (pControl)
		{
			pControl->SetLabel(str) ;
			return TRUE;
		}
    }
	else 
    if (m_validatorWindow->IsKindOf(CLASSINFO(wxTextCtrl)) )
    {
        wxTextCtrl* pControl = (wxTextCtrl*) m_validatorWindow;
		if (pControl)
		{
			pControl->SetValue(str) ;
			return TRUE;
		}
    }
	else
		return FALSE;

	// unrecognized control, or bad pointer
	return FALSE;
}

// Called to transfer data from the window
bool wxNumericValidator::TransferFromWindow(void)
{
	if ( !m_validatorWindow )
		return FALSE;

	wxString str = "";
	// string controls
	if (m_validatorWindow->IsKindOf(CLASSINFO(wxStaticText)) )
	{
		wxStaticText* pControl = (wxStaticText*) m_validatorWindow;
		if (pControl)
			str = pControl->GetLabel() ;
	} else
	if (m_validatorWindow->IsKindOf(CLASSINFO(wxTextCtrl)) )
	{
		wxTextCtrl* pControl = (wxTextCtrl*) m_validatorWindow;
		if (pControl)
			str = pControl->GetValue() ;
	}
	else // unrecognized control, or bad pointer
		return FALSE;

	if (str != "")
	{
		if (m_pValInt)
			sscanf(str, "%d", m_pValInt);
		if (m_pValFloat)
		{
			sscanf(str, "%f", m_pValFloat);
		}
		return TRUE;
	}
	return FALSE;
}

/*
  Called by constructors to initialize ALL data members
*/
void wxNumericValidator::Initialize()
{
    m_pValInt = NULL;
    m_pValFloat = NULL;
	m_iFloatDigits = 6;
}

/////////////////////////////////////////////////
//

BEGIN_EVENT_TABLE(AutoDialog, wxDialog)
EVT_INIT_DIALOG (AutoDialog::OnInitDialog)
END_EVENT_TABLE()

void AutoDialog::AddValidator(long id, wxString *sptr)
{
	wxWindow *pWin = FindWindow(id);
	if (!pWin) return;
	wxGenericValidator *gv = new wxGenericValidator(sptr);
	pWin->SetValidator(*gv);
}

void AutoDialog::AddValidator(long id, bool *bptr)
{
	wxWindow *pWin = FindWindow(id);
	if (!pWin) return;
	wxGenericValidator *gv = new wxGenericValidator(bptr);
	pWin->SetValidator(*gv);
}

void AutoDialog::AddValidator(long id, int *iptr)
{
	wxWindow *pWin = FindWindow(id);
	if (!pWin) return;
	wxGenericValidator *gv = new wxGenericValidator(iptr);
	pWin->SetValidator(*gv);
}

void AutoDialog::AddNumValidator(long id, int *iptr)
{
	wxWindow *pWin = FindWindow(id);
	if (pWin)
	{
		wxNumericValidator *gv = new wxNumericValidator(iptr);
		pWin->SetValidator(*gv);
	}
}

void AutoDialog::AddNumValidator(long id, float *fptr, int digits)
{
	wxWindow *pWin = FindWindow(id);
	if (pWin)
	{
		wxNumericValidator *gv = new wxNumericValidator(fptr, digits);
		pWin->SetValidator(*gv);
	}
}


