//
// BuildingLayer.h
//
// Copyright (c) 2001 Virtual Terrain Project
// Free for all uses, see license.txt for details.
//

#ifndef BUILDINGLAYER_H
#define BUILDINGLAYER_H

#include "vtdata/shapelib/shapefil.h"
#include "vtdata/BuildingArray.h"
#include "Layer.h"

//////////////////////////////////////////////////////////

class vtBuildingLayer : public vtLayer, public vtBuildingArray
{
public:
	vtBuildingLayer();

	bool GetExtent(DRECT &rect);
	void DrawLayer(wxDC* pDC, vtScaledView *pView);
	bool ConvertProjection(vtProjection &proj);
	bool OnSave();
	bool OnLoad();
	void GetProjection(vtProjection &proj);
	void AppendDataFrom(vtLayer *pL);
	void Offset(DPoint2 p);

	void AddElementsFromSHP(const char *filename, vtProjection &proj);
	void AddElementsFromSHPPoints(SHPHandle hSHP, int nElem);
	void AddElementsFromSHPPolygons(const char *filename,
									SHPHandle hSHP, int nElem);

	vtBuilding *FindBuilding(DPoint2 &point, double epsilon);
	bool EditBuildingProperties();

	void DrawBuilding(wxDC* pDC, vtScaledView *pView, vtBuilding *bld);

protected:
	int m_size;
};

#endif