//
// Frame.h
//
// Copyright (c) 2001 Virtual Terrain Project
// Free for all uses, see license.txt for details.
//

#ifndef VTBUILDERFRAMEH
#define VTBUILDERFRAMEH

#include "wx/dnd.h"

#include "vtdata/Projections.h"
#include "vtdata/Plants.h"

#include "BuilderView.h"
#include "StatusBar.h"
#include "ElevLayer.h"
#include "VegDlg.h"
#include "VegLayer.h"

// some shortcuts
#define ADD_TOOL(id, bmp, tooltip, tog)     \
    toolBar_main->AddTool(id, bmp, wxNullBitmap, tog, -1, -1, (wxObject *)0, tooltip, tooltip)

class MyTreeCtrl;
class MySplitterWindow;
class MyStatusBar;
class vtDLGFile;

class MainFrame: public wxFrame
{
public:
	MainFrame(wxFrame* frame, const wxString& title,
		const wxPoint& pos, const wxSize& size);
	virtual ~MainFrame();

	void CreateMenus();
	void CreateToolbar();
	void RefreshToolbar();

	void OnSize(wxSizeEvent& event);
	void DeleteContents();

	// Menu commands
	void OnProjectNew(wxCommandEvent& event);
	void OnProjectOpen(wxCommandEvent& event);
	void OnProjectSave(wxCommandEvent& event);
	
	void OnQuit(wxCommandEvent& event);

	void OnEditDelete(wxCommandEvent& event);
	void OnEditDeselectAll(wxCommandEvent& event);
	void OnEditInvertSelection(wxCommandEvent& event);
	void OnEditCrossingSelection(wxCommandEvent& event);
	void OnEditOffset(wxCommandEvent& event);

	void OnUpdateEditOffset(wxUpdateUIEvent& event);

	void OnLayerNew(wxCommandEvent& event);
	void OnLayerOpen(wxCommandEvent& event);
	void OnLayerSave(wxCommandEvent& event);
	void OnLayerSaveAs(wxCommandEvent& event);
	void OnLayerImport(wxCommandEvent& event);
	void OnLayerProperties(wxCommandEvent& event);
	void OnLayerExport(wxCommandEvent& event);
	void OnLayerConvert(wxCommandEvent& event);
	void OnLayerSetProjection(wxCommandEvent& event);
	void OnLayerFlatten(wxCommandEvent& event);

	void OnUpdateLayerSave(wxUpdateUIEvent& event);
	void OnUpdateLayerSaveAs(wxUpdateUIEvent& event);
	void OnUpdateLayerExport(wxUpdateUIEvent& event);
	void OnUpdateLayerConvert(wxUpdateUIEvent& event);
	void OnUpdateLayerFlatten(wxUpdateUIEvent& event);

	void OnViewToolbar(wxCommandEvent& event);
	void OnLayerShow(wxCommandEvent& event);
	void OnViewMagnifier(wxCommandEvent& event);
	void OnViewPan(wxCommandEvent& event);
	void OnViewDistance(wxCommandEvent& event);
	void OnViewZoomIn(wxCommandEvent& event);
	void OnViewZoomOut(wxCommandEvent& event);
	void OnViewZoomAll(wxCommandEvent& event);
	void OnViewFull(wxCommandEvent& event);
	void OnViewWorldMap();
	void OnViewUTMBounds();
	void OnViewMinutes();

	void OnUpdateToolbar(wxUpdateUIEvent& event);
	void OnUpdateLayerShow(wxUpdateUIEvent& event);
	void OnUpdateMagnifier(wxUpdateUIEvent& event);
	void OnUpdatePan(wxUpdateUIEvent& event);
	void OnUpdateDistance(wxUpdateUIEvent& event);
	void OnUpdateViewFull(wxUpdateUIEvent& event);
	void OnUpdateCrossingSelection(wxUpdateUIEvent& event);
	void OnUpdateWorldMap(wxUpdateUIEvent& event);
	void OnUpdateUTMBounds(wxUpdateUIEvent& event);
	void OnUpdateMinutes(wxUpdateUIEvent& event);

	void OnSelectRoad(wxCommandEvent& event);
	void OnSelectNode(wxCommandEvent& event);
	void OnSelectWhole(wxCommandEvent& event);
	void OnDirection(wxCommandEvent& event);
	void OnRoadEdit(wxCommandEvent& event);
	void OnShowNodes(wxCommandEvent& event);
	void OnSelectHwy(wxCommandEvent& event);
	void OnRoadClean(wxCommandEvent& event);

	void OnUpdateSelectRoad(wxUpdateUIEvent& event);
	void OnUpdateSelectNode(wxUpdateUIEvent& event);
	void OnUpdateSelectWhole(wxUpdateUIEvent& event);
	void OnUpdateDirection(wxUpdateUIEvent& event);
	void OnUpdateRoadEdit(wxUpdateUIEvent& event);
	void OnUpdateShowNodes(wxUpdateUIEvent& event);

	void OnElevSelect(wxCommandEvent& event);
	void OnElevBox(wxCommandEvent& event);
	void OnRemoveAboveSea(wxCommandEvent& event);
	void OnFillIn(wxCommandEvent& event);
	void OnScaleElevation(wxCommandEvent& event);
	void OnExportTerragen(wxCommandEvent& event);
	void OnElevShow(wxCommandEvent& event);
	void OnElevShading(wxCommandEvent& event);
	void OnElevHide(wxCommandEvent& event);

	void OnUpdateElevSelect(wxUpdateUIEvent& event);
	void OnUpdateElevBox(wxUpdateUIEvent& event);
	void OnUpdateRemoveAboveSea(wxUpdateUIEvent& event);
	void OnUpdateFillIn(wxUpdateUIEvent& event);
	void OnUpdateScaleElevation(wxUpdateUIEvent& event);
	void OnUpdateExportTerragen(wxUpdateUIEvent& event);
	void OnUpdateElevShow(wxUpdateUIEvent& event);
	void OnUpdateElevShading(wxUpdateUIEvent& event);
	void OnUpdateElevHide(wxUpdateUIEvent& event);

	void OnVegPlants(wxCommandEvent& event);
	void OnVegBioregions(wxCommandEvent& event);
	void OnVegGenerate(wxCommandEvent& event);

	void OnUpdateVegGenerate(wxUpdateUIEvent& event);

	void OnFeatureSelect(wxCommandEvent& event);
	void OnUpdateFeatureSelect(wxUpdateUIEvent& event);
	void OnBuildingEdit(wxCommandEvent& event);
	void OnUpdateBuildingEdit(wxUpdateUIEvent& event);

	void OnAreaStretch(wxCommandEvent& event);
	void OnAreaTypeIn(wxCommandEvent& event);
	void OnAreaExportBitmap(wxCommandEvent& event);

	void OnHelpAbout(wxCommandEvent& event);

	// keys (used for shortcuts)
	void OnChar(wxKeyEvent& event);

	// project
	void LoadProject(wxString &strPathName);

	// Layer methods
	vtLayer *GetActiveLayer() { return m_pActiveLayer; }
	void SetActiveLayer(vtLayerPtr lp, bool refresh = false);
	vtElevLayer *GetActiveElevLayer()
	{
		if (m_pActiveLayer && m_pActiveLayer->GetType() == LT_ELEVATION)
			return (vtElevLayer *)m_pActiveLayer;
		return NULL;
	}
	vtRoadLayer *GetActiveRoadLayer()
	{
		if (m_pActiveLayer && m_pActiveLayer->GetType() == LT_ROAD)
			return (vtRoadLayer *)m_pActiveLayer;
		return NULL;
	}
	vtBuildingLayer *GetActiveBuildingLayer()
	{
		if (m_pActiveLayer && m_pActiveLayer->GetType() == LT_BUILDING)
			return (vtBuildingLayer *)m_pActiveLayer;
		return NULL;
	}
	void LoadLayer(wxString &fname);
	void AddLayer(vtLayerPtr lp);
	void RemoveLayer(vtLayerPtr lp);
	void DeleteLayer(vtLayerPtr lp);
	int LayersOfType(LayerType lt);
	vtLayerPtr FindLayerOfType(LayerType lt);
	DRECT GetExtents();
	bool AddLayerWithCheck(vtLayerPtr pLayer, bool bRefresh);

	// 
	void RefreshTreeStatus();
	void RefreshTreeView();
	void RefreshStatusBar();
	LayerType AskLayerType();
	BuilderView *GetView() { return m_pView; }
	void StretchArea();
	LayerType GuessLayerTypeFromDLG(vtDLGFile *pDLG);

	// Projection
	void SetProjection(vtProjection &p);
	void GetProjection(vtProjection &p) { p = m_proj; }

	// Elevation
	void SampleCurrentTerrains(vtElevLayer *pTarget);
	double GetHeightFromTerrain(double lx, double ly);

	// Vegetation
	vtPlantList m_PlantList;
	vtPlantList *GetPlantList() { return &m_PlantList; }
	PlantListDlg *m_PlantListDlg;

	vtBioRegion m_BioRegions;
	vtBioRegion *GetBioRegion() { return &m_BioRegions; }
	BioRegionDlg *m_BioRegionDlg;

	void GenerateVegetation(const char *vf_file, DRECT area,
		vtVegLayer *pLandUse, vtVegLayer *pVegType,
		float fTreeSpacing, float fTreeScarcity);

	void FindvtVegLayers(vtVegLayer **Density, vtVegLayer **BioMap);

	// import
	void ImportData(LayerType ltype);
	void ImportDataFromFile(LayerType ltype, wxString strFileName, bool bRefresh);
	vtLayerPtr ImportFromDLG(wxString &strFileName, LayerType ltype);
	vtLayerPtr ImportFromSHP(wxString &strFileName, LayerType ltype);
	vtLayerPtr ImportElevation(wxString &strFileName);
	vtLayerPtr ImportFromLULC(wxString &strFileName, LayerType ltype);
	vtLayerPtr ImportVectorsWithOGR(wxString &strFileName, LayerType ltype);

	// export
	void ExportElevation();

	// Application Data
	LayerArray	m_Layers;
	DRECT		m_area;

protected:
	// INI File
	bool ReadINI();
	bool WriteINI();
	FILE *m_fpIni;

	// Application Data
	vtLayerPtr	m_pActiveLayer;

	// UI members
	wxMenu*    fileMenu;
	wxMenu*    editMenu;
	wxMenu*    layerMenu;
	wxMenu*    viewMenu;
	wxMenu*    elevMenu;
	wxMenu*    vegMenu;
	wxMenu*    bldMenu;
	wxMenu*    roadMenu;
	wxMenu*    areaMenu;
	wxMenu*    helpMenu;
	wxMenuBar *menuBar;
	wxToolBar *toolBar_main;
	wxToolBar *toolBar_road;
	MyStatusBar *m_statbar;

	MySplitterWindow *m_splitter;
	MyTreeCtrl	*m_pTree;		// left child of splitter
	BuilderView	*m_pView;		// right child of splitter

	vtProjection	m_proj;
	bool			m_bShowMinutes;

DECLARE_EVENT_TABLE()
};

class DnDFile : public wxFileDropTarget
{
public:
    virtual bool OnDropFiles(wxCoord x, wxCoord y,
                             const wxArrayString& filenames);
};

extern MainFrame *GetMainFrame();
wxString GetImportFilterString(LayerType ltype);

#endif
