//
// Fences.h
//
// Copyright (c) 2001 Virtual Terrain Project
// Free for all uses, see license.txt for details.
//

#ifndef FENCESH
#define FENCESH

#include "HeightField.h"

enum FenceType
{
	FT_WIRE,
	FT_CHAINLINK
};

#define FENCE_DEFAULT_HEIGHT	1.2f
#define FENCE_DEFAULT_SPACING	2.5f


class vtFence
{
public:
	vtFence(FenceType type, float fHeight, float fSpacing);

	void add_point(const DPoint2 &epos);
	bool close_fence(); // return true if redraw necessary

	void set_post_size(FPoint3 size ) { m_PostSize = size; }

	void set_fence_type(FenceType type) { m_FenceType = type; }
	FenceType get_fence_type() { return m_FenceType; }

	void save(FILE *fp);
	bool load(FILE *fp);

	void BuildGeometry(vtHeightField *pHeightField);
	void DestroyGeometry();

//	vtNode *GetNode() { return m_pLOD; }
	vtGeom *GetGeom() { return m_pFenceGeom; }

	static void SetScale(float fScale) { m_fFenceScale = fScale; }

protected:
	void add_fencepost(FPoint3 &p1, int iMatIdx);

	// fence size is exaggerated by this amount
	static float m_fFenceScale;

	// all fences share the same set of materials
	static vtMaterialArray *m_pFenceMats;
	static void CreateMaterials();
	static int m_mi_woodpost;
	static int m_mi_wire;
	static int m_mi_chainlink;
	static int m_mi_metalpost;

	void  AddFenceMeshes(vtHeightField *pHeightField);

	vtLOD		*m_pLOD;
	vtGeom		*m_pFenceGeom;
	DLine2		m_pFencePts;	// in earth coordinates
	FenceType	m_FenceType;
	FPoint3		m_PostSize;

	float	m_fHeight;
	float	m_fSpacing;

	bool m_bClosed;
	bool m_bBuilt;
};

typedef class vtFence *vtFencePtr;

#endif
