/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sdp;

import gov.nist.javax.sdp.MediaDescriptionImpl;
import gov.nist.javax.sdp.TimeDescriptionImpl;
import gov.nist.javax.sdp.fields.AttributeField;
import gov.nist.javax.sdp.fields.BandwidthField;
import gov.nist.javax.sdp.fields.ConnectionField;
import gov.nist.javax.sdp.fields.EmailField;
import gov.nist.javax.sdp.fields.InformationField;
import gov.nist.javax.sdp.fields.KeyField;
import gov.nist.javax.sdp.fields.MediaField;
import gov.nist.javax.sdp.fields.OriginField;
import gov.nist.javax.sdp.fields.PhoneField;
import gov.nist.javax.sdp.fields.ProtoVersionField;
import gov.nist.javax.sdp.fields.RepeatField;
import gov.nist.javax.sdp.fields.SDPField;
import gov.nist.javax.sdp.fields.SessionNameField;
import gov.nist.javax.sdp.fields.TimeField;
import gov.nist.javax.sdp.fields.URIField;
import gov.nist.javax.sdp.fields.ZoneField;
import java.text.ParseException;
import java.util.Vector;
import javax.sdp.Connection;
import javax.sdp.Info;
import javax.sdp.Key;
import javax.sdp.Origin;
import javax.sdp.SdpException;
import javax.sdp.SdpParseException;
import javax.sdp.SessionDescription;
import javax.sdp.SessionName;
import javax.sdp.URI;
import javax.sdp.Version;

public class SessionDescriptionImpl
implements SessionDescription {
    private TimeDescriptionImpl currentTimeDescription;
    private MediaDescriptionImpl currentMediaDescription;
    protected ProtoVersionField versionImpl;
    protected OriginField originImpl;
    protected SessionNameField sessionNameImpl;
    protected InformationField infoImpl;
    protected URIField uriImpl;
    protected ConnectionField connectionImpl;
    protected KeyField keyImpl;
    protected Vector timeDescriptions;
    protected Vector mediaDescriptions;
    protected Vector zoneAdjustments = new Vector();
    protected Vector emailList = new Vector();
    protected Vector phoneList = new Vector();
    protected Vector bandwidthList = new Vector();
    protected Vector attributesList;

    public SessionDescriptionImpl() {
        this.timeDescriptions = new Vector();
        this.mediaDescriptions = new Vector();
        this.attributesList = new Vector();
    }

    public void addField(SDPField sdpField) throws ParseException {
        try {
            if (sdpField instanceof ProtoVersionField) {
                this.versionImpl = (ProtoVersionField)sdpField;
            } else if (sdpField instanceof OriginField) {
                this.originImpl = (OriginField)sdpField;
            } else if (sdpField instanceof SessionNameField) {
                this.sessionNameImpl = (SessionNameField)sdpField;
            } else if (sdpField instanceof InformationField) {
                if (this.currentMediaDescription != null) {
                    this.currentMediaDescription.setInformationField((InformationField)sdpField);
                } else {
                    this.infoImpl = (InformationField)sdpField;
                }
            } else if (sdpField instanceof URIField) {
                this.uriImpl = (URIField)sdpField;
            } else if (sdpField instanceof ConnectionField) {
                if (this.currentMediaDescription != null) {
                    this.currentMediaDescription.setConnectionField((ConnectionField)sdpField);
                } else {
                    this.connectionImpl = (ConnectionField)sdpField;
                }
            } else if (sdpField instanceof KeyField) {
                if (this.currentMediaDescription != null) {
                    this.currentMediaDescription.setKey((KeyField)sdpField);
                } else {
                    this.keyImpl = (KeyField)sdpField;
                }
            } else if (sdpField instanceof EmailField) {
                this.emailList.add(sdpField);
            } else if (sdpField instanceof PhoneField) {
                this.phoneList.add(sdpField);
            } else if (sdpField instanceof TimeField) {
                this.currentTimeDescription = new TimeDescriptionImpl((TimeField)sdpField);
                this.timeDescriptions.add(this.currentTimeDescription);
            } else if (sdpField instanceof RepeatField) {
                if (this.currentTimeDescription == null) {
                    throw new ParseException("no time specified", 0);
                }
                this.currentTimeDescription.addRepeatField((RepeatField)sdpField);
            } else if (sdpField instanceof ZoneField) {
                this.zoneAdjustments.add(sdpField);
            } else if (sdpField instanceof BandwidthField) {
                if (this.currentMediaDescription != null) {
                    this.currentMediaDescription.addBandwidthField((BandwidthField)sdpField);
                } else {
                    this.bandwidthList.add(sdpField);
                }
            } else if (sdpField instanceof AttributeField) {
                if (this.currentMediaDescription != null) {
                    AttributeField af = (AttributeField)sdpField;
                    String s = af.getName();
                    this.currentMediaDescription.addAttribute((AttributeField)sdpField);
                } else {
                    this.attributesList.add(sdpField);
                }
            } else if (sdpField instanceof MediaField) {
                this.currentMediaDescription = new MediaDescriptionImpl();
                this.mediaDescriptions.add(this.currentMediaDescription);
                this.currentMediaDescription.setMediaField((MediaField)sdpField);
            }
        }
        catch (SdpException ex) {
            throw new ParseException(sdpField.encode(), 0);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SessionDescriptionImpl hi;
        Class<?> myClass = this.getClass();
        try {
            hi = (SessionDescriptionImpl)myClass.newInstance();
        }
        catch (InstantiationException ex) {
            return null;
        }
        catch (IllegalAccessException ex) {
            return null;
        }
        hi.versionImpl = (ProtoVersionField)this.versionImpl.clone();
        hi.originImpl = (OriginField)this.originImpl.clone();
        hi.sessionNameImpl = (SessionNameField)this.sessionNameImpl.clone();
        if (this.infoImpl != null) {
            hi.infoImpl = (InformationField)this.infoImpl.clone();
        }
        if (this.uriImpl != null) {
            hi.uriImpl = (URIField)this.uriImpl.clone();
        }
        if (this.connectionImpl != null) {
            hi.connectionImpl = (ConnectionField)this.connectionImpl.clone();
        }
        if (this.keyImpl != null) {
            hi.keyImpl = (KeyField)this.keyImpl.clone();
        }
        hi.timeDescriptions = (Vector)this.timeDescriptions.clone();
        hi.emailList = (Vector)this.emailList.clone();
        hi.phoneList = (Vector)this.phoneList.clone();
        hi.zoneAdjustments = (Vector)this.zoneAdjustments.clone();
        hi.bandwidthList = (Vector)this.bandwidthList.clone();
        hi.attributesList = (Vector)this.attributesList.clone();
        hi.mediaDescriptions = (Vector)this.mediaDescriptions.clone();
        return hi;
    }

    public Version getVersion() {
        return this.versionImpl;
    }

    public void setVersion(Version v) throws SdpException {
        if (v == null) {
            throw new SdpException("The parameter is null");
        }
        if (!(v instanceof ProtoVersionField)) {
            throw new SdpException("The parameter must be an instance of VersionField");
        }
        this.versionImpl = (ProtoVersionField)v;
    }

    public Origin getOrigin() {
        return this.originImpl;
    }

    public void setOrigin(Origin origin) throws SdpException {
        OriginField o;
        if (origin == null) {
            throw new SdpException("The parameter is null");
        }
        if (!(origin instanceof OriginField)) {
            throw new SdpException("The parameter must be an instance of OriginField");
        }
        this.originImpl = o = (OriginField)origin;
    }

    public SessionName getSessionName() {
        return this.sessionNameImpl;
    }

    public void setSessionName(SessionName sessionName) throws SdpException {
        SessionNameField s;
        if (sessionName == null) {
            throw new SdpException("The parameter is null");
        }
        if (!(sessionName instanceof SessionNameField)) {
            throw new SdpException("The parameter must be an instance of SessionNameField");
        }
        this.sessionNameImpl = s = (SessionNameField)sessionName;
    }

    public Info getInfo() {
        return this.infoImpl;
    }

    public void setInfo(Info i) throws SdpException {
        InformationField info;
        if (i == null) {
            throw new SdpException("The parameter is null");
        }
        if (!(i instanceof InformationField)) {
            throw new SdpException("The parameter must be an instance of InformationField");
        }
        this.infoImpl = info = (InformationField)i;
    }

    public URI getURI() {
        return this.uriImpl;
    }

    public void setURI(URI uri) throws SdpException {
        URIField u;
        if (uri == null) {
            throw new SdpException("The parameter is null");
        }
        if (!(uri instanceof URIField)) {
            throw new SdpException("The parameter must be an instance of URIField");
        }
        this.uriImpl = u = (URIField)uri;
    }

    public Vector getEmails(boolean create) throws SdpParseException {
        if (this.emailList == null && create) {
            this.emailList = new Vector();
        }
        return this.emailList;
    }

    public void setEmails(Vector emails) throws SdpException {
        if (emails == null) {
            throw new SdpException("The parameter is null");
        }
        this.emailList = emails;
    }

    public Vector getPhones(boolean create) throws SdpException {
        if (this.phoneList == null && create) {
            this.phoneList = new Vector();
        }
        return this.phoneList;
    }

    public void setPhones(Vector phones) throws SdpException {
        if (phones == null) {
            throw new SdpException("The parameter is null");
        }
        this.phoneList = phones;
    }

    public Vector getTimeDescriptions(boolean create) throws SdpException {
        if (this.timeDescriptions == null && create) {
            this.timeDescriptions = new Vector();
        }
        return this.timeDescriptions;
    }

    public void setTimeDescriptions(Vector times) throws SdpException {
        if (times == null) {
            throw new SdpException("The parameter is null");
        }
        this.timeDescriptions = times;
    }

    public Vector getZoneAdjustments(boolean create) throws SdpException {
        if (this.zoneAdjustments == null && create) {
            this.zoneAdjustments = new Vector();
        }
        return this.zoneAdjustments;
    }

    public void setZoneAdjustments(Vector zoneAdjustments) throws SdpException {
        if (zoneAdjustments == null) {
            throw new SdpException("The parameter is null");
        }
        this.zoneAdjustments = zoneAdjustments;
    }

    public Connection getConnection() {
        return this.connectionImpl;
    }

    public void setConnection(Connection conn) throws SdpException {
        ConnectionField c;
        if (conn == null) {
            throw new SdpException("The parameter is null");
        }
        if (!(conn instanceof ConnectionField)) {
            throw new SdpException("Bad implementation class ConnectionField");
        }
        this.connectionImpl = c = (ConnectionField)conn;
    }

    public Vector getBandwidths(boolean create) {
        if (this.bandwidthList == null && create) {
            this.bandwidthList = new Vector();
        }
        return this.bandwidthList;
    }

    public void setBandwidths(Vector bandwidthList) throws SdpException {
        if (bandwidthList == null) {
            throw new SdpException("The parameter is null");
        }
        this.bandwidthList = bandwidthList;
    }

    public int getBandwidth(String name) throws SdpParseException {
        if (name == null) {
            return -1;
        }
        if (this.bandwidthList == null) {
            return -1;
        }
        for (int i = 0; i < this.bandwidthList.size(); ++i) {
            BandwidthField b;
            String type;
            Object o = this.bandwidthList.elementAt(i);
            if (!(o instanceof BandwidthField) || (type = (b = (BandwidthField)o).getType()) == null || !name.equals(type)) continue;
            return b.getValue();
        }
        return -1;
    }

    public void setBandwidth(String name, int value) throws SdpException {
        if (name == null) {
            throw new SdpException("The parameter is null");
        }
        if (this.bandwidthList != null) {
            for (int i = 0; i < this.bandwidthList.size(); ++i) {
                BandwidthField b;
                String type;
                Object o = this.bandwidthList.elementAt(i);
                if (!(o instanceof BandwidthField) || (type = (b = (BandwidthField)o).getType()) == null || !name.equals(type)) continue;
                b.setValue(value);
            }
        }
    }

    public void removeBandwidth(String name) {
        if (name != null && this.bandwidthList != null) {
            for (int i = 0; i < this.bandwidthList.size(); ++i) {
                Object o = this.bandwidthList.elementAt(i);
                if (!(o instanceof BandwidthField)) continue;
                BandwidthField b = (BandwidthField)o;
                try {
                    String type = b.getType();
                    if (type == null || !name.equals(type)) continue;
                    this.bandwidthList.remove(b);
                    continue;
                }
                catch (SdpParseException e) {
                    // empty catch block
                }
            }
        }
    }

    public Key getKey() {
        return this.keyImpl;
    }

    public void setKey(Key key) throws SdpException {
        KeyField k;
        if (key == null) {
            throw new SdpException("The parameter is null");
        }
        if (!(key instanceof KeyField)) {
            throw new SdpException("The parameter must be an instance of KeyField");
        }
        this.keyImpl = k = (KeyField)key;
    }

    public String getAttribute(String name) throws SdpParseException {
        if (name == null) {
            return null;
        }
        if (this.attributesList == null) {
            return null;
        }
        for (int i = 0; i < this.attributesList.size(); ++i) {
            AttributeField a;
            String n;
            Object o = this.attributesList.elementAt(i);
            if (!(o instanceof AttributeField) || (n = (a = (AttributeField)o).getName()) == null || !name.equals(n)) continue;
            return a.getValue();
        }
        return null;
    }

    public Vector getAttributes(boolean create) {
        if (this.attributesList == null && create) {
            this.attributesList = new Vector();
        }
        return this.attributesList;
    }

    public void removeAttribute(String name) {
        if (name != null && this.attributesList != null) {
            for (int i = 0; i < this.attributesList.size(); ++i) {
                Object o = this.attributesList.elementAt(i);
                if (!(o instanceof AttributeField)) continue;
                AttributeField a = (AttributeField)o;
                try {
                    String n = a.getName();
                    if (n == null || !name.equals(n)) continue;
                    this.attributesList.remove(a);
                    continue;
                }
                catch (SdpParseException e) {
                    // empty catch block
                }
            }
        }
    }

    public void setAttribute(String name, String value) throws SdpException {
        if (name == null || value == null) {
            throw new SdpException("The parameter is null");
        }
        if (this.attributesList != null) {
            for (int i = 0; i < this.attributesList.size(); ++i) {
                AttributeField a;
                String n;
                Object o = this.attributesList.elementAt(i);
                if (!(o instanceof AttributeField) || (n = (a = (AttributeField)o).getName()) == null || !name.equals(n)) continue;
                a.setValue(value);
            }
        }
    }

    public void setAttributes(Vector attributes) throws SdpException {
        if (attributes == null) {
            throw new SdpException("The parameter is null");
        }
        this.attributesList = attributes;
    }

    public Vector getMediaDescriptions(boolean create) throws SdpException {
        if (this.mediaDescriptions == null && create) {
            this.mediaDescriptions = new Vector();
        }
        return this.mediaDescriptions;
    }

    public void setMediaDescriptions(Vector mediaDescriptions) throws SdpException {
        if (mediaDescriptions == null) {
            throw new SdpException("The parameter is null");
        }
        this.mediaDescriptions = mediaDescriptions;
    }

    private String encodeVector(Vector vector) {
        StringBuffer encBuff = new StringBuffer();
        for (int i = 0; i < vector.size(); ++i) {
            encBuff.append(vector.elementAt(i));
        }
        return encBuff.toString();
    }

    public String toString() {
        StringBuffer encBuff = new StringBuffer();
        encBuff.append(this.getVersion() == null ? "" : this.getVersion().toString());
        encBuff.append(this.getOrigin() == null ? "" : this.getOrigin().toString());
        encBuff.append(this.getSessionName() == null ? "" : this.getSessionName().toString());
        encBuff.append(this.getInfo() == null ? "" : this.getInfo().toString());
        try {
            encBuff.append(this.getURI() == null ? "" : this.getURI().toString());
            encBuff.append(this.encodeVector(this.getEmails(true)));
            encBuff.append(this.encodeVector(this.getPhones(true)));
            encBuff.append(this.getConnection() == null ? "" : this.getConnection().toString());
            encBuff.append(this.encodeVector(this.getBandwidths(true)));
            encBuff.append(this.encodeVector(this.getTimeDescriptions(true)));
            encBuff.append(this.encodeVector(this.getZoneAdjustments(true)));
            encBuff.append(this.getKey() == null ? "" : this.getKey().toString());
            encBuff.append(this.encodeVector(this.getAttributes(true)));
            encBuff.append(this.encodeVector(this.getMediaDescriptions(true)));
        }
        catch (SdpException sdpException) {
            // empty catch block
        }
        return encBuff.toString();
    }
}

