/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.header.SIPHeader;
import javax.sip.InvalidArgumentException;
import javax.sip.header.MaxForwardsHeader;

public class MaxForwards
extends SIPHeader
implements MaxForwardsHeader {
    protected int maxForwards;

    public MaxForwards() {
        super("Max-Forwards");
    }

    public int getMaxForwards() {
        return this.maxForwards;
    }

    public void setMaxForwards(int maxForwards) throws InvalidArgumentException {
        if (maxForwards < 0 || maxForwards > 255) {
            throw new InvalidArgumentException("bad max forwards value " + maxForwards);
        }
        this.maxForwards = maxForwards;
    }

    public String encodeBody() {
        return new Integer(this.maxForwards).toString();
    }

    public boolean hasReachedZero() {
        return this.maxForwards == 0;
    }

    public void decrementMaxForwards() {
        if (this.maxForwards >= 0) {
            --this.maxForwards;
        }
    }
}

