/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.core.GenericObject;
import gov.nist.javax.sip.header.ExtensionHeaderList;
import gov.nist.javax.sip.header.Indentation;
import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.header.SIPObject;
import gov.nist.javax.sip.header.SIPObjectList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class SIPHeaderList
extends SIPHeader
implements List {
    protected static final String SIPHEADERS_PACKAGE = "gov.nist.javax.sip.header";
    protected static final String SIP_PACKAGE = "gov.nist.javax.sip";
    protected SIPObjectList hlist;

    public SIPHeaderList(SIPObjectList hl, String hname) {
        super(hname);
        this.hlist = hl;
    }

    public SIPHeaderList(String hName) {
        super(hName);
        this.hlist = new SIPObjectList(null);
    }

    public SIPHeaderList(Class objclass, String hname) {
        super(hname);
        this.hlist = new SIPObjectList(hname, objclass);
    }

    public SIPHeaderList(String classname, String hname) {
        super(hname);
        this.hlist = new SIPObjectList(hname, classname);
    }

    public boolean add(Object objectToAdd) {
        return this.hlist.add(objectToAdd);
    }

    public void addFirst(Object obj) {
        this.hlist.addFirst(obj);
    }

    public void add(SIPHeader sipheader, boolean top) {
        if (top) {
            this.addFirst(sipheader);
        } else {
            this.add(sipheader);
        }
    }

    public void concatenate(SIPHeaderList other, boolean top) throws IllegalArgumentException {
        if (!this.hlist.getMyClass().equals(other.hlist.getMyClass())) {
            throw new IllegalArgumentException("SIPHeaderList concatenation " + this.hlist.getMyClass().getName() + "/" + other.hlist.getMyClass().getName());
        }
        this.hlist.concatenate(other.hlist, top);
    }

    public void concatenate(SIPHeaderList other) throws IllegalArgumentException {
        this.concatenate(other, false);
    }

    public String encode() {
        if (this.hlist.isEmpty()) {
            return this.headerName + ":" + "\r\n";
        }
        StringBuffer encoding = new StringBuffer();
        if (this.headerName.equals("WWW-Authenticate") || this.headerName.equals("Proxy-Authenticate") || this.headerName.equals("Authorization") || this.headerName.equals("Proxy-Authorization") || this instanceof ExtensionHeaderList) {
            ListIterator li = this.hlist.listIterator();
            while (li.hasNext()) {
                SIPHeader sipheader = (SIPHeader)li.next();
                encoding.append(sipheader.encode());
            }
            return encoding.toString();
        }
        return this.headerName + ":" + " " + this.encodeBody() + "\r\n";
    }

    public LinkedList getHeadersAsEncodedStrings() {
        LinkedList<String> retval = new LinkedList<String>();
        ListIterator li = this.hlist.listIterator();
        while (li.hasNext()) {
            SIPHeader sipheader = (SIPHeader)li.next();
            retval.add(sipheader.encode());
        }
        return retval;
    }

    public SIPObject first() {
        return (SIPObject)this.hlist.first();
    }

    public SIPHeader getFirst() {
        if (this.hlist == null || this.hlist.isEmpty()) {
            return null;
        }
        return (SIPHeader)this.hlist.getFirst();
    }

    public SIPHeader getLast() {
        if (this.hlist == null || this.hlist.isEmpty()) {
            return null;
        }
        return (SIPHeader)this.hlist.getLast();
    }

    public Class getMyClass() {
        return this.hlist.getMyClass();
    }

    public boolean isEmpty() {
        return this.hlist.isEmpty();
    }

    public ListIterator listIterator() {
        return this.hlist.listIterator(0);
    }

    public SIPObjectList getHeaderList() {
        return this.hlist;
    }

    public ListIterator listIterator(int position) {
        return this.hlist.listIterator(position);
    }

    public SIPObject next() {
        return (SIPObject)this.hlist.next();
    }

    public SIPObject next(ListIterator iterator) {
        return (SIPObject)this.hlist.next(iterator);
    }

    public void removeAll(Class cl) {
        LinkedList<SIPHeader> ll = new LinkedList<SIPHeader>();
        SIPHeader sh = (SIPHeader)this.hlist.first();
        while (sh != null) {
            if (sh.getClass().equals(cl)) {
                ll.add(sh);
            }
            sh = (SIPHeader)this.hlist.next();
        }
        ListIterator li = ll.listIterator();
        while (li.hasNext()) {
            SIPHeader sh2 = (SIPHeader)li.next();
            this.hlist.remove(sh2);
        }
    }

    public void removeFirst() {
        if (this.hlist.size() != 0) {
            this.hlist.removeFirst();
        }
    }

    public void removeLast() {
        if (this.hlist.size() != 0) {
            this.hlist.removeLast();
        }
    }

    public boolean remove(SIPHeader obj) {
        if (this.hlist.size() == 0) {
            return false;
        }
        return this.hlist.remove(obj);
    }

    protected void setMyClass(Class cl) {
        this.hlist.setMyClass(cl);
    }

    public String debugDump(int indentation) {
        this.stringRepresentation = "";
        String indent = new Indentation(indentation).getIndentation();
        String className = this.getClass().getName();
        this.sprint(indent + className);
        this.sprint(indent + "{");
        this.sprint(indent + this.hlist.debugDump(indentation));
        this.sprint(indent + "}");
        return this.stringRepresentation;
    }

    public String debugDump() {
        return this.debugDump(0);
    }

    public Object[] toArray() {
        SIPHeader[] retval = new SIPHeader[this.hlist.size()];
        return this.hlist.toArray(retval);
    }

    public int indexOf(GenericObject gobj) {
        return this.hlist.indexOf(gobj);
    }

    public void add(int index, SIPHeader sipHeader) throws IndexOutOfBoundsException {
        this.hlist.add(index, sipHeader);
    }

    public boolean equals(Object other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        SIPHeaderList that = (SIPHeaderList)other;
        if (this.hlist == that.hlist) {
            return true;
        }
        if (this.hlist == null) {
            return false;
        }
        return this.hlist.equals(that.hlist);
    }

    public boolean match(Object template) {
        if (template == null) {
            return true;
        }
        if (!this.getClass().equals(template.getClass())) {
            return false;
        }
        SIPHeaderList that = (SIPHeaderList)template;
        if (this.hlist == that.hlist) {
            return true;
        }
        if (this.hlist == null) {
            return false;
        }
        return this.hlist.match(that.hlist);
    }

    public void merge(Object mergeObject) {
        if (mergeObject == null) {
            return;
        }
        if (!mergeObject.getClass().equals(this.getClass())) {
            throw new IllegalArgumentException("Bad class " + this.getClass());
        }
        SIPHeaderList mergeHdrList = (SIPHeaderList)mergeObject;
        this.hlist.mergeObjects(mergeHdrList.hlist);
    }

    public Object clone() {
        try {
            SIPHeaderList retval = (SIPHeaderList)this.getClass().newInstance();
            retval.headerName = this.headerName;
            SIPHeader v = (SIPHeader)this.first();
            while (v != null) {
                retval.add((SIPHeader)v.clone());
                v = (SIPHeader)this.next();
            }
            return retval;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public int size() {
        return this.hlist.size();
    }

    public boolean isHeaderList() {
        return true;
    }

    protected String encodeBody() {
        StringBuffer encoding = new StringBuffer();
        ListIterator iterator = this.listIterator();
        while (true) {
            SIPHeader siphdr = (SIPHeader)iterator.next();
            encoding.append(siphdr.encodeBody());
            if (!iterator.hasNext()) break;
            encoding.append(",");
        }
        return encoding.toString();
    }

    public String toString() {
        return this.encode();
    }

    public void add(int position, Object headerToAdd) {
        this.hlist.add(position, headerToAdd);
    }

    public boolean addAll(Collection collection) {
        return this.hlist.add(collection);
    }

    public boolean addAll(int index, Collection collection) {
        return this.hlist.addAll(index, collection);
    }

    public void clear() {
        this.hlist.clear();
    }

    public boolean contains(Object header) {
        return this.hlist.contains(header);
    }

    public boolean containsAll(Collection collection) {
        return this.hlist.containsAll(collection);
    }

    public Object get(int index) {
        return this.hlist.get(index);
    }

    public int indexOf(Object obj) {
        return this.hlist.indexOf(obj);
    }

    public Iterator iterator() {
        return this.hlist.listIterator();
    }

    public int lastIndexOf(Object obj) {
        if (this.getMyClass() != null && !obj.getClass().equals(this.getMyClass())) {
            return -1;
        }
        return this.hlist.lastIndexOf(obj);
    }

    public boolean remove(Object obj) {
        if (this.getMyClass() != null && !obj.getClass().equals(this.getMyClass())) {
            return false;
        }
        return this.hlist.remove(obj);
    }

    public Object remove(int index) {
        return this.hlist.remove(index);
    }

    public boolean removeAll(Collection collection) {
        return this.hlist.removeAll(collection);
    }

    public boolean retainAll(Collection collection) {
        return this.hlist.retainAll(collection);
    }

    public Object set(int index, Object obj) {
        if (this.getMyClass() != null && !obj.getClass().equals(this.getMyClass())) {
            throw new IllegalArgumentException("bad class expecting " + this.getMyClass());
        }
        return this.hlist.set(index, obj);
    }

    public List subList(int index1, int index2) {
        return this.hlist.subList(index1, index2);
    }

    public Object[] toArray(Object[] obj) {
        return this.hlist.toArray();
    }
}

