/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Timer;
import java.util.TimerTask;

public class Pipeline
extends InputStream {
    private LinkedList buffList;
    private Buffer currentBuffer;
    private boolean isClosed;
    private Timer timer;
    private InputStream pipe;
    private int readTimeout;
    private TimerTask myTimerTask;

    public void startTimer() {
        if (this.readTimeout == -1) {
            return;
        }
        this.myTimerTask = new MyTimer(this);
        this.timer.schedule(this.myTimerTask, this.readTimeout);
    }

    public void stopTimer() {
        if (this.readTimeout == -1) {
            return;
        }
        this.myTimerTask.cancel();
    }

    public Pipeline(InputStream pipe, int readTimeout, Timer timer) {
        this.timer = timer;
        this.pipe = pipe;
        this.buffList = new LinkedList();
        this.readTimeout = readTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] bytes, int start, int length) throws IOException {
        if (this.isClosed) {
            throw new IOException("Closed!!");
        }
        Buffer buff = new Buffer(bytes, length);
        buff.ptr = start;
        LinkedList linkedList = this.buffList;
        synchronized (linkedList) {
            this.buffList.add(buff);
            this.buffList.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] bytes) throws IOException {
        if (this.isClosed) {
            throw new IOException("Closed!!");
        }
        Buffer buff = new Buffer(bytes, bytes.length);
        LinkedList linkedList = this.buffList;
        synchronized (linkedList) {
            this.buffList.add(buff);
            this.buffList.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.isClosed = true;
        LinkedList linkedList = this.buffList;
        synchronized (linkedList) {
            this.buffList.notifyAll();
        }
    }

    public int read() throws IOException {
        if (this.isClosed) {
            return -1;
        }
        LinkedList linkedList = this.buffList;
        synchronized (linkedList) {
            if (this.currentBuffer != null && this.currentBuffer.ptr < this.currentBuffer.length) {
                int retval = this.currentBuffer.getNextByte();
                if (this.currentBuffer.ptr == this.currentBuffer.length) {
                    this.currentBuffer = null;
                }
                return retval;
            }
            try {
                while (this.buffList.isEmpty()) {
                    this.buffList.wait();
                    if (!this.isClosed) continue;
                    return -1;
                }
                this.currentBuffer = (Buffer)this.buffList.removeFirst();
                int retval = this.currentBuffer.getNextByte();
                if (this.currentBuffer.ptr == this.currentBuffer.length) {
                    this.currentBuffer = null;
                }
                return retval;
            }
            catch (InterruptedException ex) {
                throw new IOException(ex.getMessage());
            }
            catch (NoSuchElementException ex) {
                ex.printStackTrace();
                throw new IOException(ex.getMessage());
            }
        }
    }

    class Buffer {
        byte[] bytes;
        int length;
        int ptr = 0;

        public Buffer(byte[] bytes, int length) {
            this.length = length;
            this.bytes = bytes;
        }

        public int getNextByte() {
            int retval = this.bytes[this.ptr++] & 0xFF;
            return retval;
        }
    }

    class MyTimer
    extends TimerTask {
        Pipeline pipeline;
        private boolean isCancelled;

        protected MyTimer(Pipeline pipeline) {
            this.pipeline = pipeline;
        }

        public void run() {
            if (this.isCancelled) {
                return;
            }
            this.pipeline.close();
            try {
                this.pipeline.pipe.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public boolean cancel() {
            boolean retval = super.cancel();
            this.isCancelled = true;
            return retval;
        }
    }
}

