/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.client;

import java.net.DatagramSocket;
import net.java.stun4j.NetAccessPointDescriptor;
import net.java.stun4j.StunAddress;
import net.java.stun4j.StunException;
import net.java.stun4j.StunMessageEvent;
import net.java.stun4j.attribute.MappedAddressAttribute;
import net.java.stun4j.client.BlockingRequestSender;
import net.java.stun4j.message.MessageFactory;
import net.java.stun4j.message.Response;
import net.java.stun4j.stack.StunProvider;
import net.java.stun4j.stack.StunStack;

public class SimpleAddressDetector {
    private boolean started = false;
    private StunStack stunStack = null;
    private StunProvider stunProvider = null;
    private StunAddress serverAddress = null;
    private BlockingRequestSender requestSender = null;

    public SimpleAddressDetector(StunAddress serverAddress) {
        this.serverAddress = serverAddress;
    }

    public void shutDown() {
        SimpleAddressDetector simpleAddressDetector = this;
        simpleAddressDetector.stunStack.shutDown();
        this.stunStack = null;
        this.stunProvider = null;
        this.requestSender = null;
        this.started = false;
    }

    public void start() throws StunException {
        this.stunStack = StunStack.getInstance();
        this.stunStack.start();
        this.stunProvider = this.stunStack.getProvider();
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StunAddress getMappingFor(StunAddress address) throws StunException {
        Response res;
        MappedAddressAttribute maAtt;
        NetAccessPointDescriptor apDesc = new NetAccessPointDescriptor(address);
        this.stunStack.installNetAccessPoint(apDesc);
        this.requestSender = new BlockingRequestSender(this.stunProvider, apDesc);
        StunMessageEvent evt = null;
        try {
            evt = this.requestSender.sendRequestAndWaitForResponse(MessageFactory.createBindingRequest(), this.serverAddress);
        }
        finally {
            this.stunStack.removeNetAccessPoint(apDesc);
        }
        if (evt != null && (maAtt = (MappedAddressAttribute)(res = (Response)evt.getMessage()).getAttribute('\u0001')) != null) {
            return maAtt.getAddress();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StunAddress getMappingFor(DatagramSocket socket) throws StunException {
        Response res;
        MappedAddressAttribute maAtt;
        NetAccessPointDescriptor apDesc = this.stunStack.installNetAccessPoint(socket);
        this.requestSender = new BlockingRequestSender(this.stunProvider, apDesc);
        StunMessageEvent evt = null;
        try {
            evt = this.requestSender.sendRequestAndWaitForResponse(MessageFactory.createBindingRequest(), this.serverAddress);
        }
        finally {
            this.stunStack.removeNetAccessPoint(apDesc);
        }
        if (evt != null && (maAtt = (MappedAddressAttribute)(res = (Response)evt.getMessage()).getAttribute('\u0001')) != null) {
            return maAtt.getAddress();
        }
        return null;
    }

    public StunAddress getMappingFor(int port) throws StunException {
        return this.getMappingFor(new StunAddress(port));
    }
}

